/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.cluster.ChainedLexicalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.ClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalConcatenatedCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalMergedCluster;
import it.unimi.dsi.mg4j.index.cluster.LexicalCluster;
import it.unimi.dsi.mg4j.index.cluster.LexicalClusteringStrategy;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.BloomFilter;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.EnumMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexCluster
extends Index {
    private static final Logger LOGGER = Fast.getLogger(IndexCluster.class);
    public static final String STRATEGY_DEFAULT_EXTENSION = ".strategy";
    public static final String BLOOM_EXTENSION = ".bloom";
    protected final Index[] localIndex;
    protected final BloomFilter[] termFilter;

    protected IndexCluster(Index[] localIndex, BloomFilter[] termFilter, int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, boolean hasCounts, boolean hasPositions, TermProcessor termProcessor, String field, IntList sizes, Properties properties) {
        super(numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, hasCounts, hasPositions, termProcessor, field, sizes, properties);
        this.localIndex = localIndex;
        this.termFilter = termFilter;
        for (int i = 0; i < localIndex.length; ++i) {
            localIndex[i].keyIndex(this);
        }
    }

    public static Index getInstance(CharSequence basename, boolean randomAccess, boolean documentSizes, EnumMap<Index.UriKeys, String> queryProperties) throws ConfigurationException, IOException, ClassNotFoundException, SecurityException, URISyntaxException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IntList sizes;
        Properties properties = new Properties(basename + ".properties");
        ClusteringStrategy strategy = (ClusteringStrategy)BinIO.loadObject((CharSequence)properties.getString(PropertyKeys.STRATEGY));
        Class<?> indexClass = Class.forName(properties.getString(Index.PropertyKeys.INDEXCLASS, "(missing index class)"));
        String[] localBasename = properties.getStringArray(PropertyKeys.LOCALINDEX);
        Index[] localIndex = new Index[localBasename.length];
        for (int i = 0; i < localIndex.length; ++i) {
            localIndex[i] = Index.getInstance(localBasename[i], randomAccess, documentSizes);
        }
        int numberOfDocuments = properties.getInt(Index.PropertyKeys.DOCUMENTS);
        IntList intList = sizes = queryProperties != null && queryProperties.containsKey((Object)Index.UriKeys.SIZES) ? DiskBasedIndex.readSizes(new InputBitStream(queryProperties.get((Object)Index.UriKeys.SIZES)), numberOfDocuments) : null;
        if (sizes != null && documentSizes) {
            LOGGER.warn((Object)"You are loading both local sizes and a global size file specified by the \"size\" properties, which is usually nonsensical");
        }
        boolean hasCounts = true;
        boolean hasPositions = true;
        Payload payload = null;
        for (int i = 0; i < localIndex.length; ++i) {
            hasCounts = hasCounts && localIndex[i].hasCounts;
            boolean bl = hasPositions = hasPositions && localIndex[i].hasPositions;
            if (i == 0) {
                payload = localIndex[i].payload;
            }
            if (payload == null == (localIndex[i].payload == null) && (payload == null || payload.compatibleWith(localIndex[i].payload))) continue;
            throw new IllegalStateException("The payload specification of index " + localIndex[0] + " is not compatible with that of index " + localIndex[i]);
        }
        BloomFilter[] termFilter = null;
        if (properties.getBoolean(PropertyKeys.BLOOM)) {
            LOGGER.debug((Object)"Loading Bloom filters...");
            termFilter = new BloomFilter[localIndex.length];
            for (int i = 0; i < localIndex.length; ++i) {
                termFilter[i] = (BloomFilter)BinIO.loadObject((CharSequence)(basename + "-" + i + BLOOM_EXTENSION));
            }
            LOGGER.debug((Object)"Completed.");
        }
        if (strategy instanceof ChainedLexicalClusteringStrategy) {
            strategy = new ChainedLexicalClusteringStrategy(localIndex, termFilter);
        } else if (strategy.numberOfLocalIndices() != localBasename.length) {
            throw new IllegalArgumentException("The number of local indices of the strategy (" + localIndex.length + ") and the number of local indices specified by the property file (" + localBasename.length + ") differ");
        }
        if (LexicalCluster.class.isAssignableFrom(indexClass)) {
            return new LexicalCluster(localIndex, (LexicalClusteringStrategy)strategy, termFilter, numberOfDocuments, properties.getInt(Index.PropertyKeys.TERMS), properties.getLong(Index.PropertyKeys.POSTINGS), properties.getLong(Index.PropertyKeys.OCCURRENCES), properties.getInt(Index.PropertyKeys.MAXCOUNT), payload, hasCounts, hasPositions, Index.getTermProcessor(properties), properties.getString(Index.PropertyKeys.FIELD), sizes, properties);
        }
        if (DocumentalCluster.class.isAssignableFrom(indexClass)) {
            if (DocumentalConcatenatedCluster.class.isAssignableFrom(indexClass)) {
                return new DocumentalConcatenatedCluster(localIndex, (DocumentalClusteringStrategy)strategy, properties.getBoolean(PropertyKeys.FLAT), termFilter, numberOfDocuments, properties.getInt(Index.PropertyKeys.TERMS), properties.getLong(Index.PropertyKeys.POSTINGS), properties.getLong(Index.PropertyKeys.OCCURRENCES), properties.getInt(Index.PropertyKeys.MAXCOUNT), payload, hasCounts, hasPositions, Index.getTermProcessor(properties), properties.getString(Index.PropertyKeys.FIELD), sizes, properties);
            }
            return new DocumentalMergedCluster(localIndex, (DocumentalClusteringStrategy)strategy, properties.getBoolean(PropertyKeys.FLAT), termFilter, numberOfDocuments, properties.getInt(Index.PropertyKeys.TERMS), properties.getLong(Index.PropertyKeys.POSTINGS), properties.getLong(Index.PropertyKeys.OCCURRENCES), properties.getInt(Index.PropertyKeys.MAXCOUNT), payload, hasCounts, hasPositions, Index.getTermProcessor(properties), properties.getString(Index.PropertyKeys.FIELD), sizes, properties);
        }
        throw new IllegalArgumentException("Unknown IndexCluster implementation: " + indexClass.getName());
    }

    @Override
    public void keyIndex(Index newKeyIndex) {
        super.keyIndex(newKeyIndex);
        for (int i = 0; i < this.localIndex.length; ++i) {
            this.localIndex[i].keyIndex(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKeys {
        LOCALINDEX,
        STRATEGY,
        BLOOM,
        FLAT;

    }
}

