/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.PayloadPredicateDocumentIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntersectionDocumentIterator
extends AbstractCompositeDocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    private final DocumentIterator[] sortedIterator;
    private final DocumentIterator lastIterator;
    private final PayloadPredicateDocumentIterator[] payloadPredicateDocumentIterator;
    private final int predicateStart;
    private boolean exhausted;
    private int curr;

    protected AbstractIntersectionDocumentIterator(DocumentIterator[] documentIterator) throws IOException {
        super(documentIterator);
        if (documentIterator.length == 0) {
            throw new IllegalArgumentException();
        }
        this.sortedIterator = (DocumentIterator[])documentIterator.clone();
        this.intervalIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.currentIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
        Arrays.sort(this.sortedIterator, new Comparator<DocumentIterator>(){

            @Override
            public int compare(DocumentIterator d0, DocumentIterator d1) {
                IndexIterator i1;
                PayloadPredicateDocumentIterator p1;
                PayloadPredicateDocumentIterator p0 = d0 instanceof PayloadPredicateDocumentIterator ? (PayloadPredicateDocumentIterator)d0 : null;
                PayloadPredicateDocumentIterator payloadPredicateDocumentIterator = p1 = d1 instanceof PayloadPredicateDocumentIterator ? (PayloadPredicateDocumentIterator)d1 : null;
                if (p0 != null && p1 != null) {
                    return 0;
                }
                if (p0 != null) {
                    return -1;
                }
                if (p1 != null) {
                    return 1;
                }
                IndexIterator i0 = d0 instanceof IndexIterator ? (IndexIterator)d0 : null;
                IndexIterator indexIterator = i1 = d1 instanceof IndexIterator ? (IndexIterator)d1 : null;
                if (i0 == null && i1 == null) {
                    return 0;
                }
                if (i0 != null != (i1 != null)) {
                    return i0 != null ? 1 : -1;
                }
                try {
                    return i1.frequency() - i0.frequency();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.lastIterator = this.sortedIterator[this.n - 1];
        int i = this.n;
        while (i-- != 0 && !(this.sortedIterator[i] instanceof PayloadPredicateDocumentIterator)) {
        }
        this.predicateStart = i + 1;
        this.payloadPredicateDocumentIterator = new PayloadPredicateDocumentIterator[this.predicateStart];
        i = this.predicateStart;
        while (i-- != 0) {
            this.payloadPredicateDocumentIterator[i] = (PayloadPredicateDocumentIterator)this.sortedIterator[i];
        }
        i = this.n;
        while (i-- != 0) {
            if (this.sortedIterator[i].hasNext()) continue;
            this.exhausted = true;
            return;
        }
        if (this.align()) {
            this.next = this.curr;
        } else {
            this.exhausted = true;
        }
    }

    private boolean align() throws IOException {
        int i;
        int candidate = this.curr;
        block0: do {
            i = this.n;
            while (i-- != 0) {
                int res = i < this.predicateStart ? this.payloadPredicateDocumentIterator[i].skipUnconditionallyTo(candidate) : this.sortedIterator[i].skipTo(candidate);
                if (res == Integer.MAX_VALUE) {
                    return false;
                }
                if (res == candidate) continue;
                if (res > candidate) {
                    candidate = res;
                    continue block0;
                }
                ++candidate;
                continue block0;
            }
        } while (i != -1);
        this.curr = candidate;
        return true;
    }

    @Override
    public int skipTo(int n) throws IOException {
        if (this.last >= n) {
            return this.last;
        }
        this.next = -1;
        this.last = -1;
        this.currentIterators.clear();
        if (this.curr < n) {
            this.curr = this.lastIterator.skipTo(n);
            if (this.curr == Integer.MAX_VALUE) {
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }
            this.exhausted = !this.align();
        }
        return this.exhausted ? Integer.MAX_VALUE : (this.last = this.curr);
    }

    @Override
    public int nextDocument() throws IOException {
        if (this.next >= 0) {
            this.last = this.next;
            this.next = -1;
            return this.last;
        }
        this.next = -1;
        this.last = -1;
        this.currentIterators.clear();
        this.curr = this.lastIterator.nextDocument();
        if (this.curr == -1) {
            this.exhausted = true;
        } else {
            boolean bl = this.exhausted = !this.align();
        }
        if (this.exhausted) {
            return -1;
        }
        this.last = this.curr;
        return this.last;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        ObjectIterator i = this.indices.iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        int i;
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.TRUE;
        }
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        int c = 0;
        for (i = 0; i < this.n && (intervalIterator = this.documentIterator[i].intervalIterator(index)) != IntervalIterators.FALSE; ++i) {
            if (intervalIterator == IntervalIterators.TRUE) continue;
            ++c;
        }
        if (i < this.n) {
            intervalIterator = IntervalIterators.FALSE;
        } else if (c == 0) {
            intervalIterator = IntervalIterators.TRUE;
        } else {
            intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
            if (intervalIterator == null) {
                intervalIterator = this.getComposedIntervalIterator(index);
                this.intervalIterators.put((Object)index, (Object)intervalIterator);
            }
            intervalIterator.reset();
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    protected abstract IntervalIterator getComposedIntervalIterator(Index var1);
}

