/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.CachingDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.score.Scorer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAggregator
extends AbstractIntIterator
implements Scorer {
    protected DocumentIterator documentIterator;
    protected final int n;
    protected final Scorer[] scorer;
    protected final double[] currScore;
    protected final boolean needsCaching;
    protected int[] sampleDocument;
    protected double[][] sampleScore;
    protected int samples;
    protected int currSample;
    protected int actualSamples;

    public AbstractAggregator(Scorer[] scorer) {
        this.n = scorer.length;
        this.scorer = scorer;
        this.currScore = new double[this.n];
        int needsIntervals = 0;
        int i = scorer.length;
        while (i-- != 0) {
            if (!(scorer[i] instanceof DelegatingScorer)) {
                throw new IllegalArgumentException("An aggregator needs delegating scorers");
            }
            if (!scorer[i].usesIntervals()) continue;
            ++needsIntervals;
        }
        this.needsCaching = needsIntervals > 1;
        this.actualSamples = -1;
    }

    @Override
    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double score() throws IOException {
        if (this.currSample <= this.actualSamples) {
            return this.score(this.sampleScore[this.currSample - 1]);
        }
        double[] currScore = this.currScore;
        int i = this.n;
        while (i-- != 0) {
            currScore[i] = this.scorer[i].score();
        }
        return this.score(currScore);
    }

    public synchronized void equalize(int samples) {
        this.samples = samples;
        if (samples == 0) {
            this.sampleDocument = null;
            this.sampleScore = null;
            this.actualSamples = -1;
        } else {
            this.sampleDocument = new int[samples];
            this.sampleScore = new double[samples][this.n];
        }
    }

    @Override
    public synchronized boolean setWeights(Reference2DoubleMap<Index> index2weight) {
        boolean atLeastOne = false;
        int i = this.n;
        while (i-- != 0) {
            atLeastOne |= this.scorer[i].setWeights(index2weight);
        }
        return atLeastOne;
    }

    @Override
    public boolean usesIntervals() {
        int i = this.n;
        while (i-- != 0) {
            if (!this.scorer[i].usesIntervals()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void wrap(DocumentIterator documentIterator) throws IOException {
        if (this.needsCaching) {
            documentIterator = new CachingDocumentIterator(documentIterator);
        }
        int i = this.n;
        while (i-- != 0) {
            this.scorer[i].wrap(documentIterator);
        }
        if (this.samples > 0) {
            for (i = 0; i < this.samples && (this.sampleDocument[i] = documentIterator.nextDocument()) != -1; ++i) {
                int j = this.n;
                while (j-- != 0) {
                    this.sampleScore[i][j] = this.scorer[j].score();
                }
            }
            this.actualSamples = i;
            this.currSample = 0;
        }
        this.setupEqualizationFactors();
        this.documentIterator = documentIterator;
    }

    protected abstract double score(double[] var1);

    protected abstract void setupEqualizationFactors();

    @Override
    public int nextDocument() throws IOException {
        if (this.currSample < this.actualSamples) {
            return this.sampleDocument[this.currSample++];
        }
        this.currSample = Integer.MAX_VALUE;
        return this.documentIterator.nextDocument();
    }

    public boolean hasNext() {
        return this.currSample < this.actualSamples || this.documentIterator.hasNext();
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.nextDocument();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

