/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoredDocumentBoundedSizeQueue<T> {
    private static final boolean ASSERTS = false;
    private final ObjectHeapPriorityQueue<DocumentScoreInfo<T>> queue;
    private int maxSize;

    public ScoredDocumentBoundedSizeQueue(int capacity) {
        this.maxSize = capacity;
        this.queue = new ObjectHeapPriorityQueue(capacity, DocumentScoreInfo.SCORE_DOCUMENT_COMPARATOR);
    }

    public boolean wouldEnqueue(int d, double s) {
        if (this.queue.size() < this.maxSize) {
            return true;
        }
        DocumentScoreInfo dsi = (DocumentScoreInfo)this.queue.first();
        return s > dsi.score || s == dsi.score && d > dsi.document;
    }

    public boolean enqueue(int d, double s, T i) {
        if (this.maxSize == 0) {
            return false;
        }
        if (this.queue.size() < this.maxSize) {
            this.queue.enqueue(new DocumentScoreInfo<T>(d, s, i));
            return true;
        }
        DocumentScoreInfo dsi = (DocumentScoreInfo)this.queue.first();
        if (s > dsi.score) {
            dsi.document = d;
            dsi.score = s;
            dsi.info = i;
            this.queue.changed();
            return true;
        }
        return false;
    }

    public boolean enqueue(int d, double s) {
        return this.enqueue(d, s, null);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public DocumentScoreInfo<T> dequeue() {
        return (DocumentScoreInfo)this.queue.dequeue();
    }
}

