/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.BedEntry;
import edu.unc.genomics.BedGraphEntry;
import edu.unc.genomics.GFFEntry;
import edu.unc.genomics.VCFEntry;
import edu.unc.genomics.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileReader;

public class IntervalFileSniffer {
    private static final Logger log = Logger.getLogger(IntervalFileSniffer.class);
    protected Path p;
    protected String firstLine;

    public IntervalFileSniffer(Path p) {
        this.p = p;
    }

    public boolean isAscii() throws IOException {
        return FileUtils.isAsciiText(this.p);
    }

    public boolean isBinary() throws IOException {
        return !this.isAscii();
    }

    public boolean isBigBed() {
        try {
            BBFileReader reader = new BBFileReader(this.p.toString());
            return reader.isBigBedFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isBed() throws IOException {
        if (!this.isAscii()) {
            return false;
        }
        if (this.numColumns() < 3 || this.numColumns() > 12) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(2)) || !StringUtils.isNumeric((CharSequence)this.column(3))) {
            return false;
        }
        if (this.isBedGraph()) {
            return false;
        }
        try {
            BedEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isBedGraph() throws IOException {
        if (!this.isAscii()) {
            return false;
        }
        if (this.numColumns() != 4) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(2)) || !StringUtils.isNumeric((CharSequence)this.column(3))) {
            return false;
        }
        try {
            Float.parseFloat(this.column(4));
        }
        catch (Exception e) {
            return false;
        }
        try {
            BedGraphEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isGFF() throws IOException {
        if (!this.isAscii()) {
            return false;
        }
        if (this.numColumns() < 9) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(4)) || !StringUtils.isNumeric((CharSequence)this.column(5))) {
            return false;
        }
        try {
            GFFEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isGeneTrack() throws IOException {
        if (!this.isAscii()) {
            return false;
        }
        if (this.numColumns() != 4) {
            return false;
        }
        return this.column(1).equalsIgnoreCase("chrom") && this.column(2).equalsIgnoreCase("index") && this.column(3).equalsIgnoreCase("forward") && this.column(4).equalsIgnoreCase("reverse");
    }

    public boolean isVCF() throws IOException {
        if (!this.isAscii()) {
            return false;
        }
        if (this.numColumns() < 8) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)this.column(2))) {
            return false;
        }
        try {
            VCFEntry.parse(this.getFirstLine());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBAM() {
        boolean isBam = false;
        SAMFileReader.ValidationStringency stringency = SAMFileReader.getDefaultValidationStringency();
        try {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.STRICT);
            SAMFileReader reader = new SAMFileReader(this.p.toFile());
            SAMRecord r = (SAMRecord)reader.iterator().next();
            isBam = reader.isBinary();
            reader.close();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)stringency);
        }
        return isBam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSAM() throws IOException {
        boolean isSAM = false;
        SAMFileReader.ValidationStringency stringency = SAMFileReader.getDefaultValidationStringency();
        try {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.STRICT);
            SAMFileReader reader = new SAMFileReader(this.p.toFile());
            SAMRecord r = (SAMRecord)reader.iterator().next();
            isSAM = !reader.isBinary();
            reader.close();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)stringency);
        }
        return isSAM;
    }

    private String getFirstLine() throws IOException {
        if (this.firstLine == null) {
            try (BufferedReader reader = Files.newBufferedReader(this.p, Charset.defaultCharset());){
                this.firstLine = reader.readLine();
                while (this.firstLine != null && (this.firstLine.length() == 0 || this.firstLine.startsWith("track") || this.firstLine.startsWith("#") || this.firstLine.startsWith("@"))) {
                    this.firstLine = reader.readLine();
                }
            }
            log.debug((Object)("Loaded first line of interval file: " + this.firstLine));
        }
        return this.firstLine;
    }

    private int numColumns() throws IOException {
        return this.getFirstLine().split("\t").length;
    }

    private String column(int n) throws IOException {
        return this.getFirstLine().split("\t")[n - 1];
    }
}

