/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import edu.unc.genomics.util.BinaryFileBuffer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class ExternalSort {
    public static int DEFAULTMAXTEMPFILES = 1024;

    public static long estimateBestSizeOfBlocks(Path fileToBeSorted, int maxTmpFiles) throws IOException {
        long freemem;
        long sizeoffile = 2L * Files.size(fileToBeSorted);
        long blocksize = sizeoffile / (long)maxTmpFiles + (long)(sizeoffile % (long)maxTmpFiles == 0L ? 0 : 1);
        if (blocksize < (freemem = Runtime.getRuntime().freeMemory()) / 2L) {
            blocksize = freemem / 2L;
        }
        return blocksize;
    }

    public static List<Path> sortInBatch(Path p, Comparator<String> cmp) throws IOException {
        return ExternalSort.sortInBatch(p, cmp, DEFAULTMAXTEMPFILES, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Path> sortInBatch(Path p, Comparator<String> cmp, int maxtmpfiles, Charset cs) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        BufferedReader fbr = Files.newBufferedReader(p, cs);
        long blocksize = ExternalSort.estimateBestSizeOfBlocks(p, maxtmpfiles);
        try {
            ArrayList<String> tmplist = new ArrayList<String>();
            String line = "";
            try {
                while (line != null) {
                    for (long currentblocksize = 0L; currentblocksize < blocksize && (line = fbr.readLine()) != null; currentblocksize += (long)(line.length() * 2)) {
                        tmplist.add(line);
                    }
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs));
                    tmplist.clear();
                }
            }
            catch (EOFException oef) {
                if (tmplist.size() > 0) {
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs));
                    tmplist.clear();
                }
            }
        }
        finally {
            fbr.close();
        }
        return files;
    }

    public static Path sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs) throws IOException {
        Collections.sort(tmplist, cmp);
        Path tmpFile = Files.createTempFile("sortInBatch", "flatfile", new FileAttribute[0]);
        tmpFile.toFile().deleteOnExit();
        try (BufferedWriter fbw = Files.newBufferedWriter(tmpFile, cs, new OpenOption[0]);){
            for (String r : tmplist) {
                fbw.write(r);
                fbw.newLine();
            }
        }
        return tmpFile;
    }

    public static int mergeSortedFiles(List<Path> files, Path outputFile, Comparator<String> cmp) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputFile, cmp, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mergeSortedFiles(List<Path> files, Path outputFile, final Comparator<String> cmp, Charset cs) throws IOException {
        PriorityQueue<BinaryFileBuffer> pq = new PriorityQueue<BinaryFileBuffer>(11, new Comparator<BinaryFileBuffer>(){

            @Override
            public int compare(BinaryFileBuffer i, BinaryFileBuffer j) {
                return cmp.compare(i.peek(), j.peek());
            }
        });
        for (Path p : files) {
            BinaryFileBuffer binaryFileBuffer = new BinaryFileBuffer(p, cs);
            pq.add(binaryFileBuffer);
        }
        int rowCounter = 0;
        try {
            Throwable throwable = null;
            try (BufferedWriter fbw = Files.newBufferedWriter(outputFile, cs, new OpenOption[0]);){
                while (pq.size() > 0) {
                    BinaryFileBuffer bfb2 = pq.poll();
                    String r = bfb2.pop();
                    fbw.write(r);
                    fbw.newLine();
                    ++rowCounter;
                    if (bfb2.empty()) {
                        bfb2.close();
                        Files.deleteIfExists(bfb2.p);
                        continue;
                    }
                    pq.add(bfb2);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        finally {
            for (BinaryFileBuffer binaryFileBuffer : pq) {
                binaryFileBuffer.close();
            }
        }
        return rowCounter;
    }
}

