/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

import java.io.File;
import java.nio.file.Path;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.apache.log4j.Logger;

public class Samtools {
    private static final Logger log = Logger.getLogger(Samtools.class);

    public static void indexFasta(Path p) throws Exception {
        block5: {
            log.debug((Object)"Attempting to generate FASTA index by calling 'samtools faidx'");
            try {
                Process proc = new ProcessBuilder("samtools", "faidx", p.toString()).start();
                proc.waitFor();
            }
            catch (Exception e) {
                log.error((Object)"Error attempting to call 'samtools faidx'. Is samtools available in the PATH?");
            }
            finally {
                if (IndexedFastaSequenceFile.canCreateIndexedFastaReader((File)p.toFile())) break block5;
                log.error((Object)("Could not create FASTA index for file " + p));
                throw new Exception("Could not create FASTA index for file " + p);
            }
        }
    }
}

