/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexer;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class BAMFileWriter
extends SAMFileWriterImpl {
    private final BinaryCodec outputBinaryCodec;
    private BAMRecordCodec bamRecordCodec = null;
    private final BlockCompressedOutputStream blockCompressedOutputStream;
    private BAMIndexer bamIndexer = null;

    public BAMFileWriter(File path) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(path);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(path.toString());
    }

    public BAMFileWriter(File path, int compressionLevel) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(path, compressionLevel);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(path.toString());
    }

    public BAMFileWriter(OutputStream os, File file) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(os, file);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(file.getAbsolutePath());
    }

    public BAMFileWriter(OutputStream os, File file, int compressionLevel) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(os, file, compressionLevel);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(file.getAbsolutePath());
    }

    private void prepareToWriteAlignments() {
        if (this.bamRecordCodec == null) {
            this.bamRecordCodec = new BAMRecordCodec(this.getFileHeader());
            this.bamRecordCodec.setOutputStream(this.outputBinaryCodec.getOutputStream(), this.outputBinaryCodec.getOutputFileName());
        }
    }

    void enableBamIndexConstruction() {
        if (!this.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Not creating BAM index since not sorted by coordinates: " + (Object)((Object)this.getSortOrder()));
        }
        this.bamIndexer = this.createBamIndex(this.outputBinaryCodec.getOutputFileName());
    }

    private BAMIndexer createBamIndex(String path) {
        try {
            String indexFileBase = path.endsWith(".bam") ? path.substring(0, path.lastIndexOf(".")) : path;
            File indexFile = new File(indexFileBase + ".bai");
            if (indexFile.exists() && !indexFile.canWrite()) {
                throw new SAMException("Not creating BAM index since unable to write index file " + indexFile);
            }
            return new BAMIndexer(indexFile, this.getFileHeader());
        }
        catch (Exception e) {
            throw new SAMException("Not creating BAM index", e);
        }
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        this.prepareToWriteAlignments();
        if (this.bamIndexer != null) {
            try {
                long startOffset = this.blockCompressedOutputStream.getFilePointer();
                this.bamRecordCodec.encode(alignment);
                long stopOffset = this.blockCompressedOutputStream.getFilePointer();
                alignment.setFileSource(new SAMFileSource(null, new BAMFileSpan(new Chunk(startOffset, stopOffset))));
                this.bamIndexer.processAlignment(alignment);
            }
            catch (Exception e) {
                this.bamIndexer = null;
                throw new SAMException("Exception when processing alignment for BAM index " + alignment, e);
            }
        } else {
            this.bamRecordCodec.encode(alignment);
        }
    }

    @Override
    protected void writeHeader(String textHeader) {
        this.outputBinaryCodec.writeBytes(BAMFileConstants.BAM_MAGIC);
        this.outputBinaryCodec.writeString(textHeader, true, false);
        this.outputBinaryCodec.writeInt(this.getFileHeader().getSequenceDictionary().size());
        for (SAMSequenceRecord sequenceRecord : this.getFileHeader().getSequenceDictionary().getSequences()) {
            this.outputBinaryCodec.writeString(sequenceRecord.getSequenceName(), true, true);
            this.outputBinaryCodec.writeInt(sequenceRecord.getSequenceLength());
        }
    }

    @Override
    protected void finish() {
        this.outputBinaryCodec.close();
        try {
            if (this.bamIndexer != null) {
                this.bamIndexer.finish();
            }
        }
        catch (Exception e) {
            throw new SAMException("Exception writing BAM index file", e);
        }
    }

    @Override
    protected String getFilename() {
        return this.outputBinaryCodec.getOutputFileName();
    }
}

