/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class BitLargeArray
extends LargeArray {
    private static final long serialVersionUID = -3499412355469845345L;
    private byte[] data;
    private long size;
    private final Object LOCK = new Object();

    public BitLargeArray(long l) {
        this(l, true);
    }

    public BitLargeArray(long l, boolean bl) {
        this.type = LargeArrayType.BIT;
        this.sizeof = 1L;
        if (l <= 0L) {
            throw new IllegalArgumentException(l + " is not a positive long value");
        }
        this.length = l;
        long l2 = (l - 1L) / 8L;
        this.size = l2 + 1L;
        if (l > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.size * this.sizeof);
            if (bl) {
                this.zeroNativeMemory(this.size);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.sizeof));
            MemoryCounter.increaseCounter(this.size * this.sizeof);
        } else {
            this.data = new byte[(int)this.size];
        }
    }

    public BitLargeArray(boolean[] blArray) {
        this(blArray.length);
        if (this.ptr != 0L) {
            for (int i = 0; i < blArray.length; ++i) {
                int n = 0;
                if (blArray[i]) {
                    n = 1;
                }
                long l = (long)i / 8L;
                long l2 = (long)i % 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l);
                by = (byte)(65407 >> (int)l2 & by & 0xFF);
                byte by2 = (byte)(n << (int)(8L - (l2 + 1L)) | by);
                Utilities.UNSAFE.putByte(this.ptr + l, by2);
            }
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                byte by;
                int n = 0;
                if (blArray[i]) {
                    n = 1;
                }
                int n2 = i / 8;
                int n3 = i % 8;
                byte by3 = this.data[n2];
                by3 = (byte)(65407 >> n3 & by3 & 0xFF);
                this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            }
        }
    }

    @Override
    public BitLargeArray clone() {
        BitLargeArray bitLargeArray = new BitLargeArray(this.length, false);
        Utilities.arraycopy(this, 0L, bitLargeArray, 0L, this.length);
        return bitLargeArray;
    }

    @Override
    public Boolean get(long l) {
        return this.getBoolean(l);
    }

    @Override
    public Boolean getFromNative(long l) {
        long l2 = l / 8L;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
        Utilities.UNSAFE.monitorExit(this.LOCK);
        long l3 = l % 8L;
        int n = by >> (int)(8L - (l3 + 1L)) & 1;
        return n == 1;
    }

    @Override
    public boolean getBoolean(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return n == 1;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return n3 == 1;
    }

    @Override
    public byte getByte(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return (byte)n;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return (byte)n3;
    }

    @Override
    public short getShort(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return (short)n;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return (short)n3;
    }

    @Override
    public int getInt(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return n;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return n3;
    }

    @Override
    public long getLong(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return n;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return n3;
    }

    @Override
    public float getFloat(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return n;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return n3;
    }

    @Override
    public double getDouble(long l) {
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
            long l3 = l % 8L;
            int n = by >> (int)(8L - (l3 + 1L)) & 1;
            return n;
        }
        int n = (int)l / 8;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = this.data[n];
        Utilities.UNSAFE.monitorExit(this.LOCK);
        int n2 = (int)l % 8;
        int n3 = by >> 8 - (n2 + 1) & 1;
        return n3;
    }

    public byte[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        return this.data;
    }

    @Override
    public boolean[] getBooleanData() {
        if (this.ptr != 0L) {
            return null;
        }
        boolean[] blArray = new boolean[(int)this.length];
        for (int i = 0; i < blArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            int n2 = by >> 8 - (n + 1) & 1;
            blArray[i] = n2 == 1;
        }
        return blArray;
    }

    @Override
    public boolean[] getBooleanData(boolean[] blArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        boolean[] blArray2 = blArray != null && (long)blArray.length >= l4 ? blArray : new boolean[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                int n2 = by >> (int)(8L - (l6 + 1L)) & 1;
                blArray2[n++] = n2 == 1;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n3 = (int)i / 8;
                byte by = this.data[n3];
                int n4 = (int)i % 8;
                int n5 = by >> 8 - (n4 + 1) & 1;
                blArray2[n++] = n5 == 1;
            }
        }
        return blArray2;
    }

    @Override
    public byte[] getByteData() {
        if (this.ptr != 0L) {
            return null;
        }
        byte[] byArray = new byte[(int)this.length];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            byArray[i] = (byte)(by >> 8 - (n + 1) & 1);
        }
        return byArray;
    }

    @Override
    public byte[] getByteData(byte[] byArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        byte[] byArray2 = byArray != null && (long)byArray.length >= l4 ? byArray : new byte[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                byArray2[n++] = (byte)(by >> (int)(8L - (l6 + 1L)) & 1);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n2 = (int)i / 8;
                byte by = this.data[n2];
                int n3 = (int)i % 8;
                byArray2[n++] = (byte)(by >> 8 - (n3 + 1) & 1);
            }
        }
        return byArray2;
    }

    @Override
    public short[] getShortData() {
        if (this.ptr != 0L) {
            return null;
        }
        short[] sArray = new short[(int)this.length];
        for (int i = 0; i < sArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            sArray[i] = (short)(by >> 8 - (n + 1) & 1);
        }
        return sArray;
    }

    @Override
    public short[] getShortData(short[] sArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        short[] sArray2 = sArray != null && (long)sArray.length >= l4 ? sArray : new short[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                sArray2[n++] = (short)(by >> (int)(8L - (l6 + 1L)) & 1);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n2 = (int)i / 8;
                byte by = this.data[n2];
                int n3 = (int)i % 8;
                sArray2[n++] = (short)(by >> 8 - (n3 + 1) & 1);
            }
        }
        return sArray2;
    }

    @Override
    public int[] getIntData() {
        if (this.ptr != 0L) {
            return null;
        }
        int[] nArray = new int[(int)this.length];
        for (int i = 0; i < nArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            nArray[i] = by >> 8 - (n + 1) & 1;
        }
        return nArray;
    }

    @Override
    public int[] getIntData(int[] nArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        int[] nArray2 = nArray != null && (long)nArray.length >= l4 ? nArray : new int[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                nArray2[n++] = by >> (int)(8L - (l6 + 1L)) & 1;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n2 = (int)i / 8;
                byte by = this.data[n2];
                int n3 = (int)i % 8;
                nArray2[n++] = by >> 8 - (n3 + 1) & 1;
            }
        }
        return nArray2;
    }

    @Override
    public long[] getLongData() {
        if (this.ptr != 0L) {
            return null;
        }
        long[] lArray = new long[(int)this.length];
        for (int i = 0; i < lArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            lArray[i] = by >> 8 - (n + 1) & 1;
        }
        return lArray;
    }

    @Override
    public long[] getLongData(long[] lArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        long[] lArray2 = lArray != null && (long)lArray.length >= l4 ? lArray : new long[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                lArray2[n++] = by >> (int)(8L - (l6 + 1L)) & 1;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n2 = (int)i / 8;
                byte by = this.data[n2];
                int n3 = (int)i % 8;
                lArray2[n++] = by >> 8 - (n3 + 1) & 1;
            }
        }
        return lArray2;
    }

    @Override
    public float[] getFloatData() {
        if (this.ptr != 0L) {
            return null;
        }
        float[] fArray = new float[(int)this.length];
        for (int i = 0; i < fArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            fArray[i] = by >> 8 - (n + 1) & 1;
        }
        return fArray;
    }

    @Override
    public float[] getFloatData(float[] fArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] fArray2 = fArray != null && (long)fArray.length >= l4 ? fArray : new float[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                fArray2[n++] = by >> (int)(8L - (l6 + 1L)) & 1;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n2 = (int)i / 8;
                byte by = this.data[n2];
                int n3 = (int)i % 8;
                fArray2[n++] = by >> 8 - (n3 + 1) & 1;
            }
        }
        return fArray2;
    }

    @Override
    public double[] getDoubleData() {
        if (this.ptr != 0L) {
            return null;
        }
        double[] dArray = new double[(int)this.length];
        for (int i = 0; i < dArray.length; ++i) {
            byte by = this.data[i / 8];
            int n = i % 8;
            dArray[i] = by >> 8 - (n + 1) & 1;
        }
        return dArray;
    }

    @Override
    public double[] getDoubleData(double[] dArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)BitLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        double[] dArray2 = dArray != null && (long)dArray.length >= l4 ? dArray : new double[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = i / 8L;
                byte by = Utilities.UNSAFE.getByte(this.ptr + l5);
                long l6 = i % 8L;
                dArray2[n++] = by >> (int)(8L - (l6 + 1L)) & 1;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                int n2 = (int)i / 8;
                byte by = this.data[n2];
                int n3 = (int)i % 8;
                dArray2[n++] = by >> 8 - (n3 + 1) & 1;
            }
        }
        return dArray2;
    }

    @Override
    public void setToNative(long l, Object object) {
        int n = 0;
        if (((Boolean)object).booleanValue()) {
            n = 1;
        }
        long l2 = l / 8L;
        long l3 = l % 8L;
        Utilities.UNSAFE.monitorEnter(this.LOCK);
        byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
        by = (byte)(65407 >> (int)l3 & by & 0xFF);
        byte by2 = (byte)(n << (int)(8L - (l3 + 1L)) | by);
        Utilities.UNSAFE.putByte(this.ptr + l2, by2);
        Utilities.UNSAFE.monitorExit(this.LOCK);
    }

    @Override
    public void setBoolean(long l, boolean bl) {
        if (this.ptr != 0L) {
            int n = 0;
            if (bl) {
                n = 1;
            }
            long l2 = l / 8L;
            long l3 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            by = (byte)(65407 >> (int)l3 & by & 0xFF);
            byte by2 = (byte)(n << (int)(8L - (l3 + 1L)) | by);
            Utilities.UNSAFE.putByte(this.ptr + l2, by2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by;
            int n = 0;
            if (bl) {
                n = 1;
            }
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by3 = this.data[n2];
            by3 = (byte)(65407 >> n3 & by3 & 0xFF);
            this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }

    @Override
    public void setByte(long l, byte by) {
        if (by < 0 || by > 1) {
            throw new IllegalArgumentException("value has to be 0 or 1");
        }
        if (this.ptr != 0L) {
            int n = by & 0xFF;
            long l2 = l / 8L;
            long l3 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by2 = Utilities.UNSAFE.getByte(this.ptr + l2);
            by2 = (byte)(65407 >> (int)l3 & by2 & 0xFF);
            byte by3 = (byte)(n << (int)(8L - (l3 + 1L)) | by2);
            Utilities.UNSAFE.putByte(this.ptr + l2, by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by4;
            int n = by & 0xFF;
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by5 = this.data[n2];
            by5 = (byte)(65407 >> n3 & by5 & 0xFF);
            this.data[n2] = by4 = (byte)(n << 8 - (n3 + 1) | by5);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }

    @Override
    public void setShort(long l, short s) {
        if (s < 0 || s > 1) {
            throw new IllegalArgumentException("value has to be 0 or 1");
        }
        if (this.ptr != 0L) {
            int n = (byte)s & 0xFF;
            long l2 = l / 8L;
            long l3 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            by = (byte)(65407 >> (int)l3 & by & 0xFF);
            byte by2 = (byte)(n << (int)(8L - (l3 + 1L)) | by);
            Utilities.UNSAFE.putByte(this.ptr + l2, by2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by;
            int n = (byte)s & 0xFF;
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by3 = this.data[n2];
            by3 = (byte)(65407 >> n3 & by3 & 0xFF);
            this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }

    @Override
    public void setInt(long l, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("value has to ne 0 or 1");
        }
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            long l3 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            by = (byte)(65407 >> (int)l3 & by & 0xFF);
            byte by2 = (byte)(n << (int)(8L - (l3 + 1L)) | by);
            Utilities.UNSAFE.putByte(this.ptr + l2, by2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by;
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by3 = this.data[n2];
            by3 = (byte)(65407 >> n3 & by3 & 0xFF);
            this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }

    @Override
    public void setLong(long l, long l2) {
        if (l2 < 0L || l2 > 1L) {
            throw new IllegalArgumentException("value has to be 0 or 1");
        }
        int n = (int)l2;
        if (this.ptr != 0L) {
            long l3 = l / 8L;
            long l4 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l3);
            by = (byte)(65407 >> (int)l4 & by & 0xFF);
            byte by2 = (byte)(n << (int)(8L - (l4 + 1L)) | by);
            Utilities.UNSAFE.putByte(this.ptr + l3, by2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by;
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by3 = this.data[n2];
            by3 = (byte)(65407 >> n3 & by3 & 0xFF);
            this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }

    @Override
    public void setFloat(long l, float f) {
        if ((double)f != 0.0 && (double)f != 1.0) {
            throw new IllegalArgumentException("value has to be 0 or 1");
        }
        int n = (int)f;
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            long l3 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            by = (byte)(65407 >> (int)l3 & by & 0xFF);
            byte by2 = (byte)(n << (int)(8L - (l3 + 1L)) | by);
            Utilities.UNSAFE.putByte(this.ptr + l2, by2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by;
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by3 = this.data[n2];
            by3 = (byte)(65407 >> n3 & by3 & 0xFF);
            this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }

    @Override
    public void setDouble(long l, double d) {
        if (d != 0.0 && d != 1.0) {
            throw new IllegalArgumentException("value has to be 0 or 1");
        }
        int n = (int)d;
        if (this.ptr != 0L) {
            long l2 = l / 8L;
            long l3 = l % 8L;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by = Utilities.UNSAFE.getByte(this.ptr + l2);
            by = (byte)(65407 >> (int)l3 & by & 0xFF);
            byte by2 = (byte)(n << (int)(8L - (l3 + 1L)) | by);
            Utilities.UNSAFE.putByte(this.ptr + l2, by2);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        } else {
            byte by;
            int n2 = (int)l / 8;
            int n3 = (int)l % 8;
            Utilities.UNSAFE.monitorEnter(this.LOCK);
            byte by3 = this.data[n2];
            by3 = (byte)(65407 >> n3 & by3 & 0xFF);
            this.data[n2] = by = (byte)(n << 8 - (n3 + 1) | by3);
            Utilities.UNSAFE.monitorExit(this.LOCK);
        }
    }
}

