/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.Future;
import org.jtransforms.dht.DoubleDHT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class DoubleDHT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private DoubleDHT_1D dhtColumns;
    private DoubleDHT_1D dhtRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDHT_2D(long l, long l2) {
        if (l <= 1L || l2 <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)l;
        this.columns = (int)l2;
        this.rowsl = l;
        this.columnsl = l2;
        if (l * l2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2)) {
            this.isPowerOfTwo = true;
        }
        long l3 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(l, l2));
        }
        this.dhtRows = new DoubleDHT_1D(l);
        this.dhtColumns = l == l2 ? this.dhtRows : new DoubleDHT_1D(l2);
        ConcurrencyUtils.setLargeArraysBeginN(l3);
    }

    public void forward(final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, dArray, true);
                this.ddxt2d0_subth(-1, dArray, true);
            } else {
                this.ddxt2d_sub(-1, dArray, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(dArray, i * this.columns);
                }
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                DoubleDHT_2D.this.dhtColumns.forward(dArray, i * DoubleDHT_2D.this.columns);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray2[n] = dArray[n * DoubleDHT_2D.this.columns + i];
                                }
                                DoubleDHT_2D.this.dhtRows.forward(dArray2);
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray[n * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + i] = dArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(dArray, i * this.columns);
                }
                double[] dArray2 = new double[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray2[n6] = dArray[n6 * this.columns + i];
                    }
                    this.dhtRows.forward(dArray2);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray[n6 * this.columns + i] = dArray2[n6];
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    public void forward(final DoubleLargeArray doubleLargeArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, doubleLargeArray, true);
                this.ddxt2d0_subth(-1, doubleLargeArray, true);
            } else {
                this.ddxt2d_sub(-1, doubleLargeArray, true);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.forward(doubleLargeArray, i * this.columnsl);
                }
            }
            this.yTransform(doubleLargeArray);
        } else {
            if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                DoubleDHT_2D.this.dhtColumns.forward(doubleLargeArray, i * DoubleDHT_2D.this.columnsl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.columnsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.columnsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDHT_2D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l3;
                                for (l3 = 0L; l3 < DoubleDHT_2D.this.rowsl; ++l3) {
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l3 * DoubleDHT_2D.this.columnsl + i));
                                }
                                DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2);
                                for (l3 = 0L; l3 < DoubleDHT_2D.this.rowsl; ++l3) {
                                    doubleLargeArray.setDouble(l3 * DoubleDHT_2D.this.columnsl + i, doubleLargeArray2.getDouble(l3));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.forward(doubleLargeArray, i * this.columnsl);
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.rowsl, false);
                for (long i = 0L; i < this.columnsl; ++i) {
                    long l;
                    for (l = 0L; l < this.rowsl; ++l) {
                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l * this.columnsl + i));
                    }
                    this.dhtRows.forward(doubleLargeArray2);
                    for (l = 0L; l < this.rowsl; ++l) {
                        doubleLargeArray.setDouble(l * this.columnsl + i, doubleLargeArray2.getDouble(l));
                    }
                }
            }
            this.yTransform(doubleLargeArray);
        }
    }

    public void forward(final double[][] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, dArray, true);
                this.ddxt2d0_subth(-1, dArray, true);
            } else {
                this.ddxt2d_sub(-1, dArray, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(dArray[i]);
                }
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                DoubleDHT_2D.this.dhtColumns.forward(dArray[i]);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray2[n] = dArray[n][i];
                                }
                                DoubleDHT_2D.this.dhtRows.forward(dArray2);
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray[n][i] = dArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(dArray[i]);
                }
                double[] dArray2 = new double[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray2[n6] = dArray[n6][i];
                    }
                    this.dhtRows.forward(dArray2);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray[n6][i] = dArray2[n6];
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    public void inverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, dArray, bl);
                this.ddxt2d0_subth(1, dArray, bl);
            } else {
                this.ddxt2d_sub(1, dArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(dArray, i * this.columns, bl);
                }
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                DoubleDHT_2D.this.dhtColumns.inverse(dArray, i * DoubleDHT_2D.this.columns, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray2[n] = dArray[n * DoubleDHT_2D.this.columns + i];
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(dArray2, bl);
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray[n * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + i] = dArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(dArray, i * this.columns, bl);
                }
                double[] dArray2 = new double[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray2[n6] = dArray[n6 * this.columns + i];
                    }
                    this.dhtRows.inverse(dArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray[n6 * this.columns + i] = dArray2[n6];
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    public void inverse(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, doubleLargeArray, bl);
                this.ddxt2d0_subth(1, doubleLargeArray, bl);
            } else {
                this.ddxt2d_sub(1, doubleLargeArray, bl);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.inverse(doubleLargeArray, i * this.columnsl, bl);
                }
            }
            this.yTransform(doubleLargeArray);
        } else {
            if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                DoubleDHT_2D.this.dhtColumns.inverse(doubleLargeArray, i * DoubleDHT_2D.this.columnsl, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.columnsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.columnsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(DoubleDHT_2D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l3;
                                for (l3 = 0L; l3 < DoubleDHT_2D.this.rowsl; ++l3) {
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l3 * DoubleDHT_2D.this.columnsl + i));
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, bl);
                                for (l3 = 0L; l3 < DoubleDHT_2D.this.rowsl; ++l3) {
                                    doubleLargeArray.setDouble(l3 * DoubleDHT_2D.this.columnsl + i, doubleLargeArray2.getDouble(l3));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.inverse(doubleLargeArray, i * this.columnsl, bl);
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(this.rowsl, false);
                for (long i = 0L; i < this.columnsl; ++i) {
                    long l;
                    for (l = 0L; l < this.rowsl; ++l) {
                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l * this.columnsl + i));
                    }
                    this.dhtRows.inverse(doubleLargeArray2, bl);
                    for (l = 0L; l < this.rowsl; ++l) {
                        doubleLargeArray.setDouble(l * this.columnsl + i, doubleLargeArray2.getDouble(l));
                    }
                }
            }
            this.yTransform(doubleLargeArray);
        }
    }

    public void inverse(final double[][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt2d_subth(1, dArray, bl);
                this.ddxt2d0_subth(1, dArray, bl);
            } else {
                this.ddxt2d_sub(1, dArray, bl);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(dArray[i], bl);
                }
            }
            this.yTransform(dArray);
        } else {
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n2;
                int n3;
                int n4;
                Future[] futureArray = new Future[n];
                int n5 = this.rows / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.rows : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n3; i < n2; ++i) {
                                DoubleDHT_2D.this.dhtColumns.inverse(dArray[i], bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n5 = this.columns / n;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 * n5;
                    n2 = n4 == n - 1 ? this.columns : n3 + n5;
                    futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[DoubleDHT_2D.this.rows];
                            for (int i = n3; i < n2; ++i) {
                                int n;
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray2[n] = dArray[n][i];
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(dArray2, bl);
                                for (n = 0; n < DoubleDHT_2D.this.rows; ++n) {
                                    dArray[n][i] = dArray2[n];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(dArray[i], bl);
                }
                double[] dArray2 = new double[this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n6;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray2[n6] = dArray[n6][i];
                    }
                    this.dhtRows.inverse(dArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        dArray[n6][i] = dArray2[n6];
                    }
                }
            }
            this.yTransform(dArray);
        }
    }

    private void ddxt2d_subth(final int n, final double[] dArray, final boolean bl) {
        int n2 = Math.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        } else if (this.columns < 2) {
            n3 >>= 2;
        }
        final int n4 = n3;
        final int n5 = n2;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int n10;
                        int n2;
                        double[] dArray2;
                        block12: {
                            dArray2 = new double[n4];
                            if (DoubleDHT_2D.this.columns <= 2) break block12;
                            if (n == -1) {
                                for (int i = 4 * n6; i < DoubleDHT_2D.this.columns; i += 4 * n5) {
                                    int n3;
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < DoubleDHT_2D.this.rows; ++n52) {
                                        n42 = n52 * DoubleDHT_2D.this.columns + i;
                                        n3 = DoubleDHT_2D.this.rows + n52;
                                        dArray2[n52] = dArray[n42];
                                        dArray2[n3] = dArray[n42 + 1];
                                        dArray2[n3 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n42 + 2];
                                        dArray2[n3 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n42 + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, 0);
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, 2 * DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, 3 * DoubleDHT_2D.this.rows);
                                    for (n52 = 0; n52 < DoubleDHT_2D.this.rows; ++n52) {
                                        n42 = n52 * DoubleDHT_2D.this.columns + i;
                                        n3 = DoubleDHT_2D.this.rows + n52;
                                        dArray[n42] = dArray2[n52];
                                        dArray[n42 + 1] = dArray2[n3];
                                        dArray[n42 + 2] = dArray2[n3 + DoubleDHT_2D.this.rows];
                                        dArray[n42 + 3] = dArray2[n3 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int i = 4 * n6; i < DoubleDHT_2D.this.columns; i += 4 * n5) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < DoubleDHT_2D.this.rows; ++n8) {
                                        n7 = n8 * DoubleDHT_2D.this.columns + i;
                                        n62 = DoubleDHT_2D.this.rows + n8;
                                        dArray2[n8] = dArray[n7];
                                        dArray2[n62] = dArray[n7 + 1];
                                        dArray2[n62 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n7 + 2];
                                        dArray2[n62 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n7 + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, 0, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, DoubleDHT_2D.this.rows, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, 2 * DoubleDHT_2D.this.rows, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, 3 * DoubleDHT_2D.this.rows, bl);
                                    for (n8 = 0; n8 < DoubleDHT_2D.this.rows; ++n8) {
                                        n7 = n8 * DoubleDHT_2D.this.columns + i;
                                        n62 = DoubleDHT_2D.this.rows + n8;
                                        dArray[n7] = dArray2[n8];
                                        dArray[n7 + 1] = dArray2[n62];
                                        dArray[n7 + 2] = dArray2[n62 + DoubleDHT_2D.this.rows];
                                        dArray[n7 + 3] = dArray2[n62 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDHT_2D.this.columns != 2) break block13;
                        int n9 = 0;
                        while (n9 < DoubleDHT_2D.this.rows) {
                            n2 = n9 * DoubleDHT_2D.this.columns + 2 * n6;
                            n10 = n9++;
                            dArray2[n10] = dArray[n2];
                            dArray2[n10 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n2 + 1];
                        }
                        if (n == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(dArray2, 0);
                            DoubleDHT_2D.this.dhtRows.forward(dArray2, DoubleDHT_2D.this.rows);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(dArray2, 0, bl);
                            DoubleDHT_2D.this.dhtRows.inverse(dArray2, DoubleDHT_2D.this.rows, bl);
                        }
                        n9 = 0;
                        while (n9 < DoubleDHT_2D.this.rows) {
                            n2 = n9 * DoubleDHT_2D.this.columns + 2 * n6;
                            n10 = n9++;
                            dArray[n2] = dArray2[n10];
                            dArray[n2 + 1] = dArray2[n10 + DoubleDHT_2D.this.rows];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n2 = (int)Math.min(this.columnsl, (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        } else if (this.columnsl < 2L) {
            l >>= 2;
        }
        final long l2 = l;
        final int n3 = n2;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        long l;
                        long l22;
                        DoubleLargeArray doubleLargeArray2;
                        block12: {
                            doubleLargeArray2 = new DoubleLargeArray(l2, false);
                            if (DoubleDHT_2D.this.columnsl <= 2L) break block12;
                            if (n == -1) {
                                for (long i = 4L * l3; i < DoubleDHT_2D.this.columnsl; i += (long)(4 * n3)) {
                                    long l32;
                                    long l4;
                                    long l5;
                                    for (l5 = 0L; l5 < DoubleDHT_2D.this.rowsl; ++l5) {
                                        l4 = l5 * DoubleDHT_2D.this.columnsl + i;
                                        l32 = DoubleDHT_2D.this.rowsl + l5;
                                        doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l4));
                                        doubleLargeArray2.setDouble(l32, doubleLargeArray.getDouble(l4 + 1L));
                                        doubleLargeArray2.setDouble(l32 + DoubleDHT_2D.this.rowsl, doubleLargeArray.getDouble(l4 + 2L));
                                        doubleLargeArray2.setDouble(l32 + 2L * DoubleDHT_2D.this.rowsl, doubleLargeArray.getDouble(l4 + 3L));
                                    }
                                    DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2, 0L);
                                    DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2, DoubleDHT_2D.this.rowsl);
                                    DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2, 2L * DoubleDHT_2D.this.rowsl);
                                    DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2, 3L * DoubleDHT_2D.this.rowsl);
                                    for (l5 = 0L; l5 < DoubleDHT_2D.this.rowsl; ++l5) {
                                        l4 = l5 * DoubleDHT_2D.this.columnsl + i;
                                        l32 = DoubleDHT_2D.this.rowsl + l5;
                                        doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l5));
                                        doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l32));
                                        doubleLargeArray.setDouble(l4 + 2L, doubleLargeArray2.getDouble(l32 + DoubleDHT_2D.this.rowsl));
                                        doubleLargeArray.setDouble(l4 + 3L, doubleLargeArray2.getDouble(l32 + 2L * DoubleDHT_2D.this.rowsl));
                                    }
                                }
                            } else {
                                for (long i = 4L * l3; i < DoubleDHT_2D.this.columnsl; i += (long)(4 * n3)) {
                                    long l6;
                                    long l7;
                                    long l8;
                                    for (l8 = 0L; l8 < DoubleDHT_2D.this.rowsl; ++l8) {
                                        l7 = l8 * DoubleDHT_2D.this.columnsl + i;
                                        l6 = DoubleDHT_2D.this.rowsl + l8;
                                        doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l7));
                                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l7 + 1L));
                                        doubleLargeArray2.setDouble(l6 + DoubleDHT_2D.this.rowsl, doubleLargeArray.getDouble(l7 + 2L));
                                        doubleLargeArray2.setDouble(l6 + 2L * DoubleDHT_2D.this.rowsl, doubleLargeArray.getDouble(l7 + 3L));
                                    }
                                    DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, DoubleDHT_2D.this.rowsl, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, 2L * DoubleDHT_2D.this.rowsl, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, 3L * DoubleDHT_2D.this.rowsl, bl);
                                    for (l8 = 0L; l8 < DoubleDHT_2D.this.rowsl; ++l8) {
                                        l7 = l8 * DoubleDHT_2D.this.columnsl + i;
                                        l6 = DoubleDHT_2D.this.rowsl + l8;
                                        doubleLargeArray.setDouble(l7, doubleLargeArray2.getDouble(l8));
                                        doubleLargeArray.setDouble(l7 + 1L, doubleLargeArray2.getDouble(l6));
                                        doubleLargeArray.setDouble(l7 + 2L, doubleLargeArray2.getDouble(l6 + DoubleDHT_2D.this.rowsl));
                                        doubleLargeArray.setDouble(l7 + 3L, doubleLargeArray2.getDouble(l6 + 2L * DoubleDHT_2D.this.rowsl));
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDHT_2D.this.columnsl != 2L) break block13;
                        long l9 = 0L;
                        while (l9 < DoubleDHT_2D.this.rowsl) {
                            l22 = l9 * DoubleDHT_2D.this.columnsl + 2L * l3;
                            l = l9++;
                            doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l22));
                            doubleLargeArray2.setDouble(l + DoubleDHT_2D.this.rowsl, doubleLargeArray.getDouble(l22 + 1L));
                        }
                        if (n == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2, 0L);
                            DoubleDHT_2D.this.dhtRows.forward(doubleLargeArray2, DoubleDHT_2D.this.rowsl);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                            DoubleDHT_2D.this.dhtRows.inverse(doubleLargeArray2, DoubleDHT_2D.this.rowsl, bl);
                        }
                        l9 = 0L;
                        while (l9 < DoubleDHT_2D.this.rowsl) {
                            l22 = l9 * DoubleDHT_2D.this.columnsl + 2L * l3;
                            l = l9++;
                            doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l));
                            doubleLargeArray.setDouble(l22 + 1L, doubleLargeArray2.getDouble(l + DoubleDHT_2D.this.rowsl));
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_subth(final int n, final double[][] dArray, final boolean bl) {
        int n2 = Math.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        } else if (this.columns < 2) {
            n3 >>= 2;
        }
        final int n4 = n3;
        final int n5 = n2;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int n7;
                        int n2;
                        double[] dArray2;
                        block12: {
                            dArray2 = new double[n4];
                            if (DoubleDHT_2D.this.columns <= 2) break block12;
                            if (n == -1) {
                                for (int i = 4 * n6; i < DoubleDHT_2D.this.columns; i += 4 * n5) {
                                    int n3;
                                    int n42;
                                    for (n42 = 0; n42 < DoubleDHT_2D.this.rows; ++n42) {
                                        n3 = DoubleDHT_2D.this.rows + n42;
                                        dArray2[n42] = dArray[n42][i];
                                        dArray2[n3] = dArray[n42][i + 1];
                                        dArray2[n3 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n42][i + 2];
                                        dArray2[n3 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n42][i + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, 0);
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, 2 * DoubleDHT_2D.this.rows);
                                    DoubleDHT_2D.this.dhtRows.forward(dArray2, 3 * DoubleDHT_2D.this.rows);
                                    for (n42 = 0; n42 < DoubleDHT_2D.this.rows; ++n42) {
                                        n3 = DoubleDHT_2D.this.rows + n42;
                                        dArray[n42][i] = dArray2[n42];
                                        dArray[n42][i + 1] = dArray2[n3];
                                        dArray[n42][i + 2] = dArray2[n3 + DoubleDHT_2D.this.rows];
                                        dArray[n42][i + 3] = dArray2[n3 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int i = 4 * n6; i < DoubleDHT_2D.this.columns; i += 4 * n5) {
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < DoubleDHT_2D.this.rows; ++n62) {
                                        n52 = DoubleDHT_2D.this.rows + n62;
                                        dArray2[n62] = dArray[n62][i];
                                        dArray2[n52] = dArray[n62][i + 1];
                                        dArray2[n52 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n62][i + 2];
                                        dArray2[n52 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n62][i + 3];
                                    }
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, 0, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, DoubleDHT_2D.this.rows, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, 2 * DoubleDHT_2D.this.rows, bl);
                                    DoubleDHT_2D.this.dhtRows.inverse(dArray2, 3 * DoubleDHT_2D.this.rows, bl);
                                    for (n62 = 0; n62 < DoubleDHT_2D.this.rows; ++n62) {
                                        n52 = DoubleDHT_2D.this.rows + n62;
                                        dArray[n62][i] = dArray2[n62];
                                        dArray[n62][i + 1] = dArray2[n52];
                                        dArray[n62][i + 2] = dArray2[n52 + DoubleDHT_2D.this.rows];
                                        dArray[n62][i + 3] = dArray2[n52 + 2 * DoubleDHT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (DoubleDHT_2D.this.columns != 2) break block13;
                        for (n2 = 0; n2 < DoubleDHT_2D.this.rows; ++n2) {
                            n7 = n2;
                            dArray2[n7] = dArray[n2][2 * n6];
                            dArray2[n7 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = dArray[n2][2 * n6 + 1];
                        }
                        if (n == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(dArray2, 0);
                            DoubleDHT_2D.this.dhtRows.forward(dArray2, DoubleDHT_2D.this.rows);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(dArray2, 0, bl);
                            DoubleDHT_2D.this.dhtRows.inverse(dArray2, DoubleDHT_2D.this.rows, bl);
                        }
                        for (n2 = 0; n2 < DoubleDHT_2D.this.rows; ++n2) {
                            n7 = n2;
                            dArray[n2][2 * n6] = dArray2[n7];
                            dArray[n2][2 * n6 + 1] = dArray2[n7 + DoubleDHT_2D.this.rows];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < DoubleDHT_2D.this.rows; i += n2) {
                            DoubleDHT_2D.this.dhtColumns.forward(dArray, i * DoubleDHT_2D.this.columns);
                        }
                    } else {
                        for (int i = n3; i < DoubleDHT_2D.this.rows; i += n2) {
                            DoubleDHT_2D.this.dhtColumns.inverse(dArray, i * DoubleDHT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == -1) {
                        for (long i = l; i < DoubleDHT_2D.this.rowsl; i += (long)n2) {
                            DoubleDHT_2D.this.dhtColumns.forward(doubleLargeArray, i * DoubleDHT_2D.this.columnsl);
                        }
                    } else {
                        for (long i = l; i < DoubleDHT_2D.this.rowsl; i += (long)n2) {
                            DoubleDHT_2D.this.dhtColumns.inverse(doubleLargeArray, i * DoubleDHT_2D.this.columnsl, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d0_subth(final int n, final double[][] dArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == -1) {
                        for (int i = n3; i < DoubleDHT_2D.this.rows; i += n2) {
                            DoubleDHT_2D.this.dhtColumns.forward(dArray[i]);
                        }
                    } else {
                        for (int i = n3; i < DoubleDHT_2D.this.rows; i += n2) {
                            DoubleDHT_2D.this.dhtColumns.inverse(dArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt2d_sub(int n, double[] dArray, boolean bl) {
        block16: {
            int n2;
            int n3;
            double[] dArray2;
            block15: {
                int n4 = 4 * this.rows;
                if (this.columns == 2) {
                    n4 >>= 1;
                } else if (this.columns < 2) {
                    n4 >>= 2;
                }
                dArray2 = new double[n4];
                if (this.columns <= 2) break block15;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n5;
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n7 * this.columns + i;
                            n5 = this.rows + n7;
                            dArray2[n7] = dArray[n6];
                            dArray2[n5] = dArray[n6 + 1];
                            dArray2[n5 + this.rows] = dArray[n6 + 2];
                            dArray2[n5 + 2 * this.rows] = dArray[n6 + 3];
                        }
                        this.dhtRows.forward(dArray2, 0);
                        this.dhtRows.forward(dArray2, this.rows);
                        this.dhtRows.forward(dArray2, 2 * this.rows);
                        this.dhtRows.forward(dArray2, 3 * this.rows);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = n7 * this.columns + i;
                            n5 = this.rows + n7;
                            dArray[n6] = dArray2[n7];
                            dArray[n6 + 1] = dArray2[n5];
                            dArray[n6 + 2] = dArray2[n5 + this.rows];
                            dArray[n6 + 3] = dArray2[n5 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n9 = n10 * this.columns + i;
                            n8 = this.rows + n10;
                            dArray2[n10] = dArray[n9];
                            dArray2[n8] = dArray[n9 + 1];
                            dArray2[n8 + this.rows] = dArray[n9 + 2];
                            dArray2[n8 + 2 * this.rows] = dArray[n9 + 3];
                        }
                        this.dhtRows.inverse(dArray2, 0, bl);
                        this.dhtRows.inverse(dArray2, this.rows, bl);
                        this.dhtRows.inverse(dArray2, 2 * this.rows, bl);
                        this.dhtRows.inverse(dArray2, 3 * this.rows, bl);
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n9 = n10 * this.columns + i;
                            n8 = this.rows + n10;
                            dArray[n9] = dArray2[n10];
                            dArray[n9 + 1] = dArray2[n8];
                            dArray[n9 + 2] = dArray2[n8 + this.rows];
                            dArray[n9 + 3] = dArray2[n8 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                dArray2[n3] = dArray[n2];
                dArray2[this.rows + n3] = dArray[n2 + 1];
            }
            if (n == -1) {
                this.dhtRows.forward(dArray2, 0);
                this.dhtRows.forward(dArray2, this.rows);
            } else {
                this.dhtRows.inverse(dArray2, 0, bl);
                this.dhtRows.inverse(dArray2, this.rows, bl);
            }
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n3 * this.columns;
                dArray[n2] = dArray2[n3];
                dArray[n2 + 1] = dArray2[this.rows + n3];
            }
        }
    }

    private void ddxt2d_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        block16: {
            long l;
            long l2;
            DoubleLargeArray doubleLargeArray2;
            block15: {
                long l3 = 4L * this.rowsl;
                if (this.columnsl == 2L) {
                    l3 >>= 1;
                } else if (this.columnsl < 2L) {
                    l3 >>= 2;
                }
                doubleLargeArray2 = new DoubleLargeArray(l3, false);
                if (this.columnsl <= 2L) break block15;
                if (n == -1) {
                    for (long i = 0L; i < this.columnsl; i += 4L) {
                        long l4;
                        long l5;
                        long l6;
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l5 = l6 * this.columnsl + i;
                            l4 = this.rowsl + l6;
                            doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l5));
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5 + 1L));
                            doubleLargeArray2.setDouble(l4 + this.rowsl, doubleLargeArray.getDouble(l5 + 2L));
                            doubleLargeArray2.setDouble(l4 + 2L * this.rowsl, doubleLargeArray.getDouble(l5 + 3L));
                        }
                        this.dhtRows.forward(doubleLargeArray2, 0L);
                        this.dhtRows.forward(doubleLargeArray2, this.rowsl);
                        this.dhtRows.forward(doubleLargeArray2, 2L * this.rowsl);
                        this.dhtRows.forward(doubleLargeArray2, 3L * this.rowsl);
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l5 = l6 * this.columnsl + i;
                            l4 = this.rowsl + l6;
                            doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l6));
                            doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4));
                            doubleLargeArray.setDouble(l5 + 2L, doubleLargeArray2.getDouble(l4 + this.rowsl));
                            doubleLargeArray.setDouble(l5 + 3L, doubleLargeArray2.getDouble(l4 + 2L * this.rowsl));
                        }
                    }
                } else {
                    for (long i = 0L; i < this.columnsl; i += 4L) {
                        long l7;
                        long l8;
                        long l9;
                        for (l9 = 0L; l9 < this.rowsl; ++l9) {
                            l8 = l9 * this.columnsl + i;
                            l7 = this.rowsl + l9;
                            doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l8));
                            doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l8 + 1L));
                            doubleLargeArray2.setDouble(l7 + this.rowsl, doubleLargeArray.getDouble(l8 + 2L));
                            doubleLargeArray2.setDouble(l7 + 2L * this.rowsl, doubleLargeArray.getDouble(l8 + 3L));
                        }
                        this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                        this.dhtRows.inverse(doubleLargeArray2, this.rowsl, bl);
                        this.dhtRows.inverse(doubleLargeArray2, 2L * this.rowsl, bl);
                        this.dhtRows.inverse(doubleLargeArray2, 3L * this.rowsl, bl);
                        for (l9 = 0L; l9 < this.rowsl; ++l9) {
                            l8 = l9 * this.columnsl + i;
                            l7 = this.rowsl + l9;
                            doubleLargeArray.setDouble(l8, doubleLargeArray2.getDouble(l9));
                            doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray2.getDouble(l7));
                            doubleLargeArray.setDouble(l8 + 2L, doubleLargeArray2.getDouble(l7 + this.rowsl));
                            doubleLargeArray.setDouble(l8 + 3L, doubleLargeArray2.getDouble(l7 + 2L * this.rowsl));
                        }
                    }
                }
                break block16;
            }
            if (this.columnsl != 2L) break block16;
            for (l2 = 0L; l2 < this.rowsl; ++l2) {
                l = l2 * this.columnsl;
                doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l));
                doubleLargeArray2.setDouble(this.rowsl + l2, doubleLargeArray.getDouble(l + 1L));
            }
            if (n == -1) {
                this.dhtRows.forward(doubleLargeArray2, 0L);
                this.dhtRows.forward(doubleLargeArray2, this.rowsl);
            } else {
                this.dhtRows.inverse(doubleLargeArray2, 0L, bl);
                this.dhtRows.inverse(doubleLargeArray2, this.rowsl, bl);
            }
            for (l2 = 0L; l2 < this.rowsl; ++l2) {
                l = l2 * this.columnsl;
                doubleLargeArray.setDouble(l, doubleLargeArray2.getDouble(l2));
                doubleLargeArray.setDouble(l + 1L, doubleLargeArray2.getDouble(this.rowsl + l2));
            }
        }
    }

    private void ddxt2d_sub(int n, double[][] dArray, boolean bl) {
        block16: {
            int n2;
            double[] dArray2;
            block15: {
                int n3 = 4 * this.rows;
                if (this.columns == 2) {
                    n3 >>= 1;
                } else if (this.columns < 2) {
                    n3 >>= 2;
                }
                dArray2 = new double[n3];
                if (this.columns <= 2) break block15;
                if (n == -1) {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n4;
                        int n5;
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            dArray2[n5] = dArray[n5][i];
                            dArray2[n4] = dArray[n5][i + 1];
                            dArray2[n4 + this.rows] = dArray[n5][i + 2];
                            dArray2[n4 + 2 * this.rows] = dArray[n5][i + 3];
                        }
                        this.dhtRows.forward(dArray2, 0);
                        this.dhtRows.forward(dArray2, this.rows);
                        this.dhtRows.forward(dArray2, 2 * this.rows);
                        this.dhtRows.forward(dArray2, 3 * this.rows);
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            dArray[n5][i] = dArray2[n5];
                            dArray[n5][i + 1] = dArray2[n4];
                            dArray[n5][i + 2] = dArray2[n4 + this.rows];
                            dArray[n5][i + 3] = dArray2[n4 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns; i += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = this.rows + n7;
                            dArray2[n7] = dArray[n7][i];
                            dArray2[n6] = dArray[n7][i + 1];
                            dArray2[n6 + this.rows] = dArray[n7][i + 2];
                            dArray2[n6 + 2 * this.rows] = dArray[n7][i + 3];
                        }
                        this.dhtRows.inverse(dArray2, 0, bl);
                        this.dhtRows.inverse(dArray2, this.rows, bl);
                        this.dhtRows.inverse(dArray2, 2 * this.rows, bl);
                        this.dhtRows.inverse(dArray2, 3 * this.rows, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n6 = this.rows + n7;
                            dArray[n7][i] = dArray2[n7];
                            dArray[n7][i + 1] = dArray2[n6];
                            dArray[n7][i + 2] = dArray2[n6 + this.rows];
                            dArray[n7][i + 3] = dArray2[n6 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (n2 = 0; n2 < this.rows; ++n2) {
                dArray2[n2] = dArray[n2][0];
                dArray2[this.rows + n2] = dArray[n2][1];
            }
            if (n == -1) {
                this.dhtRows.forward(dArray2, 0);
                this.dhtRows.forward(dArray2, this.rows);
            } else {
                this.dhtRows.inverse(dArray2, 0, bl);
                this.dhtRows.inverse(dArray2, this.rows, bl);
            }
            for (n2 = 0; n2 < this.rows; ++n2) {
                dArray[n2][0] = dArray2[n2];
                dArray[n2][1] = dArray2[this.rows + n2];
            }
        }
    }

    private void yTransform(double[] dArray) {
        for (int i = 0; i <= this.rows / 2; ++i) {
            int n = (this.rows - i) % this.rows;
            int n2 = i * this.columns;
            int n3 = n * this.columns;
            for (int j = 0; j <= this.columns / 2; ++j) {
                int n4 = (this.columns - j) % this.columns;
                double d = dArray[n2 + j];
                double d2 = dArray[n3 + j];
                double d3 = dArray[n2 + n4];
                double d4 = dArray[n3 + n4];
                double d5 = (d + d4 - (d2 + d3)) / 2.0;
                dArray[n2 + j] = d - d5;
                dArray[n3 + j] = d2 + d5;
                dArray[n2 + n4] = d3 + d5;
                dArray[n3 + n4] = d4 - d5;
            }
        }
    }

    private void yTransform(DoubleLargeArray doubleLargeArray) {
        for (long i = 0L; i <= this.rowsl / 2L; ++i) {
            long l = (this.rowsl - i) % this.rowsl;
            long l2 = i * this.columnsl;
            long l3 = l * this.columnsl;
            for (long j = 0L; j <= this.columnsl / 2L; ++j) {
                long l4 = (this.columnsl - j) % this.columnsl;
                double d = doubleLargeArray.getDouble(l2 + j);
                double d2 = doubleLargeArray.getDouble(l3 + j);
                double d3 = doubleLargeArray.getDouble(l2 + l4);
                double d4 = doubleLargeArray.getDouble(l3 + l4);
                double d5 = (d + d4 - (d2 + d3)) / 2.0;
                doubleLargeArray.setDouble(l2 + j, d - d5);
                doubleLargeArray.setDouble(l3 + j, d2 + d5);
                doubleLargeArray.setDouble(l2 + l4, d3 + d5);
                doubleLargeArray.setDouble(l3 + l4, d4 - d5);
            }
        }
    }

    private void yTransform(double[][] dArray) {
        for (int i = 0; i <= this.rows / 2; ++i) {
            int n = (this.rows - i) % this.rows;
            for (int j = 0; j <= this.columns / 2; ++j) {
                int n2 = (this.columns - j) % this.columns;
                double d = dArray[i][j];
                double d2 = dArray[n][j];
                double d3 = dArray[i][n2];
                double d4 = dArray[n][n2];
                double d5 = (d + d4 - (d2 + d3)) / 2.0;
                dArray[i][j] = d - d5;
                dArray[n][j] = d2 + d5;
                dArray[i][n2] = d3 + d5;
                dArray[n][n2] = d4 - d5;
            }
        }
    }
}

