/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.Future;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public class DoubleFFT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleFFT_1D fftSlices;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleFFT_3D(long l, long l2, long l3) {
        if (l <= 1L || l2 <= 1L || l3 <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)l;
        this.rows = (int)l2;
        this.columns = (int)l3;
        this.slicesl = l;
        this.rowsl = l2;
        this.columnsl = l3;
        this.sliceStride = (int)(l2 * l3);
        this.rowStride = (int)l3;
        this.sliceStridel = l2 * l3;
        this.rowStridel = l3;
        if (l * l2 * l3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2) && ConcurrencyUtils.isPowerOf2(l3)) {
            this.isPowerOfTwo = true;
        }
        long l4 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 * l3 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(Math.min(l2, l3), l));
        }
        this.fftSlices = new DoubleFFT_1D(l);
        this.fftRows = l == l2 ? this.fftSlices : new DoubleFFT_1D(l2);
        this.fftColumns = l == l3 ? this.fftSlices : (l2 == l3 ? this.fftRows : new DoubleFFT_1D(l3));
        ConcurrencyUtils.setLargeArraysBeginN(l4);
    }

    public void complexForward(final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
            } else {
                this.xdft3da_sub2(0, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray, n + j * DoubleFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexForward(dArray, n13 + n12 * this.rowStride);
                    }
                }
                double[] dArray2 = new double[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftRows.complexForward(dArray2);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
                dArray2 = new double[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftSlices.complexForward(dArray2);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final DoubleLargeArray doubleLargeArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            long l = this.columnsl;
            this.columnsl = 2L * this.columnsl;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0L, -1, doubleLargeArray, true);
                this.cdft3db_subth(-1, doubleLargeArray, true);
            } else {
                this.xdft3da_sub2(0L, -1, doubleLargeArray, true);
                this.cdft3db_sub(-1, doubleLargeArray, true);
            }
            this.columnsl = l;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        } else {
            this.sliceStridel = 2L * this.rowsl * this.columnsl;
            this.rowStridel = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.slicesl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                long l3 = i * DoubleFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(doubleLargeArray, l3 + j * DoubleFFT_3D.this.rowStridel);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * DoubleFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * DoubleFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l3));
                                        doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2);
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * DoubleFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        doubleLargeArray.setDouble(l3, doubleLargeArray2.getDouble(l22));
                                        doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * DoubleFFT_3D.this.rowStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * DoubleFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l3));
                                        doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2);
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * DoubleFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        doubleLargeArray.setDouble(l3, doubleLargeArray2.getDouble(l22));
                                        doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                long l;
                long l4;
                long l5;
                long l6;
                long l7;
                long l8;
                long l9;
                for (long i = 0L; i < this.slicesl; ++i) {
                    long l10 = i * this.sliceStridel;
                    for (long j = 0L; j < this.rowsl; ++j) {
                        this.fftColumns.complexForward(doubleLargeArray, l10 + j * this.rowStridel);
                    }
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.rowsl, false);
                for (l9 = 0L; l9 < this.slicesl; ++l9) {
                    l8 = l9 * this.sliceStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l4));
                            doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l4 + 1L));
                        }
                        this.fftRows.complexForward(doubleLargeArray2);
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l));
                            doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l + 1L));
                        }
                    }
                }
                doubleLargeArray2 = new DoubleLargeArray(2L * this.slicesl, false);
                for (l9 = 0L; l9 < this.rowsl; ++l9) {
                    l8 = l9 * this.rowStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l4));
                            doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l4 + 1L));
                        }
                        this.fftSlices.complexForward(doubleLargeArray2);
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l));
                            doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l + 1L));
                        }
                    }
                }
            }
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        }
    }

    public void complexForward(final double[][][] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
            } else {
                this.xdft3da_sub2(0, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.complexForward(dArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n32];
                                    dArray2[n + 1] = dArray[i][n2][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n32] = dArray2[n];
                                    dArray[i][n2][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n32];
                                    dArray2[n + 1] = dArray[n2][i][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n32] = dArray2[n];
                                    dArray[n2][i][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexForward(dArray[i][n11]);
                }
            }
            double[] dArray2 = new double[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n11][n8][n9];
                        dArray2[n7 + 1] = dArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray[n11][n8][n9] = dArray2[n7];
                        dArray[n11][n8][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n8][n11][n9];
                        dArray2[n7 + 1] = dArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexForward(dArray2);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray[n8][n11][n9] = dArray2[n7];
                        dArray[n8][n11][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray, n + j * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(dArray, n13 + n12 * this.rowStride, bl);
                    }
                }
                double[] dArray2 = new double[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftRows.complexInverse(dArray2, bl);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
                dArray2 = new double[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftSlices.complexInverse(dArray2, bl);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            long l = this.columnsl;
            this.columnsl = 2L * this.columnsl;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0L, 1, doubleLargeArray, bl);
                this.cdft3db_subth(1, doubleLargeArray, bl);
            } else {
                this.xdft3da_sub2(0L, 1, doubleLargeArray, bl);
                this.cdft3db_sub(1, doubleLargeArray, bl);
            }
            this.columnsl = l;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        } else {
            this.sliceStridel = 2L * this.rowsl * this.columnsl;
            this.rowStridel = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l;
                long l2;
                int n2;
                Future[] futureArray = new Future[n];
                long l3 = this.slicesl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l2; i < l; ++i) {
                                long l3 = i * DoubleFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(doubleLargeArray, l3 + j * DoubleFFT_3D.this.rowStridel, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.slicesl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * DoubleFFT_3D.this.sliceStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * DoubleFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l3));
                                        doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, bl);
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.rowsl; ++l4) {
                                        l3 = l6 + l5 + l4 * DoubleFFT_3D.this.rowStridel;
                                        l22 = 2L * l4;
                                        doubleLargeArray.setDouble(l3, doubleLargeArray2.getDouble(l22));
                                        doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l3 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l2 = (long)n2 * l3;
                    l = n2 == n - 1 ? this.rowsl : l2 + l3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                            for (long i = l2; i < l; ++i) {
                                long l6 = i * DoubleFFT_3D.this.rowStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                    long l22;
                                    long l3;
                                    long l4;
                                    long l5 = 2L * j;
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * DoubleFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l3));
                                        doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, bl);
                                    for (l4 = 0L; l4 < DoubleFFT_3D.this.slicesl; ++l4) {
                                        l3 = l4 * DoubleFFT_3D.this.sliceStridel + l6 + l5;
                                        l22 = 2L * l4;
                                        doubleLargeArray.setDouble(l3, doubleLargeArray2.getDouble(l22));
                                        doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                long l;
                long l4;
                long l5;
                long l6;
                long l7;
                long l8;
                long l9;
                for (long i = 0L; i < this.slicesl; ++i) {
                    long l10 = i * this.sliceStridel;
                    for (long j = 0L; j < this.rowsl; ++j) {
                        this.fftColumns.complexInverse(doubleLargeArray, l10 + j * this.rowStridel, bl);
                    }
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.rowsl, false);
                for (l9 = 0L; l9 < this.slicesl; ++l9) {
                    l8 = l9 * this.sliceStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l4));
                            doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l4 + 1L));
                        }
                        this.fftRows.complexInverse(doubleLargeArray2, bl);
                        for (l5 = 0L; l5 < this.rowsl; ++l5) {
                            l4 = l8 + l6 + l5 * this.rowStridel;
                            l = 2L * l5;
                            doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l));
                            doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l + 1L));
                        }
                    }
                }
                doubleLargeArray2 = new DoubleLargeArray(2L * this.slicesl, false);
                for (l9 = 0L; l9 < this.rowsl; ++l9) {
                    l8 = l9 * this.rowStridel;
                    for (l7 = 0L; l7 < this.columnsl; ++l7) {
                        l6 = 2L * l7;
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l4));
                            doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l4 + 1L));
                        }
                        this.fftSlices.complexInverse(doubleLargeArray2, bl);
                        for (l5 = 0L; l5 < this.slicesl; ++l5) {
                            l4 = l5 * this.sliceStridel + l8 + l6;
                            l = 2L * l5;
                            doubleLargeArray.setDouble(l4, doubleLargeArray2.getDouble(l));
                            doubleLargeArray.setDouble(l4 + 1L, doubleLargeArray2.getDouble(l + 1L));
                        }
                    }
                }
            }
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        }
    }

    public void complexInverse(final double[][][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.complexInverse(dArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n32];
                                    dArray2[n + 1] = dArray[i][n2][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n32] = dArray2[n];
                                    dArray[i][n2][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n32];
                                    dArray2[n + 1] = dArray[n2][i][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n32] = dArray2[n];
                                    dArray[n2][i][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexInverse(dArray[i][n11], bl);
                }
            }
            double[] dArray2 = new double[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n11][n8][n9];
                        dArray2[n7 + 1] = dArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray[n11][n8][n9] = dArray2[n7];
                        dArray[n11][n8][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n8][n11][n9];
                        dArray2[n7 + 1] = dArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray[n8][n11][n9] = dArray2[n7];
                        dArray[n8][n11][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void realForward(double[] dArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub1(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
    }

    public void realForward(DoubleLargeArray doubleLargeArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1L, -1, doubleLargeArray, true);
            this.cdft3db_subth(-1, doubleLargeArray, true);
            this.rdft3d_sub(1, doubleLargeArray);
        } else {
            this.xdft3da_sub1(1L, -1, doubleLargeArray, true);
            this.cdft3db_sub(-1, doubleLargeArray, true);
            this.rdft3d_sub(1, doubleLargeArray);
        }
    }

    public void realForward(double[][][] dArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub1(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
    }

    public void realForwardFull(double[] dArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealForwardFull(dArray);
        }
    }

    public void realForwardFull(DoubleLargeArray doubleLargeArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, -1, doubleLargeArray, true);
                this.cdft3db_subth(-1, doubleLargeArray, true);
                this.rdft3d_sub(1, doubleLargeArray);
            } else {
                this.xdft3da_sub2(1L, -1, doubleLargeArray, true);
                this.cdft3db_sub(-1, doubleLargeArray, true);
                this.rdft3d_sub(1, doubleLargeArray);
            }
            this.fillSymmetric(doubleLargeArray);
        } else {
            this.mixedRadixRealForwardFull(doubleLargeArray);
        }
    }

    public void realForwardFull(double[][][] dArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealForwardFull(dArray);
        }
    }

    public void realInverse(double[] dArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_subth(1, dArray, bl);
            this.xdft3da_subth1(1, 1, dArray, bl);
        } else {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_sub(1, dArray, bl);
            this.xdft3da_sub1(1, 1, dArray, bl);
        }
    }

    public void realInverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, doubleLargeArray);
            this.cdft3db_subth(1, doubleLargeArray, bl);
            this.xdft3da_subth1(1L, 1, doubleLargeArray, bl);
        } else {
            this.rdft3d_sub(-1, doubleLargeArray);
            this.cdft3db_sub(1, doubleLargeArray, bl);
            this.xdft3da_sub1(1L, 1, doubleLargeArray, bl);
        }
    }

    public void realInverse(double[][][] dArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_subth(1, dArray, bl);
            this.xdft3da_subth1(1, 1, dArray, bl);
        } else {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_sub(1, dArray, bl);
            this.xdft3da_sub1(1, 1, dArray, bl);
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealInverseFull(dArray, bl);
        }
    }

    public void realInverseFull(DoubleLargeArray doubleLargeArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, 1, doubleLargeArray, bl);
                this.cdft3db_subth(1, doubleLargeArray, bl);
                this.rdft3d_sub(1, doubleLargeArray);
            } else {
                this.xdft3da_sub2(1L, 1, doubleLargeArray, bl);
                this.cdft3db_sub(1, doubleLargeArray, bl);
                this.rdft3d_sub(1, doubleLargeArray);
            }
            this.fillSymmetric(doubleLargeArray);
        } else {
            this.mixedRadixRealInverseFull(doubleLargeArray, bl);
        }
    }

    public void realInverseFull(double[][][] dArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealInverseFull(dArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final double[][][] dArray) {
        double[] dArray2 = new double[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.realForwardFull(dArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n3];
                                    dArray2[n + 1] = dArray[i][n2][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n3] = dArray2[n];
                                    dArray[i][n2][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n3];
                                    dArray2[n + 1] = dArray[n2][i][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n3] = dArray2[n];
                                    dArray[n2][i][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    dArray[n][n22][n4 % n2] = dArray[i][j][n32];
                                    dArray[n][n22][(n4 + 1) % n2] = -dArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realForwardFull(dArray[n13][n12]);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n13][n10][n11];
                        dArray2[n9 + 1] = dArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray[n13][n10][n11] = dArray2[n9];
                        dArray[n13][n10][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n10][n13][n11];
                        dArray2[n9 + 1] = dArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexForward(dArray2);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray[n10][n13][n11] = dArray2[n9];
                        dArray[n10][n13][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        dArray[n12][n10][n15 % n2] = dArray[n13][n11][n14];
                        dArray[n12][n10][(n15 + 1) % n2] = -dArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[][][] dArray, final boolean bl) {
        double[] dArray2 = new double[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.realInverseFull(dArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n3];
                                    dArray2[n + 1] = dArray[i][n2][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n3] = dArray2[n];
                                    dArray[i][n2][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n3];
                                    dArray2[n + 1] = dArray[n2][i][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n3] = dArray2[n];
                                    dArray[n2][i][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    dArray[n][n22][n4 % n2] = dArray[i][j][n32];
                                    dArray[n][n22][(n4 + 1) % n2] = -dArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realInverseFull(dArray[n13][n12], bl);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n13][n10][n11];
                        dArray2[n9 + 1] = dArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray[n13][n10][n11] = dArray2[n9];
                        dArray[n13][n10][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n10][n13][n11];
                        dArray2[n9 + 1] = dArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, bl);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray[n10][n13][n11] = dArray2[n9];
                        dArray[n10][n13][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        dArray[n12][n10][n15 % n2] = dArray[n13][n11][n14];
                        dArray[n12][n10][(n15 + 1) % n2] = -dArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final double[] dArray) {
        final int n = 2 * this.columns;
        double[] dArray2 = new double[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * DoubleFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = DoubleFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(dArray, n3 + j * DoubleFFT_3D.this.rowStride, dArray2, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(dArray2);
                                System.arraycopy(dArray2, 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final double[][][] dArray3 = new double[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * DoubleFFT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray, n + j * DoubleFFT_3D.this.rowStride, dArray3[i][j], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(dArray3[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray3[i][j], 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray2[n2] = dArray[n3];
                                    dArray2[n2 + 1] = dArray[n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray[n3] = dArray2[n2];
                                    dArray[n3 + 1] = dArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray2[n3] = dArray[n2];
                                    dArray2[n3 + 1] = dArray[n2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray[n2] = dArray2[n3];
                                    dArray[n2 + 1] = dArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = DoubleFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    dArray[n7 + n92 % n] = dArray[n10];
                                    dArray[n7 + (n92 + 1) % n] = -dArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(dArray, n17 + n15 * this.rowStride, dArray2, 0, this.columns);
                    this.fftColumns.realForwardFull(dArray2);
                    System.arraycopy(dArray2, 0, dArray, n16 + n15 * n5, n);
                }
            }
            dArray2 = new double[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftSlices.complexForward(dArray2);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        dArray[n20 + n22 % n] = dArray[n23];
                        dArray[n20 + (n22 + 1) % n] = -dArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final DoubleLargeArray doubleLargeArray) {
        final long l = 2L * this.columnsl;
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l, false);
        long l2 = this.rowsl / 2L + 1L;
        final long l3 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long l4 = 2L * this.sliceStridel;
        final long l5 = 2L * this.rowStridel;
        long l6 = this.slicesl / 2L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && l6 >= (long)n && this.columnsl >= (long)n && l2 >= (long)n) {
            long l7;
            long l8;
            int n2;
            Future[] futureArray = new Future[n];
            long l9 = l6 / (long)n;
            for (int i = 0; i < n; ++i) {
                final long l10 = this.slicesl - 1L - (long)i * l9;
                final long l11 = i == n - 1 ? l6 + 1L : l10 - l9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l, false);
                        for (long i = l10; i >= l11; --i) {
                            long l3 = i * DoubleFFT_3D.this.sliceStridel;
                            long l2 = i * l4;
                            for (long j = DoubleFFT_3D.this.rowsl - 1L; j >= 0L; --j) {
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray, (long)(l3 + j * DoubleFFT_3D.this.rowStridel), (DoubleLargeArray)doubleLargeArray2, (long)0L, (long)DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(doubleLargeArray2);
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final DoubleLargeArray doubleLargeArray3 = new DoubleLargeArray((l6 + 1L) * this.rowsl * l, false);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * DoubleFFT_3D.this.sliceStridel;
                            for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray, (long)(l2 + j * DoubleFFT_3D.this.rowStridel), (DoubleLargeArray)doubleLargeArray3, (long)(i * DoubleFFT_3D.this.rowsl * l + j * l), (long)DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(doubleLargeArray3, i * DoubleFFT_3D.this.rowsl * l + j * l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * l4;
                            for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray3, (long)(i * DoubleFFT_3D.this.rowsl * l + j * l), (DoubleLargeArray)doubleLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l4;
                            for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l3));
                                    doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l3 + 1L));
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2);
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    doubleLargeArray.setDouble(l3, doubleLargeArray2.getDouble(l2));
                                    doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = l2 / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l2 : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l5;
                            for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l2));
                                    doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l2 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2);
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l3));
                                    doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(l3 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l11 = (DoubleFFT_3D.this.slicesl - i) % DoubleFFT_3D.this.slicesl;
                            long l2 = l11 * l4;
                            long l32 = i * l4;
                            for (long j = 1L; j < l3; ++j) {
                                long l42 = DoubleFFT_3D.this.rowsl - j;
                                long l52 = l42 * l5;
                                long l6 = j * l5;
                                long l72 = l2 + l52;
                                for (long k = 0L; k < DoubleFFT_3D.this.columnsl; ++k) {
                                    long l82 = 2L * k;
                                    long l9 = l - l82;
                                    long l10 = l32 + l6 + l82;
                                    doubleLargeArray.setDouble(l72 + l9 % l, doubleLargeArray.getDouble(l10));
                                    doubleLargeArray.setDouble(l72 + (l9 + 1L) % l, -doubleLargeArray.getDouble(l10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l12;
            long l13;
            long l14;
            long l15;
            long l16;
            long l17;
            long l18;
            for (l18 = this.slicesl - 1L; l18 >= 0L; --l18) {
                l17 = l18 * this.sliceStridel;
                l16 = l18 * l4;
                for (l15 = this.rowsl - 1L; l15 >= 0L; --l15) {
                    Utilities.arraycopy((DoubleLargeArray)doubleLargeArray, (long)(l17 + l15 * this.rowStridel), (DoubleLargeArray)doubleLargeArray2, (long)0L, (long)this.columnsl);
                    this.fftColumns.realForwardFull(doubleLargeArray2);
                    Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)(l16 + l15 * l5), (long)l);
                }
            }
            doubleLargeArray2 = new DoubleLargeArray(2L * this.rowsl, false);
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = l18 * l4;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l12));
                        doubleLargeArray2.setDouble(l13 + 1L, doubleLargeArray.getDouble(l12 + 1L));
                    }
                    this.fftRows.complexForward(doubleLargeArray2);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        doubleLargeArray.setDouble(l12, doubleLargeArray2.getDouble(l13));
                        doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray2.getDouble(l13 + 1L));
                    }
                }
            }
            doubleLargeArray2 = new DoubleLargeArray(2L * this.slicesl, false);
            for (l18 = 0L; l18 < l2; ++l18) {
                l17 = l18 * l5;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l12));
                        doubleLargeArray2.setDouble(l13 + 1L, doubleLargeArray.getDouble(l12 + 1L));
                    }
                    this.fftSlices.complexForward(doubleLargeArray2);
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        doubleLargeArray.setDouble(l12, doubleLargeArray2.getDouble(l13));
                        doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray2.getDouble(l13 + 1L));
                    }
                }
            }
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = (this.slicesl - l18) % this.slicesl;
                l16 = l17 * l4;
                l15 = l18 * l4;
                for (l14 = 1L; l14 < l3; ++l14) {
                    l13 = this.rowsl - l14;
                    l12 = l13 * l5;
                    long l19 = l14 * l5;
                    long l20 = l16 + l12;
                    for (long i = 0L; i < this.columnsl; ++i) {
                        long l21 = 2L * i;
                        long l22 = l - l21;
                        long l23 = l15 + l19 + l21;
                        doubleLargeArray.setDouble(l20 + l22 % l, doubleLargeArray.getDouble(l23));
                        doubleLargeArray.setDouble(l20 + (l22 + 1L) % l, -doubleLargeArray.getDouble(l23 + 1L));
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[] dArray, final boolean bl) {
        final int n = 2 * this.columns;
        double[] dArray2 = new double[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * DoubleFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = DoubleFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(dArray, n3 + j * DoubleFFT_3D.this.rowStride, dArray2, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(dArray2, bl);
                                System.arraycopy(dArray2, 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final double[][][] dArray3 = new double[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * DoubleFFT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray, n + j * DoubleFFT_3D.this.rowStride, dArray3[i][j], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(dArray3[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray3[i][j], 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray2[n2] = dArray[n3];
                                    dArray2[n2 + 1] = dArray[n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray[n3] = dArray2[n2];
                                    dArray[n3 + 1] = dArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray2[n3] = dArray[n2];
                                    dArray2[n3 + 1] = dArray[n2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray[n2] = dArray2[n3];
                                    dArray[n2 + 1] = dArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = DoubleFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    dArray[n7 + n92 % n] = dArray[n10];
                                    dArray[n7 + (n92 + 1) % n] = -dArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(dArray, n17 + n15 * this.rowStride, dArray2, 0, this.columns);
                    this.fftColumns.realInverseFull(dArray2, bl);
                    System.arraycopy(dArray2, 0, dArray, n16 + n15 * n5, n);
                }
            }
            dArray2 = new double[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, bl);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        dArray[n20 + n22 % n] = dArray[n23];
                        dArray[n20 + (n22 + 1) % n] = -dArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final long l = 2L * this.columnsl;
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l, false);
        long l2 = this.rowsl / 2L + 1L;
        final long l3 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long l4 = 2L * this.sliceStridel;
        final long l5 = 2L * this.rowStridel;
        long l6 = this.slicesl / 2L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && l6 >= (long)n && this.columnsl >= (long)n && l2 >= (long)n) {
            long l7;
            long l8;
            int n2;
            Future[] futureArray = new Future[n];
            long l9 = l6 / (long)n;
            for (int i = 0; i < n; ++i) {
                final long l10 = this.slicesl - 1L - (long)i * l9;
                final long l11 = i == n - 1 ? l6 + 1L : l10 - l9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l, false);
                        for (long i = l10; i >= l11; --i) {
                            long l3 = i * DoubleFFT_3D.this.sliceStridel;
                            long l2 = i * l4;
                            for (long j = DoubleFFT_3D.this.rowsl - 1L; j >= 0L; --j) {
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray, (long)(l3 + j * DoubleFFT_3D.this.rowStridel), (DoubleLargeArray)doubleLargeArray2, (long)0L, (long)DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(doubleLargeArray2, bl);
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final DoubleLargeArray doubleLargeArray3 = new DoubleLargeArray((l6 + 1L) * this.rowsl * l, false);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * DoubleFFT_3D.this.sliceStridel;
                            for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray, (long)(l2 + j * DoubleFFT_3D.this.rowStridel), (DoubleLargeArray)doubleLargeArray3, (long)(i * DoubleFFT_3D.this.rowsl * l + j * l), (long)DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(doubleLargeArray3, i * DoubleFFT_3D.this.rowsl * l + j * l, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l6 + 1L : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l2 = i * l4;
                            for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                Utilities.arraycopy((DoubleLargeArray)doubleLargeArray3, (long)(i * DoubleFFT_3D.this.rowsl * l + j * l), (DoubleLargeArray)doubleLargeArray, (long)(l2 + j * l5), (long)l);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l4;
                            for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l3));
                                    doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l3 + 1L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, bl);
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l3 = l + l42 * l5 + l52;
                                    l2 = 2L * l42;
                                    doubleLargeArray.setDouble(l3, doubleLargeArray2.getDouble(l2));
                                    doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = l2 / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? l2 : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                        for (long i = l8; i < l7; ++i) {
                            long l = i * l5;
                            for (long j = 0L; j < DoubleFFT_3D.this.columnsl; ++j) {
                                long l2;
                                long l3;
                                long l42;
                                long l52 = 2L * j;
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l2));
                                    doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l2 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, bl);
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.slicesl; ++l42) {
                                    l3 = 2L * l42;
                                    l2 = l42 * l4 + l + l52;
                                    doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l3));
                                    doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(l3 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l9 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l8 = (long)n2 * l9;
                l7 = n2 == n - 1 ? this.slicesl : l8 + l9;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l8; i < l7; ++i) {
                            long l11 = (DoubleFFT_3D.this.slicesl - i) % DoubleFFT_3D.this.slicesl;
                            long l2 = l11 * l4;
                            long l32 = i * l4;
                            for (long j = 1L; j < l3; ++j) {
                                long l42 = DoubleFFT_3D.this.rowsl - j;
                                long l52 = l42 * l5;
                                long l6 = j * l5;
                                long l72 = l2 + l52;
                                for (long k = 0L; k < DoubleFFT_3D.this.columnsl; ++k) {
                                    long l82 = 2L * k;
                                    long l9 = l - l82;
                                    long l10 = l32 + l6 + l82;
                                    doubleLargeArray.setDouble(l72 + l9 % l, doubleLargeArray.getDouble(l10));
                                    doubleLargeArray.setDouble(l72 + (l9 + 1L) % l, -doubleLargeArray.getDouble(l10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l12;
            long l13;
            long l14;
            long l15;
            long l16;
            long l17;
            long l18;
            for (l18 = this.slicesl - 1L; l18 >= 0L; --l18) {
                l17 = l18 * this.sliceStridel;
                l16 = l18 * l4;
                for (l15 = this.rowsl - 1L; l15 >= 0L; --l15) {
                    Utilities.arraycopy((DoubleLargeArray)doubleLargeArray, (long)(l17 + l15 * this.rowStridel), (DoubleLargeArray)doubleLargeArray2, (long)0L, (long)this.columnsl);
                    this.fftColumns.realInverseFull(doubleLargeArray2, bl);
                    Utilities.arraycopy((DoubleLargeArray)doubleLargeArray2, (long)0L, (DoubleLargeArray)doubleLargeArray, (long)(l16 + l15 * l5), (long)l);
                }
            }
            doubleLargeArray2 = new DoubleLargeArray(2L * this.rowsl, false);
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = l18 * l4;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l12));
                        doubleLargeArray2.setDouble(l13 + 1L, doubleLargeArray.getDouble(l12 + 1L));
                    }
                    this.fftRows.complexInverse(doubleLargeArray2, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l17 + l14 * l5 + l15;
                        doubleLargeArray.setDouble(l12, doubleLargeArray2.getDouble(l13));
                        doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray2.getDouble(l13 + 1L));
                    }
                }
            }
            doubleLargeArray2 = new DoubleLargeArray(2L * this.slicesl, false);
            for (l18 = 0L; l18 < l2; ++l18) {
                l17 = l18 * l5;
                for (l16 = 0L; l16 < this.columnsl; ++l16) {
                    l15 = 2L * l16;
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l12));
                        doubleLargeArray2.setDouble(l13 + 1L, doubleLargeArray.getDouble(l12 + 1L));
                    }
                    this.fftSlices.complexInverse(doubleLargeArray2, bl);
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = 2L * l14;
                        l12 = l14 * l4 + l17 + l15;
                        doubleLargeArray.setDouble(l12, doubleLargeArray2.getDouble(l13));
                        doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray2.getDouble(l13 + 1L));
                    }
                }
            }
            for (l18 = 0L; l18 < this.slicesl; ++l18) {
                l17 = (this.slicesl - l18) % this.slicesl;
                l16 = l17 * l4;
                l15 = l18 * l4;
                for (l14 = 1L; l14 < l3; ++l14) {
                    l13 = this.rowsl - l14;
                    l12 = l13 * l5;
                    long l19 = l14 * l5;
                    long l20 = l16 + l12;
                    for (long i = 0L; i < this.columnsl; ++i) {
                        long l21 = 2L * i;
                        long l22 = l - l21;
                        long l23 = l15 + l19 + l21;
                        doubleLargeArray.setDouble(l20 + l22 % l, doubleLargeArray.getDouble(l23));
                        doubleLargeArray.setDouble(l20 + (l22 + 1L) % l, -doubleLargeArray.getDouble(l23 + 1L));
                    }
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, double[] dArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        double[] dArray2 = new double[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = i * this.sliceStride;
                if (n == 0) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.complexForward(dArray, n8 + n7 * this.rowStride);
                    }
                } else {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.realForward(dArray, n8 + n7 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n7 = 0; n7 < this.columns; n7 += 8) {
                        int n9;
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            dArray2[n5] = dArray[n6];
                            dArray2[n5 + 1] = dArray[n6 + 1];
                            dArray2[n4] = dArray[n6 + 2];
                            dArray2[n4 + 1] = dArray[n6 + 3];
                            dArray2[n10] = dArray[n6 + 4];
                            dArray2[n10 + 1] = dArray[n6 + 5];
                            dArray2[n9] = dArray[n6 + 6];
                            dArray2[n9 + 1] = dArray[n6 + 7];
                        }
                        this.fftRows.complexForward(dArray2, 0);
                        this.fftRows.complexForward(dArray2, 2 * this.rows);
                        this.fftRows.complexForward(dArray2, 4 * this.rows);
                        this.fftRows.complexForward(dArray2, 6 * this.rows);
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            dArray[n6] = dArray2[n5];
                            dArray[n6 + 1] = dArray2[n5 + 1];
                            dArray[n6 + 2] = dArray2[n4];
                            dArray[n6 + 3] = dArray2[n4 + 1];
                            dArray[n6 + 4] = dArray2[n10];
                            dArray[n6 + 5] = dArray2[n10 + 1];
                            dArray[n6 + 6] = dArray2[n9];
                            dArray[n6 + 7] = dArray2[n9 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        dArray2[n5] = dArray[n6];
                        dArray2[n5 + 1] = dArray[n6 + 1];
                        dArray2[n4] = dArray[n6 + 2];
                        dArray2[n4 + 1] = dArray[n6 + 3];
                    }
                    this.fftRows.complexForward(dArray2, 0);
                    this.fftRows.complexForward(dArray2, 2 * this.rows);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        dArray[n6] = dArray2[n5];
                        dArray[n6 + 1] = dArray2[n5 + 1];
                        dArray[n6 + 2] = dArray2[n4];
                        dArray[n6 + 3] = dArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    dArray2[n5] = dArray[n6];
                    dArray2[n5 + 1] = dArray[n6 + 1];
                }
                this.fftRows.complexForward(dArray2, 0);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    dArray[n6] = dArray2[n5];
                    dArray[n6 + 1] = dArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = i * this.sliceStride;
                if (n == 0) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        this.fftColumns.complexInverse(dArray, n16 + n15 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n15 = 0; n15 < this.columns; n15 += 8) {
                        int n17;
                        int n18;
                        int n19;
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            dArray2[n13] = dArray[n14];
                            dArray2[n13 + 1] = dArray[n14 + 1];
                            dArray2[n12] = dArray[n14 + 2];
                            dArray2[n12 + 1] = dArray[n14 + 3];
                            dArray2[n18] = dArray[n14 + 4];
                            dArray2[n18 + 1] = dArray[n14 + 5];
                            dArray2[n17] = dArray[n14 + 6];
                            dArray2[n17 + 1] = dArray[n14 + 7];
                        }
                        this.fftRows.complexInverse(dArray2, 0, bl);
                        this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 6 * this.rows, bl);
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            dArray[n14] = dArray2[n13];
                            dArray[n14 + 1] = dArray2[n13 + 1];
                            dArray[n14 + 2] = dArray2[n12];
                            dArray[n14 + 3] = dArray2[n12 + 1];
                            dArray[n14 + 4] = dArray2[n18];
                            dArray[n14 + 5] = dArray2[n18 + 1];
                            dArray[n14 + 6] = dArray2[n17];
                            dArray[n14 + 7] = dArray2[n17 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        dArray2[n13] = dArray[n14];
                        dArray2[n13 + 1] = dArray[n14 + 1];
                        dArray2[n12] = dArray[n14 + 2];
                        dArray2[n12 + 1] = dArray[n14 + 3];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        dArray[n14] = dArray2[n13];
                        dArray[n14 + 1] = dArray2[n13 + 1];
                        dArray[n14 + 2] = dArray2[n12];
                        dArray[n14 + 3] = dArray2[n12 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        dArray2[n13] = dArray[n14];
                        dArray2[n13 + 1] = dArray[n14 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        dArray[n14] = dArray2[n13];
                        dArray[n14 + 1] = dArray2[n13 + 1];
                    }
                }
                if (n == 0) continue;
                for (n15 = 0; n15 < this.rows; ++n15) {
                    this.fftColumns.realInverse(dArray, n16 + n15 * this.rowStride, bl);
                }
            }
        }
    }

    private void xdft3da_sub1(long l, int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l3;
                long l4;
                long l5;
                long l6;
                long l7 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.complexForward(doubleLargeArray, l7 + l6 * this.rowStridel);
                    }
                } else {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.realForward(doubleLargeArray, l7 + l6 * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l6 = 0L; l6 < this.columnsl; l6 += 8L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5));
                            doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                            doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l5 + 2L));
                            doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l5 + 3L));
                            doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l5 + 4L));
                            doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l5 + 5L));
                            doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l5 + 6L));
                            doubleLargeArray2.setDouble(l8 + 1L, doubleLargeArray.getDouble(l5 + 7L));
                        }
                        this.fftRows.complexForward(doubleLargeArray2, 0L);
                        this.fftRows.complexForward(doubleLargeArray2, 2L * this.rowsl);
                        this.fftRows.complexForward(doubleLargeArray2, 4L * this.rowsl);
                        this.fftRows.complexForward(doubleLargeArray2, 6L * this.rowsl);
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l4));
                            doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4 + 1L));
                            doubleLargeArray.setDouble(l5 + 2L, doubleLargeArray2.getDouble(l3));
                            doubleLargeArray.setDouble(l5 + 3L, doubleLargeArray2.getDouble(l3 + 1L));
                            doubleLargeArray.setDouble(l5 + 4L, doubleLargeArray2.getDouble(l9));
                            doubleLargeArray.setDouble(l5 + 5L, doubleLargeArray2.getDouble(l9 + 1L));
                            doubleLargeArray.setDouble(l5 + 6L, doubleLargeArray2.getDouble(l8));
                            doubleLargeArray.setDouble(l5 + 7L, doubleLargeArray2.getDouble(l8 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5));
                        doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                        doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l5 + 2L));
                        doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l5 + 3L));
                    }
                    this.fftRows.complexForward(doubleLargeArray2, 0L);
                    this.fftRows.complexForward(doubleLargeArray2, 2L * this.rowsl);
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l4));
                        doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4 + 1L));
                        doubleLargeArray.setDouble(l5 + 2L, doubleLargeArray2.getDouble(l3));
                        doubleLargeArray.setDouble(l5 + 3L, doubleLargeArray2.getDouble(l3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5));
                    doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                }
                this.fftRows.complexForward(doubleLargeArray2, 0L);
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l4));
                    doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4 + 1L));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l11;
                long l12;
                long l13;
                long l14;
                long l15 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        this.fftColumns.complexInverse(doubleLargeArray, l15 + l14 * this.rowStridel, bl);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l14 = 0L; l14 < this.columnsl; l14 += 8L) {
                        long l16;
                        long l17;
                        long l18;
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                            doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                            doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l13 + 2L));
                            doubleLargeArray2.setDouble(l11 + 1L, doubleLargeArray.getDouble(l13 + 3L));
                            doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l13 + 4L));
                            doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l13 + 5L));
                            doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l13 + 6L));
                            doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l13 + 7L));
                        }
                        this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                        this.fftRows.complexInverse(doubleLargeArray2, 2L * this.rowsl, bl);
                        this.fftRows.complexInverse(doubleLargeArray2, 4L * this.rowsl, bl);
                        this.fftRows.complexInverse(doubleLargeArray2, 6L * this.rowsl, bl);
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                            doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                            doubleLargeArray.setDouble(l13 + 2L, doubleLargeArray2.getDouble(l11));
                            doubleLargeArray.setDouble(l13 + 3L, doubleLargeArray2.getDouble(l11 + 1L));
                            doubleLargeArray.setDouble(l13 + 4L, doubleLargeArray2.getDouble(l17));
                            doubleLargeArray.setDouble(l13 + 5L, doubleLargeArray2.getDouble(l17 + 1L));
                            doubleLargeArray.setDouble(l13 + 6L, doubleLargeArray2.getDouble(l16));
                            doubleLargeArray.setDouble(l13 + 7L, doubleLargeArray2.getDouble(l16 + 1L));
                        }
                    }
                } else if (this.columnsl == 4L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                        doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                        doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l13 + 2L));
                        doubleLargeArray2.setDouble(l11 + 1L, doubleLargeArray.getDouble(l13 + 3L));
                    }
                    this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                    this.fftRows.complexInverse(doubleLargeArray2, 2L * this.rowsl, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                        doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                        doubleLargeArray.setDouble(l13 + 2L, doubleLargeArray2.getDouble(l11));
                        doubleLargeArray.setDouble(l13 + 3L, doubleLargeArray2.getDouble(l11 + 1L));
                    }
                } else if (this.columnsl == 2L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                        doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                    }
                    this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                        doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                    }
                }
                if (l == 0L) continue;
                for (l14 = 0L; l14 < this.rowsl; ++l14) {
                    this.fftColumns.realInverse(doubleLargeArray, l15 + l14 * this.rowStridel, bl);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, double[] dArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        double[] dArray2 = new double[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = i * this.sliceStride;
                if (n == 0) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.complexForward(dArray, n8 + n7 * this.rowStride);
                    }
                } else {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        this.fftColumns.realForward(dArray, n8 + n7 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n7 = 0; n7 < this.columns; n7 += 8) {
                        int n9;
                        int n10;
                        int n11;
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            dArray2[n5] = dArray[n6];
                            dArray2[n5 + 1] = dArray[n6 + 1];
                            dArray2[n4] = dArray[n6 + 2];
                            dArray2[n4 + 1] = dArray[n6 + 3];
                            dArray2[n10] = dArray[n6 + 4];
                            dArray2[n10 + 1] = dArray[n6 + 5];
                            dArray2[n9] = dArray[n6 + 6];
                            dArray2[n9 + 1] = dArray[n6 + 7];
                        }
                        this.fftRows.complexForward(dArray2, 0);
                        this.fftRows.complexForward(dArray2, 2 * this.rows);
                        this.fftRows.complexForward(dArray2, 4 * this.rows);
                        this.fftRows.complexForward(dArray2, 6 * this.rows);
                        for (n11 = 0; n11 < this.rows; ++n11) {
                            n6 = n8 + n11 * this.rowStride + n7;
                            n5 = 2 * n11;
                            n4 = 2 * this.rows + 2 * n11;
                            n10 = n4 + 2 * this.rows;
                            n9 = n10 + 2 * this.rows;
                            dArray[n6] = dArray2[n5];
                            dArray[n6 + 1] = dArray2[n5 + 1];
                            dArray[n6 + 2] = dArray2[n4];
                            dArray[n6 + 3] = dArray2[n4 + 1];
                            dArray[n6 + 4] = dArray2[n10];
                            dArray[n6 + 5] = dArray2[n10 + 1];
                            dArray[n6 + 6] = dArray2[n9];
                            dArray[n6 + 7] = dArray2[n9 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        dArray2[n5] = dArray[n6];
                        dArray2[n5 + 1] = dArray[n6 + 1];
                        dArray2[n4] = dArray[n6 + 2];
                        dArray2[n4 + 1] = dArray[n6 + 3];
                    }
                    this.fftRows.complexForward(dArray2, 0);
                    this.fftRows.complexForward(dArray2, 2 * this.rows);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n8 + n7 * this.rowStride;
                        n5 = 2 * n7;
                        n4 = 2 * this.rows + 2 * n7;
                        dArray[n6] = dArray2[n5];
                        dArray[n6 + 1] = dArray2[n5 + 1];
                        dArray[n6 + 2] = dArray2[n4];
                        dArray[n6 + 3] = dArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    dArray2[n5] = dArray[n6];
                    dArray2[n5 + 1] = dArray[n6 + 1];
                }
                this.fftRows.complexForward(dArray2, 0);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    n5 = 2 * n7;
                    dArray[n6] = dArray2[n5];
                    dArray[n6 + 1] = dArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = i * this.sliceStride;
                if (n == 0) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        this.fftColumns.complexInverse(dArray, n16 + n15 * this.rowStride, bl);
                    }
                } else {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        this.fftColumns.realInverse2(dArray, n16 + n15 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n15 = 0; n15 < this.columns; n15 += 8) {
                        int n17;
                        int n18;
                        int n19;
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            dArray2[n13] = dArray[n14];
                            dArray2[n13 + 1] = dArray[n14 + 1];
                            dArray2[n12] = dArray[n14 + 2];
                            dArray2[n12 + 1] = dArray[n14 + 3];
                            dArray2[n18] = dArray[n14 + 4];
                            dArray2[n18 + 1] = dArray[n14 + 5];
                            dArray2[n17] = dArray[n14 + 6];
                            dArray2[n17 + 1] = dArray[n14 + 7];
                        }
                        this.fftRows.complexInverse(dArray2, 0, bl);
                        this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 6 * this.rows, bl);
                        for (n19 = 0; n19 < this.rows; ++n19) {
                            n14 = n16 + n19 * this.rowStride + n15;
                            n13 = 2 * n19;
                            n12 = 2 * this.rows + 2 * n19;
                            n18 = n12 + 2 * this.rows;
                            n17 = n18 + 2 * this.rows;
                            dArray[n14] = dArray2[n13];
                            dArray[n14 + 1] = dArray2[n13 + 1];
                            dArray[n14 + 2] = dArray2[n12];
                            dArray[n14 + 3] = dArray2[n12 + 1];
                            dArray[n14 + 4] = dArray2[n18];
                            dArray[n14 + 5] = dArray2[n18 + 1];
                            dArray[n14 + 6] = dArray2[n17];
                            dArray[n14 + 7] = dArray2[n17 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        dArray2[n13] = dArray[n14];
                        dArray2[n13 + 1] = dArray[n14 + 1];
                        dArray2[n12] = dArray[n14 + 2];
                        dArray2[n12 + 1] = dArray[n14 + 3];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                    for (n15 = 0; n15 < this.rows; ++n15) {
                        n14 = n16 + n15 * this.rowStride;
                        n13 = 2 * n15;
                        n12 = 2 * this.rows + 2 * n15;
                        dArray[n14] = dArray2[n13];
                        dArray[n14 + 1] = dArray2[n13 + 1];
                        dArray[n14 + 2] = dArray2[n12];
                        dArray[n14 + 3] = dArray2[n12 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n15 = 0; n15 < this.rows; ++n15) {
                    n14 = n16 + n15 * this.rowStride;
                    n13 = 2 * n15;
                    dArray2[n13] = dArray[n14];
                    dArray2[n13 + 1] = dArray[n14 + 1];
                }
                this.fftRows.complexInverse(dArray2, 0, bl);
                for (n15 = 0; n15 < this.rows; ++n15) {
                    n14 = n16 + n15 * this.rowStride;
                    n13 = 2 * n15;
                    dArray[n14] = dArray2[n13];
                    dArray[n14 + 1] = dArray2[n13 + 1];
                }
            }
        }
    }

    private void xdft3da_sub2(long l, int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l3;
                long l4;
                long l5;
                long l6;
                long l7 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.complexForward(doubleLargeArray, l7 + l6 * this.rowStridel);
                    }
                } else {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        this.fftColumns.realForward(doubleLargeArray, l7 + l6 * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l6 = 0L; l6 < this.columnsl; l6 += 8L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5));
                            doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                            doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l5 + 2L));
                            doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l5 + 3L));
                            doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l5 + 4L));
                            doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l5 + 5L));
                            doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l5 + 6L));
                            doubleLargeArray2.setDouble(l8 + 1L, doubleLargeArray.getDouble(l5 + 7L));
                        }
                        this.fftRows.complexForward(doubleLargeArray2, 0L);
                        this.fftRows.complexForward(doubleLargeArray2, 2L * this.rowsl);
                        this.fftRows.complexForward(doubleLargeArray2, 4L * this.rowsl);
                        this.fftRows.complexForward(doubleLargeArray2, 6L * this.rowsl);
                        for (l10 = 0L; l10 < this.rowsl; ++l10) {
                            l5 = l7 + l10 * this.rowStridel + l6;
                            l4 = 2L * l10;
                            l3 = 2L * this.rowsl + 2L * l10;
                            l9 = l3 + 2L * this.rowsl;
                            l8 = l9 + 2L * this.rowsl;
                            doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l4));
                            doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4 + 1L));
                            doubleLargeArray.setDouble(l5 + 2L, doubleLargeArray2.getDouble(l3));
                            doubleLargeArray.setDouble(l5 + 3L, doubleLargeArray2.getDouble(l3 + 1L));
                            doubleLargeArray.setDouble(l5 + 4L, doubleLargeArray2.getDouble(l9));
                            doubleLargeArray.setDouble(l5 + 5L, doubleLargeArray2.getDouble(l9 + 1L));
                            doubleLargeArray.setDouble(l5 + 6L, doubleLargeArray2.getDouble(l8));
                            doubleLargeArray.setDouble(l5 + 7L, doubleLargeArray2.getDouble(l8 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5));
                        doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                        doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l5 + 2L));
                        doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l5 + 3L));
                    }
                    this.fftRows.complexForward(doubleLargeArray2, 0L);
                    this.fftRows.complexForward(doubleLargeArray2, 2L * this.rowsl);
                    for (l6 = 0L; l6 < this.rowsl; ++l6) {
                        l5 = l7 + l6 * this.rowStridel;
                        l4 = 2L * l6;
                        l3 = 2L * this.rowsl + 2L * l6;
                        doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l4));
                        doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4 + 1L));
                        doubleLargeArray.setDouble(l5 + 2L, doubleLargeArray2.getDouble(l3));
                        doubleLargeArray.setDouble(l5 + 3L, doubleLargeArray2.getDouble(l3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l5));
                    doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                }
                this.fftRows.complexForward(doubleLargeArray2, 0L);
                for (l6 = 0L; l6 < this.rowsl; ++l6) {
                    l5 = l7 + l6 * this.rowStridel;
                    l4 = 2L * l6;
                    doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l4));
                    doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l4 + 1L));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l11;
                long l12;
                long l13;
                long l14;
                long l15 = i * this.sliceStridel;
                if (l == 0L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        this.fftColumns.complexInverse(doubleLargeArray, l15 + l14 * this.rowStridel, bl);
                    }
                } else {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        this.fftColumns.realInverse2(doubleLargeArray, l15 + l14 * this.rowStridel, bl);
                    }
                }
                if (this.columnsl > 4L) {
                    for (l14 = 0L; l14 < this.columnsl; l14 += 8L) {
                        long l16;
                        long l17;
                        long l18;
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                            doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                            doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l13 + 2L));
                            doubleLargeArray2.setDouble(l11 + 1L, doubleLargeArray.getDouble(l13 + 3L));
                            doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l13 + 4L));
                            doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l13 + 5L));
                            doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l13 + 6L));
                            doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l13 + 7L));
                        }
                        this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                        this.fftRows.complexInverse(doubleLargeArray2, 2L * this.rowsl, bl);
                        this.fftRows.complexInverse(doubleLargeArray2, 4L * this.rowsl, bl);
                        this.fftRows.complexInverse(doubleLargeArray2, 6L * this.rowsl, bl);
                        for (l18 = 0L; l18 < this.rowsl; ++l18) {
                            l13 = l15 + l18 * this.rowStridel + l14;
                            l12 = 2L * l18;
                            l11 = 2L * this.rowsl + 2L * l18;
                            l17 = l11 + 2L * this.rowsl;
                            l16 = l17 + 2L * this.rowsl;
                            doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                            doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                            doubleLargeArray.setDouble(l13 + 2L, doubleLargeArray2.getDouble(l11));
                            doubleLargeArray.setDouble(l13 + 3L, doubleLargeArray2.getDouble(l11 + 1L));
                            doubleLargeArray.setDouble(l13 + 4L, doubleLargeArray2.getDouble(l17));
                            doubleLargeArray.setDouble(l13 + 5L, doubleLargeArray2.getDouble(l17 + 1L));
                            doubleLargeArray.setDouble(l13 + 6L, doubleLargeArray2.getDouble(l16));
                            doubleLargeArray.setDouble(l13 + 7L, doubleLargeArray2.getDouble(l16 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                        doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                        doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l13 + 2L));
                        doubleLargeArray2.setDouble(l11 + 1L, doubleLargeArray.getDouble(l13 + 3L));
                    }
                    this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                    this.fftRows.complexInverse(doubleLargeArray2, 2L * this.rowsl, bl);
                    for (l14 = 0L; l14 < this.rowsl; ++l14) {
                        l13 = l15 + l14 * this.rowStridel;
                        l12 = 2L * l14;
                        l11 = 2L * this.rowsl + 2L * l14;
                        doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                        doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                        doubleLargeArray.setDouble(l13 + 2L, doubleLargeArray2.getDouble(l11));
                        doubleLargeArray.setDouble(l13 + 3L, doubleLargeArray2.getDouble(l11 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l14 = 0L; l14 < this.rowsl; ++l14) {
                    l13 = l15 + l14 * this.rowStridel;
                    l12 = 2L * l14;
                    doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                    doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                }
                this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                for (l14 = 0L; l14 < this.rowsl; ++l14) {
                    l13 = l15 + l14 * this.rowStridel;
                    l12 = 2L * l14;
                    doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                    doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, double[][][] dArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        double[] dArray2 = new double[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(dArray[i][n6]);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(dArray[i][n6], 0);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            dArray2[n5] = dArray[i][n9][n6];
                            dArray2[n5 + 1] = dArray[i][n9][n6 + 1];
                            dArray2[n4] = dArray[i][n9][n6 + 2];
                            dArray2[n4 + 1] = dArray[i][n9][n6 + 3];
                            dArray2[n8] = dArray[i][n9][n6 + 4];
                            dArray2[n8 + 1] = dArray[i][n9][n6 + 5];
                            dArray2[n7] = dArray[i][n9][n6 + 6];
                            dArray2[n7 + 1] = dArray[i][n9][n6 + 7];
                        }
                        this.fftRows.complexForward(dArray2, 0);
                        this.fftRows.complexForward(dArray2, 2 * this.rows);
                        this.fftRows.complexForward(dArray2, 4 * this.rows);
                        this.fftRows.complexForward(dArray2, 6 * this.rows);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            dArray[i][n9][n6] = dArray2[n5];
                            dArray[i][n9][n6 + 1] = dArray2[n5 + 1];
                            dArray[i][n9][n6 + 2] = dArray2[n4];
                            dArray[i][n9][n6 + 3] = dArray2[n4 + 1];
                            dArray[i][n9][n6 + 4] = dArray2[n8];
                            dArray[i][n9][n6 + 5] = dArray2[n8 + 1];
                            dArray[i][n9][n6 + 6] = dArray2[n7];
                            dArray[i][n9][n6 + 7] = dArray2[n7 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        dArray2[n5] = dArray[i][n6][0];
                        dArray2[n5 + 1] = dArray[i][n6][1];
                        dArray2[n4] = dArray[i][n6][2];
                        dArray2[n4 + 1] = dArray[i][n6][3];
                    }
                    this.fftRows.complexForward(dArray2, 0);
                    this.fftRows.complexForward(dArray2, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        dArray[i][n6][0] = dArray2[n5];
                        dArray[i][n6][1] = dArray2[n5 + 1];
                        dArray[i][n6][2] = dArray2[n4];
                        dArray[i][n6][3] = dArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    dArray2[n5] = dArray[i][n6][0];
                    dArray2[n5 + 1] = dArray[i][n6][1];
                }
                this.fftRows.complexForward(dArray2, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    dArray[i][n6][0] = dArray2[n5];
                    dArray[i][n6][1] = dArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n10;
                int n11;
                int n12;
                if (n == 0) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(dArray[i][n12], bl);
                    }
                }
                if (this.columns > 4) {
                    for (n12 = 0; n12 < this.columns; n12 += 8) {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            dArray2[n11] = dArray[i][n15][n12];
                            dArray2[n11 + 1] = dArray[i][n15][n12 + 1];
                            dArray2[n10] = dArray[i][n15][n12 + 2];
                            dArray2[n10 + 1] = dArray[i][n15][n12 + 3];
                            dArray2[n14] = dArray[i][n15][n12 + 4];
                            dArray2[n14 + 1] = dArray[i][n15][n12 + 5];
                            dArray2[n13] = dArray[i][n15][n12 + 6];
                            dArray2[n13 + 1] = dArray[i][n15][n12 + 7];
                        }
                        this.fftRows.complexInverse(dArray2, 0, bl);
                        this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 6 * this.rows, bl);
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            dArray[i][n15][n12] = dArray2[n11];
                            dArray[i][n15][n12 + 1] = dArray2[n11 + 1];
                            dArray[i][n15][n12 + 2] = dArray2[n10];
                            dArray[i][n15][n12 + 3] = dArray2[n10 + 1];
                            dArray[i][n15][n12 + 4] = dArray2[n14];
                            dArray[i][n15][n12 + 5] = dArray2[n14 + 1];
                            dArray[i][n15][n12 + 6] = dArray2[n13];
                            dArray[i][n15][n12 + 7] = dArray2[n13 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        dArray2[n11] = dArray[i][n12][0];
                        dArray2[n11 + 1] = dArray[i][n12][1];
                        dArray2[n10] = dArray[i][n12][2];
                        dArray2[n10 + 1] = dArray[i][n12][3];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        dArray[i][n12][0] = dArray2[n11];
                        dArray[i][n12][1] = dArray2[n11 + 1];
                        dArray[i][n12][2] = dArray2[n10];
                        dArray[i][n12][3] = dArray2[n10 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        dArray2[n11] = dArray[i][n12][0];
                        dArray2[n11 + 1] = dArray[i][n12][1];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        dArray[i][n12][0] = dArray2[n11];
                        dArray[i][n12][1] = dArray2[n11 + 1];
                    }
                }
                if (n == 0) continue;
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realInverse(dArray[i][n12], bl);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, double[][][] dArray, boolean bl) {
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        double[] dArray2 = new double[n3];
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n4;
                int n5;
                int n6;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(dArray[i][n6]);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(dArray[i][n6]);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            dArray2[n5] = dArray[i][n9][n6];
                            dArray2[n5 + 1] = dArray[i][n9][n6 + 1];
                            dArray2[n4] = dArray[i][n9][n6 + 2];
                            dArray2[n4 + 1] = dArray[i][n9][n6 + 3];
                            dArray2[n8] = dArray[i][n9][n6 + 4];
                            dArray2[n8 + 1] = dArray[i][n9][n6 + 5];
                            dArray2[n7] = dArray[i][n9][n6 + 6];
                            dArray2[n7 + 1] = dArray[i][n9][n6 + 7];
                        }
                        this.fftRows.complexForward(dArray2, 0);
                        this.fftRows.complexForward(dArray2, 2 * this.rows);
                        this.fftRows.complexForward(dArray2, 4 * this.rows);
                        this.fftRows.complexForward(dArray2, 6 * this.rows);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n5 = 2 * n9;
                            n4 = 2 * this.rows + 2 * n9;
                            n8 = n4 + 2 * this.rows;
                            n7 = n8 + 2 * this.rows;
                            dArray[i][n9][n6] = dArray2[n5];
                            dArray[i][n9][n6 + 1] = dArray2[n5 + 1];
                            dArray[i][n9][n6 + 2] = dArray2[n4];
                            dArray[i][n9][n6 + 3] = dArray2[n4 + 1];
                            dArray[i][n9][n6 + 4] = dArray2[n8];
                            dArray[i][n9][n6 + 5] = dArray2[n8 + 1];
                            dArray[i][n9][n6 + 6] = dArray2[n7];
                            dArray[i][n9][n6 + 7] = dArray2[n7 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        dArray2[n5] = dArray[i][n6][0];
                        dArray2[n5 + 1] = dArray[i][n6][1];
                        dArray2[n4] = dArray[i][n6][2];
                        dArray2[n4 + 1] = dArray[i][n6][3];
                    }
                    this.fftRows.complexForward(dArray2, 0);
                    this.fftRows.complexForward(dArray2, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        dArray[i][n6][0] = dArray2[n5];
                        dArray[i][n6][1] = dArray2[n5 + 1];
                        dArray[i][n6][2] = dArray2[n4];
                        dArray[i][n6][3] = dArray2[n4 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    dArray2[n5] = dArray[i][n6][0];
                    dArray2[n5 + 1] = dArray[i][n6][1];
                }
                this.fftRows.complexForward(dArray2, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    dArray[i][n6][0] = dArray2[n5];
                    dArray[i][n6][1] = dArray2[n5 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n10;
                int n11;
                int n12;
                if (n == 0) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(dArray[i][n12], bl);
                    }
                } else {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.realInverse2(dArray[i][n12], 0, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n12 = 0; n12 < this.columns; n12 += 8) {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            dArray2[n11] = dArray[i][n15][n12];
                            dArray2[n11 + 1] = dArray[i][n15][n12 + 1];
                            dArray2[n10] = dArray[i][n15][n12 + 2];
                            dArray2[n10 + 1] = dArray[i][n15][n12 + 3];
                            dArray2[n14] = dArray[i][n15][n12 + 4];
                            dArray2[n14 + 1] = dArray[i][n15][n12 + 5];
                            dArray2[n13] = dArray[i][n15][n12 + 6];
                            dArray2[n13 + 1] = dArray[i][n15][n12 + 7];
                        }
                        this.fftRows.complexInverse(dArray2, 0, bl);
                        this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 4 * this.rows, bl);
                        this.fftRows.complexInverse(dArray2, 6 * this.rows, bl);
                        for (n15 = 0; n15 < this.rows; ++n15) {
                            n11 = 2 * n15;
                            n10 = 2 * this.rows + 2 * n15;
                            n14 = n10 + 2 * this.rows;
                            n13 = n14 + 2 * this.rows;
                            dArray[i][n15][n12] = dArray2[n11];
                            dArray[i][n15][n12 + 1] = dArray2[n11 + 1];
                            dArray[i][n15][n12 + 2] = dArray2[n10];
                            dArray[i][n15][n12 + 3] = dArray2[n10 + 1];
                            dArray[i][n15][n12 + 4] = dArray2[n14];
                            dArray[i][n15][n12 + 5] = dArray2[n14 + 1];
                            dArray[i][n15][n12 + 6] = dArray2[n13];
                            dArray[i][n15][n12 + 7] = dArray2[n13 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        dArray2[n11] = dArray[i][n12][0];
                        dArray2[n11 + 1] = dArray[i][n12][1];
                        dArray2[n10] = dArray[i][n12][2];
                        dArray2[n10 + 1] = dArray[i][n12][3];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        n11 = 2 * n12;
                        n10 = 2 * this.rows + 2 * n12;
                        dArray[i][n12][0] = dArray2[n11];
                        dArray[i][n12][1] = dArray2[n11 + 1];
                        dArray[i][n12][2] = dArray2[n10];
                        dArray[i][n12][3] = dArray2[n10 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n12 = 0; n12 < this.rows; ++n12) {
                    n11 = 2 * n12;
                    dArray2[n11] = dArray[i][n12][0];
                    dArray2[n11 + 1] = dArray[i][n12][1];
                }
                this.fftRows.complexInverse(dArray2, 0, bl);
                for (n12 = 0; n12 < this.rows; ++n12) {
                    n11 = 2 * n12;
                    dArray[i][n12][0] = dArray2[n11];
                    dArray[i][n12][1] = dArray2[n11 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int n, double[] dArray, boolean bl) {
        block31: {
            double[] dArray2;
            block29: {
                block32: {
                    block30: {
                        int n2 = this.slices;
                        if (n2 < this.rows) {
                            n2 = this.rows;
                        }
                        n2 *= 8;
                        if (this.columns == 4) {
                            n2 >>= 1;
                        } else if (this.columns < 4) {
                            n2 >>= 2;
                        }
                        dArray2 = new double[n2];
                        if (n != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int i = 0; i < this.rows; ++i) {
                            int n3 = i * this.rowStride;
                            for (int j = 0; j < this.columns; j += 8) {
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8;
                                int n9;
                                for (n9 = 0; n9 < this.slices; ++n9) {
                                    n8 = n9 * this.sliceStride + n3 + j;
                                    n7 = 2 * n9;
                                    n6 = 2 * this.slices + 2 * n9;
                                    n5 = n6 + 2 * this.slices;
                                    n4 = n5 + 2 * this.slices;
                                    dArray2[n7] = dArray[n8];
                                    dArray2[n7 + 1] = dArray[n8 + 1];
                                    dArray2[n6] = dArray[n8 + 2];
                                    dArray2[n6 + 1] = dArray[n8 + 3];
                                    dArray2[n5] = dArray[n8 + 4];
                                    dArray2[n5 + 1] = dArray[n8 + 5];
                                    dArray2[n4] = dArray[n8 + 6];
                                    dArray2[n4 + 1] = dArray[n8 + 7];
                                }
                                this.fftSlices.complexForward(dArray2, 0);
                                this.fftSlices.complexForward(dArray2, 2 * this.slices);
                                this.fftSlices.complexForward(dArray2, 4 * this.slices);
                                this.fftSlices.complexForward(dArray2, 6 * this.slices);
                                for (n9 = 0; n9 < this.slices; ++n9) {
                                    n8 = n9 * this.sliceStride + n3 + j;
                                    n7 = 2 * n9;
                                    n6 = 2 * this.slices + 2 * n9;
                                    n5 = n6 + 2 * this.slices;
                                    n4 = n5 + 2 * this.slices;
                                    dArray[n8] = dArray2[n7];
                                    dArray[n8 + 1] = dArray2[n7 + 1];
                                    dArray[n8 + 2] = dArray2[n6];
                                    dArray[n8 + 3] = dArray2[n6 + 1];
                                    dArray[n8 + 4] = dArray2[n5];
                                    dArray[n8 + 5] = dArray2[n5 + 1];
                                    dArray[n8 + 6] = dArray2[n4];
                                    dArray[n8 + 7] = dArray2[n4 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int i = 0; i < this.rows; ++i) {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14 = i * this.rowStride;
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n14;
                            n11 = 2 * n13;
                            n10 = 2 * this.slices + 2 * n13;
                            dArray2[n11] = dArray[n12];
                            dArray2[n11 + 1] = dArray[n12 + 1];
                            dArray2[n10] = dArray[n12 + 2];
                            dArray2[n10 + 1] = dArray[n12 + 3];
                        }
                        this.fftSlices.complexForward(dArray2, 0);
                        this.fftSlices.complexForward(dArray2, 2 * this.slices);
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n14;
                            n11 = 2 * n13;
                            n10 = 2 * this.slices + 2 * n13;
                            dArray[n12] = dArray2[n11];
                            dArray[n12 + 1] = dArray2[n11 + 1];
                            dArray[n12 + 2] = dArray2[n10];
                            dArray[n12 + 3] = dArray2[n10 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int i = 0; i < this.rows; ++i) {
                    int n15;
                    int n16;
                    int n17;
                    int n18 = i * this.rowStride;
                    for (n17 = 0; n17 < this.slices; ++n17) {
                        n16 = n17 * this.sliceStride + n18;
                        n15 = 2 * n17;
                        dArray2[n15] = dArray[n16];
                        dArray2[n15 + 1] = dArray[n16 + 1];
                    }
                    this.fftSlices.complexForward(dArray2, 0);
                    for (n17 = 0; n17 < this.slices; ++n17) {
                        n16 = n17 * this.sliceStride + n18;
                        n15 = 2 * n17;
                        dArray[n16] = dArray2[n15];
                        dArray[n16 + 1] = dArray2[n15 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n19 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 8) {
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        for (n25 = 0; n25 < this.slices; ++n25) {
                            n24 = n25 * this.sliceStride + n19 + j;
                            n23 = 2 * n25;
                            n22 = 2 * this.slices + 2 * n25;
                            n21 = n22 + 2 * this.slices;
                            n20 = n21 + 2 * this.slices;
                            dArray2[n23] = dArray[n24];
                            dArray2[n23 + 1] = dArray[n24 + 1];
                            dArray2[n22] = dArray[n24 + 2];
                            dArray2[n22 + 1] = dArray[n24 + 3];
                            dArray2[n21] = dArray[n24 + 4];
                            dArray2[n21 + 1] = dArray[n24 + 5];
                            dArray2[n20] = dArray[n24 + 6];
                            dArray2[n20 + 1] = dArray[n24 + 7];
                        }
                        this.fftSlices.complexInverse(dArray2, 0, bl);
                        this.fftSlices.complexInverse(dArray2, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(dArray2, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(dArray2, 6 * this.slices, bl);
                        for (n25 = 0; n25 < this.slices; ++n25) {
                            n24 = n25 * this.sliceStride + n19 + j;
                            n23 = 2 * n25;
                            n22 = 2 * this.slices + 2 * n25;
                            n21 = n22 + 2 * this.slices;
                            n20 = n21 + 2 * this.slices;
                            dArray[n24] = dArray2[n23];
                            dArray[n24 + 1] = dArray2[n23 + 1];
                            dArray[n24 + 2] = dArray2[n22];
                            dArray[n24 + 3] = dArray2[n22 + 1];
                            dArray[n24 + 4] = dArray2[n21];
                            dArray[n24 + 5] = dArray2[n21 + 1];
                            dArray[n24 + 6] = dArray2[n20];
                            dArray[n24 + 7] = dArray2[n20 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n26;
                    int n27;
                    int n28;
                    int n29;
                    int n30 = i * this.rowStride;
                    for (n29 = 0; n29 < this.slices; ++n29) {
                        n28 = n29 * this.sliceStride + n30;
                        n27 = 2 * n29;
                        n26 = 2 * this.slices + 2 * n29;
                        dArray2[n27] = dArray[n28];
                        dArray2[n27 + 1] = dArray[n28 + 1];
                        dArray2[n26] = dArray[n28 + 2];
                        dArray2[n26 + 1] = dArray[n28 + 3];
                    }
                    this.fftSlices.complexInverse(dArray2, 0, bl);
                    this.fftSlices.complexInverse(dArray2, 2 * this.slices, bl);
                    for (n29 = 0; n29 < this.slices; ++n29) {
                        n28 = n29 * this.sliceStride + n30;
                        n27 = 2 * n29;
                        n26 = 2 * this.slices + 2 * n29;
                        dArray[n28] = dArray2[n27];
                        dArray[n28 + 1] = dArray2[n27 + 1];
                        dArray[n28 + 2] = dArray2[n26];
                        dArray[n28 + 3] = dArray2[n26 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n31;
                    int n32;
                    int n33;
                    int n34 = i * this.rowStride;
                    for (n33 = 0; n33 < this.slices; ++n33) {
                        n32 = n33 * this.sliceStride + n34;
                        n31 = 2 * n33;
                        dArray2[n31] = dArray[n32];
                        dArray2[n31 + 1] = dArray[n32 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, 0, bl);
                    for (n33 = 0; n33 < this.slices; ++n33) {
                        n32 = n33 * this.sliceStride + n34;
                        n31 = 2 * n33;
                        dArray[n32] = dArray2[n31];
                        dArray[n32 + 1] = dArray2[n31 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        block31: {
            DoubleLargeArray doubleLargeArray2;
            block29: {
                block32: {
                    block30: {
                        long l = this.slicesl;
                        if (l < this.rowsl) {
                            l = this.rowsl;
                        }
                        l *= 8L;
                        if (this.columnsl == 4L) {
                            l >>= 1;
                        } else if (this.columnsl < 4L) {
                            l >>= 2;
                        }
                        doubleLargeArray2 = new DoubleLargeArray(l, false);
                        if (n != -1) break block29;
                        if (this.columnsl <= 4L) break block30;
                        for (long i = 0L; i < this.rowsl; ++i) {
                            long l2 = i * this.rowStridel;
                            for (long j = 0L; j < this.columnsl; j += 8L) {
                                long l3;
                                long l4;
                                long l5;
                                long l6;
                                long l7;
                                long l8;
                                for (l8 = 0L; l8 < this.slicesl; ++l8) {
                                    l7 = l8 * this.sliceStridel + l2 + j;
                                    l6 = 2L * l8;
                                    l5 = 2L * this.slicesl + 2L * l8;
                                    l4 = l5 + 2L * this.slicesl;
                                    l3 = l4 + 2L * this.slicesl;
                                    doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l7));
                                    doubleLargeArray2.setDouble(l6 + 1L, doubleLargeArray.getDouble(l7 + 1L));
                                    doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l7 + 2L));
                                    doubleLargeArray2.setDouble(l5 + 1L, doubleLargeArray.getDouble(l7 + 3L));
                                    doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l7 + 4L));
                                    doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l7 + 5L));
                                    doubleLargeArray2.setDouble(l3, doubleLargeArray.getDouble(l7 + 6L));
                                    doubleLargeArray2.setDouble(l3 + 1L, doubleLargeArray.getDouble(l7 + 7L));
                                }
                                this.fftSlices.complexForward(doubleLargeArray2, 0L);
                                this.fftSlices.complexForward(doubleLargeArray2, 2L * this.slicesl);
                                this.fftSlices.complexForward(doubleLargeArray2, 4L * this.slicesl);
                                this.fftSlices.complexForward(doubleLargeArray2, 6L * this.slicesl);
                                for (l8 = 0L; l8 < this.slicesl; ++l8) {
                                    l7 = l8 * this.sliceStridel + l2 + j;
                                    l6 = 2L * l8;
                                    l5 = 2L * this.slicesl + 2L * l8;
                                    l4 = l5 + 2L * this.slicesl;
                                    l3 = l4 + 2L * this.slicesl;
                                    doubleLargeArray.setDouble(l7, doubleLargeArray2.getDouble(l6));
                                    doubleLargeArray.setDouble(l7 + 1L, doubleLargeArray2.getDouble(l6 + 1L));
                                    doubleLargeArray.setDouble(l7 + 2L, doubleLargeArray2.getDouble(l5));
                                    doubleLargeArray.setDouble(l7 + 3L, doubleLargeArray2.getDouble(l5 + 1L));
                                    doubleLargeArray.setDouble(l7 + 4L, doubleLargeArray2.getDouble(l4));
                                    doubleLargeArray.setDouble(l7 + 5L, doubleLargeArray2.getDouble(l4 + 1L));
                                    doubleLargeArray.setDouble(l7 + 6L, doubleLargeArray2.getDouble(l3));
                                    doubleLargeArray.setDouble(l7 + 7L, doubleLargeArray2.getDouble(l3 + 1L));
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columnsl != 4L) break block32;
                    for (long i = 0L; i < this.rowsl; ++i) {
                        long l;
                        long l9;
                        long l10;
                        long l11;
                        long l12 = i * this.rowStridel;
                        for (l11 = 0L; l11 < this.slicesl; ++l11) {
                            l10 = l11 * this.sliceStridel + l12;
                            l9 = 2L * l11;
                            l = 2L * this.slicesl + 2L * l11;
                            doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                            doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                            doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l10 + 2L));
                            doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l10 + 3L));
                        }
                        this.fftSlices.complexForward(doubleLargeArray2, 0L);
                        this.fftSlices.complexForward(doubleLargeArray2, 2L * this.slicesl);
                        for (l11 = 0L; l11 < this.slicesl; ++l11) {
                            l10 = l11 * this.sliceStridel + l12;
                            l9 = 2L * l11;
                            l = 2L * this.slicesl + 2L * l11;
                            doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                            doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                            doubleLargeArray.setDouble(l10 + 2L, doubleLargeArray2.getDouble(l));
                            doubleLargeArray.setDouble(l10 + 3L, doubleLargeArray2.getDouble(l + 1L));
                        }
                    }
                    break block31;
                }
                if (this.columnsl != 2L) break block31;
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l13;
                    long l14;
                    long l15 = i * this.rowStridel;
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = l14 * this.sliceStridel + l15;
                        l = 2L * l14;
                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l13));
                        doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l13 + 1L));
                    }
                    this.fftSlices.complexForward(doubleLargeArray2, 0L);
                    for (l14 = 0L; l14 < this.slicesl; ++l14) {
                        l13 = l14 * this.sliceStridel + l15;
                        l = 2L * l14;
                        doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l));
                        doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l + 1L));
                    }
                }
                break block31;
            }
            if (this.columnsl > 4L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l = i * this.rowStridel;
                    for (long j = 0L; j < this.columnsl; j += 8L) {
                        long l16;
                        long l17;
                        long l18;
                        long l19;
                        long l20;
                        long l21;
                        for (l21 = 0L; l21 < this.slicesl; ++l21) {
                            l20 = l21 * this.sliceStridel + l + j;
                            l19 = 2L * l21;
                            l18 = 2L * this.slicesl + 2L * l21;
                            l17 = l18 + 2L * this.slicesl;
                            l16 = l17 + 2L * this.slicesl;
                            doubleLargeArray2.setDouble(l19, doubleLargeArray.getDouble(l20));
                            doubleLargeArray2.setDouble(l19 + 1L, doubleLargeArray.getDouble(l20 + 1L));
                            doubleLargeArray2.setDouble(l18, doubleLargeArray.getDouble(l20 + 2L));
                            doubleLargeArray2.setDouble(l18 + 1L, doubleLargeArray.getDouble(l20 + 3L));
                            doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l20 + 4L));
                            doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l20 + 5L));
                            doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l20 + 6L));
                            doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l20 + 7L));
                        }
                        this.fftSlices.complexInverse(doubleLargeArray2, 0L, bl);
                        this.fftSlices.complexInverse(doubleLargeArray2, 2L * this.slicesl, bl);
                        this.fftSlices.complexInverse(doubleLargeArray2, 4L * this.slicesl, bl);
                        this.fftSlices.complexInverse(doubleLargeArray2, 6L * this.slicesl, bl);
                        for (l21 = 0L; l21 < this.slicesl; ++l21) {
                            l20 = l21 * this.sliceStridel + l + j;
                            l19 = 2L * l21;
                            l18 = 2L * this.slicesl + 2L * l21;
                            l17 = l18 + 2L * this.slicesl;
                            l16 = l17 + 2L * this.slicesl;
                            doubleLargeArray.setDouble(l20, doubleLargeArray2.getDouble(l19));
                            doubleLargeArray.setDouble(l20 + 1L, doubleLargeArray2.getDouble(l19 + 1L));
                            doubleLargeArray.setDouble(l20 + 2L, doubleLargeArray2.getDouble(l18));
                            doubleLargeArray.setDouble(l20 + 3L, doubleLargeArray2.getDouble(l18 + 1L));
                            doubleLargeArray.setDouble(l20 + 4L, doubleLargeArray2.getDouble(l17));
                            doubleLargeArray.setDouble(l20 + 5L, doubleLargeArray2.getDouble(l17 + 1L));
                            doubleLargeArray.setDouble(l20 + 6L, doubleLargeArray2.getDouble(l16));
                            doubleLargeArray.setDouble(l20 + 7L, doubleLargeArray2.getDouble(l16 + 1L));
                        }
                    }
                }
            } else if (this.columnsl == 4L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l22;
                    long l23;
                    long l24;
                    long l25 = i * this.rowStridel;
                    for (l24 = 0L; l24 < this.slicesl; ++l24) {
                        l23 = l24 * this.sliceStridel + l25;
                        l22 = 2L * l24;
                        l = 2L * this.slicesl + 2L * l24;
                        doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l23));
                        doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l23 + 1L));
                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l23 + 2L));
                        doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l23 + 3L));
                    }
                    this.fftSlices.complexInverse(doubleLargeArray2, 0L, bl);
                    this.fftSlices.complexInverse(doubleLargeArray2, 2L * this.slicesl, bl);
                    for (l24 = 0L; l24 < this.slicesl; ++l24) {
                        l23 = l24 * this.sliceStridel + l25;
                        l22 = 2L * l24;
                        l = 2L * this.slicesl + 2L * l24;
                        doubleLargeArray.setDouble(l23, doubleLargeArray2.getDouble(l22));
                        doubleLargeArray.setDouble(l23 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                        doubleLargeArray.setDouble(l23 + 2L, doubleLargeArray2.getDouble(l));
                        doubleLargeArray.setDouble(l23 + 3L, doubleLargeArray2.getDouble(l + 1L));
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l26;
                    long l27;
                    long l28 = i * this.rowStridel;
                    for (l27 = 0L; l27 < this.slicesl; ++l27) {
                        l26 = l27 * this.sliceStridel + l28;
                        l = 2L * l27;
                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l26));
                        doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l26 + 1L));
                    }
                    this.fftSlices.complexInverse(doubleLargeArray2, 0L, bl);
                    for (l27 = 0L; l27 < this.slicesl; ++l27) {
                        l26 = l27 * this.sliceStridel + l28;
                        l = 2L * l27;
                        doubleLargeArray.setDouble(l26, doubleLargeArray2.getDouble(l));
                        doubleLargeArray.setDouble(l26 + 1L, doubleLargeArray2.getDouble(l + 1L));
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, double[][][] dArray, boolean bl) {
        block31: {
            double[] dArray2;
            block29: {
                block32: {
                    block30: {
                        int n2 = this.slices;
                        if (n2 < this.rows) {
                            n2 = this.rows;
                        }
                        n2 *= 8;
                        if (this.columns == 4) {
                            n2 >>= 1;
                        } else if (this.columns < 4) {
                            n2 >>= 2;
                        }
                        dArray2 = new double[n2];
                        if (n != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int i = 0; i < this.rows; ++i) {
                            for (int j = 0; j < this.columns; j += 8) {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                for (n7 = 0; n7 < this.slices; ++n7) {
                                    n6 = 2 * n7;
                                    n5 = 2 * this.slices + 2 * n7;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    dArray2[n6] = dArray[n7][i][j];
                                    dArray2[n6 + 1] = dArray[n7][i][j + 1];
                                    dArray2[n5] = dArray[n7][i][j + 2];
                                    dArray2[n5 + 1] = dArray[n7][i][j + 3];
                                    dArray2[n4] = dArray[n7][i][j + 4];
                                    dArray2[n4 + 1] = dArray[n7][i][j + 5];
                                    dArray2[n3] = dArray[n7][i][j + 6];
                                    dArray2[n3 + 1] = dArray[n7][i][j + 7];
                                }
                                this.fftSlices.complexForward(dArray2, 0);
                                this.fftSlices.complexForward(dArray2, 2 * this.slices);
                                this.fftSlices.complexForward(dArray2, 4 * this.slices);
                                this.fftSlices.complexForward(dArray2, 6 * this.slices);
                                for (n7 = 0; n7 < this.slices; ++n7) {
                                    n6 = 2 * n7;
                                    n5 = 2 * this.slices + 2 * n7;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    dArray[n7][i][j] = dArray2[n6];
                                    dArray[n7][i][j + 1] = dArray2[n6 + 1];
                                    dArray[n7][i][j + 2] = dArray2[n5];
                                    dArray[n7][i][j + 3] = dArray2[n5 + 1];
                                    dArray[n7][i][j + 4] = dArray2[n4];
                                    dArray[n7][i][j + 5] = dArray2[n4 + 1];
                                    dArray[n7][i][j + 6] = dArray2[n3];
                                    dArray[n7][i][j + 7] = dArray2[n3 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int i = 0; i < this.rows; ++i) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.slices; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.slices + 2 * n10;
                            dArray2[n9] = dArray[n10][i][0];
                            dArray2[n9 + 1] = dArray[n10][i][1];
                            dArray2[n8] = dArray[n10][i][2];
                            dArray2[n8 + 1] = dArray[n10][i][3];
                        }
                        this.fftSlices.complexForward(dArray2, 0);
                        this.fftSlices.complexForward(dArray2, 2 * this.slices);
                        for (n10 = 0; n10 < this.slices; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.slices + 2 * n10;
                            dArray[n10][i][0] = dArray2[n9];
                            dArray[n10][i][1] = dArray2[n9 + 1];
                            dArray[n10][i][2] = dArray2[n8];
                            dArray[n10][i][3] = dArray2[n8 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int i = 0; i < this.rows; ++i) {
                    int n11;
                    int n12;
                    for (n12 = 0; n12 < this.slices; ++n12) {
                        n11 = 2 * n12;
                        dArray2[n11] = dArray[n12][i][0];
                        dArray2[n11 + 1] = dArray[n12][i][1];
                    }
                    this.fftSlices.complexForward(dArray2, 0);
                    for (n12 = 0; n12 < this.slices; ++n12) {
                        n11 = 2 * n12;
                        dArray[n12][i][0] = dArray2[n11];
                        dArray[n12][i][1] = dArray2[n11 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 8) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        for (n17 = 0; n17 < this.slices; ++n17) {
                            n16 = 2 * n17;
                            n15 = 2 * this.slices + 2 * n17;
                            n14 = n15 + 2 * this.slices;
                            n13 = n14 + 2 * this.slices;
                            dArray2[n16] = dArray[n17][i][j];
                            dArray2[n16 + 1] = dArray[n17][i][j + 1];
                            dArray2[n15] = dArray[n17][i][j + 2];
                            dArray2[n15 + 1] = dArray[n17][i][j + 3];
                            dArray2[n14] = dArray[n17][i][j + 4];
                            dArray2[n14 + 1] = dArray[n17][i][j + 5];
                            dArray2[n13] = dArray[n17][i][j + 6];
                            dArray2[n13 + 1] = dArray[n17][i][j + 7];
                        }
                        this.fftSlices.complexInverse(dArray2, 0, bl);
                        this.fftSlices.complexInverse(dArray2, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(dArray2, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(dArray2, 6 * this.slices, bl);
                        for (n17 = 0; n17 < this.slices; ++n17) {
                            n16 = 2 * n17;
                            n15 = 2 * this.slices + 2 * n17;
                            n14 = n15 + 2 * this.slices;
                            n13 = n14 + 2 * this.slices;
                            dArray[n17][i][j] = dArray2[n16];
                            dArray[n17][i][j + 1] = dArray2[n16 + 1];
                            dArray[n17][i][j + 2] = dArray2[n15];
                            dArray[n17][i][j + 3] = dArray2[n15 + 1];
                            dArray[n17][i][j + 4] = dArray2[n14];
                            dArray[n17][i][j + 5] = dArray2[n14 + 1];
                            dArray[n17][i][j + 6] = dArray2[n13];
                            dArray[n17][i][j + 7] = dArray2[n13 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n18;
                    int n19;
                    int n20;
                    for (n20 = 0; n20 < this.slices; ++n20) {
                        n19 = 2 * n20;
                        n18 = 2 * this.slices + 2 * n20;
                        dArray2[n19] = dArray[n20][i][0];
                        dArray2[n19 + 1] = dArray[n20][i][1];
                        dArray2[n18] = dArray[n20][i][2];
                        dArray2[n18 + 1] = dArray[n20][i][3];
                    }
                    this.fftSlices.complexInverse(dArray2, 0, bl);
                    this.fftSlices.complexInverse(dArray2, 2 * this.slices, bl);
                    for (n20 = 0; n20 < this.slices; ++n20) {
                        n19 = 2 * n20;
                        n18 = 2 * this.slices + 2 * n20;
                        dArray[n20][i][0] = dArray2[n19];
                        dArray[n20][i][1] = dArray2[n19 + 1];
                        dArray[n20][i][2] = dArray2[n18];
                        dArray[n20][i][3] = dArray2[n18 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n21;
                    int n22;
                    for (n22 = 0; n22 < this.slices; ++n22) {
                        n21 = 2 * n22;
                        dArray2[n21] = dArray[n22][i][0];
                        dArray2[n21 + 1] = dArray[n22][i][1];
                    }
                    this.fftSlices.complexInverse(dArray2, 0, bl);
                    for (n22 = 0; n22 < this.slices; ++n22) {
                        n21 = 2 * n22;
                        dArray[n22][i][0] = dArray2[n21];
                        dArray[n22][i][1] = dArray2[n21 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int n, final int n2, final double[] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n22] = dArray[n32];
                                        dArray2[n22 + 1] = dArray[n32 + 1];
                                        dArray2[n16] = dArray[n32 + 2];
                                        dArray2[n16 + 1] = dArray[n32 + 3];
                                        dArray2[n7] = dArray[n32 + 4];
                                        dArray2[n7 + 1] = dArray[n32 + 5];
                                        dArray2[n62] = dArray[n32 + 6];
                                        dArray2[n62 + 1] = dArray[n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 6 * DoubleFFT_3D.this.rows);
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n32] = dArray2[n22];
                                        dArray[n32 + 1] = dArray2[n22 + 1];
                                        dArray[n32 + 2] = dArray2[n16];
                                        dArray[n32 + 3] = dArray2[n16 + 1];
                                        dArray[n32 + 4] = dArray2[n7];
                                        dArray[n32 + 5] = dArray2[n7 + 1];
                                        dArray[n32 + 6] = dArray2[n62];
                                        dArray[n32 + 7] = dArray2[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    dArray2[n22] = dArray[n32];
                                    dArray2[n22 + 1] = dArray[n32 + 1];
                                    dArray2[n16] = dArray[n32 + 2];
                                    dArray2[n16 + 1] = dArray[n32 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    dArray[n32] = dArray2[n22];
                                    dArray[n32 + 1] = dArray2[n22 + 1];
                                    dArray[n32 + 2] = dArray2[n16];
                                    dArray[n32 + 3] = dArray2[n16 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                dArray2[n22] = dArray[n32];
                                dArray2[n22 + 1] = dArray[n32 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                dArray[n32] = dArray2[n22];
                                dArray[n32 + 1] = dArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n9] = dArray[n10];
                                        dArray2[n9 + 1] = dArray[n10 + 1];
                                        dArray2[n17] = dArray[n10 + 2];
                                        dArray2[n17 + 1] = dArray[n10 + 3];
                                        dArray2[n14] = dArray[n10 + 4];
                                        dArray2[n14 + 1] = dArray[n10 + 5];
                                        dArray2[n13] = dArray[n10 + 6];
                                        dArray2[n13 + 1] = dArray[n10 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n10] = dArray2[n9];
                                        dArray[n10 + 1] = dArray2[n9 + 1];
                                        dArray[n10 + 2] = dArray2[n17];
                                        dArray[n10 + 3] = dArray2[n17 + 1];
                                        dArray[n10 + 4] = dArray2[n14];
                                        dArray[n10 + 5] = dArray2[n14 + 1];
                                        dArray[n10 + 6] = dArray2[n13];
                                        dArray[n10 + 7] = dArray2[n13 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    dArray2[n9] = dArray[n10];
                                    dArray2[n9 + 1] = dArray[n10 + 1];
                                    dArray2[n17] = dArray[n10 + 2];
                                    dArray2[n17 + 1] = dArray[n10 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    dArray[n10] = dArray2[n9];
                                    dArray[n10 + 1] = dArray2[n9 + 1];
                                    dArray[n10 + 2] = dArray2[n17];
                                    dArray[n10 + 3] = dArray2[n17 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    dArray2[n9] = dArray[n10];
                                    dArray2[n9 + 1] = dArray[n10 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    dArray[n10] = dArray2[n9];
                                    dArray[n10 + 1] = dArray2[n9 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                DoubleFFT_3D.this.fftColumns.realInverse(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth1(final long l, final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)Math.min((long)ConcurrencyUtils.getNumberOfThreads(), this.slicesl);
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        final long l3 = l2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l3, false);
                    if (n == -1) {
                        for (long i = l4; i < DoubleFFT_3D.this.slicesl; i += (long)n2) {
                            long l16;
                            long l2;
                            long l32;
                            long l42;
                            long l5 = i * DoubleFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(doubleLargeArray, l5 + l42 * DoubleFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    DoubleFFT_3D.this.fftColumns.realForward(doubleLargeArray, l5 + l42 * DoubleFFT_3D.this.rowStridel);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.columnsl; l42 += 8L) {
                                    long l6;
                                    long l7;
                                    long l8;
                                    for (l8 = 0L; l8 < DoubleFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * DoubleFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * DoubleFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32));
                                        doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                                        doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l32 + 2L));
                                        doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l32 + 3L));
                                        doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l32 + 4L));
                                        doubleLargeArray2.setDouble(l7 + 1L, doubleLargeArray.getDouble(l32 + 5L));
                                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l32 + 6L));
                                        doubleLargeArray2.setDouble(l6 + 1L, doubleLargeArray.getDouble(l32 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 4L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 6L * DoubleFFT_3D.this.rowsl);
                                    for (l8 = 0L; l8 < DoubleFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * DoubleFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * DoubleFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l2));
                                        doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                                        doubleLargeArray.setDouble(l32 + 2L, doubleLargeArray2.getDouble(l16));
                                        doubleLargeArray.setDouble(l32 + 3L, doubleLargeArray2.getDouble(l16 + 1L));
                                        doubleLargeArray.setDouble(l32 + 4L, doubleLargeArray2.getDouble(l7));
                                        doubleLargeArray.setDouble(l32 + 5L, doubleLargeArray2.getDouble(l7 + 1L));
                                        doubleLargeArray.setDouble(l32 + 6L, doubleLargeArray2.getDouble(l6));
                                        doubleLargeArray.setDouble(l32 + 7L, doubleLargeArray2.getDouble(l6 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l42;
                                    doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32));
                                    doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                                    doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l32 + 2L));
                                    doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l32 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                                DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl);
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l42;
                                    doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l2));
                                    doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                                    doubleLargeArray.setDouble(l32 + 2L, doubleLargeArray2.getDouble(l16));
                                    doubleLargeArray.setDouble(l32 + 3L, doubleLargeArray2.getDouble(l16 + 1L));
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) continue;
                            for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32));
                                doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                            for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l2));
                                doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                            }
                        }
                    } else {
                        for (long i = l4; i < DoubleFFT_3D.this.slicesl; i += (long)n2) {
                            long l17;
                            long l9;
                            long l10;
                            long l11;
                            long l12 = i * DoubleFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(doubleLargeArray, l12 + l11 * DoubleFFT_3D.this.rowStridel, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.columnsl; l11 += 8L) {
                                    long l13;
                                    long l14;
                                    long l15;
                                    for (l15 = 0L; l15 < DoubleFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * DoubleFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * DoubleFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                                        doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                                        doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l10 + 2L));
                                        doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l10 + 3L));
                                        doubleLargeArray2.setDouble(l14, doubleLargeArray.getDouble(l10 + 4L));
                                        doubleLargeArray2.setDouble(l14 + 1L, doubleLargeArray.getDouble(l10 + 5L));
                                        doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l10 + 6L));
                                        doubleLargeArray2.setDouble(l13 + 1L, doubleLargeArray.getDouble(l10 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 4L * DoubleFFT_3D.this.rowsl, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 6L * DoubleFFT_3D.this.rowsl, bl);
                                    for (l15 = 0L; l15 < DoubleFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * DoubleFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * DoubleFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                                        doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                                        doubleLargeArray.setDouble(l10 + 2L, doubleLargeArray2.getDouble(l17));
                                        doubleLargeArray.setDouble(l10 + 3L, doubleLargeArray2.getDouble(l17 + 1L));
                                        doubleLargeArray.setDouble(l10 + 4L, doubleLargeArray2.getDouble(l14));
                                        doubleLargeArray.setDouble(l10 + 5L, doubleLargeArray2.getDouble(l14 + 1L));
                                        doubleLargeArray.setDouble(l10 + 6L, doubleLargeArray2.getDouble(l13));
                                        doubleLargeArray.setDouble(l10 + 7L, doubleLargeArray2.getDouble(l13 + 1L));
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l11;
                                    doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                                    doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                                    doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l10 + 2L));
                                    doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l10 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl, bl);
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l11;
                                    doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                                    doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                                    doubleLargeArray.setDouble(l10 + 2L, doubleLargeArray2.getDouble(l17));
                                    doubleLargeArray.setDouble(l10 + 3L, doubleLargeArray2.getDouble(l17 + 1L));
                                }
                            } else if (DoubleFFT_3D.this.columnsl == 2L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                                    doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                                    doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                                }
                            }
                            if (l == 0L) continue;
                            for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                DoubleFFT_3D.this.fftColumns.realInverse(doubleLargeArray, l12 + l11 * DoubleFFT_3D.this.rowStridel, bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final double[] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n22] = dArray[n32];
                                        dArray2[n22 + 1] = dArray[n32 + 1];
                                        dArray2[n16] = dArray[n32 + 2];
                                        dArray2[n16 + 1] = dArray[n32 + 3];
                                        dArray2[n7] = dArray[n32 + 4];
                                        dArray2[n7 + 1] = dArray[n32 + 5];
                                        dArray2[n62] = dArray[n32 + 6];
                                        dArray2[n62 + 1] = dArray[n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 6 * DoubleFFT_3D.this.rows);
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = 2 * n8;
                                        n16 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n32] = dArray2[n22];
                                        dArray[n32 + 1] = dArray2[n22 + 1];
                                        dArray[n32 + 2] = dArray2[n16];
                                        dArray[n32 + 3] = dArray2[n16 + 1];
                                        dArray[n32 + 4] = dArray2[n7];
                                        dArray[n32 + 5] = dArray2[n7 + 1];
                                        dArray[n32 + 6] = dArray2[n62];
                                        dArray[n32 + 7] = dArray2[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    dArray2[n22] = dArray[n32];
                                    dArray2[n22 + 1] = dArray[n32 + 1];
                                    dArray2[n16] = dArray[n32 + 2];
                                    dArray2[n16 + 1] = dArray[n32 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = 2 * n4;
                                    n16 = 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    dArray[n32] = dArray2[n22];
                                    dArray[n32 + 1] = dArray2[n22 + 1];
                                    dArray[n32 + 2] = dArray2[n16];
                                    dArray[n32 + 3] = dArray2[n16 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                dArray2[n22] = dArray[n32];
                                dArray2[n22 + 1] = dArray[n32 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = 2 * n4;
                                dArray[n32] = dArray2[n22];
                                dArray[n32 + 1] = dArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            } else {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n9] = dArray[n10];
                                        dArray2[n9 + 1] = dArray[n10 + 1];
                                        dArray2[n17] = dArray[n10 + 2];
                                        dArray2[n17 + 1] = dArray[n10 + 3];
                                        dArray2[n14] = dArray[n10 + 4];
                                        dArray2[n14 + 1] = dArray[n10 + 5];
                                        dArray2[n13] = dArray[n10 + 6];
                                        dArray2[n13 + 1] = dArray[n10 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = 2 * n15;
                                        n17 = 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n10] = dArray2[n9];
                                        dArray[n10 + 1] = dArray2[n9 + 1];
                                        dArray[n10 + 2] = dArray2[n17];
                                        dArray[n10 + 3] = dArray2[n17 + 1];
                                        dArray[n10 + 4] = dArray2[n14];
                                        dArray[n10 + 5] = dArray2[n14 + 1];
                                        dArray[n10 + 6] = dArray2[n13];
                                        dArray[n10 + 7] = dArray2[n13 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    dArray2[n9] = dArray[n10];
                                    dArray2[n9 + 1] = dArray[n10 + 1];
                                    dArray2[n17] = dArray[n10 + 2];
                                    dArray2[n17 + 1] = dArray[n10 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = 2 * n11;
                                    n17 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    dArray[n10] = dArray2[n9];
                                    dArray[n10 + 1] = dArray2[n9 + 1];
                                    dArray[n10 + 2] = dArray2[n17];
                                    dArray[n10 + 3] = dArray2[n17 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                n9 = 2 * n11;
                                dArray2[n9] = dArray[n10];
                                dArray2[n9 + 1] = dArray[n10 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                            for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                n9 = 2 * n11;
                                dArray[n10] = dArray2[n9];
                                dArray[n10 + 1] = dArray2[n9 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final long l, final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)Math.min((long)ConcurrencyUtils.getNumberOfThreads(), this.slicesl);
        long l2 = this.slicesl;
        if (l2 < this.rowsl) {
            l2 = this.rowsl;
        }
        l2 *= 8L;
        if (this.columnsl == 4L) {
            l2 >>= 1;
        } else if (this.columnsl < 4L) {
            l2 >>= 2;
        }
        final long l3 = l2;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l3, false);
                    if (n == -1) {
                        for (long i = l4; i < DoubleFFT_3D.this.slicesl; i += (long)n2) {
                            long l16;
                            long l2;
                            long l32;
                            long l42;
                            long l5 = i * DoubleFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(doubleLargeArray, l5 + l42 * DoubleFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    DoubleFFT_3D.this.fftColumns.realForward(doubleLargeArray, l5 + l42 * DoubleFFT_3D.this.rowStridel);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.columnsl; l42 += 8L) {
                                    long l6;
                                    long l7;
                                    long l8;
                                    for (l8 = 0L; l8 < DoubleFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * DoubleFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * DoubleFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32));
                                        doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                                        doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l32 + 2L));
                                        doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l32 + 3L));
                                        doubleLargeArray2.setDouble(l7, doubleLargeArray.getDouble(l32 + 4L));
                                        doubleLargeArray2.setDouble(l7 + 1L, doubleLargeArray.getDouble(l32 + 5L));
                                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l32 + 6L));
                                        doubleLargeArray2.setDouble(l6 + 1L, doubleLargeArray.getDouble(l32 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 4L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 6L * DoubleFFT_3D.this.rowsl);
                                    for (l8 = 0L; l8 < DoubleFFT_3D.this.rowsl; ++l8) {
                                        l32 = l5 + l8 * DoubleFFT_3D.this.rowStridel + l42;
                                        l2 = 2L * l8;
                                        l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l8;
                                        l7 = l16 + 2L * DoubleFFT_3D.this.rowsl;
                                        l6 = l7 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l2));
                                        doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                                        doubleLargeArray.setDouble(l32 + 2L, doubleLargeArray2.getDouble(l16));
                                        doubleLargeArray.setDouble(l32 + 3L, doubleLargeArray2.getDouble(l16 + 1L));
                                        doubleLargeArray.setDouble(l32 + 4L, doubleLargeArray2.getDouble(l7));
                                        doubleLargeArray.setDouble(l32 + 5L, doubleLargeArray2.getDouble(l7 + 1L));
                                        doubleLargeArray.setDouble(l32 + 6L, doubleLargeArray2.getDouble(l6));
                                        doubleLargeArray.setDouble(l32 + 7L, doubleLargeArray2.getDouble(l6 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l42;
                                    doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32));
                                    doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                                    doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l32 + 2L));
                                    doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l32 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                                DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl);
                                for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                    l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                    l2 = 2L * l42;
                                    l16 = 2L * DoubleFFT_3D.this.rowsl + 2L * l42;
                                    doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l2));
                                    doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                                    doubleLargeArray.setDouble(l32 + 2L, doubleLargeArray2.getDouble(l16));
                                    doubleLargeArray.setDouble(l32 + 3L, doubleLargeArray2.getDouble(l16 + 1L));
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) continue;
                            for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                doubleLargeArray2.setDouble(l2, doubleLargeArray.getDouble(l32));
                                doubleLargeArray2.setDouble(l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                            for (l42 = 0L; l42 < DoubleFFT_3D.this.rowsl; ++l42) {
                                l32 = l5 + l42 * DoubleFFT_3D.this.rowStridel;
                                l2 = 2L * l42;
                                doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(l2));
                                doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(l2 + 1L));
                            }
                        }
                    } else {
                        for (long i = l4; i < DoubleFFT_3D.this.slicesl; i += (long)n2) {
                            long l17;
                            long l9;
                            long l10;
                            long l11;
                            long l12 = i * DoubleFFT_3D.this.sliceStridel;
                            if (l == 0L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(doubleLargeArray, l12 + l11 * DoubleFFT_3D.this.rowStridel, bl);
                                }
                            } else {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(doubleLargeArray, l12 + l11 * DoubleFFT_3D.this.rowStridel, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.columnsl; l11 += 8L) {
                                    long l13;
                                    long l14;
                                    long l15;
                                    for (l15 = 0L; l15 < DoubleFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * DoubleFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * DoubleFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                                        doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                                        doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l10 + 2L));
                                        doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l10 + 3L));
                                        doubleLargeArray2.setDouble(l14, doubleLargeArray.getDouble(l10 + 4L));
                                        doubleLargeArray2.setDouble(l14 + 1L, doubleLargeArray.getDouble(l10 + 5L));
                                        doubleLargeArray2.setDouble(l13, doubleLargeArray.getDouble(l10 + 6L));
                                        doubleLargeArray2.setDouble(l13 + 1L, doubleLargeArray.getDouble(l10 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 4L * DoubleFFT_3D.this.rowsl, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 6L * DoubleFFT_3D.this.rowsl, bl);
                                    for (l15 = 0L; l15 < DoubleFFT_3D.this.rowsl; ++l15) {
                                        l10 = l12 + l15 * DoubleFFT_3D.this.rowStridel + l11;
                                        l9 = 2L * l15;
                                        l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l15;
                                        l14 = l17 + 2L * DoubleFFT_3D.this.rowsl;
                                        l13 = l14 + 2L * DoubleFFT_3D.this.rowsl;
                                        doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                                        doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                                        doubleLargeArray.setDouble(l10 + 2L, doubleLargeArray2.getDouble(l17));
                                        doubleLargeArray.setDouble(l10 + 3L, doubleLargeArray2.getDouble(l17 + 1L));
                                        doubleLargeArray.setDouble(l10 + 4L, doubleLargeArray2.getDouble(l14));
                                        doubleLargeArray.setDouble(l10 + 5L, doubleLargeArray2.getDouble(l14 + 1L));
                                        doubleLargeArray.setDouble(l10 + 6L, doubleLargeArray2.getDouble(l13));
                                        doubleLargeArray.setDouble(l10 + 7L, doubleLargeArray2.getDouble(l13 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l11;
                                    doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                                    doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                                    doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l10 + 2L));
                                    doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l10 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 2L * DoubleFFT_3D.this.rowsl, bl);
                                for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                    l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                    l9 = 2L * l11;
                                    l17 = 2L * DoubleFFT_3D.this.rowsl + 2L * l11;
                                    doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                                    doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                                    doubleLargeArray.setDouble(l10 + 2L, doubleLargeArray2.getDouble(l17));
                                    doubleLargeArray.setDouble(l10 + 3L, doubleLargeArray2.getDouble(l17 + 1L));
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) continue;
                            for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                l9 = 2L * l11;
                                doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l10));
                                doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l10 + 1L));
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                            for (l11 = 0L; l11 < DoubleFFT_3D.this.rowsl; ++l11) {
                                l10 = l12 + l11 * DoubleFFT_3D.this.rowStridel;
                                l9 = 2L * l11;
                                doubleLargeArray.setDouble(l10, doubleLargeArray2.getDouble(l9));
                                doubleLargeArray.setDouble(l10 + 1L, doubleLargeArray2.getDouble(l9 + 1L));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth1(final int n, final int n2, final double[][][] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray[i][n32], 0);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n22] = dArray[i][n62][n32];
                                        dArray2[n22 + 1] = dArray[i][n62][n32 + 1];
                                        dArray2[n12] = dArray[i][n62][n32 + 2];
                                        dArray2[n12 + 1] = dArray[i][n62][n32 + 3];
                                        dArray2[n52] = dArray[i][n62][n32 + 4];
                                        dArray2[n52 + 1] = dArray[i][n62][n32 + 5];
                                        dArray2[n4] = dArray[i][n62][n32 + 6];
                                        dArray2[n4 + 1] = dArray[i][n62][n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 6 * DoubleFFT_3D.this.rows);
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n62][n32] = dArray2[n22];
                                        dArray[i][n62][n32 + 1] = dArray2[n22 + 1];
                                        dArray[i][n62][n32 + 2] = dArray2[n12];
                                        dArray[i][n62][n32 + 3] = dArray2[n12 + 1];
                                        dArray[i][n62][n32 + 4] = dArray2[n52];
                                        dArray[i][n62][n32 + 5] = dArray2[n52 + 1];
                                        dArray[i][n62][n32 + 6] = dArray2[n4];
                                        dArray[i][n62][n32 + 7] = dArray2[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    dArray2[n22] = dArray[i][n32][0];
                                    dArray2[n22 + 1] = dArray[i][n32][1];
                                    dArray2[n12] = dArray[i][n32][2];
                                    dArray2[n12 + 1] = dArray[i][n32][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    dArray[i][n32][0] = dArray2[n22];
                                    dArray[i][n32][1] = dArray2[n22 + 1];
                                    dArray[i][n32][2] = dArray2[n12];
                                    dArray[i][n32][3] = dArray2[n12 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                dArray2[n22] = dArray[i][n32][0];
                                dArray2[n22 + 1] = dArray[i][n32][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                dArray[i][n32][0] = dArray2[n22];
                                dArray[i][n32][1] = dArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray[i][n8], bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n7] = dArray[i][n11][n8];
                                        dArray2[n7 + 1] = dArray[i][n11][n8 + 1];
                                        dArray2[n13] = dArray[i][n11][n8 + 2];
                                        dArray2[n13 + 1] = dArray[i][n11][n8 + 3];
                                        dArray2[n10] = dArray[i][n11][n8 + 4];
                                        dArray2[n10 + 1] = dArray[i][n11][n8 + 5];
                                        dArray2[n9] = dArray[i][n11][n8 + 6];
                                        dArray2[n9 + 1] = dArray[i][n11][n8 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n11][n8] = dArray2[n7];
                                        dArray[i][n11][n8 + 1] = dArray2[n7 + 1];
                                        dArray[i][n11][n8 + 2] = dArray2[n13];
                                        dArray[i][n11][n8 + 3] = dArray2[n13 + 1];
                                        dArray[i][n11][n8 + 4] = dArray2[n10];
                                        dArray[i][n11][n8 + 5] = dArray2[n10 + 1];
                                        dArray[i][n11][n8 + 6] = dArray2[n9];
                                        dArray[i][n11][n8 + 7] = dArray2[n9 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    dArray2[n7] = dArray[i][n8][0];
                                    dArray2[n7 + 1] = dArray[i][n8][1];
                                    dArray2[n13] = dArray[i][n8][2];
                                    dArray2[n13 + 1] = dArray[i][n8][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    dArray[i][n8][0] = dArray2[n7];
                                    dArray[i][n8][1] = dArray2[n7 + 1];
                                    dArray[i][n8][2] = dArray2[n13];
                                    dArray[i][n8][3] = dArray2[n13 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    dArray2[n7] = dArray[i][n8][0];
                                    dArray2[n7 + 1] = dArray[i][n8][1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    dArray[i][n8][0] = dArray2[n7];
                                    dArray[i][n8][1] = dArray2[n7 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                DoubleFFT_3D.this.fftColumns.realInverse(dArray[i][n8], bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final double[][][] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = this.slices;
        if (n4 < this.rows) {
            n4 = this.rows;
        }
        n4 *= 8;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        final int n5 = n4;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] dArray2 = new double[n5];
                    if (n2 == -1) {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray[i][n32]);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n22] = dArray[i][n62][n32];
                                        dArray2[n22 + 1] = dArray[i][n62][n32 + 1];
                                        dArray2[n12] = dArray[i][n62][n32 + 2];
                                        dArray2[n12 + 1] = dArray[i][n62][n32 + 3];
                                        dArray2[n52] = dArray[i][n62][n32 + 4];
                                        dArray2[n52 + 1] = dArray[i][n62][n32 + 5];
                                        dArray2[n4] = dArray[i][n62][n32 + 6];
                                        dArray2[n4 + 1] = dArray[i][n62][n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2, 6 * DoubleFFT_3D.this.rows);
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = 2 * n62;
                                        n12 = 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n62][n32] = dArray2[n22];
                                        dArray[i][n62][n32 + 1] = dArray2[n22 + 1];
                                        dArray[i][n62][n32 + 2] = dArray2[n12];
                                        dArray[i][n62][n32 + 3] = dArray2[n12 + 1];
                                        dArray[i][n62][n32 + 4] = dArray2[n52];
                                        dArray[i][n62][n32 + 5] = dArray2[n52 + 1];
                                        dArray[i][n62][n32 + 6] = dArray2[n4];
                                        dArray[i][n62][n32 + 7] = dArray2[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    dArray2[n22] = dArray[i][n32][0];
                                    dArray2[n22 + 1] = dArray[i][n32][1];
                                    dArray2[n12] = dArray[i][n32][2];
                                    dArray2[n12 + 1] = dArray[i][n32][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_3D.this.rows);
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n12 = 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    dArray[i][n32][0] = dArray2[n22];
                                    dArray[i][n32][1] = dArray2[n22 + 1];
                                    dArray[i][n32][2] = dArray2[n12];
                                    dArray[i][n32][3] = dArray2[n12 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                dArray2[n22] = dArray[i][n32][0];
                                dArray2[n22 + 1] = dArray[i][n32][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(dArray2, 0);
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = 2 * n32;
                                dArray[i][n32][0] = dArray2[n22];
                                dArray[i][n32][1] = dArray2[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n6; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray[i][n8], bl);
                                }
                            } else {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(dArray[i][n8], 0, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        dArray2[n7] = dArray[i][n11][n8];
                                        dArray2[n7 + 1] = dArray[i][n11][n8 + 1];
                                        dArray2[n13] = dArray[i][n11][n8 + 2];
                                        dArray2[n13 + 1] = dArray[i][n11][n8 + 3];
                                        dArray2[n10] = dArray[i][n11][n8 + 4];
                                        dArray2[n10 + 1] = dArray[i][n11][n8 + 5];
                                        dArray2[n9] = dArray[i][n11][n8 + 6];
                                        dArray2[n9 + 1] = dArray[i][n11][n8 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = 2 * n11;
                                        n13 = 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n11][n8] = dArray2[n7];
                                        dArray[i][n11][n8 + 1] = dArray2[n7 + 1];
                                        dArray[i][n11][n8 + 2] = dArray2[n13];
                                        dArray[i][n11][n8 + 3] = dArray2[n13 + 1];
                                        dArray[i][n11][n8 + 4] = dArray2[n10];
                                        dArray[i][n11][n8 + 5] = dArray2[n10 + 1];
                                        dArray[i][n11][n8 + 6] = dArray2[n9];
                                        dArray[i][n11][n8 + 7] = dArray2[n9 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    dArray2[n7] = dArray[i][n8][0];
                                    dArray2[n7 + 1] = dArray[i][n8][1];
                                    dArray2[n13] = dArray[i][n8][2];
                                    dArray2[n13 + 1] = dArray[i][n8][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = 2 * n8;
                                    n13 = 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    dArray[i][n8][0] = dArray2[n7];
                                    dArray[i][n8][1] = dArray2[n7 + 1];
                                    dArray[i][n8][2] = dArray2[n13];
                                    dArray[i][n8][3] = dArray2[n13 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                n7 = 2 * n8;
                                dArray2[n7] = dArray[i][n8][0];
                                dArray2[n7 + 1] = dArray[i][n8][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(dArray2, 0, bl);
                            for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                n7 = 2 * n8;
                                dArray[i][n8][0] = dArray2[n7];
                                dArray[i][n8][1] = dArray2[n7 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        double[] dArray2;
                        block25: {
                            block28: {
                                block26: {
                                    dArray2 = new double[n4];
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                        int n28 = i * DoubleFFT_3D.this.rowStride;
                                        for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                            int n29;
                                            int n3;
                                            int n42;
                                            int n52;
                                            int n6;
                                            int n7;
                                            for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * DoubleFFT_3D.this.sliceStride + n28 + j;
                                                n52 = 2 * n7;
                                                n42 = 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * DoubleFFT_3D.this.slices;
                                                n29 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                dArray2[n52] = dArray[n6];
                                                dArray2[n52 + 1] = dArray[n6 + 1];
                                                dArray2[n42] = dArray[n6 + 2];
                                                dArray2[n42 + 1] = dArray[n6 + 3];
                                                dArray2[n3] = dArray[n6 + 4];
                                                dArray2[n3 + 1] = dArray[n6 + 5];
                                                dArray2[n29] = dArray[n6 + 6];
                                                dArray2[n29 + 1] = dArray[n6 + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 0);
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 6 * DoubleFFT_3D.this.slices);
                                            for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * DoubleFFT_3D.this.sliceStride + n28 + j;
                                                n52 = 2 * n7;
                                                n42 = 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * DoubleFFT_3D.this.slices;
                                                n29 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                dArray[n6] = dArray2[n52];
                                                dArray[n6 + 1] = dArray2[n52 + 1];
                                                dArray[n6 + 2] = dArray2[n42];
                                                dArray[n6 + 3] = dArray2[n42 + 1];
                                                dArray[n6 + 4] = dArray2[n3];
                                                dArray[n6 + 5] = dArray2[n3 + 1];
                                                dArray[n6 + 6] = dArray2[n29];
                                                dArray[n6 + 7] = dArray2[n29 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                    int n30;
                                    int n8;
                                    int n9;
                                    int n10;
                                    int n11 = i * DoubleFFT_3D.this.rowStride;
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * DoubleFFT_3D.this.sliceStride + n11;
                                        n8 = 2 * n10;
                                        n30 = 2 * DoubleFFT_3D.this.slices + 2 * n10;
                                        dArray2[n8] = dArray[n9];
                                        dArray2[n8 + 1] = dArray[n9 + 1];
                                        dArray2[n30] = dArray[n9 + 2];
                                        dArray2[n30 + 1] = dArray[n9 + 3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 0);
                                    DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 2 * DoubleFFT_3D.this.slices);
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * DoubleFFT_3D.this.sliceStride + n11;
                                        n8 = 2 * n10;
                                        n30 = 2 * DoubleFFT_3D.this.slices + 2 * n10;
                                        dArray[n9] = dArray2[n8];
                                        dArray[n9 + 1] = dArray2[n8 + 1];
                                        dArray[n9 + 2] = dArray2[n30];
                                        dArray[n9 + 3] = dArray2[n30 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n31;
                                int n12;
                                int n13;
                                int n14 = i * DoubleFFT_3D.this.rowStride;
                                for (n13 = 0; n13 < DoubleFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * DoubleFFT_3D.this.sliceStride + n14;
                                    n31 = 2 * n13;
                                    dArray2[n31] = dArray[n12];
                                    dArray2[n31 + 1] = dArray[n12 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 0);
                                for (n13 = 0; n13 < DoubleFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * DoubleFFT_3D.this.sliceStride + n14;
                                    n31 = 2 * n13;
                                    dArray[n12] = dArray2[n31];
                                    dArray[n12 + 1] = dArray2[n31 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n32 = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                    int n15;
                                    int n16;
                                    int n17;
                                    int n18;
                                    int n19;
                                    int n20;
                                    for (n20 = 0; n20 < DoubleFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * DoubleFFT_3D.this.sliceStride + n32 + j;
                                        n18 = 2 * n20;
                                        n17 = 2 * DoubleFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * DoubleFFT_3D.this.slices;
                                        n15 = n16 + 2 * DoubleFFT_3D.this.slices;
                                        dArray2[n18] = dArray[n19];
                                        dArray2[n18 + 1] = dArray[n19 + 1];
                                        dArray2[n17] = dArray[n19 + 2];
                                        dArray2[n17 + 1] = dArray[n19 + 3];
                                        dArray2[n16] = dArray[n19 + 4];
                                        dArray2[n16 + 1] = dArray[n19 + 5];
                                        dArray2[n15] = dArray[n19 + 6];
                                        dArray2[n15 + 1] = dArray[n19 + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 0, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 2 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 4 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 6 * DoubleFFT_3D.this.slices, bl);
                                    for (n20 = 0; n20 < DoubleFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * DoubleFFT_3D.this.sliceStride + n32 + j;
                                        n18 = 2 * n20;
                                        n17 = 2 * DoubleFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * DoubleFFT_3D.this.slices;
                                        n15 = n16 + 2 * DoubleFFT_3D.this.slices;
                                        dArray[n19] = dArray2[n18];
                                        dArray[n19 + 1] = dArray2[n18 + 1];
                                        dArray[n19 + 2] = dArray2[n17];
                                        dArray[n19 + 3] = dArray2[n17 + 1];
                                        dArray[n19 + 4] = dArray2[n16];
                                        dArray[n19 + 5] = dArray2[n16 + 1];
                                        dArray[n19 + 6] = dArray2[n15];
                                        dArray[n19 + 7] = dArray2[n15 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n33;
                                int n21;
                                int n22;
                                int n23;
                                int n24 = i * DoubleFFT_3D.this.rowStride;
                                for (n23 = 0; n23 < DoubleFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * DoubleFFT_3D.this.sliceStride + n24;
                                    n21 = 2 * n23;
                                    n33 = 2 * DoubleFFT_3D.this.slices + 2 * n23;
                                    dArray2[n21] = dArray[n22];
                                    dArray2[n21 + 1] = dArray[n22 + 1];
                                    dArray2[n33] = dArray[n22 + 2];
                                    dArray2[n33 + 1] = dArray[n22 + 3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 0, bl);
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 2 * DoubleFFT_3D.this.slices, bl);
                                for (n23 = 0; n23 < DoubleFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * DoubleFFT_3D.this.sliceStride + n24;
                                    n21 = 2 * n23;
                                    n33 = 2 * DoubleFFT_3D.this.slices + 2 * n23;
                                    dArray[n22] = dArray2[n21];
                                    dArray[n22 + 1] = dArray2[n21 + 1];
                                    dArray[n22 + 2] = dArray2[n33];
                                    dArray[n22 + 3] = dArray2[n33 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n34;
                                int n25;
                                int n26;
                                int n27 = i * DoubleFFT_3D.this.rowStride;
                                for (n26 = 0; n26 < DoubleFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * DoubleFFT_3D.this.sliceStride + n27;
                                    n34 = 2 * n26;
                                    dArray2[n34] = dArray[n25];
                                    dArray2[n34 + 1] = dArray[n25 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 0, bl);
                                for (n26 = 0; n26 < DoubleFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * DoubleFFT_3D.this.sliceStride + n27;
                                    n34 = 2 * n26;
                                    dArray[n25] = dArray2[n34];
                                    dArray[n25 + 1] = dArray2[n34 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)Math.min((long)ConcurrencyUtils.getNumberOfThreads(), this.rowsl);
        long l = this.slicesl;
        if (l < this.rowsl) {
            l = this.rowsl;
        }
        l *= 8L;
        if (this.columnsl == 4L) {
            l >>= 1;
        } else if (this.columnsl < 4L) {
            l >>= 2;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        DoubleLargeArray doubleLargeArray2;
                        block25: {
                            block28: {
                                block26: {
                                    doubleLargeArray2 = new DoubleLargeArray(l2, false);
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.columnsl <= 4L) break block26;
                                    for (long i = l3; i < DoubleFFT_3D.this.rowsl; i += (long)n2) {
                                        long l = i * DoubleFFT_3D.this.rowStridel;
                                        for (long j = 0L; j < DoubleFFT_3D.this.columnsl; j += 8L) {
                                            long l28;
                                            long l32;
                                            long l4;
                                            long l5;
                                            long l6;
                                            long l7;
                                            for (l7 = 0L; l7 < DoubleFFT_3D.this.slicesl; ++l7) {
                                                l6 = l7 * DoubleFFT_3D.this.sliceStridel + l + j;
                                                l5 = 2L * l7;
                                                l4 = 2L * DoubleFFT_3D.this.slicesl + 2L * l7;
                                                l32 = l4 + 2L * DoubleFFT_3D.this.slicesl;
                                                l28 = l32 + 2L * DoubleFFT_3D.this.slicesl;
                                                doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l6));
                                                doubleLargeArray2.setDouble(l5 + 1L, doubleLargeArray.getDouble(l6 + 1L));
                                                doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l6 + 2L));
                                                doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l6 + 3L));
                                                doubleLargeArray2.setDouble(l32, doubleLargeArray.getDouble(l6 + 4L));
                                                doubleLargeArray2.setDouble(l32 + 1L, doubleLargeArray.getDouble(l6 + 5L));
                                                doubleLargeArray2.setDouble(l28, doubleLargeArray.getDouble(l6 + 6L));
                                                doubleLargeArray2.setDouble(l28 + 1L, doubleLargeArray.getDouble(l6 + 7L));
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 0L);
                                            DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 2L * DoubleFFT_3D.this.slicesl);
                                            DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 4L * DoubleFFT_3D.this.slicesl);
                                            DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 6L * DoubleFFT_3D.this.slicesl);
                                            for (l7 = 0L; l7 < DoubleFFT_3D.this.slicesl; ++l7) {
                                                l6 = l7 * DoubleFFT_3D.this.sliceStridel + l + j;
                                                l5 = 2L * l7;
                                                l4 = 2L * DoubleFFT_3D.this.slicesl + 2L * l7;
                                                l32 = l4 + 2L * DoubleFFT_3D.this.slicesl;
                                                l28 = l32 + 2L * DoubleFFT_3D.this.slicesl;
                                                doubleLargeArray.setDouble(l6, doubleLargeArray2.getDouble(l5));
                                                doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray2.getDouble(l5 + 1L));
                                                doubleLargeArray.setDouble(l6 + 2L, doubleLargeArray2.getDouble(l4));
                                                doubleLargeArray.setDouble(l6 + 3L, doubleLargeArray2.getDouble(l4 + 1L));
                                                doubleLargeArray.setDouble(l6 + 4L, doubleLargeArray2.getDouble(l32));
                                                doubleLargeArray.setDouble(l6 + 5L, doubleLargeArray2.getDouble(l32 + 1L));
                                                doubleLargeArray.setDouble(l6 + 6L, doubleLargeArray2.getDouble(l28));
                                                doubleLargeArray.setDouble(l6 + 7L, doubleLargeArray2.getDouble(l28 + 1L));
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columnsl != 4L) break block28;
                                for (long i = l3; i < DoubleFFT_3D.this.rowsl; i += (long)n2) {
                                    long l;
                                    long l8;
                                    long l9;
                                    long l10;
                                    long l11 = i * DoubleFFT_3D.this.rowStridel;
                                    for (l10 = 0L; l10 < DoubleFFT_3D.this.slicesl; ++l10) {
                                        l9 = l10 * DoubleFFT_3D.this.sliceStridel + l11;
                                        l8 = 2L * l10;
                                        l = 2L * DoubleFFT_3D.this.slicesl + 2L * l10;
                                        doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l9));
                                        doubleLargeArray2.setDouble(l8 + 1L, doubleLargeArray.getDouble(l9 + 1L));
                                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l9 + 2L));
                                        doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l9 + 3L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 0L);
                                    DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 2L * DoubleFFT_3D.this.slicesl);
                                    for (l10 = 0L; l10 < DoubleFFT_3D.this.slicesl; ++l10) {
                                        l9 = l10 * DoubleFFT_3D.this.sliceStridel + l11;
                                        l8 = 2L * l10;
                                        l = 2L * DoubleFFT_3D.this.slicesl + 2L * l10;
                                        doubleLargeArray.setDouble(l9, doubleLargeArray2.getDouble(l8));
                                        doubleLargeArray.setDouble(l9 + 1L, doubleLargeArray2.getDouble(l8 + 1L));
                                        doubleLargeArray.setDouble(l9 + 2L, doubleLargeArray2.getDouble(l));
                                        doubleLargeArray.setDouble(l9 + 3L, doubleLargeArray2.getDouble(l + 1L));
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) break block27;
                            for (long i = l3; i < DoubleFFT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l12;
                                long l13;
                                long l14 = i * DoubleFFT_3D.this.rowStridel;
                                for (l13 = 0L; l13 < DoubleFFT_3D.this.slicesl; ++l13) {
                                    l12 = l13 * DoubleFFT_3D.this.sliceStridel + l14;
                                    l = 2L * l13;
                                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l12));
                                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l12 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(doubleLargeArray2, 0L);
                                for (l13 = 0L; l13 < DoubleFFT_3D.this.slicesl; ++l13) {
                                    l12 = l13 * DoubleFFT_3D.this.sliceStridel + l14;
                                    l = 2L * l13;
                                    doubleLargeArray.setDouble(l12, doubleLargeArray2.getDouble(l));
                                    doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray2.getDouble(l + 1L));
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columnsl > 4L) {
                            for (long i = l3; i < DoubleFFT_3D.this.rowsl; i += (long)n2) {
                                long l = i * DoubleFFT_3D.this.rowStridel;
                                for (long j = 0L; j < DoubleFFT_3D.this.columnsl; j += 8L) {
                                    long l15;
                                    long l16;
                                    long l17;
                                    long l18;
                                    long l19;
                                    long l20;
                                    for (l20 = 0L; l20 < DoubleFFT_3D.this.slicesl; ++l20) {
                                        l19 = l20 * DoubleFFT_3D.this.sliceStridel + l + j;
                                        l18 = 2L * l20;
                                        l17 = 2L * DoubleFFT_3D.this.slicesl + 2L * l20;
                                        l16 = l17 + 2L * DoubleFFT_3D.this.slicesl;
                                        l15 = l16 + 2L * DoubleFFT_3D.this.slicesl;
                                        doubleLargeArray2.setDouble(l18, doubleLargeArray.getDouble(l19));
                                        doubleLargeArray2.setDouble(l18 + 1L, doubleLargeArray.getDouble(l19 + 1L));
                                        doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l19 + 2L));
                                        doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l19 + 3L));
                                        doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l19 + 4L));
                                        doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l19 + 5L));
                                        doubleLargeArray2.setDouble(l15, doubleLargeArray.getDouble(l19 + 6L));
                                        doubleLargeArray2.setDouble(l15 + 1L, doubleLargeArray.getDouble(l19 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 0L, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 2L * DoubleFFT_3D.this.slicesl, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 4L * DoubleFFT_3D.this.slicesl, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 6L * DoubleFFT_3D.this.slicesl, bl);
                                    for (l20 = 0L; l20 < DoubleFFT_3D.this.slicesl; ++l20) {
                                        l19 = l20 * DoubleFFT_3D.this.sliceStridel + l + j;
                                        l18 = 2L * l20;
                                        l17 = 2L * DoubleFFT_3D.this.slicesl + 2L * l20;
                                        l16 = l17 + 2L * DoubleFFT_3D.this.slicesl;
                                        l15 = l16 + 2L * DoubleFFT_3D.this.slicesl;
                                        doubleLargeArray.setDouble(l19, doubleLargeArray2.getDouble(l18));
                                        doubleLargeArray.setDouble(l19 + 1L, doubleLargeArray2.getDouble(l18 + 1L));
                                        doubleLargeArray.setDouble(l19 + 2L, doubleLargeArray2.getDouble(l17));
                                        doubleLargeArray.setDouble(l19 + 3L, doubleLargeArray2.getDouble(l17 + 1L));
                                        doubleLargeArray.setDouble(l19 + 4L, doubleLargeArray2.getDouble(l16));
                                        doubleLargeArray.setDouble(l19 + 5L, doubleLargeArray2.getDouble(l16 + 1L));
                                        doubleLargeArray.setDouble(l19 + 6L, doubleLargeArray2.getDouble(l15));
                                        doubleLargeArray.setDouble(l19 + 7L, doubleLargeArray2.getDouble(l15 + 1L));
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columnsl == 4L) {
                            for (long i = l3; i < DoubleFFT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l21;
                                long l22;
                                long l23;
                                long l24 = i * DoubleFFT_3D.this.rowStridel;
                                for (l23 = 0L; l23 < DoubleFFT_3D.this.slicesl; ++l23) {
                                    l22 = l23 * DoubleFFT_3D.this.sliceStridel + l24;
                                    l21 = 2L * l23;
                                    l = 2L * DoubleFFT_3D.this.slicesl + 2L * l23;
                                    doubleLargeArray2.setDouble(l21, doubleLargeArray.getDouble(l22));
                                    doubleLargeArray2.setDouble(l21 + 1L, doubleLargeArray.getDouble(l22 + 1L));
                                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l22 + 2L));
                                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l22 + 3L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 0L, bl);
                                DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 2L * DoubleFFT_3D.this.slicesl, bl);
                                for (l23 = 0L; l23 < DoubleFFT_3D.this.slicesl; ++l23) {
                                    l22 = l23 * DoubleFFT_3D.this.sliceStridel + l24;
                                    l21 = 2L * l23;
                                    l = 2L * DoubleFFT_3D.this.slicesl + 2L * l23;
                                    doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l21));
                                    doubleLargeArray.setDouble(l22 + 1L, doubleLargeArray2.getDouble(l21 + 1L));
                                    doubleLargeArray.setDouble(l22 + 2L, doubleLargeArray2.getDouble(l));
                                    doubleLargeArray.setDouble(l22 + 3L, doubleLargeArray2.getDouble(l + 1L));
                                }
                            }
                        } else if (DoubleFFT_3D.this.columnsl == 2L) {
                            for (long i = l3; i < DoubleFFT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l25;
                                long l26;
                                long l27 = i * DoubleFFT_3D.this.rowStridel;
                                for (l26 = 0L; l26 < DoubleFFT_3D.this.slicesl; ++l26) {
                                    l25 = l26 * DoubleFFT_3D.this.sliceStridel + l27;
                                    l = 2L * l26;
                                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l25));
                                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l25 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(doubleLargeArray2, 0L, bl);
                                for (l26 = 0L; l26 < DoubleFFT_3D.this.slicesl; ++l26) {
                                    l25 = l26 * DoubleFFT_3D.this.sliceStridel + l27;
                                    l = 2L * l26;
                                    doubleLargeArray.setDouble(l25, doubleLargeArray2.getDouble(l));
                                    doubleLargeArray.setDouble(l25 + 1L, doubleLargeArray2.getDouble(l + 1L));
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final double[][][] dArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = this.slices;
        if (n3 < this.rows) {
            n3 = this.rows;
        }
        n3 *= 8;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        double[] dArray2;
                        block25: {
                            block28: {
                                block26: {
                                    dArray2 = new double[n4];
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                        for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                            int n16;
                                            int n22;
                                            int n3;
                                            int n42;
                                            int n52;
                                            for (n52 = 0; n52 < DoubleFFT_3D.this.slices; ++n52) {
                                                n42 = 2 * n52;
                                                n3 = 2 * DoubleFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                n16 = n22 + 2 * DoubleFFT_3D.this.slices;
                                                dArray2[n42] = dArray[n52][i][j];
                                                dArray2[n42 + 1] = dArray[n52][i][j + 1];
                                                dArray2[n3] = dArray[n52][i][j + 2];
                                                dArray2[n3 + 1] = dArray[n52][i][j + 3];
                                                dArray2[n22] = dArray[n52][i][j + 4];
                                                dArray2[n22 + 1] = dArray[n52][i][j + 5];
                                                dArray2[n16] = dArray[n52][i][j + 6];
                                                dArray2[n16 + 1] = dArray[n52][i][j + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 0);
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 6 * DoubleFFT_3D.this.slices);
                                            for (n52 = 0; n52 < DoubleFFT_3D.this.slices; ++n52) {
                                                n42 = 2 * n52;
                                                n3 = 2 * DoubleFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                n16 = n22 + 2 * DoubleFFT_3D.this.slices;
                                                dArray[n52][i][j] = dArray2[n42];
                                                dArray[n52][i][j + 1] = dArray2[n42 + 1];
                                                dArray[n52][i][j + 2] = dArray2[n3];
                                                dArray[n52][i][j + 3] = dArray2[n3 + 1];
                                                dArray[n52][i][j + 4] = dArray2[n22];
                                                dArray[n52][i][j + 5] = dArray2[n22 + 1];
                                                dArray[n52][i][j + 6] = dArray2[n16];
                                                dArray[n52][i][j + 7] = dArray2[n16 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                    int n17;
                                    int n6;
                                    int n7;
                                    for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                        n6 = 2 * n7;
                                        n17 = 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                        dArray2[n6] = dArray[n7][i][0];
                                        dArray2[n6 + 1] = dArray[n7][i][1];
                                        dArray2[n17] = dArray[n7][i][2];
                                        dArray2[n17 + 1] = dArray[n7][i][3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 0);
                                    DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 2 * DoubleFFT_3D.this.slices);
                                    for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                        n6 = 2 * n7;
                                        n17 = 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                        dArray[n7][i][0] = dArray2[n6];
                                        dArray[n7][i][1] = dArray2[n6 + 1];
                                        dArray[n7][i][2] = dArray2[n17];
                                        dArray[n7][i][3] = dArray2[n17 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n18;
                                int n8;
                                for (n8 = 0; n8 < DoubleFFT_3D.this.slices; ++n8) {
                                    n18 = 2 * n8;
                                    dArray2[n18] = dArray[n8][i][0];
                                    dArray2[n18 + 1] = dArray[n8][i][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2, 0);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.slices; ++n8) {
                                    n18 = 2 * n8;
                                    dArray[n8][i][0] = dArray2[n18];
                                    dArray[n8][i][1] = dArray2[n18 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                    int n19;
                                    int n9;
                                    int n10;
                                    int n11;
                                    int n12;
                                    for (n12 = 0; n12 < DoubleFFT_3D.this.slices; ++n12) {
                                        n11 = 2 * n12;
                                        n10 = 2 * DoubleFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.slices;
                                        n19 = n9 + 2 * DoubleFFT_3D.this.slices;
                                        dArray2[n11] = dArray[n12][i][j];
                                        dArray2[n11 + 1] = dArray[n12][i][j + 1];
                                        dArray2[n10] = dArray[n12][i][j + 2];
                                        dArray2[n10 + 1] = dArray[n12][i][j + 3];
                                        dArray2[n9] = dArray[n12][i][j + 4];
                                        dArray2[n9 + 1] = dArray[n12][i][j + 5];
                                        dArray2[n19] = dArray[n12][i][j + 6];
                                        dArray2[n19 + 1] = dArray[n12][i][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 0, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 2 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 4 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 6 * DoubleFFT_3D.this.slices, bl);
                                    for (n12 = 0; n12 < DoubleFFT_3D.this.slices; ++n12) {
                                        n11 = 2 * n12;
                                        n10 = 2 * DoubleFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.slices;
                                        n19 = n9 + 2 * DoubleFFT_3D.this.slices;
                                        dArray[n12][i][j] = dArray2[n11];
                                        dArray[n12][i][j + 1] = dArray2[n11 + 1];
                                        dArray[n12][i][j + 2] = dArray2[n10];
                                        dArray[n12][i][j + 3] = dArray2[n10 + 1];
                                        dArray[n12][i][j + 4] = dArray2[n9];
                                        dArray[n12][i][j + 5] = dArray2[n9 + 1];
                                        dArray[n12][i][j + 6] = dArray2[n19];
                                        dArray[n12][i][j + 7] = dArray2[n19 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n20;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < DoubleFFT_3D.this.slices; ++n14) {
                                    n13 = 2 * n14;
                                    n20 = 2 * DoubleFFT_3D.this.slices + 2 * n14;
                                    dArray2[n13] = dArray[n14][i][0];
                                    dArray2[n13 + 1] = dArray[n14][i][1];
                                    dArray2[n20] = dArray[n14][i][2];
                                    dArray2[n20 + 1] = dArray[n14][i][3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 0, bl);
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 2 * DoubleFFT_3D.this.slices, bl);
                                for (n14 = 0; n14 < DoubleFFT_3D.this.slices; ++n14) {
                                    n13 = 2 * n14;
                                    n20 = 2 * DoubleFFT_3D.this.slices + 2 * n14;
                                    dArray[n14][i][0] = dArray2[n13];
                                    dArray[n14][i][1] = dArray2[n13 + 1];
                                    dArray[n14][i][2] = dArray2[n20];
                                    dArray[n14][i][3] = dArray2[n20 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int i = n5; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n21;
                                int n15;
                                for (n15 = 0; n15 < DoubleFFT_3D.this.slices; ++n15) {
                                    n21 = 2 * n15;
                                    dArray2[n21] = dArray[n15][i][0];
                                    dArray2[n21 + 1] = dArray[n15][i][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, 0, bl);
                                for (n15 = 0; n15 < DoubleFFT_3D.this.slices; ++n15) {
                                    n21 = 2 * n15;
                                    dArray[n15][i][0] = dArray2[n21];
                                    dArray[n15][i][1] = dArray2[n21 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void rdft3d_sub(int n, double[] dArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            double d;
            int n6;
            int n7;
            int n8;
            int n9;
            for (int i = 1; i < n2; ++i) {
                int n10 = this.slices - i;
                n9 = i * this.sliceStride;
                n8 = n10 * this.sliceStride;
                n7 = i * this.sliceStride + n3 * this.rowStride;
                n6 = n10 * this.sliceStride + n3 * this.rowStride;
                d = dArray[n9] - dArray[n8];
                int n11 = n9;
                dArray[n11] = dArray[n11] + dArray[n8];
                dArray[n8] = d;
                d = dArray[n8 + 1] - dArray[n9 + 1];
                int n12 = n9 + 1;
                dArray[n12] = dArray[n12] + dArray[n8 + 1];
                dArray[n8 + 1] = d;
                d = dArray[n7] - dArray[n6];
                int n13 = n7;
                dArray[n13] = dArray[n13] + dArray[n6];
                dArray[n6] = d;
                d = dArray[n6 + 1] - dArray[n7 + 1];
                int n14 = n7 + 1;
                dArray[n14] = dArray[n14] + dArray[n6 + 1];
                dArray[n6 + 1] = d;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    n9 = i * this.sliceStride + n5 * this.rowStride;
                    n8 = n10 * this.sliceStride + n4 * this.rowStride;
                    d = dArray[n9] - dArray[n8];
                    int n15 = n9;
                    dArray[n15] = dArray[n15] + dArray[n8];
                    dArray[n8] = d;
                    d = dArray[n8 + 1] - dArray[n9 + 1];
                    int n16 = n9 + 1;
                    dArray[n16] = dArray[n16] + dArray[n8 + 1];
                    dArray[n8 + 1] = d;
                    n7 = n10 * this.sliceStride + n5 * this.rowStride;
                    n6 = i * this.sliceStride + n4 * this.rowStride;
                    d = dArray[n7] - dArray[n6];
                    int n17 = n7;
                    dArray[n17] = dArray[n17] + dArray[n6];
                    dArray[n6] = d;
                    d = dArray[n6 + 1] - dArray[n7 + 1];
                    int n18 = n7 + 1;
                    dArray[n18] = dArray[n18] + dArray[n6 + 1];
                    dArray[n6 + 1] = d;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                n9 = n5 * this.rowStride;
                n8 = n4 * this.rowStride;
                d = dArray[n9] - dArray[n8];
                int n19 = n9;
                dArray[n19] = dArray[n19] + dArray[n8];
                dArray[n8] = d;
                d = dArray[n8 + 1] - dArray[n9 + 1];
                int n20 = n9 + 1;
                dArray[n20] = dArray[n20] + dArray[n8 + 1];
                dArray[n8 + 1] = d;
                n7 = n2 * this.sliceStride + n5 * this.rowStride;
                n6 = n2 * this.sliceStride + n4 * this.rowStride;
                d = dArray[n7] - dArray[n6];
                int n21 = n7;
                dArray[n21] = dArray[n21] + dArray[n6];
                dArray[n6] = d;
                d = dArray[n6 + 1] - dArray[n7 + 1];
                int n22 = n7 + 1;
                dArray[n22] = dArray[n22] + dArray[n6 + 1];
                dArray[n6 + 1] = d;
            }
        } else {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            for (int i = 1; i < n2; ++i) {
                int n29 = this.slices - i;
                n28 = n29 * this.sliceStride;
                n27 = i * this.sliceStride;
                dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                int n30 = n27;
                dArray[n30] = dArray[n30] - dArray[n28];
                dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                int n31 = n27 + 1;
                dArray[n31] = dArray[n31] - dArray[n28 + 1];
                n26 = n29 * this.sliceStride + n3 * this.rowStride;
                n25 = i * this.sliceStride + n3 * this.rowStride;
                dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                int n32 = n25;
                dArray[n32] = dArray[n32] - dArray[n26];
                dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                int n33 = n25 + 1;
                dArray[n33] = dArray[n33] - dArray[n26 + 1];
                for (n24 = 1; n24 < n3; ++n24) {
                    n23 = this.rows - n24;
                    n28 = n29 * this.sliceStride + n23 * this.rowStride;
                    n27 = i * this.sliceStride + n24 * this.rowStride;
                    dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                    int n34 = n27;
                    dArray[n34] = dArray[n34] - dArray[n28];
                    dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                    int n35 = n27 + 1;
                    dArray[n35] = dArray[n35] - dArray[n28 + 1];
                    n26 = i * this.sliceStride + n23 * this.rowStride;
                    n25 = n29 * this.sliceStride + n24 * this.rowStride;
                    dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                    int n36 = n25;
                    dArray[n36] = dArray[n36] - dArray[n26];
                    dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                    int n37 = n25 + 1;
                    dArray[n37] = dArray[n37] - dArray[n26 + 1];
                }
            }
            for (n24 = 1; n24 < n3; ++n24) {
                n23 = this.rows - n24;
                n28 = n23 * this.rowStride;
                n27 = n24 * this.rowStride;
                dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                int n38 = n27;
                dArray[n38] = dArray[n38] - dArray[n28];
                dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                int n39 = n27 + 1;
                dArray[n39] = dArray[n39] - dArray[n28 + 1];
                n26 = n2 * this.sliceStride + n23 * this.rowStride;
                n25 = n2 * this.sliceStride + n24 * this.rowStride;
                dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                int n40 = n25;
                dArray[n40] = dArray[n40] - dArray[n26];
                dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                int n41 = n25 + 1;
                dArray[n41] = dArray[n41] - dArray[n26 + 1];
            }
        }
    }

    private void rdft3d_sub(int n, DoubleLargeArray doubleLargeArray) {
        long l = this.slicesl >> 1;
        long l2 = this.rowsl >> 1;
        if (n < 0) {
            long l3;
            long l4;
            double d;
            long l5;
            long l6;
            long l7;
            long l8;
            for (long i = 1L; i < l; ++i) {
                long l9 = this.slicesl - i;
                l8 = i * this.sliceStridel;
                l7 = l9 * this.sliceStridel;
                l6 = i * this.sliceStridel + l2 * this.rowStridel;
                l5 = l9 * this.sliceStridel + l2 * this.rowStridel;
                d = doubleLargeArray.getDouble(l8) - doubleLargeArray.getDouble(l7);
                doubleLargeArray.setDouble(l8, doubleLargeArray.getDouble(l8) + doubleLargeArray.getDouble(l7));
                doubleLargeArray.setDouble(l7, d);
                d = doubleLargeArray.getDouble(l7 + 1L) - doubleLargeArray.getDouble(l8 + 1L);
                doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray.getDouble(l8 + 1L) + doubleLargeArray.getDouble(l7 + 1L));
                doubleLargeArray.setDouble(l7 + 1L, d);
                d = doubleLargeArray.getDouble(l6) - doubleLargeArray.getDouble(l5);
                doubleLargeArray.setDouble(l6, doubleLargeArray.getDouble(l6) + doubleLargeArray.getDouble(l5));
                doubleLargeArray.setDouble(l5, d);
                d = doubleLargeArray.getDouble(l5 + 1L) - doubleLargeArray.getDouble(l6 + 1L);
                doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray.getDouble(l6 + 1L) + doubleLargeArray.getDouble(l5 + 1L));
                doubleLargeArray.setDouble(l5 + 1L, d);
                for (l4 = 1L; l4 < l2; ++l4) {
                    l3 = this.rowsl - l4;
                    l8 = i * this.sliceStridel + l4 * this.rowStridel;
                    l7 = l9 * this.sliceStridel + l3 * this.rowStridel;
                    d = doubleLargeArray.getDouble(l8) - doubleLargeArray.getDouble(l7);
                    doubleLargeArray.setDouble(l8, doubleLargeArray.getDouble(l8) + doubleLargeArray.getDouble(l7));
                    doubleLargeArray.setDouble(l7, d);
                    d = doubleLargeArray.getDouble(l7 + 1L) - doubleLargeArray.getDouble(l8 + 1L);
                    doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray.getDouble(l8 + 1L) + doubleLargeArray.getDouble(l7 + 1L));
                    doubleLargeArray.setDouble(l7 + 1L, d);
                    l6 = l9 * this.sliceStridel + l4 * this.rowStridel;
                    l5 = i * this.sliceStridel + l3 * this.rowStridel;
                    d = doubleLargeArray.getDouble(l6) - doubleLargeArray.getDouble(l5);
                    doubleLargeArray.setDouble(l6, doubleLargeArray.getDouble(l6) + doubleLargeArray.getDouble(l5));
                    doubleLargeArray.setDouble(l5, d);
                    d = doubleLargeArray.getDouble(l5 + 1L) - doubleLargeArray.getDouble(l6 + 1L);
                    doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray.getDouble(l6 + 1L) + doubleLargeArray.getDouble(l5 + 1L));
                    doubleLargeArray.setDouble(l5 + 1L, d);
                }
            }
            for (l4 = 1L; l4 < l2; ++l4) {
                l3 = this.rowsl - l4;
                l8 = l4 * this.rowStridel;
                l7 = l3 * this.rowStridel;
                d = doubleLargeArray.getDouble(l8) - doubleLargeArray.getDouble(l7);
                doubleLargeArray.setDouble(l8, doubleLargeArray.getDouble(l8) + doubleLargeArray.getDouble(l7));
                doubleLargeArray.setDouble(l7, d);
                d = doubleLargeArray.getDouble(l7 + 1L) - doubleLargeArray.getDouble(l8 + 1L);
                doubleLargeArray.setDouble(l8 + 1L, doubleLargeArray.getDouble(l8 + 1L) + doubleLargeArray.getDouble(l7 + 1L));
                doubleLargeArray.setDouble(l7 + 1L, d);
                l6 = l * this.sliceStridel + l4 * this.rowStridel;
                l5 = l * this.sliceStridel + l3 * this.rowStridel;
                d = doubleLargeArray.getDouble(l6) - doubleLargeArray.getDouble(l5);
                doubleLargeArray.setDouble(l6, doubleLargeArray.getDouble(l6) + doubleLargeArray.getDouble(l5));
                doubleLargeArray.setDouble(l5, d);
                d = doubleLargeArray.getDouble(l5 + 1L) - doubleLargeArray.getDouble(l6 + 1L);
                doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray.getDouble(l6 + 1L) + doubleLargeArray.getDouble(l5 + 1L));
                doubleLargeArray.setDouble(l5 + 1L, d);
            }
        } else {
            long l10;
            long l11;
            long l12;
            long l13;
            long l14;
            long l15;
            for (long i = 1L; i < l; ++i) {
                long l16 = this.slicesl - i;
                l15 = l16 * this.sliceStridel;
                l14 = i * this.sliceStridel;
                doubleLargeArray.setDouble(l15, 0.5 * (doubleLargeArray.getDouble(l14) - doubleLargeArray.getDouble(l15)));
                doubleLargeArray.setDouble(l14, doubleLargeArray.getDouble(l14) - doubleLargeArray.getDouble(l15));
                doubleLargeArray.setDouble(l15 + 1L, 0.5 * (doubleLargeArray.getDouble(l14 + 1L) + doubleLargeArray.getDouble(l15 + 1L)));
                doubleLargeArray.setDouble(l14 + 1L, doubleLargeArray.getDouble(l14 + 1L) - doubleLargeArray.getDouble(l15 + 1L));
                l13 = l16 * this.sliceStridel + l2 * this.rowStridel;
                l12 = i * this.sliceStridel + l2 * this.rowStridel;
                doubleLargeArray.setDouble(l13, 0.5 * (doubleLargeArray.getDouble(l12) - doubleLargeArray.getDouble(l13)));
                doubleLargeArray.setDouble(l12, doubleLargeArray.getDouble(l12) - doubleLargeArray.getDouble(l13));
                doubleLargeArray.setDouble(l13 + 1L, 0.5 * (doubleLargeArray.getDouble(l12 + 1L) + doubleLargeArray.getDouble(l13 + 1L)));
                doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray.getDouble(l12 + 1L) - doubleLargeArray.getDouble(l13 + 1L));
                for (l11 = 1L; l11 < l2; ++l11) {
                    l10 = this.rowsl - l11;
                    l15 = l16 * this.sliceStridel + l10 * this.rowStridel;
                    l14 = i * this.sliceStridel + l11 * this.rowStridel;
                    doubleLargeArray.setDouble(l15, 0.5 * (doubleLargeArray.getDouble(l14) - doubleLargeArray.getDouble(l15)));
                    doubleLargeArray.setDouble(l14, doubleLargeArray.getDouble(l14) - doubleLargeArray.getDouble(l15));
                    doubleLargeArray.setDouble(l15 + 1L, 0.5 * (doubleLargeArray.getDouble(l14 + 1L) + doubleLargeArray.getDouble(l15 + 1L)));
                    doubleLargeArray.setDouble(l14 + 1L, doubleLargeArray.getDouble(l14 + 1L) - doubleLargeArray.getDouble(l15 + 1L));
                    l13 = i * this.sliceStridel + l10 * this.rowStridel;
                    l12 = l16 * this.sliceStridel + l11 * this.rowStridel;
                    doubleLargeArray.setDouble(l13, 0.5 * (doubleLargeArray.getDouble(l12) - doubleLargeArray.getDouble(l13)));
                    doubleLargeArray.setDouble(l12, doubleLargeArray.getDouble(l12) - doubleLargeArray.getDouble(l13));
                    doubleLargeArray.setDouble(l13 + 1L, 0.5 * (doubleLargeArray.getDouble(l12 + 1L) + doubleLargeArray.getDouble(l13 + 1L)));
                    doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray.getDouble(l12 + 1L) - doubleLargeArray.getDouble(l13 + 1L));
                }
            }
            for (l11 = 1L; l11 < l2; ++l11) {
                l10 = this.rowsl - l11;
                l15 = l10 * this.rowStridel;
                l14 = l11 * this.rowStridel;
                doubleLargeArray.setDouble(l15, 0.5 * (doubleLargeArray.getDouble(l14) - doubleLargeArray.getDouble(l15)));
                doubleLargeArray.setDouble(l14, doubleLargeArray.getDouble(l14) - doubleLargeArray.getDouble(l15));
                doubleLargeArray.setDouble(l15 + 1L, 0.5 * (doubleLargeArray.getDouble(l14 + 1L) + doubleLargeArray.getDouble(l15 + 1L)));
                doubleLargeArray.setDouble(l14 + 1L, doubleLargeArray.getDouble(l14 + 1L) - doubleLargeArray.getDouble(l15 + 1L));
                l13 = l * this.sliceStridel + l10 * this.rowStridel;
                l12 = l * this.sliceStridel + l11 * this.rowStridel;
                doubleLargeArray.setDouble(l13, 0.5 * (doubleLargeArray.getDouble(l12) - doubleLargeArray.getDouble(l13)));
                doubleLargeArray.setDouble(l12, doubleLargeArray.getDouble(l12) - doubleLargeArray.getDouble(l13));
                doubleLargeArray.setDouble(l13 + 1L, 0.5 * (doubleLargeArray.getDouble(l12 + 1L) + doubleLargeArray.getDouble(l13 + 1L)));
                doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray.getDouble(l12 + 1L) - doubleLargeArray.getDouble(l13 + 1L));
            }
        }
    }

    private void rdft3d_sub(int n, double[][][] dArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            double d;
            for (int i = 1; i < n2; ++i) {
                int n6 = this.slices - i;
                d = dArray[i][0][0] - dArray[n6][0][0];
                double[] dArray2 = dArray[i][0];
                dArray2[0] = dArray2[0] + dArray[n6][0][0];
                dArray[n6][0][0] = d;
                d = dArray[n6][0][1] - dArray[i][0][1];
                double[] dArray3 = dArray[i][0];
                dArray3[1] = dArray3[1] + dArray[n6][0][1];
                dArray[n6][0][1] = d;
                d = dArray[i][n3][0] - dArray[n6][n3][0];
                double[] dArray4 = dArray[i][n3];
                dArray4[0] = dArray4[0] + dArray[n6][n3][0];
                dArray[n6][n3][0] = d;
                d = dArray[n6][n3][1] - dArray[i][n3][1];
                double[] dArray5 = dArray[i][n3];
                dArray5[1] = dArray5[1] + dArray[n6][n3][1];
                dArray[n6][n3][1] = d;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    d = dArray[i][n5][0] - dArray[n6][n4][0];
                    double[] dArray6 = dArray[i][n5];
                    dArray6[0] = dArray6[0] + dArray[n6][n4][0];
                    dArray[n6][n4][0] = d;
                    d = dArray[n6][n4][1] - dArray[i][n5][1];
                    double[] dArray7 = dArray[i][n5];
                    dArray7[1] = dArray7[1] + dArray[n6][n4][1];
                    dArray[n6][n4][1] = d;
                    d = dArray[n6][n5][0] - dArray[i][n4][0];
                    double[] dArray8 = dArray[n6][n5];
                    dArray8[0] = dArray8[0] + dArray[i][n4][0];
                    dArray[i][n4][0] = d;
                    d = dArray[i][n4][1] - dArray[n6][n5][1];
                    double[] dArray9 = dArray[n6][n5];
                    dArray9[1] = dArray9[1] + dArray[i][n4][1];
                    dArray[i][n4][1] = d;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                d = dArray[0][n5][0] - dArray[0][n4][0];
                double[] dArray10 = dArray[0][n5];
                dArray10[0] = dArray10[0] + dArray[0][n4][0];
                dArray[0][n4][0] = d;
                d = dArray[0][n4][1] - dArray[0][n5][1];
                double[] dArray11 = dArray[0][n5];
                dArray11[1] = dArray11[1] + dArray[0][n4][1];
                dArray[0][n4][1] = d;
                d = dArray[n2][n5][0] - dArray[n2][n4][0];
                double[] dArray12 = dArray[n2][n5];
                dArray12[0] = dArray12[0] + dArray[n2][n4][0];
                dArray[n2][n4][0] = d;
                d = dArray[n2][n4][1] - dArray[n2][n5][1];
                double[] dArray13 = dArray[n2][n5];
                dArray13[1] = dArray13[1] + dArray[n2][n4][1];
                dArray[n2][n4][1] = d;
            }
        } else {
            int n7;
            int n8;
            for (int i = 1; i < n2; ++i) {
                int n9 = this.slices - i;
                dArray[n9][0][0] = 0.5 * (dArray[i][0][0] - dArray[n9][0][0]);
                double[] dArray14 = dArray[i][0];
                dArray14[0] = dArray14[0] - dArray[n9][0][0];
                dArray[n9][0][1] = 0.5 * (dArray[i][0][1] + dArray[n9][0][1]);
                double[] dArray15 = dArray[i][0];
                dArray15[1] = dArray15[1] - dArray[n9][0][1];
                dArray[n9][n3][0] = 0.5 * (dArray[i][n3][0] - dArray[n9][n3][0]);
                double[] dArray16 = dArray[i][n3];
                dArray16[0] = dArray16[0] - dArray[n9][n3][0];
                dArray[n9][n3][1] = 0.5 * (dArray[i][n3][1] + dArray[n9][n3][1]);
                double[] dArray17 = dArray[i][n3];
                dArray17[1] = dArray17[1] - dArray[n9][n3][1];
                for (n8 = 1; n8 < n3; ++n8) {
                    n7 = this.rows - n8;
                    dArray[n9][n7][0] = 0.5 * (dArray[i][n8][0] - dArray[n9][n7][0]);
                    double[] dArray18 = dArray[i][n8];
                    dArray18[0] = dArray18[0] - dArray[n9][n7][0];
                    dArray[n9][n7][1] = 0.5 * (dArray[i][n8][1] + dArray[n9][n7][1]);
                    double[] dArray19 = dArray[i][n8];
                    dArray19[1] = dArray19[1] - dArray[n9][n7][1];
                    dArray[i][n7][0] = 0.5 * (dArray[n9][n8][0] - dArray[i][n7][0]);
                    double[] dArray20 = dArray[n9][n8];
                    dArray20[0] = dArray20[0] - dArray[i][n7][0];
                    dArray[i][n7][1] = 0.5 * (dArray[n9][n8][1] + dArray[i][n7][1]);
                    double[] dArray21 = dArray[n9][n8];
                    dArray21[1] = dArray21[1] - dArray[i][n7][1];
                }
            }
            for (n8 = 1; n8 < n3; ++n8) {
                n7 = this.rows - n8;
                dArray[0][n7][0] = 0.5 * (dArray[0][n8][0] - dArray[0][n7][0]);
                double[] dArray22 = dArray[0][n8];
                dArray22[0] = dArray22[0] - dArray[0][n7][0];
                dArray[0][n7][1] = 0.5 * (dArray[0][n8][1] + dArray[0][n7][1]);
                double[] dArray23 = dArray[0][n8];
                dArray23[1] = dArray23[1] - dArray[0][n7][1];
                dArray[n2][n7][0] = 0.5 * (dArray[n2][n8][0] - dArray[n2][n7][0]);
                double[] dArray24 = dArray[n2][n8];
                dArray24[0] = dArray24[0] - dArray[n2][n7][0];
                dArray[n2][n7][1] = 0.5 * (dArray[n2][n8][1] + dArray[n2][n7][1]);
                double[] dArray25 = dArray[n2][n8];
                dArray25[1] = dArray25[1] - dArray[n2][n7][1];
            }
        }
    }

    private void fillSymmetric(final double[][][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        final int n5 = 2 * this.columns;
        final int n6 = this.rows / 2;
        int n7 = this.slices / 2;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.useThreads && this.slices >= n8) {
            Future[] futureArray = new Future[n8];
            n4 = this.slices / n8;
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n4 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                int n22 = (DoubleFFT_3D.this.rows - j) % DoubleFFT_3D.this.rows;
                                for (int k = 1; k < DoubleFFT_3D.this.columns; k += 2) {
                                    int n3 = n5 - k;
                                    dArray[n4][n22][n3] = -dArray[i][j][k + 2];
                                    dArray[n4][n22][n3 - 1] = dArray[i][j][k + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                dArray[n3][j][((DoubleFFT_3D)DoubleFFT_3D.this).columns] = dArray[i][n22][1];
                                dArray[i][n22][((DoubleFFT_3D)DoubleFFT_3D.this).columns] = dArray[i][n22][1];
                                dArray[n3][j][((DoubleFFT_3D)DoubleFFT_3D.this).columns + 1] = -dArray[i][n22][0];
                                dArray[i][n22][((DoubleFFT_3D)DoubleFFT_3D.this).columns + 1] = dArray[i][n22][0];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                dArray[n3][n22][0] = dArray[i][j][0];
                                dArray[n3][n22][1] = -dArray[i][j][1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = (this.rows - n3) % this.rows;
                    for (n = 1; n < this.columns; n += 2) {
                        int n10 = n5 - n;
                        dArray[n4][n2][n10] = -dArray[n9][n3][n + 2];
                        dArray[n4][n2][n10 - 1] = dArray[n9][n3][n + 1];
                    }
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    dArray[n4][n3][this.columns] = dArray[n9][n2][1];
                    dArray[n9][n2][this.columns] = dArray[n9][n2][1];
                    dArray[n4][n3][this.columns + 1] = -dArray[n9][n2][0];
                    dArray[n9][n2][this.columns + 1] = dArray[n9][n2][0];
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    dArray[n4][n2][0] = dArray[n9][n3][0];
                    dArray[n4][n2][1] = -dArray[n9][n3][1];
                }
            }
        }
        for (int i = 1; i < n7; ++i) {
            n4 = this.slices - i;
            dArray[i][0][this.columns] = dArray[n4][0][1];
            dArray[n4][0][this.columns] = dArray[n4][0][1];
            dArray[i][0][this.columns + 1] = -dArray[n4][0][0];
            dArray[n4][0][this.columns + 1] = dArray[n4][0][0];
            dArray[i][n6][this.columns] = dArray[n4][n6][1];
            dArray[n4][n6][this.columns] = dArray[n4][n6][1];
            dArray[i][n6][this.columns + 1] = -dArray[n4][n6][0];
            dArray[n4][n6][this.columns + 1] = dArray[n4][n6][0];
            dArray[n4][0][0] = dArray[i][0][0];
            dArray[n4][0][1] = -dArray[i][0][1];
            dArray[n4][n6][0] = dArray[i][n6][0];
            dArray[n4][n6][1] = -dArray[i][n6][1];
        }
        dArray[0][0][this.columns] = dArray[0][0][1];
        dArray[0][0][1] = 0.0;
        dArray[0][n6][this.columns] = dArray[0][n6][1];
        dArray[0][n6][1] = 0.0;
        dArray[n7][0][this.columns] = dArray[n7][0][1];
        dArray[n7][0][1] = 0.0;
        dArray[n7][n6][this.columns] = dArray[n7][n6][1];
        dArray[n7][n6][1] = 0.0;
        dArray[n7][0][this.columns + 1] = 0.0;
        dArray[n7][n6][this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        final int n11 = 2 * this.columns;
        final int n12 = this.rows / 2;
        int n13 = this.slices / 2;
        final int n14 = this.rows * n11;
        final int n15 = n11;
        for (n10 = this.slices - 1; n10 >= 1; --n10) {
            n9 = n10 * this.sliceStride;
            n8 = 2 * n9;
            for (n7 = 0; n7 < this.rows; ++n7) {
                n6 = n7 * this.rowStride;
                n5 = 2 * n6;
                for (n4 = 0; n4 < this.columns; n4 += 2) {
                    n3 = n9 + n6 + n4;
                    n2 = n8 + n5 + n4;
                    dArray[n2] = dArray[n3];
                    dArray[n3] = 0.0;
                    dArray[++n2] = dArray[++n3];
                    dArray[n3] = 0.0;
                }
            }
        }
        for (n10 = 1; n10 < this.rows; ++n10) {
            n9 = (this.rows - n10) * this.rowStride;
            n8 = (this.rows - n10) * n15;
            for (n7 = 0; n7 < this.columns; n7 += 2) {
                n3 = n9 + n7;
                n2 = n8 + n7;
                dArray[n2] = dArray[n3];
                dArray[n3] = 0.0;
                dArray[++n2] = dArray[++n3];
                dArray[n3] = 0.0;
            }
        }
        n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.useThreads && this.slices >= n10) {
            int n16;
            int n17;
            Future[] futureArray = new Future[n10];
            n4 = this.slices / n10;
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                int n3 = (DoubleFFT_3D.this.rows - j) % DoubleFFT_3D.this.rows * n15;
                                int n4 = j * n15;
                                for (int k = 1; k < DoubleFFT_3D.this.columns; k += 2) {
                                    int n5 = n + n3 + n11 - k;
                                    int n6 = n2 + n4 + k;
                                    dArray[n5] = -dArray[n6 + 2];
                                    dArray[n5 - 1] = dArray[n6 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n2 + (DoubleFFT_3D.this.rows - j) * n15;
                                int n4 = n + j * n15 + DoubleFFT_3D.this.columns;
                                int n5 = n3 + DoubleFFT_3D.this.columns;
                                int n6 = n3 + 1;
                                dArray[n4] = dArray[n6];
                                dArray[n5] = dArray[n6];
                                dArray[n4 + 1] = -dArray[n3];
                                dArray[n5 + 1] = dArray[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n + (DoubleFFT_3D.this.rows - j) * n15;
                                int n4 = n2 + j * n15;
                                dArray[n3] = dArray[n4];
                                dArray[n3 + 1] = -dArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n6 = n7 * n14;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n8 = (this.rows - n4) % this.rows * n15;
                    n5 = n4 * n15;
                    for (n = 1; n < this.columns; n += 2) {
                        n3 = n9 + n8 + n11 - n;
                        n2 = n6 + n5 + n;
                        dArray[n3] = -dArray[n2 + 2];
                        dArray[n3 - 1] = dArray[n2 + 1];
                    }
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n6 = (this.slices - n7) % this.slices * n14;
                n5 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n8 = n5 + (this.rows - n4) * n15;
                    n3 = n6 + n4 * n15 + this.columns;
                    n2 = n8 + this.columns;
                    n9 = n8 + 1;
                    dArray[n3] = dArray[n9];
                    dArray[n2] = dArray[n9];
                    dArray[n3 + 1] = -dArray[n8];
                    dArray[n2 + 1] = dArray[n8];
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n8 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n3 = n9 + (this.rows - n4) * n15;
                    n2 = n8 + n4 * n15;
                    dArray[n3] = dArray[n2];
                    dArray[n3 + 1] = -dArray[n2 + 1];
                }
            }
        }
        for (int i = 1; i < n13; ++i) {
            n3 = i * n14;
            n2 = (this.slices - i) * n14;
            n9 = n12 * n15;
            n8 = n3 + n9;
            n6 = n2 + n9;
            dArray[n3 + this.columns] = dArray[n2 + 1];
            dArray[n2 + this.columns] = dArray[n2 + 1];
            dArray[n3 + this.columns + 1] = -dArray[n2];
            dArray[n2 + this.columns + 1] = dArray[n2];
            dArray[n8 + this.columns] = dArray[n6 + 1];
            dArray[n6 + this.columns] = dArray[n6 + 1];
            dArray[n8 + this.columns + 1] = -dArray[n6];
            dArray[n6 + this.columns + 1] = dArray[n6];
            dArray[n2] = dArray[n3];
            dArray[n2 + 1] = -dArray[n3 + 1];
            dArray[n6] = dArray[n8];
            dArray[n6 + 1] = -dArray[n8 + 1];
        }
        dArray[this.columns] = dArray[1];
        dArray[1] = 0.0;
        n3 = n12 * n15;
        n2 = n13 * n14;
        n9 = n3 + n2;
        dArray[n3 + this.columns] = dArray[n3 + 1];
        dArray[n3 + 1] = 0.0;
        dArray[n2 + this.columns] = dArray[n2 + 1];
        dArray[n2 + 1] = 0.0;
        dArray[n9 + this.columns] = dArray[n9 + 1];
        dArray[n9 + 1] = 0.0;
        dArray[n2 + this.columns + 1] = 0.0;
        dArray[n9 + this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final DoubleLargeArray doubleLargeArray) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        final long l10 = 2L * this.columnsl;
        final long l11 = this.rowsl / 2L;
        long l12 = this.slicesl / 2L;
        final long l13 = this.rowsl * l10;
        final long l14 = l10;
        for (l9 = this.slicesl - 1L; l9 >= 1L; --l9) {
            l8 = l9 * this.sliceStridel;
            l7 = 2L * l8;
            for (l6 = 0L; l6 < this.rowsl; ++l6) {
                l5 = l6 * this.rowStridel;
                l4 = 2L * l5;
                for (long i = 0L; i < this.columnsl; i += 2L) {
                    l3 = l8 + l5 + i;
                    l2 = l7 + l4 + i;
                    doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l3));
                    doubleLargeArray.setDouble(l3, 0.0);
                    doubleLargeArray.setDouble(++l2, doubleLargeArray.getDouble(++l3));
                    doubleLargeArray.setDouble(l3, 0.0);
                }
            }
        }
        for (l9 = 1L; l9 < this.rowsl; ++l9) {
            l8 = (this.rowsl - l9) * this.rowStridel;
            l7 = (this.rowsl - l9) * l14;
            for (l6 = 0L; l6 < this.columnsl; l6 += 2L) {
                l3 = l8 + l6;
                l2 = l7 + l6;
                doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l3));
                doubleLargeArray.setDouble(l3, 0.0);
                doubleLargeArray.setDouble(++l2, doubleLargeArray.getDouble(++l3));
                doubleLargeArray.setDouble(l3, 0.0);
            }
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && this.slicesl >= (long)n) {
            long l15;
            int n2;
            Future[] futureArray = new Future[n];
            l6 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l = (long)n2 * l6;
                l15 = n2 == n - 1 ? this.slicesl : l + l6;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l; i < l15; ++i) {
                            long l7 = (DoubleFFT_3D.this.slicesl - i) % DoubleFFT_3D.this.slicesl * l13;
                            long l2 = i * l13;
                            for (long j = 0L; j < DoubleFFT_3D.this.rowsl; ++j) {
                                long l3 = (DoubleFFT_3D.this.rowsl - j) % DoubleFFT_3D.this.rowsl * l14;
                                long l4 = j * l14;
                                for (long k = 1L; k < DoubleFFT_3D.this.columnsl; k += 2L) {
                                    long l5 = l7 + l3 + l10 - k;
                                    long l6 = l2 + l4 + k;
                                    doubleLargeArray.setDouble(l5, -doubleLargeArray.getDouble(l6 + 2L));
                                    doubleLargeArray.setDouble(l5 - 1L, doubleLargeArray.getDouble(l6 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l = (long)n2 * l6;
                l15 = n2 == n - 1 ? this.slicesl : l + l6;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l; i < l15; ++i) {
                            long l7 = (DoubleFFT_3D.this.slicesl - i) % DoubleFFT_3D.this.slicesl * l13;
                            long l2 = i * l13;
                            for (long j = 1L; j < l11; ++j) {
                                long l3 = l2 + (DoubleFFT_3D.this.rowsl - j) * l14;
                                long l4 = l7 + j * l14 + DoubleFFT_3D.this.columnsl;
                                long l5 = l3 + DoubleFFT_3D.this.columnsl;
                                long l6 = l3 + 1L;
                                doubleLargeArray.setDouble(l4, doubleLargeArray.getDouble(l6));
                                doubleLargeArray.setDouble(l5, doubleLargeArray.getDouble(l6));
                                doubleLargeArray.setDouble(l4 + 1L, -doubleLargeArray.getDouble(l3));
                                doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray.getDouble(l3));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l = (long)n2 * l6;
                l15 = n2 == n - 1 ? this.slicesl : l + l6;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l; i < l15; ++i) {
                            long l5 = (DoubleFFT_3D.this.slicesl - i) % DoubleFFT_3D.this.slicesl * l13;
                            long l2 = i * l13;
                            for (long j = 1L; j < l11; ++j) {
                                long l3 = l5 + (DoubleFFT_3D.this.rowsl - j) * l14;
                                long l4 = l2 + j * l14;
                                doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l4));
                                doubleLargeArray.setDouble(l3 + 1L, -doubleLargeArray.getDouble(l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l16;
            long l17;
            for (l17 = 0L; l17 < this.slicesl; ++l17) {
                l8 = (this.slicesl - l17) % this.slicesl * l13;
                l5 = l17 * l13;
                for (l16 = 0L; l16 < this.rowsl; ++l16) {
                    l7 = (this.rowsl - l16) % this.rowsl * l14;
                    l4 = l16 * l14;
                    for (l = 1L; l < this.columnsl; l += 2L) {
                        l3 = l8 + l7 + l10 - l;
                        l2 = l5 + l4 + l;
                        doubleLargeArray.setDouble(l3, -doubleLargeArray.getDouble(l2 + 2L));
                        doubleLargeArray.setDouble(l3 - 1L, doubleLargeArray.getDouble(l2 + 1L));
                    }
                }
            }
            for (l17 = 0L; l17 < this.slicesl; ++l17) {
                l5 = (this.slicesl - l17) % this.slicesl * l13;
                l4 = l17 * l13;
                for (l16 = 1L; l16 < l11; ++l16) {
                    l7 = l4 + (this.rowsl - l16) * l14;
                    l3 = l5 + l16 * l14 + this.columnsl;
                    l2 = l7 + this.columnsl;
                    l8 = l7 + 1L;
                    doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l8));
                    doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l8));
                    doubleLargeArray.setDouble(l3 + 1L, -doubleLargeArray.getDouble(l7));
                    doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray.getDouble(l7));
                }
            }
            for (l17 = 0L; l17 < this.slicesl; ++l17) {
                l8 = (this.slicesl - l17) % this.slicesl * l13;
                l7 = l17 * l13;
                for (l16 = 1L; l16 < l11; ++l16) {
                    l3 = l8 + (this.rowsl - l16) * l14;
                    l2 = l7 + l16 * l14;
                    doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l2));
                    doubleLargeArray.setDouble(l3 + 1L, -doubleLargeArray.getDouble(l2 + 1L));
                }
            }
        }
        for (long i = 1L; i < l12; ++i) {
            l3 = i * l13;
            l2 = (this.slicesl - i) * l13;
            l8 = l11 * l14;
            l7 = l3 + l8;
            l5 = l2 + l8;
            doubleLargeArray.setDouble(l3 + this.columnsl, doubleLargeArray.getDouble(l2 + 1L));
            doubleLargeArray.setDouble(l2 + this.columnsl, doubleLargeArray.getDouble(l2 + 1L));
            doubleLargeArray.setDouble(l3 + this.columnsl + 1L, -doubleLargeArray.getDouble(l2));
            doubleLargeArray.setDouble(l2 + this.columnsl + 1L, doubleLargeArray.getDouble(l2));
            doubleLargeArray.setDouble(l7 + this.columnsl, doubleLargeArray.getDouble(l5 + 1L));
            doubleLargeArray.setDouble(l5 + this.columnsl, doubleLargeArray.getDouble(l5 + 1L));
            doubleLargeArray.setDouble(l7 + this.columnsl + 1L, -doubleLargeArray.getDouble(l5));
            doubleLargeArray.setDouble(l5 + this.columnsl + 1L, doubleLargeArray.getDouble(l5));
            doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l3));
            doubleLargeArray.setDouble(l2 + 1L, -doubleLargeArray.getDouble(l3 + 1L));
            doubleLargeArray.setDouble(l5, doubleLargeArray.getDouble(l7));
            doubleLargeArray.setDouble(l5 + 1L, -doubleLargeArray.getDouble(l7 + 1L));
        }
        doubleLargeArray.setDouble(this.columnsl, doubleLargeArray.getDouble(1L));
        doubleLargeArray.setDouble(1L, 0.0);
        l3 = l11 * l14;
        l2 = l12 * l13;
        l8 = l3 + l2;
        doubleLargeArray.setDouble(l3 + this.columnsl, doubleLargeArray.getDouble(l3 + 1L));
        doubleLargeArray.setDouble(l3 + 1L, 0.0);
        doubleLargeArray.setDouble(l2 + this.columnsl, doubleLargeArray.getDouble(l2 + 1L));
        doubleLargeArray.setDouble(l2 + 1L, 0.0);
        doubleLargeArray.setDouble(l8 + this.columnsl, doubleLargeArray.getDouble(l8 + 1L));
        doubleLargeArray.setDouble(l8 + 1L, 0.0);
        doubleLargeArray.setDouble(l2 + this.columnsl + 1L, 0.0);
        doubleLargeArray.setDouble(l8 + this.columnsl + 1L, 0.0);
    }
}

