/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.IntervalException;
import edu.unc.genomics.Strand;
import java.io.Serializable;

public class Interval
implements Serializable {
    private static final long serialVersionUID = 7515817773660876485L;
    private String chr;
    private int start;
    private int stop;
    private String id;

    public Interval(String chr, int start, int stop) {
        this(chr, start, stop, null);
    }

    public Interval(String chr, int start, int stop, String id) {
        this.chr = chr;
        this.start = start;
        this.stop = stop;
        this.id = id;
    }

    public static Interval parse(String s) throws IntervalException {
        int colon = s.indexOf(58);
        if (colon == -1) {
            throw new IntervalException("Cannot parse invalid interval string " + s);
        }
        int dash = s.indexOf(45);
        if (dash == -1) {
            throw new IntervalException("Cannot parse invalid interval string " + s);
        }
        try {
            String chr = s.substring(0, colon);
            int start = Integer.parseInt(s.substring(colon + 1, dash).replaceAll(",", ""));
            int stop = Integer.parseInt(s.substring(dash + 1).replaceAll(",", ""));
            return new Interval(chr, start, stop);
        }
        catch (NumberFormatException e) {
            throw new IntervalException("Cannot parse invalid interval string " + s);
        }
    }

    public String toBed() {
        String idStr = this.id == null ? "." : this.id;
        return this.chr + "\t" + (this.low() - 1) + "\t" + this.high() + "\t" + idStr + "\t.\t" + (Object)((Object)this.strand());
    }

    public String toBedGraph() {
        return this.chr + "\t" + (this.low() - 1) + "\t" + this.high();
    }

    public String toGFF() {
        String idStr = this.id == null ? "no_id" : this.id;
        return this.chr + "\tSpotArray\tfeature\t" + this.low() + "\t" + this.high() + "\t.\t" + (Object)((Object)this.strand()) + "\t.\tprobe_id=" + idStr + ";count=1";
    }

    public String toOutput() {
        return this.toString();
    }

    public final int center() {
        return (this.start + this.stop) / 2;
    }

    public final int length() {
        return Math.abs(this.stop - this.start) + 1;
    }

    public final boolean includes(String chr, int bp) {
        return this.chr.equals(chr) && this.includes(bp);
    }

    public final boolean includes(int bp) {
        return this.low() <= bp && bp <= this.high();
    }

    public final int low() {
        return Math.min(this.start, this.stop);
    }

    public final int high() {
        return Math.max(this.start, this.stop);
    }

    public final boolean isWatson() {
        return this.stop >= this.start;
    }

    public final boolean isCrick() {
        return !this.isWatson();
    }

    public final Strand strand() {
        return this.isWatson() ? Strand.WATSON : Strand.CRICK;
    }

    public final Interval intersection(Interval other) {
        int high;
        if (other == null || !this.chr.equals(other.chr)) {
            return null;
        }
        int low = Math.max(this.low(), other.low());
        if (low > (high = Math.min(this.high(), other.high()))) {
            return null;
        }
        return new Interval(this.chr, low, high);
    }

    public final Interval union(Interval other) throws IntervalException {
        if (other == null) {
            return new Interval(this.chr, this.low(), this.high());
        }
        if (!this.chr.equals(other.chr)) {
            throw new IntervalException("Cannot union intervals with different chromosomes (" + this.chr + ", " + other.chr + ")");
        }
        int low = Math.min(this.low(), other.low());
        int high = Math.max(this.high(), other.high());
        return new Interval(this.chr, low, high);
    }

    public final String toString() {
        return this.chr + ":" + this.start + "-" + this.stop;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chr == null ? 0 : this.chr.hashCode());
        result = 31 * result + this.start;
        result = 31 * result + this.stop;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.chr == null ? other.chr != null : !this.chr.equals(other.chr)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.stop == other.stop;
    }

    public final String getChr() {
        return this.chr;
    }

    public final void setChr(String chr) {
        this.chr = chr;
    }

    public final int getStart() {
        return this.start;
    }

    public final void setStart(int start) {
        this.start = start;
    }

    public final int getStop() {
        return this.stop;
    }

    public final void setStop(int stop) {
        this.stop = stop;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }
}

