/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFileFormatException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VCFEntry
extends Interval {
    private static final long serialVersionUID = 6831019853585975440L;
    private String ref;
    private String[] alt = null;
    private Double qual = null;
    private String filter;
    private Map<String, String> info = new LinkedHashMap<String, String>();
    private String[] format;
    private List<String[]> genotypes = new ArrayList<String[]>();

    public VCFEntry(String chr, int pos, String id) {
        super(chr, pos, pos, id);
    }

    public static VCFEntry parse(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        String[] entry = line.split("\t");
        if (entry.length < 8) {
            throw new IntervalFileFormatException("Invalid VCF entry has < 8 columns");
        }
        String chr = entry[0];
        int pos = Integer.parseInt(entry[1]);
        String id = entry[2];
        VCFEntry vcf = new VCFEntry(chr, pos, id);
        vcf.setRef(entry[3]);
        if (!entry[4].equalsIgnoreCase(".")) {
            vcf.setAlt(entry[4].split(","));
        }
        if (!entry[5].equalsIgnoreCase(".")) {
            vcf.setQual(Double.parseDouble(entry[5]));
        }
        vcf.setFilter(entry[6]);
        for (String token : entry[7].split(";")) {
            String[] keypair = token.split("=");
            if (keypair.length == 1) {
                vcf.addInfo(keypair[0], null);
                continue;
            }
            if (keypair.length == 2) {
                vcf.addInfo(keypair[0], keypair[1]);
                continue;
            }
            throw new IntervalFileFormatException("Invalid key-value pair (" + token + ") in info string (" + entry[7] + ") in VCF file!");
        }
        if (entry.length > 8) {
            vcf.setFormat(entry[8].split(":"));
            for (int i = 9; i < entry.length; ++i) {
                vcf.addGenotype(entry[i].split(":"));
            }
        }
        return vcf;
    }

    @Override
    public String toOutput() {
        return this.toVCF();
    }

    public String toVCF() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChr()).append('\t').append(this.getStart()).append('\t').append(this.getId());
        sb.append('\t').append(this.ref).append('\t').append(StringUtils.join((Object[])this.alt, (char)','));
        sb.append('\t').append(this.qual).append('\t').append(this.filter).append('\t').append(this.getInfoString());
        if (this.format != null) {
            sb.append('\t').append(this.getFormatString());
        }
        if (this.genotypes.size() > 0) {
            for (int i = 0; i < this.genotypes.size(); ++i) {
                sb.append('\t').append(StringUtils.join((Object[])this.genotypes.get(i), (char)':'));
            }
        }
        return sb.toString();
    }

    public final String getRef() {
        return this.ref;
    }

    public final void setRef(String ref) {
        this.ref = ref;
    }

    public final String[] getAlt() {
        return this.alt;
    }

    public final void setAlt(String[] alt) {
        this.alt = alt;
    }

    public final Double getQual() {
        return this.qual;
    }

    public final void setQual(Double qual) {
        this.qual = qual;
    }

    public final String getFilter() {
        return this.filter;
    }

    public final void setFilter(String filter) {
        this.filter = filter;
    }

    public final Map<String, String> getInfo() {
        return this.info;
    }

    public final String getInfoString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String key : this.info.keySet()) {
            sb.append(key);
            if (this.info.get(key) != null) {
                sb.append('=').append(this.info.get(key));
            }
            if (++i >= this.info.size()) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public final void addInfo(String key, String value) {
        this.info.put(key, value);
    }

    public final String[] getFormat() {
        return this.format;
    }

    public final String getFormatString() {
        return StringUtils.join((Object[])this.format, (String)":");
    }

    public final void setFormat(String[] format) {
        this.format = format;
    }

    public final List<String[]> getGenotypes() {
        return this.genotypes;
    }

    public final void addGenotype(String[] genotype) {
        this.genotypes.add(genotype);
    }
}

