/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.SAMEntry;
import edu.unc.genomics.io.IntervalFileFormatException;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.SAMEntryIterator;
import edu.unc.genomics.util.Samtools;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;

public class BAMFileReader
extends IntervalFileReader<SAMEntry> {
    private static final Logger log = Logger.getLogger(BAMFileReader.class);
    private Set<String> chromosomes;
    private SAMFileReader reader;
    private Path index;
    private SAMRecordIterator it;
    private boolean allowUnmappedReads = true;

    public BAMFileReader(Path p) {
        super(p);
        log.debug((Object)("Opening BAM file reader " + p));
        this.reader = new SAMFileReader(p.toFile());
        if (!this.reader.hasIndex()) {
            try {
                this.index = Files.createTempFile(p.getFileName().toString(), ".bai", new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Error creating temporary BAM index for: " + p.getFileName()));
                e.printStackTrace();
                throw new RuntimeException("Error creating temporary BAM index for: " + p.getFileName());
            }
            this.index.toFile().deleteOnExit();
            Samtools.indexBAMFile(p, this.index);
            this.reader = new SAMFileReader(p.toFile(), this.index.toFile());
            if (!this.reader.hasIndex()) {
                throw new IntervalFileFormatException("Error indexing BAM file: " + p);
            }
        }
        this.reader.enableIndexMemoryMapping(false);
        this.reader.enableIndexCaching(true);
    }

    public BAMFileReader(Path p, boolean allowUnmappedReads) {
        this(p);
        this.allowUnmappedReads = allowUnmappedReads;
    }

    @Override
    public void close() throws IOException {
        log.debug((Object)("Closing BAM file " + this.p));
        this.reader.close();
    }

    @Override
    public int count() {
        int count = 0;
        BAMIndex index = this.reader.getIndex();
        int nRefs = this.reader.getFileHeader().getSequenceDictionary().size();
        for (int i = 0; i < nRefs; ++i) {
            BAMIndexMetaData data = index.getMetaData(i);
            count += data.getAlignedRecordCount();
            count += data.getUnalignedRecordCount();
        }
        return count;
    }

    @Override
    public Set<String> chromosomes() {
        if (this.chromosomes == null) {
            this.chromosomes = new LinkedHashSet<String>();
            SAMSequenceDictionary dict = this.reader.getFileHeader().getSequenceDictionary();
            for (SAMSequenceRecord seqRec : dict.getSequences()) {
                this.chromosomes.add(seqRec.getSequenceName());
            }
        }
        return this.chromosomes;
    }

    @Override
    public Iterator<SAMEntry> iterator() {
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.iterator();
        return new SAMEntryIterator(this.it, this.allowUnmappedReads);
    }

    @Override
    public Iterator<SAMEntry> query(String chr, int start, int stop) {
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.query(chr, start, stop, false);
        return new SAMEntryIterator(this.it, this.allowUnmappedReads);
    }

    public boolean doesAllowUnmappedReads() {
        return this.allowUnmappedReads;
    }

    public void setAllowUnmappedReads(boolean allowUnmappedReads) {
        this.allowUnmappedReads = allowUnmappedReads;
    }
}

