/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.VCFEntry;
import edu.unc.genomics.io.TextIntervalFileReader;
import java.io.IOException;
import java.nio.file.Path;
import net.sf.samtools.TabixWriter;
import org.apache.log4j.Logger;

public class VCFFileReader
extends TextIntervalFileReader<VCFEntry> {
    private static final Logger log = Logger.getLogger(VCFFileReader.class);

    public VCFFileReader(Path p) throws IOException {
        super(p, new VCFEntryFactory());
        log.debug((Object)("Opening VCF file reader " + p));
    }

    public static class VCFEntryFactory
    implements IntervalFactory<VCFEntry> {
        @Override
        public VCFEntry parse(String line) {
            return VCFEntry.parse(line);
        }

        @Override
        public TabixWriter.Conf tabixConf() {
            return TabixWriter.VCF_CONF;
        }
    }
}

