/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.mg4j.index.cluster.LexicalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.LexicalPartitioningStrategy;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.Properties;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ContiguousLexicalStrategy
implements LexicalPartitioningStrategy,
LexicalClusteringStrategy {
    static final long serialVersionUID = 0L;
    private final int[] cutPoint;
    private final MutableString[] cutPointTerm;
    private final int k;

    public ContiguousLexicalStrategy(int[] cutPoint, CharSequence[] cutPointTerm) {
        if (cutPoint.length == 0) {
            throw new IllegalArgumentException("Empty cutpoint array");
        }
        if (cutPoint.length != cutPointTerm.length) {
            throw new IllegalArgumentException("The cutpoint array and the term cutpoint array have different lengths (" + cutPoint.length + ", " + cutPointTerm.length + ")");
        }
        if (cutPoint[0] != 0) {
            throw new IllegalArgumentException("The first cutpoint must be 0");
        }
        this.cutPoint = cutPoint;
        this.k = cutPoint.length - 1;
        this.cutPointTerm = new MutableString[this.k + 1];
        for (int i = 0; i < this.k; ++i) {
            this.cutPointTerm[i] = new MutableString(cutPointTerm[i]);
        }
        this.cutPointTerm[this.k] = new MutableString("\uffff");
    }

    public int numberOfLocalIndices() {
        return this.k;
    }

    public int localIndex(int globalNumber) {
        if (globalNumber >= this.cutPoint[this.k]) {
            throw new IndexOutOfBoundsException(Integer.toString(globalNumber));
        }
        int i = this.k;
        while (i-- != 0) {
            if (this.cutPoint[i] > globalNumber) continue;
            return i;
        }
        throw new IndexOutOfBoundsException(Integer.toString(globalNumber));
    }

    public int localIndex(CharSequence term) {
        int i = this.k;
        while (i-- != 0) {
            if (this.cutPointTerm[i].compareTo(term) > 0) continue;
            return i;
        }
        throw new NoSuchElementException(((Object)term).toString());
    }

    public int globalNumber(int localIndex, int localNumber) {
        return localNumber + this.cutPoint[localIndex];
    }

    public int localNumber(int globalNumber) {
        return globalNumber - this.cutPoint[this.localIndex(globalNumber)];
    }

    public Properties[] properties() {
        Properties[] properties = new Properties[this.k];
        for (int i = 0; i < this.k; ++i) {
            properties[i] = new Properties();
            properties[i].addProperty("termfrom", this.cutPointTerm[i]);
            properties[i].addProperty("termto", this.cutPointTerm[i + 1]);
            properties[i].addProperty("termnumberfrom", this.cutPoint[i]);
            properties[i].addProperty("termnumberto", this.cutPoint[i + 1]);
        }
        return properties;
    }

    public String toString() {
        return "{ " + Arrays.toString(this.cutPoint) + ", " + Arrays.toString(this.cutPointTerm) + " }";
    }
}

