/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import cern.colt.Timer;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class IndexOfSpeedTest {
    private IndexOfSpeedTest() {
    }

    public static void main(String[] arg) {
        String target = null;
        MutableString ms = new MutableString();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((line = br.readLine()) != null) {
                ms.append("\n").append(line);
            }
            ms.compact();
            target = ms.toString();
        }
        catch (IOException e) {
            System.err.println("Problems while reading target");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        Timer timer = new Timer();
        String p = arg[0];
        System.err.println("Searching for " + p);
        int k = 10;
        while (k-- != 0) {
            timer.reset();
            timer.start();
            int i = -1;
            int n = 0;
            do {
                i = target.indexOf(p, i + 1);
                ++n;
            } while (i != -1);
            timer.stop();
            System.err.println("Called indexOf() " + n + " times on a string in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
        k = 10;
        MutableString mp = new MutableString(p);
        while (k-- != 0) {
            timer.reset();
            timer.start();
            int i = -1;
            int n = 0;
            do {
                i = ms.indexOf(mp, i + 1);
                ++n;
            } while (i != -1);
            timer.stop();
            System.err.println("Called indexOf() " + n + " times on a mutable string in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
        k = 10;
        String sp = p;
        while (k-- != 0) {
            timer.reset();
            timer.start();
            int i = -1;
            int n = 0;
            do {
                i = ms.indexOf(sp, i + 1);
                ++n;
            } while (i != -1);
            timer.stop();
            System.err.println("Called indexOf() " + n + " times on a char sequence in " + timer.millis() + " ms (" + (double)n * 1000.0 / (double)timer.millis() + " calls/s)");
        }
    }
}

