/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.Char2CharOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.TextPattern;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableStringRegressionTest {
    private static final int MAXINT = 100;
    private static final int MAXSHORT = 10000;
    private static final int MINCHAR = 65;
    private static final int MAXCHAR = 90;
    private static final int SPACE_FREQ = 8;
    private static final int MAXLENGTH = 100;
    private static Method[] sbMethod = StringBuffer.class.getDeclaredMethods();
    private static Method[] msMethod = MutableString.class.getDeclaredMethods();
    private static int[] sbTimes = new int[sbMethod.length];
    private static int[] msTimes = new int[msMethod.length];
    private static int[] sbExc = new int[sbMethod.length];
    private static int[] msExc = new int[msMethod.length];
    private static Random rand;
    private static Map<Class, Set<Class>> alternativeType;
    private static int sbIdx;
    private static int msIdx;
    private static Class[] alternativeParameterType;
    static final int NUMBER_OF_SPECIAL_TESTS = 23;
    static final int NUMBER_OF_TESTS = 100;

    private MutableStringRegressionTest() {
    }

    private static String a2s(Object[] o) {
        String res = "[";
        for (int i = 0; i < o.length; ++i) {
            res = res + (i > 0 ? "," : "") + (o[i] instanceof char[] ? new cern.colt.list.CharArrayList((char[])o[i]).toString() : String.valueOf(o[i]));
        }
        return res + "]";
    }

    private static MutableString s2i(MutableString s) {
        MutableString res = new MutableString().append("[");
        for (int i = 0; i < s.length(); ++i) {
            res.append(i != 0 ? ", " : "").append((int)s.charAt(i));
        }
        return res.append("]");
    }

    private static Iterator possibleComb(final Set[] o) {
        final int n = o.length;
        int c = 1;
        for (int i = 0; i < n; ++i) {
            c *= o[i].size();
        }
        final int m = c;
        return new Iterator(){
            int emitted = 0;
            int nextEmit = MutableStringRegressionTest.access$000().nextInt(m);

            public boolean hasNext() {
                return this.emitted < m;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                if (this.emitted >= m) {
                    throw new NoSuchElementException();
                }
                Object[] res = new Object[n];
                int residual = this.nextEmit;
                for (int i = 0; i < n; ++i) {
                    int j = residual % o[i].size();
                    residual /= o[i].size();
                    Object[] a = o[i].toArray();
                    res[i] = a[j];
                }
                ++this.emitted;
                this.nextEmit = (this.nextEmit + 1) % m;
                return res;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public static Method randomMethod() {
        MutableStringRegressionTest.alternativeParameterType = null;
        block4: while (true) {
            if (!Modifier.isPublic((msm = MutableStringRegressionTest.msMethod[MutableStringRegressionTest.rand.nextInt(MutableStringRegressionTest.msMethod.length)]).getModifiers())) {
                continue;
            }
            for (MutableStringRegressionTest.msIdx = 0; MutableStringRegressionTest.msIdx < MutableStringRegressionTest.msMethod.length && !MutableStringRegressionTest.msMethod[MutableStringRegressionTest.msIdx].equals(msm); ++MutableStringRegressionTest.msIdx) {
            }
            if (MutableStringRegressionTest.msIdx == MutableStringRegressionTest.msMethod.length) {
                System.out.println("I was looking for " + msm);
                System.exit(1);
            }
            try {
                sbm = StringBuffer.class.getDeclaredMethod(msm.getName(), msm.getParameterTypes());
                if (!Modifier.isPublic(sbm.getModifiers())) continue;
                for (MutableStringRegressionTest.sbIdx = 0; MutableStringRegressionTest.sbIdx < MutableStringRegressionTest.sbMethod.length && !MutableStringRegressionTest.sbMethod[MutableStringRegressionTest.sbIdx].equals(sbm); ++MutableStringRegressionTest.sbIdx) {
                }
                if (MutableStringRegressionTest.sbIdx == MutableStringRegressionTest.sbMethod.length) {
                    System.out.println("I was looking for " + sbm);
                    System.exit(1);
                }
                return msm;
            }
            catch (NoSuchMethodException e) {
                type = msm.getParameterTypes();
                alternat = new Set[type.length];
                for (i = 0; i < type.length; ++i) {
                    alternat[i] = new HashSet<E>();
                    alternat[i].add(type[i]);
                    if (!MutableStringRegressionTest.alternativeType.containsKey(type[i])) continue;
                    alternat[i].addAll((Collection)MutableStringRegressionTest.alternativeType.get(type[i]));
                }
                it = MutableStringRegressionTest.possibleComb(alternat);
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block4;
                    o = (Object[])it.next();
                    altPar = new Class[o.length];
                    System.arraycopy(o, 0, altPar, 0, o.length);
                    try {
                        sbm = StringBuffer.class.getDeclaredMethod(msm.getName(), altPar);
                        if (Modifier.isPublic(sbm.getModifiers())) break;
                    }
                    catch (NoSuchMethodException e1) {}
                }
                for (MutableStringRegressionTest.sbIdx = 0; MutableStringRegressionTest.sbIdx < MutableStringRegressionTest.sbMethod.length && !MutableStringRegressionTest.sbMethod[MutableStringRegressionTest.sbIdx].equals(sbm); ++MutableStringRegressionTest.sbIdx) {
                }
                if (MutableStringRegressionTest.sbIdx == MutableStringRegressionTest.sbMethod.length) {
                    System.out.println("I was looking for " + sbm);
                    System.exit(1);
                }
                MutableStringRegressionTest.alternativeParameterType = new Class[altPar.length];
                System.arraycopy(altPar, 0, MutableStringRegressionTest.alternativeParameterType, 0, altPar.length);
                return msm;
            }
            break;
        }
    }

    public static Object[] params(Method m) {
        Class<?>[] types = m.getParameterTypes();
        Object[] res = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getName().equals("byte")) {
                res[i] = new Byte((byte)rand.nextInt(256));
                continue;
            }
            if (types[i].getName().equals("char")) {
                res[i] = new Character((char)(65 + rand.nextInt(26)));
                continue;
            }
            if (types[i].getName().equals("double")) {
                res[i] = new Double(rand.nextDouble());
                continue;
            }
            if (types[i].getName().equals("float")) {
                res[i] = new Float(rand.nextFloat());
                continue;
            }
            if (types[i].getName().equals("int")) {
                res[i] = new Integer(rand.nextInt(100));
                continue;
            }
            if (types[i].getName().equals("long")) {
                res[i] = new Long(rand.nextInt(100));
                continue;
            }
            if (types[i].getName().equals("short")) {
                res[i] = new Short((short)rand.nextInt(10000));
                continue;
            }
            if (types[i].getName().equals("boolean")) {
                res[i] = new Boolean(rand.nextBoolean());
                continue;
            }
            if (types[i].getName().equals("[C")) {
                res[i] = MutableStringRegressionTest.generateCharArray();
                continue;
            }
            if (types[i].getName().equals("java.lang.String")) {
                res[i] = MutableStringRegressionTest.generateString();
                continue;
            }
            if (types[i].getName().equals("java.lang.StringBuffer")) {
                res[i] = MutableStringRegressionTest.generateStringBuffer();
                continue;
            }
            if (types[i].getName().equals("java.lang.CharSequence")) {
                res[i] = MutableStringRegressionTest.generateString();
                continue;
            }
            if (types[i].getName().equals("it.unimi.dsi.mg4j.util.MutableString")) {
                res[i] = MutableStringRegressionTest.generateMutableString();
                continue;
            }
            if (types[i].getName().equals("java.lang.Object")) {
                res[i] = new Object();
                continue;
            }
            throw new IllegalArgumentException("Type " + types[i] + " not (yet) implemented");
        }
        return res;
    }

    public static char[] generateCharArray() {
        return MutableStringRegressionTest.generateCharArray(100);
    }

    public static char[] generateCharArray(int m) {
        int n = rand.nextInt(m + 1);
        char[] res = new char[n];
        for (int i = 0; i < n; ++i) {
            res[i] = (char)(rand.nextInt(8) == 0 ? 32 : (char)(65 + rand.nextInt(26)));
        }
        return res;
    }

    public static char[] generateUnicodeCharArray(int n) {
        char[] res = new char[n];
        for (int i = 0; i < n; ++i) {
            while (!Character.isLetterOrDigit(res[i] = (char)rand.nextInt())) {
            }
        }
        return res;
    }

    public static String generateString() {
        return new String(MutableStringRegressionTest.generateCharArray());
    }

    public static StringBuffer generateStringBuffer() {
        return new StringBuffer(new String(MutableStringRegressionTest.generateCharArray()));
    }

    public static MutableString generateMutableString() {
        return new MutableString(MutableStringRegressionTest.generateCharArray());
    }

    public static Object convert(Object o, Class<? extends Object> c1, Class c2) {
        if (c1.equals(c2)) {
            return o;
        }
        if (Number.class.isAssignableFrom(c1)) {
            return o;
        }
        if (c1.equals(MutableString.class)) {
            if (c2.equals(String.class)) {
                return ((MutableString)o).toString();
            }
            if (c2.equals(StringBuffer.class)) {
                return new StringBuffer(((MutableString)o).toString());
            }
        } else if (c1.equals(StringBuffer.class)) {
            if (c2.equals(String.class)) {
                return ((StringBuffer)o).toString();
            }
        } else if (c1.equals(CharSequence.class)) {
            if (c2.equals(String.class)) {
                return ((Object)((CharSequence)o)).toString();
            }
        } else if (c1.equals(Character.class) && c2.equals(String.class)) {
            return o.toString();
        }
        System.err.println("Don't know how to convert " + c1 + " to " + c2);
        System.err.println("(Object to convert is " + o + ")");
        System.exit(1);
        return null;
    }

    public static Object[] convert(Object[] arg) {
        int n = arg.length;
        Object[] res = new Object[n];
        if (alternativeParameterType == null) {
            System.arraycopy(arg, 0, res, 0, n);
            return res;
        }
        assert (n == alternativeParameterType.length);
        for (int i = 0; i < n; ++i) {
            res[i] = MutableStringRegressionTest.convert(arg[i], arg[i].getClass(), alternativeParameterType[i]);
        }
        return res;
    }

    private static void print(String type, String name, CharSequence s) {
        System.out.println(type + " content of " + name + " was");
        System.out.println(s + " [" + s.length() + " chars]");
        System.out.println(CharArrayList.wrap((char[])new MutableString(s).toCharArray()));
        System.out.print("[");
        for (int i = 0; i < s.length(); ++i) {
            System.out.print(s.charAt(i) + (i == 0 ? "" : ", "));
        }
        System.out.println("]");
    }

    private static void print2(String type, String sb, String ms) {
        MutableStringRegressionTest.print(type, "StringBuffer", sb);
        MutableStringRegressionTest.print(type, "MutableString", ms);
    }

    public static void specialTest(StringBuffer sb, MutableString ms) {
        Comparable<Character> msRes = null;
        Object sbRes = null;
        Exception msThrow = null;
        Exception sbThrow = null;
        Method msm = null;
        String ssb = new String(sb.toString());
        String sms = new String(ms.toString());
        boolean compact = ms.isCompact();
        int which = rand.nextInt(23);
        try {
            block79 : switch (which) {
                case 0: {
                    try {
                        ms.toLowerCase();
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sb.setLength(0);
                        sb.append(ssb.toString().toLowerCase());
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("toLowerCase", new Class[0]);
                    break;
                }
                case 1: {
                    try {
                        ms.toUpperCase();
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sb.setLength(0);
                        sb.append(ssb.toString().toUpperCase());
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("toUpperCase", new Class[0]);
                    break;
                }
                case 2: {
                    try {
                        ms.trim();
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sb.setLength(0);
                        sb.append(ssb.toString().trim());
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("trim", new Class[0]);
                    break;
                }
                case 20: {
                    try {
                        ms.trimLeft();
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sb.setLength(0);
                        sb.append((ssb.toString() + "X").trim());
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("trimLeft", new Class[0]);
                    break;
                }
                case 21: {
                    try {
                        ms.trimRight();
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sb.setLength(0);
                        sb.append(("X" + ssb.toString()).trim().substring(1));
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("trimRight", new Class[0]);
                    break;
                }
                case 3: {
                    try {
                        msRes = new Character(ms.lastChar());
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sbRes = new Character(sb.toString().charAt(sb.length() - 1));
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("lastChar", new Class[0]);
                    break;
                }
                case 4: {
                    try {
                        msRes = new Character(ms.firstChar());
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sbRes = new Character(sb.toString().charAt(0));
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("firstChar", new Class[0]);
                    break;
                }
                case 5: {
                    try {
                        ms.loose();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    msm = MutableString.class.getDeclaredMethod("loose", new Class[0]);
                    break;
                }
                case 6: {
                    try {
                        ms.compact();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (ms.capacity() != ms.length()) {
                        System.err.println("After compact, MutableString does not appear to be compact");
                        MutableStringRegressionTest.print("Current", "MutableString", ms);
                        MutableStringRegressionTest.print("Previous", "MutableString", sms);
                        System.err.println("Capacity=" + ms.capacity() + ", length=" + ms.length());
                        System.exit(1);
                    }
                    msm = MutableString.class.getDeclaredMethod("compact", new Class[0]);
                    break;
                }
                case 7: {
                    try {
                        msRes = new cern.colt.list.CharArrayList(ms.array()).partFromTo(0, ms.length() - 1);
                    }
                    catch (Exception e) {
                        msThrow = e;
                    }
                    try {
                        sbRes = new cern.colt.list.CharArrayList(sb.toString().toCharArray());
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    msm = MutableString.class.getDeclaredMethod("array", new Class[0]);
                    break;
                }
                case 8: {
                    char c;
                    int pos;
                    ms.compact();
                    compact = true;
                    char[] a = ms.array();
                    msm = MutableString.class.getDeclaredMethod("changed", new Class[0]);
                    if (sb.length() == 0) break;
                    int changeHowMany = rand.nextInt(sb.length());
                    for (int i = 0; i < changeHowMany; ++i) {
                        pos = rand.nextInt(sb.length());
                        a[pos] = (char)(65 + rand.nextInt(26));
                        c = a[pos];
                        sb.setCharAt(pos, c);
                    }
                    ms.changed();
                    break;
                }
                case 9: {
                    if (ms.isCompact()) {
                        try {
                            ms = MutableString.wrap(ms.array());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        msm = MutableString.class.getDeclaredMethod("wrap", char[].class);
                        break;
                    }
                    try {
                        ms = MutableString.wrap(ms.array(), ms.length());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    msm = MutableString.class.getDeclaredMethod("wrap", char[].class, Integer.TYPE);
                    break;
                }
                case 10: {
                    String s;
                    StringBuffer b;
                    CharSequence o;
                    if (!ms.equals(new MutableString(sb))) {
                        System.err.println("equals(MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(sb));
                        System.exit(1);
                    }
                    if (!ms.equals(new MutableString(ssb.toCharArray()))) {
                        System.err.println("equals(char[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(ssb.toCharArray()));
                        System.exit(1);
                    }
                    if (!ms.equals(sb.toString())) {
                        System.err.println("equals(String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + sb);
                        System.exit(1);
                    }
                    if (!ms.equals(ssb = ssb.intern())) {
                        System.err.println("equals(String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + ssb);
                        System.exit(1);
                    }
                    if (!ms.equals((Object)(o = sb))) {
                        System.err.println("equals(Object=MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(sb));
                        System.exit(1);
                    }
                    if (!ms.equals((Object)(o = sb.toString()))) {
                        System.err.println("equals(Object=String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + sb);
                        System.exit(1);
                    }
                    if (!ms.equals((Object)(o = ssb.intern()))) {
                        System.err.println("equals(Object=String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + ssb);
                        System.exit(1);
                    }
                    if (ms.equals(new MutableString(b = new StringBuffer(sb.toString()).append(' ')))) {
                        System.err.println("! equalsMutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(b));
                        System.exit(1);
                    }
                    if (ms.equals(new MutableString(b.toString().toCharArray()))) {
                        System.err.println("! equalschar[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(b.toString().toCharArray()));
                        System.exit(1);
                    }
                    if (ms.equals(b.toString())) {
                        System.err.println("! equalsString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + b);
                        System.exit(1);
                    }
                    if (ms.equals(s = b.toString().intern())) {
                        System.err.println("! equalsString.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + s);
                        System.exit(1);
                    }
                    if (ms.equals((Object)(o = b))) {
                        System.err.println("! equals(Object=MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + o);
                        System.exit(1);
                    }
                    if (ms.equals((Object)(o = b.toString()))) {
                        System.err.println("! equals(Object=String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + o);
                        System.exit(1);
                    }
                    if (ms.equals((Object)(o = b.toString().intern()))) {
                        System.err.println("! equals(Object=String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + o);
                        System.exit(1);
                    }
                    msm = MutableString.class.getDeclaredMethod("equals", Object.class);
                    break;
                }
                case 11: {
                    StringBuffer b = new StringBuffer(new String(sb).toUpperCase());
                    String s = b.toString();
                    if (!ms.equalsIgnoreCase(new MutableString(b))) {
                        System.err.println("equalsIgnoreCase(MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(b));
                        System.exit(1);
                    }
                    if (!ms.equalsIgnoreCase(new MutableString(s.toCharArray()))) {
                        System.err.println("equalsIgnoreCase(char[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(s.toCharArray()));
                        System.exit(1);
                    }
                    if (!ms.equalsIgnoreCase(s.toString())) {
                        System.err.println("equalsIgnoreCase(String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + s);
                        System.exit(1);
                    }
                    if (!ms.equalsIgnoreCase(ssb = ssb.intern())) {
                        System.err.println("equalsIgnoreCase(String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + ssb);
                        System.exit(1);
                    }
                    if (ms.equalsIgnoreCase(new MutableString(b = new StringBuffer(new String(sb).toUpperCase()).append(' ')))) {
                        System.err.println("! equalsIgnoreCaseMutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(b));
                        System.exit(1);
                    }
                    if (ms.equalsIgnoreCase(new MutableString(b.toString().toCharArray()))) {
                        System.err.println("! equalsIgnoreCasechar[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(b.toString().toCharArray()));
                        System.exit(1);
                    }
                    if (ms.equalsIgnoreCase(b.toString())) {
                        System.err.println("! equalsIgnoreCaseString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + b);
                        System.exit(1);
                    }
                    if (ms.equalsIgnoreCase(s = b.toString().intern())) {
                        System.err.println("! equalsIgnoreCaseString.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + s);
                        System.exit(1);
                    }
                    msm = MutableString.class.getDeclaredMethod("equalsIgnoreCase", MutableString.class);
                    break;
                }
                case 12: {
                    char d;
                    String s;
                    char c;
                    if (0 != ms.compareTo(new MutableString(sb))) {
                        System.err.println("compareTo(MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(sb));
                        System.exit(1);
                    }
                    if (0 != ms.compareTo(new MutableString(ssb.toCharArray()))) {
                        System.err.println("compareTo(char[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(ssb.toCharArray()));
                        System.exit(1);
                    }
                    if (0 != ms.compareTo(sb.toString())) {
                        System.err.println("compareTo(String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + sb);
                        System.exit(1);
                    }
                    if (0 != ms.compareTo(ssb = ssb.intern())) {
                        System.err.println("compareTo(String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + ssb);
                        System.exit(1);
                    }
                    CharSequence o = sb;
                    StringBuffer b = new StringBuffer(sb.toString());
                    if (b.length() == 0) {
                        d = 'A';
                        b.append('A');
                        c = '\u0000';
                    } else {
                        int p = rand.nextInt(b.length());
                        c = b.charAt(p);
                        d = (char)(c + rand.nextInt(2) * 2 - 1);
                    }
                    if (0 < (d - c) * ms.compareTo(new MutableString(b))) {
                        System.err.println("! compareTo(MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(b));
                        System.exit(1);
                    }
                    if (0 < (d - c) * ms.compareTo(new MutableString(b.toString().toCharArray()))) {
                        System.err.println("! compareTo(char[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(b.toString().toCharArray()));
                        System.exit(1);
                    }
                    if (0 < (d - c) * ms.compareTo(b.toString())) {
                        System.err.println("! compareTo(String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + b);
                        System.exit(1);
                    }
                    if (0 < (d - c) * ms.compareTo(s = b.toString().intern())) {
                        System.err.println("! compareTo(String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + s);
                        System.exit(1);
                    }
                    break;
                }
                case 13: {
                    char d;
                    String s;
                    StringBuffer b;
                    char c;
                    if (0 != ms.compareToIgnoreCase(new MutableString(sb))) {
                        System.err.println("compareToIgnoreCase(MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(sb));
                        System.exit(1);
                    }
                    if (0 != ms.compareToIgnoreCase(new MutableString(ssb.toCharArray()))) {
                        System.err.println("compareToIgnoreCase(char[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(ssb.toCharArray()));
                        System.exit(1);
                    }
                    if (0 != ms.compareToIgnoreCase(sb.toString())) {
                        System.err.println("compareToIgnoreCase(String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + sb);
                        System.exit(1);
                    }
                    if (0 != ms.compareToIgnoreCase(ssb = ssb.intern())) {
                        System.err.println("compareToIgnoreCase(String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + ssb);
                        System.exit(1);
                    }
                    if ((b = new StringBuffer(sb.toString())).length() == 0) {
                        d = 'A';
                        b.append('A');
                        c = '\u0000';
                    } else {
                        int p = rand.nextInt(b.length());
                        c = b.charAt(p);
                        d = (char)(c + rand.nextInt(2) * 2 - 1);
                    }
                    if (0 < (d - c) * ms.compareToIgnoreCase(new MutableString(b))) {
                        System.err.println("! compareToIgnoreCase(MutableString) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new MutableString(b));
                        System.exit(1);
                    }
                    if (0 < (d - c) * ms.compareToIgnoreCase(new MutableString(b.toString().toCharArray()))) {
                        System.err.println("! compareToIgnoreCase(char[]) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + new cern.colt.list.CharArrayList(b.toString().toCharArray()));
                        System.exit(1);
                    }
                    if (0 < (d - c) * ms.compareToIgnoreCase(b.toString())) {
                        System.err.println("! compareToIgnoreCase(String) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + b);
                        System.exit(1);
                    }
                    if (0 < (d - c) * ms.compareToIgnoreCase(s = b.toString().intern())) {
                        System.err.println("! compareToIgnoreCase(String.intern()) failed");
                        System.err.println("MutableString is " + ms);
                        System.err.println("Argument is      " + s);
                        System.exit(1);
                    }
                    msm = MutableString.class.getDeclaredMethod("compareToIgnoreCase", MutableString.class);
                    break;
                }
                case 14: {
                    int i;
                    int choice = rand.nextInt(9);
                    int l = choice > 4 ? 1 : rand.nextInt(40);
                    char[] a = new char[l];
                    for (int i2 = 0; i2 < l; ++i2) {
                        a[i2] = (char)(64 + i2);
                    }
                    MutableString[] as = new MutableString[a.length];
                    StringBuffer b = new StringBuffer();
                    for (i = 0; i < a.length; ++i) {
                        as[i] = MutableStringRegressionTest.generateMutableString().length(choice == 3 || choice == 4 || choice == 8 ? 1 : 1 + rand.nextInt(4));
                    }
                    for (i = 0; i < sb.length(); ++i) {
                        int j;
                        for (j = 0; j < a.length; ++j) {
                            if (sb.charAt(i) != a[j]) continue;
                            b.append(as[j]);
                            break;
                        }
                        if (j != a.length) continue;
                        b.append(sb.charAt(i));
                    }
                    sb.setLength(0);
                    sb.append(b);
                    switch (choice) {
                        case 0: {
                            ms.replace(a, as);
                            msm = MutableString.class.getDeclaredMethod("replace", char[].class, MutableString[].class);
                            break block79;
                        }
                        case 1: {
                            String[] badString = new String[as.length];
                            for (int i3 = 0; i3 < as.length; ++i3) {
                                badString[i3] = as[i3].toString();
                            }
                            ms.replace(a, badString);
                            msm = MutableString.class.getDeclaredMethod("replace", char[].class, String[].class);
                            break block79;
                        }
                        case 2: {
                            CharSequence[] badCS = new CharSequence[as.length];
                            for (int i4 = 0; i4 < as.length; ++i4) {
                                badCS[i4] = as[i4];
                            }
                            ms.replace(a, badCS);
                            msm = MutableString.class.getDeclaredMethod("replace", char[].class, CharSequence[].class);
                            break block79;
                        }
                        case 3: {
                            char[] badChar = new char[as.length];
                            for (int i5 = 0; i5 < as.length; ++i5) {
                                badChar[i5] = as[i5].charAt(0);
                            }
                            ms.replace(a, badChar);
                            msm = MutableString.class.getDeclaredMethod("replace", char[].class, char[].class);
                            break block79;
                        }
                        case 4: {
                            Char2CharOpenHashMap m = new Char2CharOpenHashMap();
                            for (int i6 = 0; i6 < as.length; ++i6) {
                                m.put(a[i6], as[i6].charAt(0));
                            }
                            ms.replace((Char2CharMap)m);
                            msm = MutableString.class.getDeclaredMethod("replace", Char2CharMap.class);
                            break block79;
                        }
                        case 5: {
                            ms.replace(a[0], as[0]);
                            msm = MutableString.class.getDeclaredMethod("replace", Character.TYPE, MutableString.class);
                            break block79;
                        }
                        case 6: {
                            String badString1 = as[0].toString();
                            ms.replace(a[0], badString1);
                            msm = MutableString.class.getDeclaredMethod("replace", Character.TYPE, String.class);
                            break block79;
                        }
                        case 7: {
                            MutableString badCS1 = as[0];
                            ms.replace(a[0], (CharSequence)badCS1);
                            msm = MutableString.class.getDeclaredMethod("replace", Character.TYPE, CharSequence.class);
                            break block79;
                        }
                        case 8: {
                            ms.replace(a[0], as[0].charAt(0));
                            msm = MutableString.class.getDeclaredMethod("replace", Character.TYPE, Character.TYPE);
                        }
                    }
                    break;
                }
                case 15: {
                    int choice = rand.nextInt(6);
                    int l = rand.nextInt(ms.length() + 1);
                    String s = sb.toString().substring(0, l);
                    if (choice >= 3 && choice < 6) {
                        s = s.toLowerCase();
                    }
                    if (choice > 5) {
                        s = new String(MutableStringRegressionTest.generateCharArray(l));
                    }
                    switch (choice % 6) {
                        case 0: {
                            try {
                                msRes = new Boolean(ms.startsWith(ms.substring(0, l)));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().startsWith(s));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("startsWith", MutableString.class);
                            break block79;
                        }
                        case 1: {
                            try {
                                msRes = new Boolean(ms.startsWith(ms.substring(0, l).toString()));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().startsWith(s));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("startsWith", String.class);
                            break block79;
                        }
                        case 2: {
                            try {
                                msRes = new Boolean(ms.startsWith(new StringBuffer(ms.substring(0, l).toString())));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().startsWith(s));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("startsWith", CharSequence.class);
                            break block79;
                        }
                        case 3: {
                            try {
                                msRes = new Boolean(ms.startsWithIgnoreCase(ms.substring(0, l)));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().toLowerCase().startsWith(s.toLowerCase()));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("startsWithIgnoreCase", MutableString.class);
                            break block79;
                        }
                        case 4: {
                            try {
                                msRes = new Boolean(ms.startsWithIgnoreCase(ms.substring(0, l).toString()));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().toLowerCase().startsWith(s.toLowerCase()));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("startsWithIgnoreCase", String.class);
                            break block79;
                        }
                        case 5: {
                            try {
                                msRes = new Boolean(ms.startsWithIgnoreCase(new StringBuffer(ms.substring(0, l).toString())));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().toLowerCase().startsWith(s.toLowerCase()));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("startsWithIgnoreCase", CharSequence.class);
                        }
                    }
                    break;
                }
                case 16: {
                    int choice = rand.nextInt(6);
                    int l = rand.nextInt(ms.length() + 1);
                    String s = sb.toString().substring(sb.length() - l);
                    if (choice >= 3 && choice < 6) {
                        s = s.toLowerCase();
                    }
                    if (choice > 5) {
                        s = new String(MutableStringRegressionTest.generateCharArray(l));
                    }
                    switch (choice % 6) {
                        case 0: {
                            try {
                                msRes = new Boolean(ms.endsWith(ms.substring(l)));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().endsWith(s));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("endsWith", MutableString.class);
                            break block79;
                        }
                        case 1: {
                            try {
                                msRes = new Boolean(ms.endsWith(ms.substring(l).toString()));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().endsWith(s));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("endsWith", String.class);
                            break block79;
                        }
                        case 2: {
                            try {
                                msRes = new Boolean(ms.endsWith(new StringBuffer(ms.substring(l).toString())));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().endsWith(s));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("endsWith", CharSequence.class);
                            break block79;
                        }
                        case 3: {
                            try {
                                msRes = new Boolean(ms.endsWithIgnoreCase(ms.substring(l)));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().toLowerCase().endsWith(s.toLowerCase()));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("endsWithIgnoreCase", MutableString.class);
                            break block79;
                        }
                        case 4: {
                            try {
                                msRes = new Boolean(ms.endsWithIgnoreCase(ms.substring(l).toString()));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().toLowerCase().endsWith(s.toLowerCase()));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("endsWithIgnoreCase", String.class);
                            break block79;
                        }
                        case 5: {
                            try {
                                msRes = new Boolean(ms.endsWithIgnoreCase(new StringBuffer(ms.substring(l).toString())));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Boolean(sb.toString().toLowerCase().endsWith(s.toLowerCase()));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("endsWithIgnoreCase", CharSequence.class);
                        }
                    }
                    break;
                }
                case 17: {
                    int pos;
                    char[] a;
                    int l = rand.nextInt(sb.length() / 2 + 1);
                    String s = rand.nextBoolean() ? new String(MutableStringRegressionTest.generateCharArray(l)) : sb.toString().substring(l, l + rand.nextInt(sb.length() / 4 + 1));
                    int from = rand.nextInt() % (sb.length() * 2 + 1);
                    switch (rand.nextInt(8)) {
                        case 0: {
                            try {
                                msRes = new Integer(ms.indexOf(s, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Integer(new TextPattern(s).search(sb, from));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("indexOf", MutableString.class);
                            break block79;
                        }
                        case 1: {
                            try {
                                msRes = new Integer(ms.indexOf(s, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Integer(new TextPattern(s).search(ms, from));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("indexOf", MutableString.class);
                            break block79;
                        }
                        case 2: {
                            int i;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.indexOfAnyOf(a, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int temp = Integer.MAX_VALUE;
                                for (i = 0; i < a.length; ++i) {
                                    pos = sms.indexOf(a[i], from);
                                    if (pos == -1) continue;
                                    temp = Math.min(temp, pos);
                                }
                                sbRes = new Integer(temp == Integer.MAX_VALUE ? -1 : temp);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("indexOfAnyOf", char[].class);
                            break block79;
                        }
                        case 3: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.indexOfAnyBut(a, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = 0;
                                }
                                if (from > ms.length()) {
                                    from = ms.length();
                                }
                                for (i = from; i < ms.length(); ++i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j == a.length) break;
                                }
                                sbRes = new Integer(i < ms.length() ? i : -1);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("indexOfAnyBut", char[].class);
                            break block79;
                        }
                        case 4: {
                            int i;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.indexOfAnyOf((CharSet)new CharOpenHashSet(a), from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int temp = Integer.MAX_VALUE;
                                for (i = 0; i < a.length; ++i) {
                                    pos = sms.indexOf(a[i], from);
                                    if (pos == -1) continue;
                                    temp = Math.min(temp, pos);
                                }
                                sbRes = new Integer(temp == Integer.MAX_VALUE ? -1 : temp);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("indexOfAnyOf", CharSet.class);
                            break block79;
                        }
                        case 5: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.indexOfAnyBut((CharSet)new CharOpenHashSet(a), from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = 0;
                                }
                                if (from > ms.length()) {
                                    from = ms.length();
                                }
                                for (i = from; i < ms.length(); ++i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j == a.length) break;
                                }
                                sbRes = new Integer(i < ms.length() ? i : -1);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("indexOfAnyBut", CharSet.class);
                            break block79;
                        }
                        case 6: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.span(a, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = 0;
                                }
                                if (from > ms.length()) {
                                    from = ms.length();
                                }
                                for (i = from; i < ms.length(); ++i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j == a.length) break;
                                }
                                sbRes = new Integer(i - from);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("span", char[].class);
                            break block79;
                        }
                        case 7: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.span((CharSet)new CharOpenHashSet(a), from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = 0;
                                }
                                if (from > ms.length()) {
                                    from = ms.length();
                                }
                                for (i = from; i < ms.length(); ++i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j == a.length) break;
                                }
                                sbRes = new Integer(i - from);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("span", CharSet.class);
                        }
                    }
                    break;
                }
                case 18: {
                    String s;
                    String search = new String(MutableStringRegressionTest.generateCharArray(rand.nextInt(10)));
                    if (search.length() == 0) {
                        search = search + "X";
                    }
                    String replace = new String(MutableStringRegressionTest.generateCharArray(rand.nextInt(10)));
                    try {
                        s = new String(sb).replaceAll(search, replace);
                        sb.setLength(0);
                        sb.append(s);
                    }
                    catch (Exception e) {
                        sbThrow = e;
                    }
                    switch (rand.nextInt(3)) {
                        case 0: {
                            try {
                                ms.replace(new MutableString(search), new MutableString(replace));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("replace", MutableString.class, MutableString.class);
                            break block79;
                        }
                        case 1: {
                            try {
                                ms.replace(search, replace);
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("replace", String.class, String.class);
                            break block79;
                        }
                        case 2: {
                            String s1 = search;
                            String r1 = replace;
                            try {
                                ms.replace((CharSequence)s1, (CharSequence)r1);
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("replace", CharSequence.class, CharSequence.class);
                        }
                    }
                    break;
                }
                case 19: {
                    int pos;
                    char[] a;
                    int l = rand.nextInt(sb.length() / 2 + 1);
                    String s = rand.nextBoolean() ? new String(MutableStringRegressionTest.generateCharArray(l)) : sb.toString().substring(l, l + rand.nextInt(sb.length() / 4 + 1));
                    int from = rand.nextInt() % (sb.length() * 2 + 1);
                    switch (rand.nextInt(7)) {
                        case 0: {
                            try {
                                msRes = new Integer(ms.lastIndexOf(s, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                sbRes = new Integer(sb.lastIndexOf(s, from));
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("lastIndexOf", MutableString.class);
                            break block79;
                        }
                        case 1: {
                            int i;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.lastIndexOfAnyOf(a, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int temp = Integer.MIN_VALUE;
                                for (i = 0; i < a.length; ++i) {
                                    pos = sms.lastIndexOf(a[i], from);
                                    if (pos == -1) continue;
                                    temp = Math.max(temp, pos);
                                }
                                sbRes = new Integer(temp == Integer.MIN_VALUE ? -1 : temp);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("lastIndexOfAnyOf", char[].class);
                            break block79;
                        }
                        case 2: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.lastIndexOfAnyBut(a, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = -1;
                                }
                                if (from >= ms.length()) {
                                    from = ms.length() - 1;
                                }
                                for (i = from; i >= 0; --i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j == a.length) break;
                                }
                                sbRes = new Integer(i);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("lastIndexOfAnyBut", char[].class);
                            break block79;
                        }
                        case 3: {
                            int i;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.lastIndexOfAnyOf((CharSet)new CharOpenHashSet(a), from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int temp = Integer.MIN_VALUE;
                                for (i = 0; i < a.length; ++i) {
                                    pos = sms.lastIndexOf(a[i], from);
                                    if (pos == -1) continue;
                                    temp = Math.max(temp, pos);
                                }
                                sbRes = new Integer(temp == Integer.MIN_VALUE ? -1 : temp);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("lastIndexOfAnyOf", CharSet.class);
                            break block79;
                        }
                        case 4: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.lastIndexOfAnyBut((CharSet)new CharOpenHashSet(a), from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = -1;
                                }
                                if (from >= ms.length()) {
                                    from = ms.length() - 1;
                                }
                                for (i = from; i >= 0; --i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j == a.length) break;
                                }
                                sbRes = new Integer(i);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("lastIndexOfAnyBut", CharSet.class);
                            break block79;
                        }
                        case 5: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.cospan(a, from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = 0;
                                }
                                if (from > ms.length()) {
                                    from = ms.length();
                                }
                                for (i = from; i < ms.length(); ++i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j != a.length) break;
                                }
                                sbRes = new Integer(i - from);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("cospan", char[].class);
                            break block79;
                        }
                        case 6: {
                            int j;
                            a = s.toCharArray();
                            try {
                                msRes = new Integer(ms.cospan((CharSet)new CharOpenHashSet(a), from));
                            }
                            catch (Exception e) {
                                msThrow = e;
                            }
                            try {
                                int i;
                                if (from < 0) {
                                    from = 0;
                                }
                                if (from > ms.length()) {
                                    from = ms.length();
                                }
                                for (i = from; i < ms.length(); ++i) {
                                    for (j = 0; j < a.length && ms.charAt(i) != a[j]; ++j) {
                                    }
                                    if (j != a.length) break;
                                }
                                sbRes = new Integer(i - from);
                            }
                            catch (Exception e) {
                                sbThrow = e;
                            }
                            msm = MutableString.class.getDeclaredMethod("cospan", CharSet.class);
                        }
                    }
                    break;
                }
                case 22: {
                    int choice = rand.nextInt(3);
                    int l = choice == 0 ? 1 : rand.nextInt(40);
                    char[] a = new char[l];
                    for (int i = 0; i < l; ++i) {
                        a[i] = (char)(64 + rand.nextInt(26));
                    }
                    CharOpenHashSet charSet = new CharOpenHashSet(a);
                    int i = 0;
                    while (i < sb.length()) {
                        if (charSet.contains(sb.charAt(i))) {
                            sb.delete(i, i + 1);
                            continue;
                        }
                        ++i;
                    }
                    switch (choice) {
                        case 0: {
                            ms.delete(a[0]);
                            msm = MutableString.class.getDeclaredMethod("delete", Character.TYPE);
                            break block79;
                        }
                        case 1: {
                            ms.delete(a);
                            msm = MutableString.class.getDeclaredMethod("delete", char[].class);
                            break block79;
                        }
                        case 2: {
                            ms.delete((CharSet)charSet);
                            msm = MutableString.class.getDeclaredMethod("delete", CharSet.class);
                        }
                    }
                    break;
                }
                default: {
                    System.err.println("Special test number " + which + " not (yet) defined");
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (sbThrow == null && msThrow != null) {
            System.out.println("Method " + msm + " threw exception " + msThrow);
            System.out.println("No exception was thrown by StringBuffer");
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            System.exit(1);
        }
        if (sbThrow != null && msThrow == null) {
            System.out.println("Method " + msm + " threw no exception ");
            System.out.println("StringBuffer threw " + sbThrow);
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            System.exit(1);
        }
        if (sbThrow != null && msThrow != null && !msThrow.getClass().equals(msThrow.getClass())) {
            System.out.println("Method " + msm + " threw " + msThrow);
            System.out.println("StringBuffer threw " + sbThrow);
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            System.exit(1);
        }
        for (msIdx = 0; msIdx < msMethod.length && !msMethod[msIdx].equals(msm); ++msIdx) {
        }
        if (msIdx == msMethod.length) {
            System.out.println("I was looking for " + msm + " (which = " + which + ")");
            System.exit(1);
        }
        int n = msIdx;
        msTimes[n] = msTimes[n] + 1;
        if (sbThrow != null) {
            int n2 = msIdx;
            msExc[n2] = msExc[n2] + 1;
        }
        if (which != 6 && which != 5 && ms.isCompact() != compact) {
            System.out.println("On method " + msm);
            System.out.println("Previously MutableString was " + (compact ? "compact" : "loose") + "; now it is " + (ms.isCompact() ? "compact" : "loose"));
            if (sbThrow != null) {
                System.out.println("The method produced an " + sbThrow);
            }
            System.exit(1);
        }
        if (msRes == null && sbRes != null || msRes != null && sbRes == null || msRes != null && !msRes.equals(sbRes)) {
            System.out.println("On method " + msm + " returned value was " + msRes);
            System.out.println("StringBuffer returned " + sbRes + " instead");
            System.out.println("Class of first result: " + sbRes.getClass() + " hashcode=" + sbRes.hashCode());
            System.out.println("Class of second result: " + msRes.getClass() + " hashcode=" + msRes.hashCode());
            System.out.println("The two results are equal? " + msRes.equals(sbRes));
            System.out.println("The two results (as Strings) are equal? " + msRes.toString().equals(sbRes.toString()));
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            if (msThrow != null) {
                System.out.println("The MutableString method produced an " + msThrow);
            }
            if (sbThrow != null) {
                System.out.println("The StringBuffer method produced an " + sbThrow);
            }
            System.exit(1);
        }
        if (!sb.toString().equals(ms.toString())) {
            int i;
            System.out.println("After call, values are different");
            System.out.println("Method " + msm);
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            MutableStringRegressionTest.print("Current", "StringBuffer", sb);
            MutableStringRegressionTest.print("Current", "MutableString", ms);
            for (i = 0; i < Math.min(sb.length(), ms.length()) && sb.charAt(i) == ms.charAt(i); ++i) {
            }
            System.out.println("First different character has index " + i);
            if (msThrow != null) {
                System.out.println("The MutableString method produced an " + msThrow);
            }
            if (sbThrow != null) {
                System.out.println("The StringBuffer method produced an " + sbThrow);
            }
            System.exit(1);
        }
    }

    public static void testIO(int n) throws IOException {
        int i;
        int i2;
        MutableString[] a = new MutableString[n];
        MutableString t = new MutableString();
        int[] l = new int[n];
        DataOutputStream dbos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("regressionTest")));
        for (int i3 = 0; i3 < n; ++i3) {
            l[i3] = rand.nextBoolean() ? rand.nextInt(100) : rand.nextInt(100000);
            a[i3] = new MutableString(MutableStringRegressionTest.generateUnicodeCharArray(l[i3]));
            a[i3].writeSelfDelimUTF8(dbos);
        }
        dbos.close();
        DataInputStream dbis = new DataInputStream(new BufferedInputStream(new FileInputStream("regressionTest")));
        for (i2 = 0; i2 < n; ++i2) {
            if (a[i2].equals(t.readSelfDelimUTF8(dbis))) continue;
            System.out.println("On I/O with self-delimiting UTF-8 (" + i2 + ")");
            System.out.println("Written was " + MutableStringRegressionTest.s2i(a[i2]));
            System.out.println("Read is     " + MutableStringRegressionTest.s2i(t));
            System.exit(1);
        }
        dbis.close();
        dbos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("regressionTest")));
        for (i2 = 0; i2 < n; ++i2) {
            l[i2] = rand.nextBoolean() ? rand.nextInt(100) : rand.nextInt(100000);
            a[i2] = new MutableString(MutableStringRegressionTest.generateUnicodeCharArray(l[i2]));
            a[i2].writeUTF8(dbos);
        }
        dbos.close();
        dbis = new DataInputStream(new BufferedInputStream(new FileInputStream("regressionTest")));
        for (i2 = 0; i2 < n; ++i2) {
            if (a[i2].equals(t.readUTF8(dbis, l[i2]))) continue;
            System.out.println("On I/O with UTF-8 (" + i2 + ")");
            System.out.println("Written was " + MutableStringRegressionTest.s2i(a[i2]));
            System.out.println("Read is     " + MutableStringRegressionTest.s2i(t));
            System.exit(1);
        }
        dbis.close();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream("regressionTest"));
        for (int i4 = 0; i4 < n; ++i4) {
            l[i4] = rand.nextBoolean() ? rand.nextInt(100) : rand.nextInt(100000);
            a[i4] = new MutableString(MutableStringRegressionTest.generateUnicodeCharArray(l[i4]));
            a[i4].writeSelfDelimUTF8(bos);
        }
        bos.close();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream("regressionTest"));
        for (i = 0; i < n; ++i) {
            if (a[i].equals(t.readSelfDelimUTF8(bis))) continue;
            System.out.println("On I/O with self-delimiting UTF-8 (" + i + ")");
            System.out.println("Written was " + MutableStringRegressionTest.s2i(a[i]));
            System.out.println("Read is     " + MutableStringRegressionTest.s2i(t));
            System.exit(1);
        }
        bis.close();
        bos = new BufferedOutputStream(new FileOutputStream("regressionTest"));
        for (i = 0; i < n; ++i) {
            l[i] = rand.nextBoolean() ? rand.nextInt(100) : rand.nextInt(100000);
            a[i] = new MutableString(MutableStringRegressionTest.generateUnicodeCharArray(l[i]));
            a[i].writeUTF8(bos);
        }
        bos.close();
        bis = new BufferedInputStream(new FileInputStream("regressionTest"));
        for (i = 0; i < n; ++i) {
            if (a[i].equals(t.readUTF8(bis, l[i]))) continue;
            System.out.println("On I/O with UTF-8 (" + i + ")");
            System.out.println("Written was " + MutableStringRegressionTest.s2i(a[i]));
            System.out.println("Read is     " + MutableStringRegressionTest.s2i(t));
            System.exit(1);
        }
        bis.close();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream("regressionTest")), "UTF-16BE");
        for (int i5 = 0; i5 < n; ++i5) {
            l[i5] = rand.nextBoolean() ? rand.nextInt(100) : rand.nextInt(100000);
            a[i5] = new MutableString(MutableStringRegressionTest.generateUnicodeCharArray(l[i5]));
            a[i5].write(osw);
        }
        osw.close();
        InputStreamReader isr = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream("regressionTest")), "UTF-16BE");
        for (int i6 = 0; i6 < n; ++i6) {
            int u = t.read(isr, l[i6]);
            if (u != l[i6]) {
                System.out.println("I/O error on " + t + ": " + l[i6] + " characters read, " + u + " characters written");
            }
            if (a[i6].equals(t)) continue;
            System.out.println("On I/O with Reader (" + i6 + ")");
            System.out.println("Written was " + MutableStringRegressionTest.s2i(a[i6]));
            System.out.println("Read is     " + MutableStringRegressionTest.s2i(t));
            System.exit(1);
        }
        isr.close();
    }

    public static void test(StringBuffer sb, MutableString ms) throws IllegalArgumentException, IllegalAccessException {
        if (rand.nextInt(100) < 23) {
            MutableStringRegressionTest.specialTest(sb, ms);
            return;
        }
        String ssb = sb.toString();
        String sms = ms.toString();
        Method m = MutableStringRegressionTest.randomMethod();
        Object[] msargs = MutableStringRegressionTest.params(m);
        Object[] sbargs = MutableStringRegressionTest.convert(msargs);
        Object sbRes = null;
        Object msRes = null;
        Throwable sbThrow = null;
        Throwable msThrow = null;
        boolean compact = ms.isCompact();
        try {
            sbRes = sbMethod[sbIdx].invoke((Object)sb, sbargs);
        }
        catch (InvocationTargetException e) {
            sbThrow = e.getTargetException();
        }
        try {
            msRes = msMethod[msIdx].invoke((Object)ms, msargs);
        }
        catch (InvocationTargetException e) {
            msThrow = e.getTargetException();
        }
        if (sbThrow == null && msThrow != null) {
            System.out.println("On method " + sbMethod[sbIdx] + " with args " + MutableStringRegressionTest.a2s(sbargs) + " threw no Exception");
            System.out.println("On method " + msMethod[msIdx] + " with args " + MutableStringRegressionTest.a2s(msargs) + " threw " + msThrow);
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            System.exit(1);
        }
        if (sbThrow != null && msThrow == null) {
            System.out.println("On method " + sbMethod[sbIdx] + " with args " + MutableStringRegressionTest.a2s(sbargs) + " threw " + sbThrow);
            System.out.println("On method " + msMethod[msIdx] + " with args " + MutableStringRegressionTest.a2s(msargs) + " threw no Exception");
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            System.exit(1);
        }
        if (sbThrow != null && msThrow != null && !msThrow.getClass().equals(msThrow.getClass())) {
            System.out.println("On method " + sbMethod[sbIdx] + " with args " + MutableStringRegressionTest.a2s(sbargs) + " threw " + sbThrow);
            System.out.println("On method " + msMethod[msIdx] + " with args " + MutableStringRegressionTest.a2s(msargs) + " threw " + msThrow);
            MutableStringRegressionTest.print2("Previous", ssb, sms);
            System.exit(1);
        }
        int n = sbIdx;
        sbTimes[n] = sbTimes[n] + 1;
        int n2 = msIdx;
        msTimes[n2] = msTimes[n2] + 1;
        if (sbThrow != null) {
            int n3 = sbIdx;
            sbExc[n3] = sbExc[n3] + 1;
            int n4 = msIdx;
            msExc[n4] = msExc[n4] + 1;
        }
        if (m.getName().equals("capacity")) {
            return;
        }
        if (ms.isCompact() != compact && !msMethod[msIdx].getName().equals("ensureCapacity")) {
            System.out.println("On method " + msMethod[msIdx] + " with args " + MutableStringRegressionTest.a2s(msargs) + " returned " + msRes);
            System.out.println("Previously MutableString was " + (compact ? "compact" : "loose") + "; now it is " + (ms.isCompact() ? "compact" : "loose"));
            if (sbThrow != null) {
                System.out.println("The method produced an " + sbThrow);
            }
            System.exit(1);
        }
        if (sbMethod[sbIdx].getReturnType() != Void.TYPE && msMethod[msIdx].getReturnType() != Void.TYPE) {
            if (msRes == null && sbRes != null || msRes != null && sbRes == null || msRes != null && !msRes.equals(sbRes)) {
                System.out.println("On method " + sbMethod[sbIdx] + " with args " + MutableStringRegressionTest.a2s(sbargs) + " returned " + sbRes);
                System.out.println("On method " + msMethod[msIdx] + " with args " + MutableStringRegressionTest.a2s(msargs) + " returned " + msRes);
                System.out.println("Class of first result: " + sbRes.getClass() + " hashcode=" + sbRes.hashCode());
                System.out.println("Class of second result: " + msRes.getClass() + " hashcode=" + msRes.hashCode());
                System.out.println("The two results are equal? " + msRes.equals(sbRes));
                System.out.println("The two results (as Strings) are equal? " + msRes.toString().equals(sbRes.toString()));
                MutableStringRegressionTest.print2("Previous", ssb, sms);
                if (sbThrow != null) {
                    System.out.println("The method produced an " + sbThrow);
                }
                System.exit(1);
            }
            if (!sb.toString().equals(ms.toString())) {
                System.out.println("After call, values are different");
                System.out.println("Method " + sbMethod[sbIdx] + " with args " + MutableStringRegressionTest.a2s(sbargs));
                System.out.println("Method " + msMethod[msIdx] + " with args " + MutableStringRegressionTest.a2s(msargs));
                MutableStringRegressionTest.print2("Previous", ssb, sms);
                MutableStringRegressionTest.print("Current", "StringBuffer", sb);
                MutableStringRegressionTest.print("Current", "MutableString", ms);
                if (sbThrow != null) {
                    System.out.println("The call produced an " + sbThrow);
                }
                System.exit(1);
            }
        }
    }

    public static void main(String[] arg) throws IllegalArgumentException, IllegalAccessException, IOException {
        int i;
        int noOfTest = Integer.parseInt(arg[0]);
        int noOfIOTests = arg.length < 2 ? 100 : Integer.parseInt(arg[1]);
        long seed = arg.length < 3 ? System.currentTimeMillis() : Long.parseLong(arg[2]);
        rand = new Random(seed);
        System.out.println("Seed = " + seed);
        char[] c = MutableStringRegressionTest.generateCharArray();
        StringBuffer sb = new StringBuffer(new String(c));
        MutableString ms = new MutableString(new String(c));
        for (i = 0; i < noOfTest; ++i) {
            MutableStringRegressionTest.test(sb, ms);
        }
        MutableStringRegressionTest.testIO(noOfIOTests);
        System.out.println("\nStringBuffer Methods");
        for (i = 0; i < sbMethod.length; ++i) {
            System.out.println("\t" + sbMethod[i] + " called " + sbTimes[i] + " (exc. " + sbExc[i] + ")");
        }
        System.out.println("\nMutableString Methods");
        for (i = 0; i < msMethod.length; ++i) {
            System.out.println("\t" + msMethod[i] + " called " + msTimes[i] + " (exc. " + msExc[i] + ")");
        }
    }

    static /* synthetic */ Random access$000() {
        return rand;
    }

    static {
        alternativeType = new HashMap<Class, Set<Class>>();
        alternativeType.put(MutableString.class, (Set<Class>)new ObjectOpenHashSet((Object[])new Class[]{String.class, StringBuffer.class}));
        alternativeType.put(String.class, (Set<Class>)ObjectSets.singleton(StringBuffer.class));
        alternativeType.put(StringBuffer.class, (Set<Class>)ObjectSets.singleton(String.class));
        alternativeType.put(CharSequence.class, (Set<Class>)ObjectSets.singleton(String.class));
        alternativeType.put(Character.TYPE, (Set<Class>)ObjectSets.singleton(String.class));
        alternativeParameterType = null;
    }
}

