/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.jet.random.engine.MersenneTwister;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Random;

public class BloomFilter
implements Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 2L;
    private int size;
    public static final long MAX_BITS = 137438953408L;
    private static final long LOG2_LONG_SIZE = 6L;
    private static final long BIT_INDEX_MASK = 63L;
    public static final int NUMBER_OF_WEIGHTS = 16;
    public final long m;
    public final int d;
    private final long[] bits;
    private final int[][] weight;
    private final int[] init;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);

    public BloomFilter(int n) {
        this(n, Fast.mostSignificantBit(n) + 1);
    }

    public BloomFilter(int n, int d) {
        this.d = d;
        long wantedNumberOfBits = (long)Math.ceil((double)n * ((double)d / NATURAL_LOG_OF_2));
        if (wantedNumberOfBits > 137438953408L) {
            throw new IllegalArgumentException("The wanted number of bits (" + wantedNumberOfBits + ") is larger than " + 137438953408L);
        }
        this.bits = new long[(int)((wantedNumberOfBits + 64L - 1L) / 64L)];
        this.m = (long)this.bits.length * 64L;
        MersenneTwister mersenneTwister = new MersenneTwister(new Random().nextInt());
        this.weight = new int[d][];
        this.init = new int[d];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new int[16];
            this.init[i] = mersenneTwister.nextInt();
            for (int j = 0; j < 16; ++j) {
                this.weight[i][j] = mersenneTwister.nextInt();
            }
        }
    }

    private static boolean get(long[] bits, long index) {
        return (bits[(int)(index >> 6)] & 1L << (int)(index & 0x3FL)) != 0L;
    }

    private boolean set(long[] bits, long index) {
        int unit = (int)(index >> 6);
        long mask = 1L << (int)(index & 0x3FL);
        boolean result = (bits[unit] & mask) != 0L;
        int n = unit;
        bits[n] = bits[n] | mask;
        return result;
    }

    private long hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(s.charAt(i) * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(byte[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(short[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(char[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(int[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(a[i] * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(long[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + a[i] * (long)w[i % 16] + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(float[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + (long)(Float.floatToRawIntBits(a[i]) * w[i % 16]) + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    private long hash(double[] a, int l, int k) {
        int[] w = this.weight[k];
        long h = this.init[k];
        int i = l;
        while (i-- != 0) {
            h ^= (h << 5) + Double.doubleToRawLongBits(a[i]) * (long)w[i % 16] + (h >>> 2);
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(byte[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(short[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(char[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(long[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(float[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(double[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        while (i-- != 0) {
            if (BloomFilter.get(bits, this.hash(a, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        int i = this.d;
        int l = s.length();
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(s, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(byte[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(short[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(char[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(int[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(long[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(float[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean add(double[] a) {
        int i = this.d;
        int l = a.length;
        long[] bits = this.bits;
        boolean alreadySet = true;
        while (i-- != 0) {
            alreadySet &= this.set(bits, this.hash(a, l, i));
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public void clear() {
        LongArrays.fill((long[])this.bits, (long)0L);
        this.size = 0;
    }

    public long size() {
        return this.size;
    }

    public static void main(String[] arg) throws IOException, JSAPException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(BloomFilter.class.getName(), "Creates a Bloom filter reading from standard input a newline-separated list of terms.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)IntSizeStringParser.getParser(), "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new UnflaggedOption("bloomFilter", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised front-coded list."), new UnflaggedOption("size", (StringParser)JSAP.INTSIZE_PARSER, JSAP.NO_DEFAULT, true, false, "The size of the filter (i.e., the expected number of elements in the filter; usually, the number of terms)."), new UnflaggedOption("precision", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, false, "The precision of the filter.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String filterName = jsapResult.getString("bloomFilter");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        BloomFilter filter = new BloomFilter(jsapResult.getInt("size"), jsapResult.getInt("precision"));
        ProgressLogger pl = new ProgressLogger();
        pl.itemsName = "terms";
        pl.start("Reading terms...");
        MutableString s = new MutableString();
        FastBufferedReader reader = new FastBufferedReader(new InputStreamReader(System.in, encoding), bufferSize);
        while (reader.readLine(s) != null) {
            filter.add(s);
            pl.lightUpdate();
        }
        pl.done();
        BinIO.storeObject((Object)filter, (CharSequence)filterName);
    }
}

