/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.compression;

import cern.colt.bitvector.BitVector;
import it.unimi.dsi.mg4j.compression.HuTuckerCodec;
import java.io.IOException;
import java.util.Random;
import test.it.unimi.dsi.mg4j.compression.CodecTest;

public class HuTuckerCodecTest
extends CodecTest {
    public void testOneSymbol() throws IOException {
        HuTuckerCodec codec = new HuTuckerCodec(new int[]{1});
        HuTuckerCodecTest.assertEquals((int)1, (int)codec.codeWords().length);
        HuTuckerCodecTest.assertEquals((Object)new BitVector(0), (Object)codec.codeWords()[0]);
        long seed = System.currentTimeMillis();
        System.err.println(seed);
        Random r = new Random(seed);
        this.checkPrefixCodec(codec, r);
    }

    public void testTwoEquiprobableSymbols() throws IOException {
        HuTuckerCodec codec = new HuTuckerCodec(new int[]{1, 1});
        HuTuckerCodecTest.assertEquals((int)2, (int)codec.codeWords().length);
        HuTuckerCodecTest.assertEquals((Object)new BitVector(1), (Object)codec.codeWords()[0]);
        BitVector v = new BitVector(1);
        v.set(0);
        HuTuckerCodecTest.assertEquals((Object)v, (Object)codec.codeWords()[1]);
        long seed = System.currentTimeMillis();
        System.err.println(seed);
        Random r = new Random(seed);
        this.checkPrefixCodec(codec, r);
    }

    public void testThreeNonequiprobableSymbols() throws IOException {
        HuTuckerCodec codec = new HuTuckerCodec(new int[]{1, 2, 4});
        HuTuckerCodecTest.assertEquals((int)3, (int)codec.codeWords().length);
        BitVector v = new BitVector(2);
        HuTuckerCodecTest.assertEquals((Object)v, (Object)codec.codeWords()[0]);
        v.set(1);
        HuTuckerCodecTest.assertEquals((Object)v, (Object)codec.codeWords()[1]);
        v = new BitVector(1);
        v.set(0);
        HuTuckerCodecTest.assertEquals((Object)v, (Object)codec.codeWords()[2]);
        long seed = System.currentTimeMillis();
        System.err.println(seed);
        Random r = new Random(seed);
        this.checkPrefixCodec(codec, r);
    }

    public void testRandomFrequencies() throws IOException {
        long seed = System.currentTimeMillis();
        System.err.println(seed);
        Random r = new Random(seed);
        int[] frequency = new int[100];
        for (int i = 0; i < frequency.length; ++i) {
            frequency[i] = r.nextInt(1000);
        }
        HuTuckerCodec codec = new HuTuckerCodec(frequency);
        this.checkPrefixCodec(codec, r);
    }

    public void testRandomCodeLengths() throws IOException {
        int[] frequency = new int[]{805, 1335, 6401, 7156, 7333, 10613, 10951, 11708, 12710, 12948, 13237, 13976, 20355, 20909, 22398, 26303, 26400, 28380, 28865, 30152, 31693};
        int[] codeLength = new int[]{7, 7, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3};
        HuTuckerCodec codec = new HuTuckerCodec(frequency);
        this.checkLengths(frequency, codeLength, codec.codeWords());
        this.checkPrefixCodec(codec, new Random());
    }

    public void testExponentialCodeLengths() throws IOException {
        int[] frequency = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
        int[] codeLength = new int[]{30, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        HuTuckerCodec codec = new HuTuckerCodec(frequency);
        this.checkLengths(frequency, codeLength, codec.codeWords());
        this.checkPrefixCodec(codec, new Random());
    }
}

