/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.io;

import it.unimi.dsi.mg4j.io.ByteBufferInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Random;
import junit.framework.TestCase;

public class ByteBufferInputStreamTest
extends TestCase {
    public void testStream() throws FileNotFoundException, IOException {
        File f = File.createTempFile(ByteBufferInputStreamTest.class.getName(), "tmp");
        f.deleteOnExit();
        int l = 100000;
        long seed = System.currentTimeMillis();
        System.err.println("Seed: " + seed);
        Random random = new Random(seed);
        FileOutputStream fos = new FileOutputStream(f);
        for (int i = 0; i < 100000; ++i) {
            fos.write(random.nextInt() & 0xFF);
        }
        fos.close();
        ByteBufferInputStream bis = new ByteBufferInputStream(new FileInputStream(f).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 100000L));
        FileInputStream test = new FileInputStream(f);
        FileChannel fc = test.getChannel();
        Random r = new Random();
        byte[] b1 = new byte[32768];
        byte[] b2 = new byte[32768];
        block9: for (int k = 0; k < 100000; ++k) {
            switch (r.nextInt(6)) {
                case 0: {
                    System.err.println("read()");
                    int a1 = bis.read();
                    int a2 = test.read();
                    ByteBufferInputStreamTest.assertEquals((int)a2, (int)a1);
                    continue block9;
                }
                case 1: {
                    int off = r.nextInt(b1.length);
                    int len = r.nextInt(b1.length - off + 1);
                    int a1 = bis.read(b1, off, len);
                    int a2 = test.read(b2, off, len);
                    System.err.println("read(b, " + off + ", " + len + ")");
                    ByteBufferInputStreamTest.assertEquals((int)a2, (int)a1);
                    for (int i = off; i < off + len; ++i) {
                        ByteBufferInputStreamTest.assertEquals((byte)b2[i], (byte)b1[i]);
                    }
                    continue block9;
                }
                case 2: {
                    System.err.println("available()");
                    ByteBufferInputStreamTest.assertEquals((int)test.available(), (int)bis.available());
                    continue block9;
                }
                case 3: {
                    System.err.println("position()");
                    int pos = (int)bis.position();
                    ByteBufferInputStreamTest.assertEquals((int)((int)fc.position()), (int)pos);
                    continue block9;
                }
                case 4: {
                    int pos = r.nextInt(100000);
                    bis.position(pos);
                    System.err.println("position(" + pos + ")");
                    test = new FileInputStream(f);
                    test.skip(pos);
                    fc = test.getChannel();
                    continue block9;
                }
                case 5: {
                    int pos = r.nextInt((int)(100000L - bis.position() + 1L));
                    int a1 = (int)bis.skip(pos);
                    int a2 = (int)test.skip(pos);
                    System.err.println("skip(" + pos + ")");
                    ByteBufferInputStreamTest.assertEquals((int)a2, (int)a1);
                }
            }
        }
    }
}

