/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.util.MutableString;

public class PorterStemmerTermProcessor
implements TermProcessor {
    private static final long serialVersionUID = -6858827105201663304L;
    private static final PorterStemmerTermProcessor INSTANCE = new PorterStemmerTermProcessor();

    public static final TermProcessor getInstance() {
        return INSTANCE;
    }

    private PorterStemmerTermProcessor() {
    }

    public PorterStemmerTermProcessor copy() {
        return this;
    }

    public boolean processPrefix(MutableString prefix) {
        prefix.toLowerCase();
        return true;
    }

    public boolean processTerm(MutableString str) {
        if (str.length() == 0) {
            return false;
        }
        str.toLowerCase();
        MutableString original = new MutableString(str);
        char[] a = str.array();
        int i = str.length();
        while (i-- != 0) {
            if (Character.isLetter(a[i])) continue;
            return true;
        }
        str.replace(this.step1a(str));
        str.replace(this.step1b(str));
        str.replace(this.step1c(str));
        str.replace(this.step2(str));
        str.replace(this.step3(str));
        str.replace(this.step4(str));
        str.replace(this.step5a(str));
        str.replace(this.step5b(str));
        if (str.length() == 0) {
            str.replace(original);
        }
        return true;
    }

    private MutableString step1a(MutableString str) {
        if (str.endsWith("sses")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ies")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ss")) {
            return str;
        }
        if (str.endsWith("s")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private MutableString step1b(MutableString str) {
        if (str.endsWith("eed")) {
            if (this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
                return str.substring(0, str.length() - 1);
            }
            return str;
        }
        if (str.endsWith("ed") && this.containsVowel(str.substring(0, str.length() - 2))) {
            return this.step1b2(str.substring(0, str.length() - 2));
        }
        if (str.endsWith("ing") && this.containsVowel(str.substring(0, str.length() - 3))) {
            return this.step1b2(str.substring(0, str.length() - 3));
        }
        return str;
    }

    private MutableString step1b2(MutableString str) {
        if (str.endsWith("at") || str.endsWith("bl") || str.endsWith("iz")) {
            return new MutableString(str + "e");
        }
        if (this.endsWithDoubleConsonent(str) && !str.endsWith("l") && !str.endsWith("s") && !str.endsWith("z")) {
            return str.substring(0, str.length() - 1);
        }
        if (this.stringMeasure(str) == 1 && this.endsWithCVC(str)) {
            return new MutableString(str + "e");
        }
        return str;
    }

    private MutableString step1c(MutableString str) {
        if (str.endsWith("y") && this.containsVowel(str.substring(0, str.length() - 1))) {
            return new MutableString(str.substring(0, str.length() - 1) + "i");
        }
        return str;
    }

    private MutableString step2(MutableString str) {
        if (str.endsWith("ational") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return new MutableString(str.substring(0, str.length() - 5) + "e");
        }
        if (str.endsWith("tional") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("enci") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("anci") && this.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return new MutableString(str.substring(0, str.length() - 1) + "e");
        }
        if (str.endsWith("izer") && this.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return str.substring(0, str.length() - 1);
        }
        if (str.endsWith("abli") && this.stringMeasure(str.substring(0, str.length() - 1)) > 0) {
            return new MutableString(str.substring(0, str.length() - 1) + "e");
        }
        if (str.endsWith("alli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("entli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("eli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ousli") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ization") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return new MutableString(str.substring(0, str.length() - 5) + "e");
        }
        if (str.endsWith("ation") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return new MutableString(str.substring(0, str.length() - 3) + "e");
        }
        if (str.endsWith("ator") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return new MutableString(str.substring(0, str.length() - 2) + "e");
        }
        if (str.endsWith("alism") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iveness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("fulness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ousness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("aliti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iviti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return new MutableString(str.substring(0, str.length() - 3) + "e");
        }
        if (str.endsWith("biliti") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return new MutableString(str.substring(0, str.length() - 5) + "le");
        }
        return str;
    }

    private MutableString step3(MutableString str) {
        if (str.endsWith("icate") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ative") && this.stringMeasure(str.substring(0, str.length() - 5)) > 0) {
            return str.substring(0, str.length() - 5);
        }
        if (str.endsWith("alize") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iciti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ical") && this.stringMeasure(str.substring(0, str.length() - 2)) > 0) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ful") && this.stringMeasure(str.substring(0, str.length() - 3)) > 0) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ness") && this.stringMeasure(str.substring(0, str.length() - 4)) > 0) {
            return str.substring(0, str.length() - 4);
        }
        return str;
    }

    private MutableString step4(MutableString str) {
        if (str.endsWith("al") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ance") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ence") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("er") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ic") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("able") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ible") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ant") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ement") && this.stringMeasure(str.substring(0, str.length() - 5)) > 1) {
            return str.substring(0, str.length() - 5);
        }
        if (str.endsWith("ment") && this.stringMeasure(str.substring(0, str.length() - 4)) > 1) {
            return str.substring(0, str.length() - 4);
        }
        if (str.endsWith("ent") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if ((str.endsWith("sion") || str.endsWith("tion")) && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ou") && this.stringMeasure(str.substring(0, str.length() - 2)) > 1) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ism") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ate") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("iti") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ous") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ive") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        if (str.endsWith("ize") && this.stringMeasure(str.substring(0, str.length() - 3)) > 1) {
            return str.substring(0, str.length() - 3);
        }
        return str;
    }

    private MutableString step5a(MutableString str) {
        if (str.length() == 0) {
            return str;
        }
        if (this.stringMeasure(str.substring(0, str.length() - 1)) > 1 && str.endsWith("e")) {
            return str.substring(0, str.length() - 1);
        }
        if (this.stringMeasure(str.substring(0, str.length() - 1)) == 1 && !this.endsWithCVC(str.substring(0, str.length() - 1)) && str.endsWith("e")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private MutableString step5b(MutableString str) {
        if (str.endsWith("l") && this.endsWithDoubleConsonent(str) && this.stringMeasure(str.substring(0, str.length() - 1)) > 1) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private boolean containsVowel(MutableString str) {
        char[] strchars = str.toCharArray();
        for (int i = 0; i < strchars.length; ++i) {
            if (!this.isVowel(strchars[i])) continue;
            return true;
        }
        return str.indexOf('y') > -1;
    }

    private boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    private boolean endsWithDoubleConsonent(MutableString str) {
        char c = str.charAt(str.length() - 1);
        if (str.length() == 1) {
            return false;
        }
        return c == str.charAt(str.length() - 2) && !this.containsVowel(str.substring(str.length() - 2));
    }

    private int stringMeasure(MutableString str) {
        int count = 0;
        boolean vowelSeen = false;
        char[] strchars = str.toCharArray();
        for (int i = 0; i < strchars.length; ++i) {
            if (this.isVowel(strchars[i])) {
                vowelSeen = true;
                continue;
            }
            if (!vowelSeen) continue;
            ++count;
            vowelSeen = false;
        }
        return count;
    }

    private boolean endsWithCVC(MutableString str) {
        char c2 = ' ';
        if (str.length() < 3) {
            return false;
        }
        char c = str.charAt(str.length() - 1);
        char v = str.charAt(str.length() - 2);
        c2 = str.charAt(str.length() - 3);
        if (c == 'w' || c == 'x' || c == 'y') {
            return false;
        }
        if (this.isVowel(c)) {
            return false;
        }
        if (!this.isVowel(v)) {
            return false;
        }
        return !this.isVowel(c2);
    }
}

