/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.mg4j.index.AbstractTermMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class RemoteTermMap
extends AbstractTermMap
implements TermMap,
Serializable {
    private static final byte GET_NUMBER = 0;
    private static final byte GET_TERM = 1;
    private static final byte HAS_TERMS = 2;
    static final long serialVersionUID = 1L;
    private SocketAddress address;
    private final int size;
    private transient RemoteIndexServerConnection remoteConnection;

    public RemoteTermMap(SocketAddress address, int size) {
        this.address = address;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    private void ensureConnection() throws IOException {
        if (this.remoteConnection == null) {
            this.remoteConnection = new RemoteIndexServerConnection(this.address, 2);
        }
    }

    public int getNumber(CharSequence term) {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(0);
            new MutableString(term).writeSelfDelimUTF8(this.remoteConnection.outputStream);
            this.remoteConnection.outputStream.flush();
            return this.remoteConnection.inputStream.readInt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CharSequence getTerm(int index) {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(1);
            this.remoteConnection.outputStream.writeInt(index);
            this.remoteConnection.outputStream.flush();
            return new MutableString().readSelfDelimUTF8(this.remoteConnection.inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasTerms() {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(2);
            this.remoteConnection.outputStream.flush();
            return this.remoteConnection.inputStream.readBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private static final Logger LOGGER = Fast.getLogger(ServerThread.class);
        private final TermMap termMap;

        public ServerThread(Socket socket, TermMap termMap) throws IOException {
            super(socket);
            this.termMap = termMap;
        }

        public void run() {
            try {
                MutableString s = new MutableString();
                block8: while (true) {
                    byte command = this.inputStream.readByte();
                    switch (command) {
                        case 0: {
                            this.outputStream.writeInt(this.termMap.getNumber(s.readSelfDelimUTF8(this.inputStream)));
                            this.outputStream.flush();
                            continue block8;
                        }
                        case 1: {
                            this.termMap.getTerm(this.inputStream.readInt(), s).writeSelfDelimUTF8(this.outputStream);
                            this.outputStream.flush();
                            continue block8;
                        }
                        case 2: {
                            this.outputStream.writeBoolean(this.termMap.hasTerms());
                            this.outputStream.flush();
                            continue block8;
                        }
                    }
                    LOGGER.error((Object)("Unknown remote command: " + command));
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }
}

