/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import it.unimi.dsi.mg4j.util.SemiExternalGammaList;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BM25FScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    private static final Logger LOGGER = Logger.getLogger(BM25FScorer.class);
    private static final boolean DEBUG = false;
    public static final double DEFAULT_K1 = 1.2;
    public static final double DEFAULT_B = 0.5;
    public static final double EPSILON_SCORE = 1.000000082240371E-9;
    private final CounterCollectionVisitor counterCollectionVisitor;
    private final CounterSetupVisitor setupVisitor;
    private final TermCollectionVisitor termVisitor = new TermCollectionVisitor();
    public final double k1;
    public final double b;
    private final double k1Plus1;
    private final double oneMinusB;
    private double averageDocumentSize;
    private IntList[] sizes;
    private int[] size;
    private double[] idfPart;
    private double[] weight;
    LongList frequencies;

    public BM25FScorer(double k1, double b, LongList frequencies) {
        this.setupVisitor = new CounterSetupVisitor(this.termVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.setupVisitor);
        this.k1 = k1;
        this.b = b;
        this.frequencies = frequencies;
        this.k1Plus1 = k1 + 1.0;
        this.oneMinusB = 1.0 - b;
    }

    public BM25FScorer(String frequencies) throws FileNotFoundException, IOException {
        this(Double.toString(1.2), Double.toString(0.5), frequencies);
    }

    public BM25FScorer(String k1, String b, String frequencies) throws NumberFormatException, FileNotFoundException, IOException {
        this(Double.parseDouble(k1), Double.parseDouble(b), LongLists.synchronize((LongList)new SemiExternalGammaList(new InputBitStream(frequencies))));
    }

    public synchronized BM25FScorer copy() {
        BM25FScorer scorer = new BM25FScorer(this.k1, this.b, this.frequencies);
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    public double score() throws IOException {
        this.setupVisitor.clear();
        this.documentIterator.acceptOnTruePaths(this.counterCollectionVisitor);
        int document = this.documentIterator.document();
        int[] count = this.setupVisitor.count;
        int[] indexNumber = this.setupVisitor.indexNumber;
        double[] weightedIdfPart = this.idfPart;
        int[] size = this.size;
        int i = this.currIndex.length;
        while (i-- != 0) {
            size[i] = this.sizes[i].getInt(document);
        }
        double virtualCount = 0.0;
        int i2 = count.length;
        while (i2-- != 0) {
            virtualCount += (double)count[i2] * this.weight[i2];
        }
        return this.k1Plus1 * virtualCount;
    }

    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    public void wrap(DocumentIterator d) throws IOException {
        this.documentIterator = d;
        this.termVisitor.prepare();
        d.accept(this.termVisitor);
        Index[] index = this.termVisitor.indices();
        this.sizes = new IntList[index.length];
        int i = index.length;
        while (i-- != 0) {
            this.sizes[i] = index[i].sizes;
            if (this.sizes[i] != null) continue;
            throw new IllegalStateException("A BM25 scorer requires document sizes");
        }
        this.averageDocumentSize = 0.0;
        i = index.length;
        while (i-- != 0) {
            this.averageDocumentSize += this.index2Weight.getDouble((Object)index[i]) * (double)index[i].numberOfOccurrences / (double)index[i].numberOfDocuments;
        }
        this.setupVisitor.prepare();
        d.accept(this.setupVisitor);
        int[] frequency = this.setupVisitor.frequency;
        int[] indexNumber = this.setupVisitor.indexNumber;
        this.idfPart = new double[frequency.length];
        this.weight = new double[frequency.length];
        int i2 = this.idfPart.length;
        while (i2-- != 0) {
            this.weight[i2] = this.index2Weight.getDouble((Object)index[indexNumber[i2]]);
            this.idfPart[i2] = Math.max(1.000000082240371E-9, Math.log(((double)(index[indexNumber[i2]].numberOfDocuments - frequency[i2]) + 0.5) / ((double)frequency[i2] + 0.5)));
        }
        this.size = new int[index.length];
        this.currIndex = index;
    }

    public boolean usesIntervals() {
        return false;
    }
}

