/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.LineIterator;
import it.unimi.dsi.mg4j.tool.VirtualDocumentResolver;
import it.unimi.dsi.mg4j.util.BloomFilter;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressLogger;
import it.unimi.dsi.mg4j.util.ShiftAddXorSignedMinimalPerfectHash;
import it.unimi.dsi.mg4j.util.SignedMinimalPerfectHash;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;

public class URLMPHVirtualDocumentResolver
implements VirtualDocumentResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(URLMPHVirtualDocumentResolver.class);
    private final TermMap url2DocumentPointer;
    private transient URI documentURI;

    public URLMPHVirtualDocumentResolver(TermMap url2DocumentPointer) {
        this.url2DocumentPointer = url2DocumentPointer;
    }

    public void context(Document document) {
        try {
            this.documentURI = new URI(((Object)document.uri()).toString()).normalize();
        }
        catch (URISyntaxException e) {
            this.documentURI = null;
        }
    }

    public int resolve(CharSequence virtualDocumentSpec) {
        try {
            URI virtualURI = URI.create(((Object)virtualDocumentSpec).toString()).normalize();
            if (!virtualURI.isAbsolute()) {
                if (this.documentURI == null) {
                    return -1;
                }
                virtualURI = this.documentURI.resolve(virtualURI);
            }
            return this.url2DocumentPointer.getNumber(virtualURI.toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int numberOfDocuments() {
        return this.url2DocumentPointer.size();
    }

    private static void makeUnique(BloomFilter filter, MutableString uri) {
        while (!filter.add(uri)) {
            LOGGER.debug((Object)("Duplicate URI " + uri));
            uri.append('/').append(RandomStringUtils.randomAlphanumeric((int)32));
        }
    }

    public static void main(String[] arg) throws JSAPException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException, InstantiationException {
        SignedMinimalPerfectHash minimalPerfectHash;
        SimpleJSAP jsap = new SimpleJSAP(URLMPHVirtualDocumentResolver.class.getName(), "Builds a URL document resolver from a sequence of URIs, extracted typically using ScanMetadata.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("class", (StringParser)MG4JClassParser.getParser(), ShiftAddXorSignedMinimalPerfectHash.class.getName(), false, 'c', "class", "A subclass of MinimalPerfectHash to be used when creating the table."), new FlaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "offline", "Read terms from this file (without loading them into core memory) instead of standard input."), new FlaggedOption("uniqueUris", (StringParser)JSAP.INTSIZE_PARSER, JSAP.NO_DEFAULT, false, 'U', "unique-uris", "Force URIs to be unique by adding random garbage at the end of duplicates; the argument is an upper bound for the number of URIs that will be read, and will be used to create a Bloom filter."), new UnflaggedOption("resolver", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the resolver.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String resolverName = jsapResult.getString("resolver");
        Class tableClass = jsapResult.getClass("class");
        String termFile = jsapResult.getString("termFile");
        BloomFilter filter = null;
        boolean uniqueURIs = jsapResult.userSpecified("uniqueUris");
        if (uniqueURIs) {
            filter = new BloomFilter(jsapResult.getInt("uniqueUris"));
        }
        if (termFile == null) {
            ArrayList<MutableString> termList = new ArrayList<MutableString>();
            ProgressLogger pl = new ProgressLogger();
            pl.itemsName = "URIs";
            LineIterator termIterator = new LineIterator(new FastBufferedReader(new InputStreamReader(System.in, "UTF-8"), bufferSize), pl);
            pl.start("Reading URIs...");
            while (termIterator.hasNext()) {
                MutableString uri = termIterator.next();
                if (uniqueURIs) {
                    URLMPHVirtualDocumentResolver.makeUnique(filter, uri);
                }
                termList.add(uri.copy());
            }
            pl.done();
            LOGGER.debug((Object)"Building minimal perfect hash table...");
            minimalPerfectHash = (SignedMinimalPerfectHash)tableClass.getConstructor(Iterable.class).newInstance(termList);
        } else {
            if (uniqueURIs) {
                ProgressLogger pl = new ProgressLogger();
                pl.itemsName = "URIs";
                pl.start("Copying URIs...");
                LineIterator termIterator = new LineIterator(new FastBufferedReader(new InputStreamReader(new FileInputStream(termFile)), bufferSize), pl);
                File temp = File.createTempFile(URLMPHVirtualDocumentResolver.class.getName(), ".uniqueuris");
                temp.deleteOnExit();
                termFile = temp.toString();
                FastBufferedOutputStream outputStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(termFile), bufferSize);
                while (termIterator.hasNext()) {
                    MutableString uri = termIterator.next();
                    URLMPHVirtualDocumentResolver.makeUnique(filter, uri);
                    uri.writeUTF8((OutputStream)outputStream);
                    outputStream.write(10);
                }
                pl.done();
                outputStream.close();
            }
            LOGGER.debug((Object)"Building minimal perfect hash table...");
            minimalPerfectHash = (SignedMinimalPerfectHash)tableClass.getConstructor(String.class, String.class, Integer.TYPE).newInstance(termFile, "UTF-8", -1);
        }
        LOGGER.debug((Object)" writing to file...");
        BinIO.storeObject((Object)new URLMPHVirtualDocumentResolver(minimalPerfectHash), (CharSequence)resolverName);
        LOGGER.debug((Object)" done.");
    }
}

