/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.BinaryCigarCodec;
import net.sf.samtools.BinaryTagCodec;
import net.sf.samtools.DefaultSAMRecordFactory;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.RuntimeEOFException;
import net.sf.samtools.util.SortingCollection;

public class BAMRecordCodec
implements SortingCollection.Codec<SAMRecord> {
    private final BinaryCigarCodec cigarCodec = new BinaryCigarCodec();
    private final SAMFileHeader header;
    private final BinaryCodec binaryCodec = new BinaryCodec();
    private final BinaryTagCodec binaryTagCodec = new BinaryTagCodec(this.binaryCodec);
    private final SAMRecordFactory samRecordFactory;

    public BAMRecordCodec(SAMFileHeader header) {
        this(header, new DefaultSAMRecordFactory());
    }

    public BAMRecordCodec(SAMFileHeader header, SAMRecordFactory factory) {
        this.header = header;
        this.samRecordFactory = factory;
    }

    public BAMRecordCodec clone() {
        return new BAMRecordCodec(this.header, this.samRecordFactory);
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.binaryCodec.setOutputStream(os);
    }

    @Override
    public void setInputStream(InputStream is) {
        this.binaryCodec.setInputStream(is);
    }

    @Override
    public void encode(SAMRecord alignment) {
        int readLength = alignment.getReadLength();
        int cigarLength = alignment.getCigarLength();
        int blockSize = 32 + alignment.getReadNameLength() + 1 + cigarLength * 4 + (readLength + 1) / 2 + readLength;
        int attributesSize = alignment.getAttributesBinarySize();
        if (attributesSize != -1) {
            blockSize += attributesSize;
        } else {
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                blockSize += BinaryTagCodec.getTagSize(attribute.value);
            }
        }
        int indexBin = 0;
        if (alignment.getReferenceIndex() >= 0) {
            indexBin = alignment.getIndexingBin() != null ? alignment.getIndexingBin().intValue() : alignment.computeIndexingBin();
        }
        this.binaryCodec.writeInt(blockSize);
        this.binaryCodec.writeInt(alignment.getReferenceIndex());
        this.binaryCodec.writeInt(alignment.getAlignmentStart() - 1);
        this.binaryCodec.writeUByte((short)(alignment.getReadNameLength() + 1));
        this.binaryCodec.writeUByte((short)alignment.getMappingQuality());
        this.binaryCodec.writeUShort(indexBin);
        this.binaryCodec.writeUShort(cigarLength);
        this.binaryCodec.writeUShort(alignment.getFlags());
        this.binaryCodec.writeInt(alignment.getReadLength());
        this.binaryCodec.writeInt(alignment.getMateReferenceIndex());
        this.binaryCodec.writeInt(alignment.getMateAlignmentStart() - 1);
        this.binaryCodec.writeInt(alignment.getInferredInsertSize());
        byte[] variableLengthBinaryBlock = alignment.getVariableBinaryRepresentation();
        if (variableLengthBinaryBlock != null) {
            this.binaryCodec.writeBytes(variableLengthBinaryBlock);
        } else {
            int[] binaryCigar;
            if (alignment.getReadLength() != alignment.getBaseQualities().length && alignment.getBaseQualities().length != 0) {
                throw new RuntimeException("Mismatch between read length and quals length writing read " + alignment.getReadName() + "; read length: " + alignment.getReadLength() + "; quals length: " + alignment.getBaseQualities().length);
            }
            this.binaryCodec.writeString(alignment.getReadName(), false, true);
            for (int cigarElement : binaryCigar = this.cigarCodec.encode(alignment.getCigar())) {
                this.binaryCodec.writeInt(cigarElement);
            }
            this.binaryCodec.writeBytes(SAMUtils.bytesToCompressedBases(alignment.getReadBases()));
            byte[] qualities = alignment.getBaseQualities();
            if (qualities.length == 0) {
                qualities = new byte[alignment.getReadLength()];
                Arrays.fill(qualities, (byte)-1);
            }
            this.binaryCodec.writeBytes(qualities);
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                this.binaryTagCodec.writeTag(attribute.tag, attribute.value, attribute.isUnsignedArray());
            }
        }
    }

    @Override
    public SAMRecord decode() {
        int recordLength = 0;
        try {
            recordLength = this.binaryCodec.readInt();
        }
        catch (RuntimeEOFException e) {
            return null;
        }
        if (recordLength < 32) {
            throw new SAMFormatException("Invalid record length: " + recordLength);
        }
        int referenceID = this.binaryCodec.readInt();
        int coordinate = this.binaryCodec.readInt() + 1;
        short readNameLength = this.binaryCodec.readUByte();
        short mappingQuality = this.binaryCodec.readUByte();
        int bin = this.binaryCodec.readUShort();
        int cigarLen = this.binaryCodec.readUShort();
        int flags = this.binaryCodec.readUShort();
        int readLen = this.binaryCodec.readInt();
        int mateReferenceID = this.binaryCodec.readInt();
        int mateCoordinate = this.binaryCodec.readInt() + 1;
        int insertSize = this.binaryCodec.readInt();
        byte[] restOfRecord = new byte[recordLength - 32];
        this.binaryCodec.readBytes(restOfRecord);
        BAMRecord ret = this.samRecordFactory.createBAMRecord(this.header, referenceID, coordinate, readNameLength, mappingQuality, bin, cigarLen, flags, readLen, mateReferenceID, mateCoordinate, insertSize, restOfRecord);
        ret.setHeader(this.header);
        return ret;
    }
}

