/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Assembly;
import edu.unc.genomics.AssemblyManager;
import edu.unc.genomics.AssemblyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.DataFormatException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class AssemblyManagerDialog
extends JDialog {
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 500;
    private static final long serialVersionUID = -1461628562713621064L;
    private static final Logger log = Logger.getLogger(AssemblyManagerDialog.class);
    private final JPanel contentPanel = new JPanel();
    private final JFileChooser fcCustomAssembly = new JFileChooser();
    private final JTable assembliesTable = new JTable();
    private AssemblyTableModel model;

    public AssemblyManagerDialog(JFrame parent) {
        super(parent, "Assembly Manager", true);
        this.setSize(400, 500);
        int centeredX = parent.getX() + (parent.getWidth() - this.getWidth()) / 2;
        int centeredY = parent.getY() + (parent.getHeight() - this.getHeight()) / 2;
        this.setLocation(centeredX, centeredY);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.model = new AssemblyTableModel(AssemblyManager.getAvailableAssemblies());
        this.assembliesTable.setModel(this.model);
        this.assembliesTable.setRowSelectionAllowed(true);
        JScrollPane scrollPane = new JScrollPane(this.assembliesTable);
        this.assembliesTable.setFillsViewportHeight(true);
        this.contentPanel.add(scrollPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton removeAssemblyButton = new JButton("Remove");
        removeAssemblyButton.setActionCommand("RemoveAssembly");
        removeAssemblyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssemblyManagerDialog.this.removeCustomAssembly();
            }
        });
        buttonPane.add(removeAssemblyButton);
        JButton loadAssemblyButton = new JButton("Load Custom Assembly");
        loadAssemblyButton.setActionCommand("LoadAssembly");
        loadAssemblyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssemblyManagerDialog.this.loadCustomAssembly();
            }
        });
        buttonPane.add(loadAssemblyButton);
        JButton doneButton = new JButton("Done");
        doneButton.setActionCommand("Done");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssemblyManagerDialog.this.closeDialog();
            }
        });
        buttonPane.add(doneButton);
        this.getRootPane().setDefaultButton(doneButton);
    }

    private void removeCustomAssembly() {
        for (int row : this.assembliesTable.getSelectedRows()) {
            try {
                Assembly a = this.model.getRow(row);
                AssemblyManager.deleteAssembly(a);
                this.model.removeRow(row);
            }
            catch (IOException e) {
                log.error((Object)"Error deleting Assembly");
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error deleting assembly", "Assembly Manager Error", 0);
            }
        }
    }

    private void loadCustomAssembly() {
        int returnVal = this.fcCustomAssembly.showOpenDialog(this);
        if (returnVal == 0) {
            Path assemblyFile = this.fcCustomAssembly.getSelectedFile().toPath();
            try {
                Assembly a = AssemblyManager.loadCustomAssembly(assemblyFile);
                this.model.addAssembly(a);
            }
            catch (IOException | DataFormatException e) {
                log.error((Object)("Error loading custom assembly: " + assemblyFile));
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading custom assembly", "Assembly Manager Error", 0);
            }
        }
    }

    private void closeDialog() {
        this.dispose();
    }
}

