/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

public class FloatHistogram {
    int[] bins = null;
    int nBins;
    float xLow;
    float xHigh;
    float delBin;
    int overFlows = 0;
    int underFlows = 0;

    public FloatHistogram(int nBins, float xLow, float xHigh) {
        this.nBins = nBins;
        this.xLow = xLow;
        this.xHigh = xHigh;
        this.bins = new int[nBins];
        this.delBin = (xHigh - xLow) / (float)nBins;
        this.reset();
    }

    public FloatHistogram(int nBins, double xLow, double xHigh) {
        this(nBins, (float)xLow, (float)xHigh);
    }

    public void addValue(double data) {
        this.addValue((float)data);
    }

    public void addValue(float data) {
        if (data < this.xLow) {
            ++this.underFlows;
        } else if (data >= this.xHigh) {
            ++this.overFlows;
        } else {
            int bin = (int)((data - this.xLow) / this.delBin);
            if (bin >= 0 && bin < this.nBins) {
                int n = bin;
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public int[] getHistogram() {
        return this.bins;
    }

    public float getBinSize() {
        return this.delBin;
    }

    public void reset() {
        for (int i = 0; i < this.nBins; ++i) {
            this.bins[i] = 0;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.bins.length; ++i) {
            sb.append(this.xLow + (float)i * this.delBin + "\t" + this.bins[i] + "\n");
        }
        return sb.toString();
    }
}

