/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.visitor;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.visitor.AbstractDocumentIteratorVisitor;
import java.io.IOException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermCollectionVisitor
extends AbstractDocumentIteratorVisitor {
    private static final Logger LOGGER = Logger.getLogger(TermCollectionVisitor.class);
    private static final boolean DEBUG = false;
    private final Reference2ObjectMap<Index, Object2IntMap<String>> index2termMap = new Reference2ObjectOpenHashMap();
    private int numberOfPairs;
    private Index[] index;
    private Reference2IntMap<Index> indexMap = new Reference2IntLinkedOpenHashMap(16, 0.5f);

    @Override
    public TermCollectionVisitor prepare() {
        this.index = null;
        this.index2termMap.clear();
        this.indexMap.clear();
        this.numberOfPairs = 0;
        return this;
    }

    @Override
    public boolean visit(IndexIterator indexIterator) throws IOException {
        if (indexIterator.frequency() > 0 && indexIterator.index().hasCounts) {
            Object2IntMap termMap;
            Index index = indexIterator.index();
            String term = indexIterator.term();
            if (term == null) {
                throw new NullPointerException("This visitor needs a non-null term for each index iterator of nonzero frequency");
            }
            if (!this.indexMap.containsKey((Object)index)) {
                this.indexMap.put((Object)index, this.indexMap.size());
                termMap = new Object2IntLinkedOpenHashMap(16, 0.5f);
                this.index2termMap.put((Object)index, (Object)termMap);
                termMap.defaultReturnValue(-1);
            } else {
                termMap = (Object2IntMap)this.index2termMap.get((Object)index);
            }
            int offset = termMap.getInt((Object)term);
            if (offset == -1) {
                offset = this.numberOfPairs++;
                termMap.put((Object)term, offset);
            }
            indexIterator.id(offset);
        }
        return true;
    }

    public int numberOfPairs() {
        return this.numberOfPairs;
    }

    public Index[] indices() {
        if (this.index == null) {
            this.index = (Index[])this.indexMap.keySet().toArray((Object[])new Index[this.index2termMap.size()]);
        }
        return this.index;
    }

    public Reference2IntMap<Index> indexMap() {
        return this.indexMap;
    }

    public String[] terms(Index index) {
        Object2IntMap termMap = (Object2IntMap)this.index2termMap.get((Object)index);
        return termMap == null ? null : (String[])termMap.keySet().toArray((Object[])new String[termMap.size()]);
    }

    public int offset(Index index, String term) {
        return ((Object2IntMap)this.index2termMap.get((Object)index)).getInt((Object)term);
    }

    public String toString() {
        return "[Leaves: " + this.numberOfPairs + "; " + this.index2termMap + "]";
    }
}

