/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.Future;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class DoubleFFT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private DoubleFFT_1D fftColumns;
    private DoubleFFT_1D fftRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleFFT_2D(long l, long l2) {
        if (l <= 1L || l2 <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)l;
        this.columns = (int)l2;
        this.rowsl = l;
        this.columnsl = l2;
        if (l * l2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2)) {
            this.isPowerOfTwo = true;
        }
        long l3 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(l, l2));
        }
        this.fftRows = new DoubleFFT_1D(l);
        this.fftColumns = l == l2 ? this.fftRows : new DoubleFFT_1D(l2);
        ConcurrencyUtils.setLargeArraysBeginN(l3);
    }

    public void complexForward(final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, dArray, true);
                this.cdft2d_subth(-1, dArray, true);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(dArray, i * this.columns);
                }
                this.cdft2d_sub(-1, dArray, true);
            }
            this.columns /= 2;
        } else {
            final int n2 = 2 * this.columns;
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                DoubleFFT_2D.this.fftColumns.complexForward(dArray, i * n2);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.columns / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.columns : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_2D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n;
                                int n22;
                                int n32;
                                int n42 = 2 * i;
                                for (n32 = 0; n32 < DoubleFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    dArray2[n22] = dArray[n];
                                    dArray2[n22 + 1] = dArray[n + 1];
                                }
                                DoubleFFT_2D.this.fftRows.complexForward(dArray2);
                                for (n32 = 0; n32 < DoubleFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    dArray[n] = dArray2[n22];
                                    dArray[n + 1] = dArray2[n22 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(dArray, i * n2);
                }
                double[] dArray2 = new double[2 * this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n7;
                    int n8;
                    int n9;
                    int n10 = 2 * i;
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        dArray2[n8] = dArray[n7];
                        dArray2[n8 + 1] = dArray[n7 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        dArray[n7] = dArray2[n8];
                        dArray[n7 + 1] = dArray2[n8 + 1];
                    }
                }
            }
        }
    }

    public void complexForward(final DoubleLargeArray doubleLargeArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columnsl = 2L * this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0L, -1, doubleLargeArray, true);
                this.cdft2d_subth(-1, doubleLargeArray, true);
            } else {
                int n2 = 0;
                while ((long)n2 < this.rowsl) {
                    this.fftColumns.complexForward(doubleLargeArray, (long)n2 * this.columnsl);
                    ++n2;
                }
                this.cdft2d_sub(-1, doubleLargeArray, true);
            }
            this.columnsl /= 2L;
        } else {
            final long l = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l2;
                long l3;
                int n3;
                Future[] futureArray = new Future[n];
                long l4 = this.rowsl / (long)n;
                for (n3 = 0; n3 < n; ++n3) {
                    l3 = (long)n3 * l4;
                    l2 = n3 == n - 1 ? this.rowsl : l3 + l4;
                    futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l3; i < l2; ++i) {
                                DoubleFFT_2D.this.fftColumns.complexForward(doubleLargeArray, i * l);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l4 = this.columnsl / (long)n;
                for (n3 = 0; n3 < n; ++n3) {
                    l3 = (long)n3 * l4;
                    l2 = n3 == n - 1 ? this.columnsl : l3 + l4;
                    futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_2D.this.rowsl, false);
                            for (long i = l3; i < l2; ++i) {
                                long l5;
                                long l22;
                                long l32;
                                long l4 = 2L * i;
                                for (l32 = 0L; l32 < DoubleFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l5));
                                    doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                                }
                                DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2);
                                for (l32 = 0L; l32 < DoubleFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l22));
                                    doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.complexForward(doubleLargeArray, i * l);
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.rowsl, false);
                for (long i = 0L; i < this.columnsl; ++i) {
                    long l5;
                    long l6;
                    long l7;
                    long l8 = 2L * i;
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l5));
                        doubleLargeArray2.setDouble(l6 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                    }
                    this.fftRows.complexForward(doubleLargeArray2);
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l6));
                        doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l6 + 1L));
                    }
                }
            }
        }
    }

    public void complexForward(final double[][] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, dArray, true);
                this.cdft2d_subth(-1, dArray, true);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(dArray[i]);
                }
                this.cdft2d_sub(-1, dArray, true);
            }
            this.columns /= 2;
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            DoubleFFT_2D.this.fftColumns.complexForward(dArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            int n22;
                            int n32 = 2 * i;
                            for (n22 = 0; n22 < DoubleFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                dArray2[n] = dArray[n22][n32];
                                dArray2[n + 1] = dArray[n22][n32 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(dArray2);
                            for (n22 = 0; n22 < DoubleFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                dArray[n22][n32] = dArray2[n];
                                dArray[n22][n32 + 1] = dArray2[n + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.complexForward(dArray[i]);
            }
            double[] dArray2 = new double[2 * this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                int n7;
                int n8 = 2 * i;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    dArray2[n6] = dArray[n7][n8];
                    dArray2[n6 + 1] = dArray[n7][n8 + 1];
                }
                this.fftRows.complexForward(dArray2);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    dArray[n7][n8] = dArray2[n6];
                    dArray[n7][n8 + 1] = dArray2[n6 + 1];
                }
            }
        }
    }

    public void complexInverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, dArray, bl);
                this.cdft2d_subth(1, dArray, bl);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(dArray, i * this.columns, bl);
                }
                this.cdft2d_sub(1, dArray, bl);
            }
            this.columns /= 2;
        } else {
            final int n2 = 2 * this.columns;
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(dArray, i * n2, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.columns / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.columns : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_2D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n;
                                int n22;
                                int n32;
                                int n42 = 2 * i;
                                for (n32 = 0; n32 < DoubleFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    dArray2[n22] = dArray[n];
                                    dArray2[n22 + 1] = dArray[n + 1];
                                }
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, bl);
                                for (n32 = 0; n32 < DoubleFFT_2D.this.rows; ++n32) {
                                    n22 = 2 * n32;
                                    n = n32 * n2 + n42;
                                    dArray[n] = dArray2[n22];
                                    dArray[n + 1] = dArray2[n22 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(dArray, i * n2, bl);
                }
                double[] dArray2 = new double[2 * this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n7;
                    int n8;
                    int n9;
                    int n10 = 2 * i;
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        dArray2[n8] = dArray[n7];
                        dArray2[n8 + 1] = dArray[n7 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n9 = 0; n9 < this.rows; ++n9) {
                        n8 = 2 * n9;
                        n7 = n9 * n2 + n10;
                        dArray[n7] = dArray2[n8];
                        dArray[n7 + 1] = dArray2[n8 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columnsl = 2L * this.columnsl;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0L, 1, doubleLargeArray, bl);
                this.cdft2d_subth(1, doubleLargeArray, bl);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.complexInverse(doubleLargeArray, i * this.columnsl, bl);
                }
                this.cdft2d_sub(1, doubleLargeArray, bl);
            }
            this.columnsl /= 2L;
        } else {
            final long l = 2L * this.columnsl;
            if (n > 1 && this.useThreads && this.rowsl >= (long)n && this.columnsl >= (long)n) {
                long l2;
                long l3;
                int n2;
                Future[] futureArray = new Future[n];
                long l4 = this.rowsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l3 = (long)n2 * l4;
                    l2 = n2 == n - 1 ? this.rowsl : l3 + l4;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l3; i < l2; ++i) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(doubleLargeArray, i * l, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                l4 = this.columnsl / (long)n;
                for (n2 = 0; n2 < n; ++n2) {
                    l3 = (long)n2 * l4;
                    l2 = n2 == n - 1 ? this.columnsl : l3 + l4;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * DoubleFFT_2D.this.rowsl, false);
                            for (long i = l3; i < l2; ++i) {
                                long l5;
                                long l22;
                                long l32;
                                long l4 = 2L * i;
                                for (l32 = 0L; l32 < DoubleFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    doubleLargeArray2.setDouble(l22, doubleLargeArray.getDouble(l5));
                                    doubleLargeArray2.setDouble(l22 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                                }
                                DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, bl);
                                for (l32 = 0L; l32 < DoubleFFT_2D.this.rowsl; ++l32) {
                                    l22 = 2L * l32;
                                    l5 = l32 * l + l4;
                                    doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l22));
                                    doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l22 + 1L));
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.complexInverse(doubleLargeArray, i * l, bl);
                }
                DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(2L * this.rowsl, false);
                for (long i = 0L; i < this.columnsl; ++i) {
                    long l5;
                    long l6;
                    long l7;
                    long l8 = 2L * i;
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        doubleLargeArray2.setDouble(l6, doubleLargeArray.getDouble(l5));
                        doubleLargeArray2.setDouble(l6 + 1L, doubleLargeArray.getDouble(l5 + 1L));
                    }
                    this.fftRows.complexInverse(doubleLargeArray2, bl);
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = 2L * l7;
                        l5 = l7 * l + l8;
                        doubleLargeArray.setDouble(l5, doubleLargeArray2.getDouble(l6));
                        doubleLargeArray.setDouble(l5 + 1L, doubleLargeArray2.getDouble(l6 + 1L));
                    }
                }
            }
        }
    }

    public void complexInverse(final double[][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            this.columns = 2 * this.columns;
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, dArray, bl);
                this.cdft2d_subth(1, dArray, bl);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(dArray[i], bl);
                }
                this.cdft2d_sub(1, dArray, bl);
            }
            this.columns /= 2;
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            DoubleFFT_2D.this.fftColumns.complexInverse(dArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.columns / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.columns : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_2D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n;
                            int n22;
                            int n32 = 2 * i;
                            for (n22 = 0; n22 < DoubleFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                dArray2[n] = dArray[n22][n32];
                                dArray2[n + 1] = dArray[n22][n32 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, bl);
                            for (n22 = 0; n22 < DoubleFFT_2D.this.rows; ++n22) {
                                n = 2 * n22;
                                dArray[n22][n32] = dArray2[n];
                                dArray[n22][n32 + 1] = dArray2[n + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.complexInverse(dArray[i], bl);
            }
            double[] dArray2 = new double[2 * this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n6;
                int n7;
                int n8 = 2 * i;
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    dArray2[n6] = dArray[n7][n8];
                    dArray2[n6 + 1] = dArray[n7][n8 + 1];
                }
                this.fftRows.complexInverse(dArray2, bl);
                for (n7 = 0; n7 < this.rows; ++n7) {
                    n6 = 2 * n7;
                    dArray[n7][n8] = dArray2[n6];
                    dArray[n7][n8 + 1] = dArray2[n6 + 1];
                }
            }
        }
    }

    public void realForward(double[] dArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realForward(dArray, i * this.columns);
            }
            this.cdft2d_sub(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        }
    }

    public void realForward(DoubleLargeArray doubleLargeArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1L, 1, doubleLargeArray, true);
            this.cdft2d_subth(-1, doubleLargeArray, true);
            this.rdft2d_sub(1, doubleLargeArray);
        } else {
            for (long i = 0L; i < this.rowsl; ++i) {
                this.fftColumns.realForward(doubleLargeArray, i * this.columnsl);
            }
            this.cdft2d_sub(-1, doubleLargeArray, true);
            this.rdft2d_sub(1, doubleLargeArray);
        }
    }

    public void realForward(double[][] dArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, dArray, true);
            this.cdft2d_subth(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realForward(dArray[i]);
            }
            this.cdft2d_sub(-1, dArray, true);
            this.rdft2d_sub(1, dArray);
        }
    }

    public void realForwardFull(double[] dArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, dArray, true);
                this.cdft2d_subth(-1, dArray, true);
                this.rdft2d_sub(1, dArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realForward(dArray, i * this.columns);
                }
                this.cdft2d_sub(-1, dArray, true);
                this.rdft2d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealForwardFull(dArray);
        }
    }

    public void realForwardFull(DoubleLargeArray doubleLargeArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1L, 1, doubleLargeArray, true);
                this.cdft2d_subth(-1, doubleLargeArray, true);
                this.rdft2d_sub(1, doubleLargeArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.realForward(doubleLargeArray, i * this.columnsl);
                }
                this.cdft2d_sub(-1, doubleLargeArray, true);
                this.rdft2d_sub(1, doubleLargeArray);
            }
            this.fillSymmetric(doubleLargeArray);
        } else {
            this.mixedRadixRealForwardFull(doubleLargeArray);
        }
    }

    public void realForwardFull(double[][] dArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, dArray, true);
                this.cdft2d_subth(-1, dArray, true);
                this.rdft2d_sub(1, dArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realForward(dArray[i]);
                }
                this.cdft2d_sub(-1, dArray, true);
                this.rdft2d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealForwardFull(dArray);
        }
    }

    public void realInverse(double[] dArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_subth(1, dArray, bl);
            this.xdft2d0_subth1(1, -1, dArray, bl);
        } else {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_sub(1, dArray, bl);
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realInverse(dArray, i * this.columns, bl);
            }
        }
    }

    public void realInverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, doubleLargeArray);
            this.cdft2d_subth(1, doubleLargeArray, bl);
            this.xdft2d0_subth1(1L, -1, doubleLargeArray, bl);
        } else {
            this.rdft2d_sub(-1, doubleLargeArray);
            this.cdft2d_sub(1, doubleLargeArray, bl);
            for (long i = 0L; i < this.rowsl; ++i) {
                this.fftColumns.realInverse(doubleLargeArray, i * this.columnsl, bl);
            }
        }
    }

    public void realInverse(double[][] dArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_subth(1, dArray, bl);
            this.xdft2d0_subth1(1, -1, dArray, bl);
        } else {
            this.rdft2d_sub(-1, dArray);
            this.cdft2d_sub(1, dArray, bl);
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realInverse(dArray[i], bl);
            }
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, dArray, bl);
                this.cdft2d_subth(1, dArray, bl);
                this.rdft2d_sub(1, dArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realInverse2(dArray, i * this.columns, bl);
                }
                this.cdft2d_sub(1, dArray, bl);
                this.rdft2d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealInverseFull(dArray, bl);
        }
    }

    public void realInverseFull(DoubleLargeArray doubleLargeArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1L, -1, doubleLargeArray, bl);
                this.cdft2d_subth(1, doubleLargeArray, bl);
                this.rdft2d_sub(1, doubleLargeArray);
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.fftColumns.realInverse2(doubleLargeArray, i * this.columnsl, bl);
                }
                this.cdft2d_sub(1, doubleLargeArray, bl);
                this.rdft2d_sub(1, doubleLargeArray);
            }
            this.fillSymmetric(doubleLargeArray);
        } else {
            this.mixedRadixRealInverseFull(doubleLargeArray, bl);
        }
    }

    public void realInverseFull(double[][] dArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, dArray, bl);
                this.cdft2d_subth(1, dArray, bl);
                this.rdft2d_sub(1, dArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realInverse2(dArray[i], 0, bl);
                }
                this.cdft2d_sub(1, dArray, bl);
                this.rdft2d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealInverseFull(dArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final double[][] dArray) {
        final int n = this.columns / 2 + 1;
        final double[][] dArray2 = new double[n][2 * this.rows];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.useThreads && this.rows >= n2 && n - 2 >= n2) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n2];
            int n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            DoubleFFT_2D.this.fftColumns.realForward(dArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < this.rows; ++n5) {
                dArray2[0][n5] = dArray[n5][0];
            }
            this.fftRows.realForwardFull(dArray2[0]);
            n6 = (n - 2) / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? n - 1 : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < DoubleFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                dArray2[i][n2] = dArray[j][n];
                                dArray2[i][n2 + 1] = dArray[j][n + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(dArray2[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    dArray2[n - 1][n5] = dArray[n5][1];
                }
                this.fftRows.realForwardFull(dArray2[n - 1]);
            } else {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    n3 = n - 1;
                    dArray2[n3][n4] = dArray[n5][2 * n3];
                    dArray2[n3][n4 + 1] = dArray[n5][1];
                }
                this.fftRows.complexForward(dArray2[n - 1]);
            }
            n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = 2 * i;
                            for (int j = 0; j < n; ++j) {
                                int n2 = 2 * j;
                                dArray[i][n2] = dArray2[j][n5];
                                dArray[i][n2 + 1] = dArray2[j][n5 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = DoubleFFT_2D.this.rows - i;
                            for (int j = n; j < DoubleFFT_2D.this.columns; ++j) {
                                int n2 = 2 * j;
                                int n32 = 2 * (DoubleFFT_2D.this.columns - j);
                                dArray[0][n2] = dArray[0][n32];
                                dArray[0][n2 + 1] = -dArray[0][n32 + 1];
                                dArray[i][n2] = dArray[n5][n32];
                                dArray[i][n2 + 1] = -dArray[n5][n32 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = 0; n10 < this.rows; ++n10) {
                this.fftColumns.realForward(dArray[n10]);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                dArray2[0][n10] = dArray[n10][0];
            }
            this.fftRows.realForwardFull(dArray2[0]);
            for (n10 = 1; n10 < n - 1; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    dArray2[n10][n7] = dArray[n8][n9];
                    dArray2[n10][n7 + 1] = dArray[n8][n9 + 1];
                }
                this.fftRows.complexForward(dArray2[n10]);
            }
            if (this.columns % 2 == 0) {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    dArray2[n - 1][n10] = dArray[n10][1];
                }
                this.fftRows.realForwardFull(dArray2[n - 1]);
            } else {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = 2 * n10;
                    n8 = n - 1;
                    dArray2[n8][n9] = dArray[n10][2 * n8];
                    dArray2[n8][n9 + 1] = dArray[n10][1];
                }
                this.fftRows.complexForward(dArray2[n - 1]);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < n; ++n8) {
                    n7 = 2 * n8;
                    dArray[n10][n7] = dArray2[n8][n9];
                    dArray[n10][n7 + 1] = dArray2[n8][n9 + 1];
                }
            }
            for (n10 = 1; n10 < this.rows; ++n10) {
                n9 = this.rows - n10;
                for (n8 = n; n8 < this.columns; ++n8) {
                    n7 = 2 * n8;
                    int n11 = 2 * (this.columns - n8);
                    dArray[0][n7] = dArray[0][n11];
                    dArray[0][n7 + 1] = -dArray[0][n11 + 1];
                    dArray[n10][n7] = dArray[n9][n11];
                    dArray[n10][n7 + 1] = -dArray[n9][n11 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final double[] dArray) {
        final int n = 2 * this.columns;
        final int n2 = this.columns / 2 + 1;
        final double[][] dArray2 = new double[n2][2 * this.rows];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && this.rows >= n3 && n2 - 2 >= n3) {
            int n4;
            int n5;
            int n6;
            Future[] futureArray = new Future[n3];
            int n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            DoubleFFT_2D.this.fftColumns.realForward(dArray, i * DoubleFFT_2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < this.rows; ++n6) {
                dArray2[0][n6] = dArray[n6 * this.columns];
            }
            this.fftRows.realForwardFull(dArray2[0]);
            n7 = (n2 - 2) / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? n2 - 1 : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < DoubleFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                int n3 = j * DoubleFFT_2D.this.columns + n;
                                dArray2[i][n2] = dArray[n3];
                                dArray2[i][n2 + 1] = dArray[n3 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(dArray2[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n2 - 1][n6] = dArray[n6 * this.columns + 1];
                }
                this.fftRows.realForwardFull(dArray2[n2 - 1]);
            } else {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    n4 = n6 * this.columns;
                    int n8 = n2 - 1;
                    dArray2[n8][n5] = dArray[n4 + 2 * n8];
                    dArray2[n8][n5 + 1] = dArray[n4 + 1];
                }
                this.fftRows.complexForward(dArray2[n2 - 1]);
            }
            n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n6 = 2 * i;
                            for (int j = 0; j < n2; ++j) {
                                int n22 = 2 * j;
                                int n3 = i * n + n22;
                                dArray[n3] = dArray2[j][n6];
                                dArray[n3 + 1] = dArray2[j][n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n7 = i * n;
                            int n22 = (DoubleFFT_2D.this.rows - i + 1) * n;
                            for (int j = n2; j < DoubleFFT_2D.this.columns; ++j) {
                                int n3 = 2 * j;
                                int n42 = 2 * (DoubleFFT_2D.this.columns - j);
                                dArray[n3] = dArray[n42];
                                dArray[n3 + 1] = -dArray[n42 + 1];
                                int n52 = n7 + n3;
                                int n6 = n22 - n3;
                                dArray[n52] = dArray[n6];
                                dArray[n52 + 1] = -dArray[n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.fftColumns.realForward(dArray, n13 * this.columns);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                dArray2[0][n13] = dArray[n13 * this.columns];
            }
            this.fftRows.realForwardFull(dArray2[0]);
            for (n13 = 1; n13 < n2 - 1; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    n9 = n11 * this.columns + n12;
                    dArray2[n13][n10] = dArray[n9];
                    dArray2[n13][n10 + 1] = dArray[n9 + 1];
                }
                this.fftRows.complexForward(dArray2[n13]);
            }
            if (this.columns % 2 == 0) {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    dArray2[n2 - 1][n13] = dArray[n13 * this.columns + 1];
                }
                this.fftRows.realForwardFull(dArray2[n2 - 1]);
            } else {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = 2 * n13;
                    n11 = n13 * this.columns;
                    n10 = n2 - 1;
                    dArray2[n10][n12] = dArray[n11 + 2 * n10];
                    dArray2[n10][n12 + 1] = dArray[n11 + 1];
                }
                this.fftRows.complexForward(dArray2[n2 - 1]);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = 2 * n11;
                    n9 = n13 * n + n10;
                    dArray[n9] = dArray2[n11][n12];
                    dArray[n9 + 1] = dArray2[n11][n12 + 1];
                }
            }
            for (n13 = 1; n13 < this.rows; ++n13) {
                n12 = n13 * n;
                n11 = (this.rows - n13 + 1) * n;
                for (n10 = n2; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    int n14 = 2 * (this.columns - n10);
                    dArray[n9] = dArray[n14];
                    dArray[n9 + 1] = -dArray[n14 + 1];
                    int n15 = n12 + n9;
                    int n16 = n11 - n9;
                    dArray[n15] = dArray[n16];
                    dArray[n15 + 1] = -dArray[n16 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final DoubleLargeArray doubleLargeArray) {
        final long l = 2L * this.columnsl;
        final long l2 = this.columnsl / 2L + 1L;
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2 * 2L * this.rowsl, false);
        final long l3 = 2L * this.rowsl;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && this.rowsl >= (long)n && l2 - 2L >= (long)n) {
            int n2;
            long l4;
            long l5;
            long l6;
            Future[] futureArray = new Future[n];
            long l7 = this.rowsl / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = (long)i * l7;
                l5 = i == n - 1 ? this.rowsl : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            DoubleFFT_2D.this.fftColumns.realForward(doubleLargeArray, i * DoubleFFT_2D.this.columnsl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (long i = 0L; i < this.rowsl; ++i) {
                doubleLargeArray2.setDouble(i, doubleLargeArray.getDouble(i * this.columnsl));
            }
            this.fftRows.realForwardFull(doubleLargeArray2);
            l7 = (l2 - 2L) / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = 1L + (long)i * l7;
                l5 = i == n - 1 ? l2 - 1L : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l = 2L * i;
                            for (long j = 0L; j < DoubleFFT_2D.this.rowsl; ++j) {
                                long l2 = 2L * j;
                                long l32 = j * DoubleFFT_2D.this.columnsl + l;
                                doubleLargeArray2.setDouble(i * l3 + l2, doubleLargeArray.getDouble(l32));
                                doubleLargeArray2.setDouble(i * l3 + l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, i * l3);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columnsl % 2L == 0L) {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    doubleLargeArray2.setDouble((l2 - 1L) * l3 + l4, doubleLargeArray.getDouble(l4 * this.columnsl + 1L));
                }
                this.fftRows.realForwardFull(doubleLargeArray2, (l2 - 1L) * l3);
            } else {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    long l8 = 2L * l4;
                    long l9 = l4 * this.columnsl;
                    long l10 = l2 - 1L;
                    doubleLargeArray2.setDouble(l10 * l3 + l8, doubleLargeArray.getDouble(l9 + 2L * l10));
                    doubleLargeArray2.setDouble(l10 * l3 + l8 + 1L, doubleLargeArray.getDouble(l9 + 1L));
                }
                this.fftRows.complexForward(doubleLargeArray2, (l2 - 1L) * l3);
            }
            l7 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l6 = (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l4 = 2L * i;
                            for (long j = 0L; j < l2; ++j) {
                                long l22 = 2L * j;
                                long l32 = i * l + l22;
                                doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(j * l3 + l4));
                                doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(j * l3 + l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l6 = 1L + (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l7 = i * l;
                            long l22 = (DoubleFFT_2D.this.rowsl - i + 1L) * l;
                            for (long j = l2; j < DoubleFFT_2D.this.columnsl; ++j) {
                                long l3 = 2L * j;
                                long l4 = 2L * (DoubleFFT_2D.this.columnsl - j);
                                doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l4));
                                doubleLargeArray.setDouble(l3 + 1L, -doubleLargeArray.getDouble(l4 + 1L));
                                long l52 = l7 + l3;
                                long l62 = l22 - l3;
                                doubleLargeArray.setDouble(l52, doubleLargeArray.getDouble(l62));
                                doubleLargeArray.setDouble(l52 + 1L, -doubleLargeArray.getDouble(l62 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l11;
            long l12;
            long l13;
            long l14;
            long l15;
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                this.fftColumns.realForward(doubleLargeArray, l15 * this.columnsl);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                doubleLargeArray2.setDouble(l15, doubleLargeArray.getDouble(l15 * this.columnsl));
            }
            this.fftRows.realForwardFull(doubleLargeArray2);
            for (l15 = 1L; l15 < l2 - 1L; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < this.rowsl; ++l13) {
                    l12 = 2L * l13;
                    l11 = l13 * this.columnsl + l14;
                    doubleLargeArray2.setDouble(l15 * l3 + l12, doubleLargeArray.getDouble(l11));
                    doubleLargeArray2.setDouble(l15 * l3 + l12 + 1L, doubleLargeArray.getDouble(l11 + 1L));
                }
                this.fftRows.complexForward(doubleLargeArray2, l15 * l3);
            }
            if (this.columnsl % 2L == 0L) {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    doubleLargeArray2.setDouble((l2 - 1L) * l3 + l15, doubleLargeArray.getDouble(l15 * this.columnsl + 1L));
                }
                this.fftRows.realForwardFull(doubleLargeArray2, (l2 - 1L) * l3);
            } else {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    l14 = 2L * l15;
                    l13 = l15 * this.columnsl;
                    l12 = l2 - 1L;
                    doubleLargeArray2.setDouble(l12 * l3 + l14, doubleLargeArray.getDouble(l13 + 2L * l12));
                    doubleLargeArray2.setDouble(l12 * l3 + l14 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                }
                this.fftRows.complexForward(doubleLargeArray2, (l2 - 1L) * l3);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < l2; ++l13) {
                    l12 = 2L * l13;
                    l11 = l15 * l + l12;
                    doubleLargeArray.setDouble(l11, doubleLargeArray2.getDouble(l13 * l3 + l14));
                    doubleLargeArray.setDouble(l11 + 1L, doubleLargeArray2.getDouble(l13 * l3 + l14 + 1L));
                }
            }
            for (l15 = 1L; l15 < this.rowsl; ++l15) {
                l14 = l15 * l;
                l13 = (this.rowsl - l15 + 1L) * l;
                for (l12 = l2; l12 < this.columnsl; ++l12) {
                    l11 = 2L * l12;
                    long l16 = 2L * (this.columnsl - l12);
                    doubleLargeArray.setDouble(l11, doubleLargeArray.getDouble(l16));
                    doubleLargeArray.setDouble(l11 + 1L, -doubleLargeArray.getDouble(l16 + 1L));
                    long l17 = l14 + l11;
                    long l18 = l13 - l11;
                    doubleLargeArray.setDouble(l17, doubleLargeArray.getDouble(l18));
                    doubleLargeArray.setDouble(l17 + 1L, -doubleLargeArray.getDouble(l18 + 1L));
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[][] dArray, final boolean bl) {
        final int n = this.columns / 2 + 1;
        final double[][] dArray2 = new double[n][2 * this.rows];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.useThreads && this.rows >= n2 && n - 2 >= n2) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n2];
            int n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            DoubleFFT_2D.this.fftColumns.realInverse2(dArray[i], 0, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < this.rows; ++n5) {
                dArray2[0][n5] = dArray[n5][0];
            }
            this.fftRows.realInverseFull(dArray2[0], bl);
            n6 = (n - 2) / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? n - 1 : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < DoubleFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                dArray2[i][n2] = dArray[j][n];
                                dArray2[i][n2 + 1] = dArray[j][n + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    dArray2[n - 1][n5] = dArray[n5][1];
                }
                this.fftRows.realInverseFull(dArray2[n - 1], bl);
            } else {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    n3 = n - 1;
                    dArray2[n3][n4] = dArray[n5][2 * n3];
                    dArray2[n3][n4 + 1] = dArray[n5][1];
                }
                this.fftRows.complexInverse(dArray2[n - 1], bl);
            }
            n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = 2 * i;
                            for (int j = 0; j < n; ++j) {
                                int n2 = 2 * j;
                                dArray[i][n2] = dArray2[j][n5];
                                dArray[i][n2 + 1] = dArray2[j][n5 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = DoubleFFT_2D.this.rows - i;
                            for (int j = n; j < DoubleFFT_2D.this.columns; ++j) {
                                int n2 = 2 * j;
                                int n32 = 2 * (DoubleFFT_2D.this.columns - j);
                                dArray[0][n2] = dArray[0][n32];
                                dArray[0][n2 + 1] = -dArray[0][n32 + 1];
                                dArray[i][n2] = dArray[n5][n32];
                                dArray[i][n2 + 1] = -dArray[n5][n32 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = 0; n10 < this.rows; ++n10) {
                this.fftColumns.realInverse2(dArray[n10], 0, bl);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                dArray2[0][n10] = dArray[n10][0];
            }
            this.fftRows.realInverseFull(dArray2[0], bl);
            for (n10 = 1; n10 < n - 1; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    dArray2[n10][n7] = dArray[n8][n9];
                    dArray2[n10][n7 + 1] = dArray[n8][n9 + 1];
                }
                this.fftRows.complexInverse(dArray2[n10], bl);
            }
            if (this.columns % 2 == 0) {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    dArray2[n - 1][n10] = dArray[n10][1];
                }
                this.fftRows.realInverseFull(dArray2[n - 1], bl);
            } else {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = 2 * n10;
                    n8 = n - 1;
                    dArray2[n8][n9] = dArray[n10][2 * n8];
                    dArray2[n8][n9 + 1] = dArray[n10][1];
                }
                this.fftRows.complexInverse(dArray2[n - 1], bl);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < n; ++n8) {
                    n7 = 2 * n8;
                    dArray[n10][n7] = dArray2[n8][n9];
                    dArray[n10][n7 + 1] = dArray2[n8][n9 + 1];
                }
            }
            for (n10 = 1; n10 < this.rows; ++n10) {
                n9 = this.rows - n10;
                for (n8 = n; n8 < this.columns; ++n8) {
                    n7 = 2 * n8;
                    int n11 = 2 * (this.columns - n8);
                    dArray[0][n7] = dArray[0][n11];
                    dArray[0][n7 + 1] = -dArray[0][n11 + 1];
                    dArray[n10][n7] = dArray[n9][n11];
                    dArray[n10][n7 + 1] = -dArray[n9][n11 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[] dArray, final boolean bl) {
        final int n = 2 * this.columns;
        final int n2 = this.columns / 2 + 1;
        final double[][] dArray2 = new double[n2][2 * this.rows];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && this.rows >= n3 && n2 - 2 >= n3) {
            int n4;
            int n5;
            int n6;
            Future[] futureArray = new Future[n3];
            int n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            DoubleFFT_2D.this.fftColumns.realInverse2(dArray, i * DoubleFFT_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < this.rows; ++n6) {
                dArray2[0][n6] = dArray[n6 * this.columns];
            }
            this.fftRows.realInverseFull(dArray2[0], bl);
            n7 = (n2 - 2) / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? n2 - 1 : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < DoubleFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                int n3 = j * DoubleFFT_2D.this.columns + n;
                                dArray2[i][n2] = dArray[n3];
                                dArray2[i][n2 + 1] = dArray[n3 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    dArray2[n2 - 1][n6] = dArray[n6 * this.columns + 1];
                }
                this.fftRows.realInverseFull(dArray2[n2 - 1], bl);
            } else {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    n4 = n6 * this.columns;
                    int n8 = n2 - 1;
                    dArray2[n8][n5] = dArray[n4 + 2 * n8];
                    dArray2[n8][n5 + 1] = dArray[n4 + 1];
                }
                this.fftRows.complexInverse(dArray2[n2 - 1], bl);
            }
            n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n6 = 2 * i;
                            for (int j = 0; j < n2; ++j) {
                                int n22 = 2 * j;
                                int n3 = i * n + n22;
                                dArray[n3] = dArray2[j][n6];
                                dArray[n3 + 1] = dArray2[j][n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n7 = i * n;
                            int n22 = (DoubleFFT_2D.this.rows - i + 1) * n;
                            for (int j = n2; j < DoubleFFT_2D.this.columns; ++j) {
                                int n3 = 2 * j;
                                int n42 = 2 * (DoubleFFT_2D.this.columns - j);
                                dArray[n3] = dArray[n42];
                                dArray[n3 + 1] = -dArray[n42 + 1];
                                int n52 = n7 + n3;
                                int n6 = n22 - n3;
                                dArray[n52] = dArray[n6];
                                dArray[n52 + 1] = -dArray[n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.fftColumns.realInverse2(dArray, n13 * this.columns, bl);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                dArray2[0][n13] = dArray[n13 * this.columns];
            }
            this.fftRows.realInverseFull(dArray2[0], bl);
            for (n13 = 1; n13 < n2 - 1; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    n9 = n11 * this.columns + n12;
                    dArray2[n13][n10] = dArray[n9];
                    dArray2[n13][n10 + 1] = dArray[n9 + 1];
                }
                this.fftRows.complexInverse(dArray2[n13], bl);
            }
            if (this.columns % 2 == 0) {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    dArray2[n2 - 1][n13] = dArray[n13 * this.columns + 1];
                }
                this.fftRows.realInverseFull(dArray2[n2 - 1], bl);
            } else {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = 2 * n13;
                    n11 = n13 * this.columns;
                    n10 = n2 - 1;
                    dArray2[n10][n12] = dArray[n11 + 2 * n10];
                    dArray2[n10][n12 + 1] = dArray[n11 + 1];
                }
                this.fftRows.complexInverse(dArray2[n2 - 1], bl);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = 2 * n11;
                    n9 = n13 * n + n10;
                    dArray[n9] = dArray2[n11][n12];
                    dArray[n9 + 1] = dArray2[n11][n12 + 1];
                }
            }
            for (n13 = 1; n13 < this.rows; ++n13) {
                n12 = n13 * n;
                n11 = (this.rows - n13 + 1) * n;
                for (n10 = n2; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    int n14 = 2 * (this.columns - n10);
                    dArray[n9] = dArray[n14];
                    dArray[n9 + 1] = -dArray[n14 + 1];
                    int n15 = n12 + n9;
                    int n16 = n11 - n9;
                    dArray[n15] = dArray[n16];
                    dArray[n15 + 1] = -dArray[n16 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final long l = 2L * this.columnsl;
        final long l2 = this.columnsl / 2L + 1L;
        final DoubleLargeArray doubleLargeArray2 = new DoubleLargeArray(l2 * 2L * this.rowsl, false);
        final long l3 = 2L * this.rowsl;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && this.rowsl >= (long)n && l2 - 2L >= (long)n) {
            int n2;
            long l4;
            long l5;
            long l6;
            Future[] futureArray = new Future[n];
            long l7 = this.rowsl / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = (long)i * l7;
                l5 = i == n - 1 ? this.rowsl : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            DoubleFFT_2D.this.fftColumns.realInverse2(doubleLargeArray, i * DoubleFFT_2D.this.columnsl, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (long i = 0L; i < this.rowsl; ++i) {
                doubleLargeArray2.setDouble(i, doubleLargeArray.getDouble(i * this.columnsl));
            }
            this.fftRows.realInverseFull(doubleLargeArray2, bl);
            l7 = (l2 - 2L) / (long)n;
            for (int i = 0; i < n; ++i) {
                l6 = 1L + (long)i * l7;
                l5 = i == n - 1 ? l2 - 1L : l6 + l7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l = 2L * i;
                            for (long j = 0L; j < DoubleFFT_2D.this.rowsl; ++j) {
                                long l2 = 2L * j;
                                long l32 = j * DoubleFFT_2D.this.columnsl + l;
                                doubleLargeArray2.setDouble(i * l3 + l2, doubleLargeArray.getDouble(l32));
                                doubleLargeArray2.setDouble(i * l3 + l2 + 1L, doubleLargeArray.getDouble(l32 + 1L));
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, i * l3, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columnsl % 2L == 0L) {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    doubleLargeArray2.setDouble((l2 - 1L) * l3 + l4, doubleLargeArray.getDouble(l4 * this.columnsl + 1L));
                }
                this.fftRows.realInverseFull(doubleLargeArray2, (l2 - 1L) * l3, bl);
            } else {
                for (l4 = 0L; l4 < this.rowsl; ++l4) {
                    long l8 = 2L * l4;
                    long l9 = l4 * this.columnsl;
                    long l10 = l2 - 1L;
                    doubleLargeArray2.setDouble(l10 * l3 + l8, doubleLargeArray.getDouble(l9 + 2L * l10));
                    doubleLargeArray2.setDouble(l10 * l3 + l8 + 1L, doubleLargeArray.getDouble(l9 + 1L));
                }
                this.fftRows.complexInverse(doubleLargeArray2, (l2 - 1L) * l3, bl);
            }
            l7 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l6 = (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l4 = 2L * i;
                            for (long j = 0L; j < l2; ++j) {
                                long l22 = 2L * j;
                                long l32 = i * l + l22;
                                doubleLargeArray.setDouble(l32, doubleLargeArray2.getDouble(j * l3 + l4));
                                doubleLargeArray.setDouble(l32 + 1L, doubleLargeArray2.getDouble(j * l3 + l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l6 = 1L + (long)n2 * l7;
                l5 = n2 == n - 1 ? this.rowsl : l6 + l7;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l6; i < l5; ++i) {
                            long l7 = i * l;
                            long l22 = (DoubleFFT_2D.this.rowsl - i + 1L) * l;
                            for (long j = l2; j < DoubleFFT_2D.this.columnsl; ++j) {
                                long l3 = 2L * j;
                                long l4 = 2L * (DoubleFFT_2D.this.columnsl - j);
                                doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l4));
                                doubleLargeArray.setDouble(l3 + 1L, -doubleLargeArray.getDouble(l4 + 1L));
                                long l52 = l7 + l3;
                                long l62 = l22 - l3;
                                doubleLargeArray.setDouble(l52, doubleLargeArray.getDouble(l62));
                                doubleLargeArray.setDouble(l52 + 1L, -doubleLargeArray.getDouble(l62 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l11;
            long l12;
            long l13;
            long l14;
            long l15;
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                this.fftColumns.realInverse2(doubleLargeArray, l15 * this.columnsl, bl);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                doubleLargeArray2.setDouble(l15, doubleLargeArray.getDouble(l15 * this.columnsl));
            }
            this.fftRows.realInverseFull(doubleLargeArray2, bl);
            for (l15 = 1L; l15 < l2 - 1L; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < this.rowsl; ++l13) {
                    l12 = 2L * l13;
                    l11 = l13 * this.columnsl + l14;
                    doubleLargeArray2.setDouble(l15 * l3 + l12, doubleLargeArray.getDouble(l11));
                    doubleLargeArray2.setDouble(l15 * l3 + l12 + 1L, doubleLargeArray.getDouble(l11 + 1L));
                }
                this.fftRows.complexInverse(doubleLargeArray2, l15 * l3, bl);
            }
            if (this.columnsl % 2L == 0L) {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    doubleLargeArray2.setDouble((l2 - 1L) * l3 + l15, doubleLargeArray.getDouble(l15 * this.columnsl + 1L));
                }
                this.fftRows.realInverseFull(doubleLargeArray2, (l2 - 1L) * l3, bl);
            } else {
                for (l15 = 0L; l15 < this.rowsl; ++l15) {
                    l14 = 2L * l15;
                    l13 = l15 * this.columnsl;
                    l12 = l2 - 1L;
                    doubleLargeArray2.setDouble(l12 * l3 + l14, doubleLargeArray.getDouble(l13 + 2L * l12));
                    doubleLargeArray2.setDouble(l12 * l3 + l14 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                }
                this.fftRows.complexInverse(doubleLargeArray2, (l2 - 1L) * l3, bl);
            }
            for (l15 = 0L; l15 < this.rowsl; ++l15) {
                l14 = 2L * l15;
                for (l13 = 0L; l13 < l2; ++l13) {
                    l12 = 2L * l13;
                    l11 = l15 * l + l12;
                    doubleLargeArray.setDouble(l11, doubleLargeArray2.getDouble(l13 * l3 + l14));
                    doubleLargeArray.setDouble(l11 + 1L, doubleLargeArray2.getDouble(l13 * l3 + l14 + 1L));
                }
            }
            for (l15 = 1L; l15 < this.rowsl; ++l15) {
                l14 = l15 * l;
                l13 = (this.rowsl - l15 + 1L) * l;
                for (l12 = l2; l12 < this.columnsl; ++l12) {
                    l11 = 2L * l12;
                    long l16 = 2L * (this.columnsl - l12);
                    doubleLargeArray.setDouble(l11, doubleLargeArray.getDouble(l16));
                    doubleLargeArray.setDouble(l11 + 1L, -doubleLargeArray.getDouble(l16 + 1L));
                    long l17 = l14 + l11;
                    long l18 = l13 - l11;
                    doubleLargeArray.setDouble(l17, doubleLargeArray.getDouble(l18));
                    doubleLargeArray.setDouble(l17 + 1L, -doubleLargeArray.getDouble(l18 + 1L));
                }
            }
        }
    }

    private void rdft2d_sub(int n, double[] dArray) {
        int n2 = this.rows >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.rows - i;
                int n4 = i * this.columns;
                int n5 = n3 * this.columns;
                double d = dArray[n4] - dArray[n5];
                int n6 = n4;
                dArray[n6] = dArray[n6] + dArray[n5];
                dArray[n5] = d;
                d = dArray[n5 + 1] - dArray[n4 + 1];
                int n7 = n4 + 1;
                dArray[n7] = dArray[n7] + dArray[n5 + 1];
                dArray[n5 + 1] = d;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = this.rows - i;
                int n9 = i * this.columns;
                int n10 = n8 * this.columns;
                dArray[n10] = 0.5 * (dArray[n9] - dArray[n10]);
                int n11 = n9;
                dArray[n11] = dArray[n11] - dArray[n10];
                dArray[n10 + 1] = 0.5 * (dArray[n9 + 1] + dArray[n10 + 1]);
                int n12 = n9 + 1;
                dArray[n12] = dArray[n12] - dArray[n10 + 1];
            }
        }
    }

    private void rdft2d_sub(int n, DoubleLargeArray doubleLargeArray) {
        long l = this.rowsl >> 1;
        if (n < 0) {
            for (long i = 1L; i < l; ++i) {
                long l2 = this.rowsl - i;
                long l3 = i * this.columnsl;
                long l4 = l2 * this.columnsl;
                double d = doubleLargeArray.getDouble(l3) - doubleLargeArray.getDouble(l4);
                doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l3) + doubleLargeArray.getDouble(l4));
                doubleLargeArray.setDouble(l4, d);
                d = doubleLargeArray.getDouble(l4 + 1L) - doubleLargeArray.getDouble(l3 + 1L);
                doubleLargeArray.setDouble(l3 + 1L, doubleLargeArray.getDouble(l3 + 1L) + doubleLargeArray.getDouble(l4 + 1L));
                doubleLargeArray.setDouble(l4 + 1L, d);
            }
        } else {
            for (long i = 1L; i < l; ++i) {
                long l5 = this.rowsl - i;
                long l6 = i * this.columnsl;
                long l7 = l5 * this.columnsl;
                doubleLargeArray.setDouble(l7, 0.5 * (doubleLargeArray.getDouble(l6) - doubleLargeArray.getDouble(l7)));
                doubleLargeArray.setDouble(l6, doubleLargeArray.getDouble(l6) - doubleLargeArray.getDouble(l7));
                doubleLargeArray.setDouble(l7 + 1L, 0.5 * (doubleLargeArray.getDouble(l6 + 1L) + doubleLargeArray.getDouble(l7 + 1L)));
                doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray.getDouble(l6 + 1L) - doubleLargeArray.getDouble(l7 + 1L));
            }
        }
    }

    private void rdft2d_sub(int n, double[][] dArray) {
        int n2 = this.rows >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.rows - i;
                double d = dArray[i][0] - dArray[n3][0];
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + dArray[n3][0];
                dArray[n3][0] = d;
                d = dArray[n3][1] - dArray[i][1];
                double[] dArray3 = dArray[i];
                dArray3[1] = dArray3[1] + dArray[n3][1];
                dArray[n3][1] = d;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n4 = this.rows - i;
                dArray[n4][0] = 0.5 * (dArray[i][0] - dArray[n4][0]);
                double[] dArray4 = dArray[i];
                dArray4[0] = dArray4[0] - dArray[n4][0];
                dArray[n4][1] = 0.5 * (dArray[i][1] + dArray[n4][1]);
                double[] dArray5 = dArray[i];
                dArray5[1] = dArray5[1] - dArray[n4][1];
            }
        }
    }

    private void cdft2d_sub(int n, double[] dArray, boolean bl) {
        block24: {
            double[] dArray2;
            block22: {
                int n2;
                int n3;
                int n4;
                block25: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    block23: {
                        int n9 = 8 * this.rows;
                        if (this.columns == 4) {
                            n9 >>= 1;
                        } else if (this.columns < 4) {
                            n9 >>= 2;
                        }
                        dArray2 = new double[n9];
                        if (n != -1) break block22;
                        if (this.columns <= 4) break block23;
                        for (int i = 0; i < this.columns; i += 8) {
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            int n15;
                            for (n15 = 0; n15 < this.rows; ++n15) {
                                n14 = n15 * this.columns + i;
                                n13 = 2 * n15;
                                n12 = 2 * this.rows + 2 * n15;
                                n11 = n12 + 2 * this.rows;
                                n10 = n11 + 2 * this.rows;
                                dArray2[n13] = dArray[n14];
                                dArray2[n13 + 1] = dArray[n14 + 1];
                                dArray2[n12] = dArray[n14 + 2];
                                dArray2[n12 + 1] = dArray[n14 + 3];
                                dArray2[n11] = dArray[n14 + 4];
                                dArray2[n11 + 1] = dArray[n14 + 5];
                                dArray2[n10] = dArray[n14 + 6];
                                dArray2[n10 + 1] = dArray[n14 + 7];
                            }
                            this.fftRows.complexForward(dArray2, 0);
                            this.fftRows.complexForward(dArray2, 2 * this.rows);
                            this.fftRows.complexForward(dArray2, 4 * this.rows);
                            this.fftRows.complexForward(dArray2, 6 * this.rows);
                            for (n15 = 0; n15 < this.rows; ++n15) {
                                n14 = n15 * this.columns + i;
                                n13 = 2 * n15;
                                n12 = 2 * this.rows + 2 * n15;
                                n11 = n12 + 2 * this.rows;
                                n10 = n11 + 2 * this.rows;
                                dArray[n14] = dArray2[n13];
                                dArray[n14 + 1] = dArray2[n13 + 1];
                                dArray[n14 + 2] = dArray2[n12];
                                dArray[n14 + 3] = dArray2[n12 + 1];
                                dArray[n14 + 4] = dArray2[n11];
                                dArray[n14 + 5] = dArray2[n11 + 1];
                                dArray[n14 + 6] = dArray2[n10];
                                dArray[n14 + 7] = dArray2[n10 + 1];
                            }
                        }
                        break block24;
                    }
                    if (this.columns != 4) break block25;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = n8 * this.columns;
                        n6 = 2 * n8;
                        n5 = 2 * this.rows + 2 * n8;
                        dArray2[n6] = dArray[n7];
                        dArray2[n6 + 1] = dArray[n7 + 1];
                        dArray2[n5] = dArray[n7 + 2];
                        dArray2[n5 + 1] = dArray[n7 + 3];
                    }
                    this.fftRows.complexForward(dArray2, 0);
                    this.fftRows.complexForward(dArray2, 2 * this.rows);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = n8 * this.columns;
                        n6 = 2 * n8;
                        n5 = 2 * this.rows + 2 * n8;
                        dArray[n7] = dArray2[n6];
                        dArray[n7 + 1] = dArray2[n6 + 1];
                        dArray[n7 + 2] = dArray2[n5];
                        dArray[n7 + 3] = dArray2[n5 + 1];
                    }
                    break block24;
                }
                if (this.columns != 2) break block24;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n4 * this.columns;
                    n2 = 2 * n4;
                    dArray2[n2] = dArray[n3];
                    dArray2[n2 + 1] = dArray[n3 + 1];
                }
                this.fftRows.complexForward(dArray2, 0);
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n4 * this.columns;
                    n2 = 2 * n4;
                    dArray[n3] = dArray2[n2];
                    dArray[n3 + 1] = dArray2[n2 + 1];
                }
                break block24;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.columns; i += 8) {
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    int n21;
                    for (n21 = 0; n21 < this.rows; ++n21) {
                        n20 = n21 * this.columns + i;
                        n19 = 2 * n21;
                        n18 = 2 * this.rows + 2 * n21;
                        n17 = n18 + 2 * this.rows;
                        n16 = n17 + 2 * this.rows;
                        dArray2[n19] = dArray[n20];
                        dArray2[n19 + 1] = dArray[n20 + 1];
                        dArray2[n18] = dArray[n20 + 2];
                        dArray2[n18 + 1] = dArray[n20 + 3];
                        dArray2[n17] = dArray[n20 + 4];
                        dArray2[n17 + 1] = dArray[n20 + 5];
                        dArray2[n16] = dArray[n20 + 6];
                        dArray2[n16 + 1] = dArray[n20 + 7];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                    this.fftRows.complexInverse(dArray2, 4 * this.rows, bl);
                    this.fftRows.complexInverse(dArray2, 6 * this.rows, bl);
                    for (n21 = 0; n21 < this.rows; ++n21) {
                        n20 = n21 * this.columns + i;
                        n19 = 2 * n21;
                        n18 = 2 * this.rows + 2 * n21;
                        n17 = n18 + 2 * this.rows;
                        n16 = n17 + 2 * this.rows;
                        dArray[n20] = dArray2[n19];
                        dArray[n20 + 1] = dArray2[n19 + 1];
                        dArray[n20 + 2] = dArray2[n18];
                        dArray[n20 + 3] = dArray2[n18 + 1];
                        dArray[n20 + 4] = dArray2[n17];
                        dArray[n20 + 5] = dArray2[n17 + 1];
                        dArray[n20 + 6] = dArray2[n16];
                        dArray[n20 + 7] = dArray2[n16 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int n22;
                int n23;
                int n24;
                int n25;
                for (n25 = 0; n25 < this.rows; ++n25) {
                    n24 = n25 * this.columns;
                    n23 = 2 * n25;
                    n22 = 2 * this.rows + 2 * n25;
                    dArray2[n23] = dArray[n24];
                    dArray2[n23 + 1] = dArray[n24 + 1];
                    dArray2[n22] = dArray[n24 + 2];
                    dArray2[n22 + 1] = dArray[n24 + 3];
                }
                this.fftRows.complexInverse(dArray2, 0, bl);
                this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                for (n25 = 0; n25 < this.rows; ++n25) {
                    n24 = n25 * this.columns;
                    n23 = 2 * n25;
                    n22 = 2 * this.rows + 2 * n25;
                    dArray[n24] = dArray2[n23];
                    dArray[n24 + 1] = dArray2[n23 + 1];
                    dArray[n24 + 2] = dArray2[n22];
                    dArray[n24 + 3] = dArray2[n22 + 1];
                }
            } else if (this.columns == 2) {
                int n26;
                int n27;
                int n28;
                for (n28 = 0; n28 < this.rows; ++n28) {
                    n27 = n28 * this.columns;
                    n26 = 2 * n28;
                    dArray2[n26] = dArray[n27];
                    dArray2[n26 + 1] = dArray[n27 + 1];
                }
                this.fftRows.complexInverse(dArray2, 0, bl);
                for (n28 = 0; n28 < this.rows; ++n28) {
                    n27 = n28 * this.columns;
                    n26 = 2 * n28;
                    dArray[n27] = dArray2[n26];
                    dArray[n27 + 1] = dArray2[n26 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int n, DoubleLargeArray doubleLargeArray, boolean bl) {
        block24: {
            DoubleLargeArray doubleLargeArray2;
            block22: {
                long l;
                long l2;
                long l3;
                block25: {
                    long l4;
                    long l5;
                    long l6;
                    long l7;
                    block23: {
                        long l8 = 8L * this.rowsl;
                        if (this.columnsl == 4L) {
                            l8 >>= 1;
                        } else if (this.columnsl < 4L) {
                            l8 >>= 2;
                        }
                        doubleLargeArray2 = new DoubleLargeArray(l8, false);
                        if (n != -1) break block22;
                        if (this.columnsl <= 4L) break block23;
                        for (long i = 0L; i < this.columnsl; i += 8L) {
                            long l9;
                            long l10;
                            long l11;
                            long l12;
                            long l13;
                            long l14;
                            for (l14 = 0L; l14 < this.rowsl; ++l14) {
                                l13 = l14 * this.columnsl + i;
                                l12 = 2L * l14;
                                l11 = 2L * this.rowsl + 2L * l14;
                                l10 = l11 + 2L * this.rowsl;
                                l9 = l10 + 2L * this.rowsl;
                                doubleLargeArray2.setDouble(l12, doubleLargeArray.getDouble(l13));
                                doubleLargeArray2.setDouble(l12 + 1L, doubleLargeArray.getDouble(l13 + 1L));
                                doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l13 + 2L));
                                doubleLargeArray2.setDouble(l11 + 1L, doubleLargeArray.getDouble(l13 + 3L));
                                doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l13 + 4L));
                                doubleLargeArray2.setDouble(l10 + 1L, doubleLargeArray.getDouble(l13 + 5L));
                                doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l13 + 6L));
                                doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l13 + 7L));
                            }
                            this.fftRows.complexForward(doubleLargeArray2, 0L);
                            this.fftRows.complexForward(doubleLargeArray2, 2L * this.rowsl);
                            this.fftRows.complexForward(doubleLargeArray2, 4L * this.rowsl);
                            this.fftRows.complexForward(doubleLargeArray2, 6L * this.rowsl);
                            for (l14 = 0L; l14 < this.rowsl; ++l14) {
                                l13 = l14 * this.columnsl + i;
                                l12 = 2L * l14;
                                l11 = 2L * this.rowsl + 2L * l14;
                                l10 = l11 + 2L * this.rowsl;
                                l9 = l10 + 2L * this.rowsl;
                                doubleLargeArray.setDouble(l13, doubleLargeArray2.getDouble(l12));
                                doubleLargeArray.setDouble(l13 + 1L, doubleLargeArray2.getDouble(l12 + 1L));
                                doubleLargeArray.setDouble(l13 + 2L, doubleLargeArray2.getDouble(l11));
                                doubleLargeArray.setDouble(l13 + 3L, doubleLargeArray2.getDouble(l11 + 1L));
                                doubleLargeArray.setDouble(l13 + 4L, doubleLargeArray2.getDouble(l10));
                                doubleLargeArray.setDouble(l13 + 5L, doubleLargeArray2.getDouble(l10 + 1L));
                                doubleLargeArray.setDouble(l13 + 6L, doubleLargeArray2.getDouble(l9));
                                doubleLargeArray.setDouble(l13 + 7L, doubleLargeArray2.getDouble(l9 + 1L));
                            }
                        }
                        break block24;
                    }
                    if (this.columnsl != 4L) break block25;
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = l7 * this.columnsl;
                        l5 = 2L * l7;
                        l4 = 2L * this.rowsl + 2L * l7;
                        doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l6));
                        doubleLargeArray2.setDouble(l5 + 1L, doubleLargeArray.getDouble(l6 + 1L));
                        doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l6 + 2L));
                        doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l6 + 3L));
                    }
                    this.fftRows.complexForward(doubleLargeArray2, 0L);
                    this.fftRows.complexForward(doubleLargeArray2, 2L * this.rowsl);
                    for (l7 = 0L; l7 < this.rowsl; ++l7) {
                        l6 = l7 * this.columnsl;
                        l5 = 2L * l7;
                        l4 = 2L * this.rowsl + 2L * l7;
                        doubleLargeArray.setDouble(l6, doubleLargeArray2.getDouble(l5));
                        doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray2.getDouble(l5 + 1L));
                        doubleLargeArray.setDouble(l6 + 2L, doubleLargeArray2.getDouble(l4));
                        doubleLargeArray.setDouble(l6 + 3L, doubleLargeArray2.getDouble(l4 + 1L));
                    }
                    break block24;
                }
                if (this.columnsl != 2L) break block24;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l3 * this.columnsl;
                    l = 2L * l3;
                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l2));
                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l2 + 1L));
                }
                this.fftRows.complexForward(doubleLargeArray2, 0L);
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l3 * this.columnsl;
                    l = 2L * l3;
                    doubleLargeArray.setDouble(l2, doubleLargeArray2.getDouble(l));
                    doubleLargeArray.setDouble(l2 + 1L, doubleLargeArray2.getDouble(l + 1L));
                }
                break block24;
            }
            if (this.columnsl > 4L) {
                for (long i = 0L; i < this.columnsl; i += 8L) {
                    long l;
                    long l15;
                    long l16;
                    long l17;
                    long l18;
                    long l19;
                    for (l19 = 0L; l19 < this.rowsl; ++l19) {
                        l18 = l19 * this.columnsl + i;
                        l17 = 2L * l19;
                        l16 = 2L * this.rowsl + 2L * l19;
                        l15 = l16 + 2L * this.rowsl;
                        l = l15 + 2L * this.rowsl;
                        doubleLargeArray2.setDouble(l17, doubleLargeArray.getDouble(l18));
                        doubleLargeArray2.setDouble(l17 + 1L, doubleLargeArray.getDouble(l18 + 1L));
                        doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l18 + 2L));
                        doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l18 + 3L));
                        doubleLargeArray2.setDouble(l15, doubleLargeArray.getDouble(l18 + 4L));
                        doubleLargeArray2.setDouble(l15 + 1L, doubleLargeArray.getDouble(l18 + 5L));
                        doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l18 + 6L));
                        doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l18 + 7L));
                    }
                    this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                    this.fftRows.complexInverse(doubleLargeArray2, 2L * this.rowsl, bl);
                    this.fftRows.complexInverse(doubleLargeArray2, 4L * this.rowsl, bl);
                    this.fftRows.complexInverse(doubleLargeArray2, 6L * this.rowsl, bl);
                    for (l19 = 0L; l19 < this.rowsl; ++l19) {
                        l18 = l19 * this.columnsl + i;
                        l17 = 2L * l19;
                        l16 = 2L * this.rowsl + 2L * l19;
                        l15 = l16 + 2L * this.rowsl;
                        l = l15 + 2L * this.rowsl;
                        doubleLargeArray.setDouble(l18, doubleLargeArray2.getDouble(l17));
                        doubleLargeArray.setDouble(l18 + 1L, doubleLargeArray2.getDouble(l17 + 1L));
                        doubleLargeArray.setDouble(l18 + 2L, doubleLargeArray2.getDouble(l16));
                        doubleLargeArray.setDouble(l18 + 3L, doubleLargeArray2.getDouble(l16 + 1L));
                        doubleLargeArray.setDouble(l18 + 4L, doubleLargeArray2.getDouble(l15));
                        doubleLargeArray.setDouble(l18 + 5L, doubleLargeArray2.getDouble(l15 + 1L));
                        doubleLargeArray.setDouble(l18 + 6L, doubleLargeArray2.getDouble(l));
                        doubleLargeArray.setDouble(l18 + 7L, doubleLargeArray2.getDouble(l + 1L));
                    }
                }
            } else if (this.columnsl == 4L) {
                long l;
                long l20;
                long l21;
                long l22;
                for (l22 = 0L; l22 < this.rowsl; ++l22) {
                    l21 = l22 * this.columnsl;
                    l20 = 2L * l22;
                    l = 2L * this.rowsl + 2L * l22;
                    doubleLargeArray2.setDouble(l20, doubleLargeArray.getDouble(l21));
                    doubleLargeArray2.setDouble(l20 + 1L, doubleLargeArray.getDouble(l21 + 1L));
                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l21 + 2L));
                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l21 + 3L));
                }
                this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                this.fftRows.complexInverse(doubleLargeArray2, 2L * this.rowsl, bl);
                for (l22 = 0L; l22 < this.rowsl; ++l22) {
                    l21 = l22 * this.columnsl;
                    l20 = 2L * l22;
                    l = 2L * this.rowsl + 2L * l22;
                    doubleLargeArray.setDouble(l21, doubleLargeArray2.getDouble(l20));
                    doubleLargeArray.setDouble(l21 + 1L, doubleLargeArray2.getDouble(l20 + 1L));
                    doubleLargeArray.setDouble(l21 + 2L, doubleLargeArray2.getDouble(l));
                    doubleLargeArray.setDouble(l21 + 3L, doubleLargeArray2.getDouble(l + 1L));
                }
            } else if (this.columnsl == 2L) {
                long l;
                long l23;
                long l24;
                for (l24 = 0L; l24 < this.rowsl; ++l24) {
                    l23 = l24 * this.columnsl;
                    l = 2L * l24;
                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l23));
                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l23 + 1L));
                }
                this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                for (l24 = 0L; l24 < this.rowsl; ++l24) {
                    l23 = l24 * this.columnsl;
                    l = 2L * l24;
                    doubleLargeArray.setDouble(l23, doubleLargeArray2.getDouble(l));
                    doubleLargeArray.setDouble(l23 + 1L, doubleLargeArray2.getDouble(l + 1L));
                }
            }
        }
    }

    private void cdft2d_sub(int n, double[][] dArray, boolean bl) {
        block24: {
            double[] dArray2;
            block22: {
                int n2;
                int n3;
                block25: {
                    int n4;
                    int n5;
                    int n6;
                    block23: {
                        int n7 = 8 * this.rows;
                        if (this.columns == 4) {
                            n7 >>= 1;
                        } else if (this.columns < 4) {
                            n7 >>= 2;
                        }
                        dArray2 = new double[n7];
                        if (n != -1) break block22;
                        if (this.columns <= 4) break block23;
                        for (int i = 0; i < this.columns; i += 8) {
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            for (n12 = 0; n12 < this.rows; ++n12) {
                                n11 = 2 * n12;
                                n10 = 2 * this.rows + 2 * n12;
                                n9 = n10 + 2 * this.rows;
                                n8 = n9 + 2 * this.rows;
                                dArray2[n11] = dArray[n12][i];
                                dArray2[n11 + 1] = dArray[n12][i + 1];
                                dArray2[n10] = dArray[n12][i + 2];
                                dArray2[n10 + 1] = dArray[n12][i + 3];
                                dArray2[n9] = dArray[n12][i + 4];
                                dArray2[n9 + 1] = dArray[n12][i + 5];
                                dArray2[n8] = dArray[n12][i + 6];
                                dArray2[n8 + 1] = dArray[n12][i + 7];
                            }
                            this.fftRows.complexForward(dArray2, 0);
                            this.fftRows.complexForward(dArray2, 2 * this.rows);
                            this.fftRows.complexForward(dArray2, 4 * this.rows);
                            this.fftRows.complexForward(dArray2, 6 * this.rows);
                            for (n12 = 0; n12 < this.rows; ++n12) {
                                n11 = 2 * n12;
                                n10 = 2 * this.rows + 2 * n12;
                                n9 = n10 + 2 * this.rows;
                                n8 = n9 + 2 * this.rows;
                                dArray[n12][i] = dArray2[n11];
                                dArray[n12][i + 1] = dArray2[n11 + 1];
                                dArray[n12][i + 2] = dArray2[n10];
                                dArray[n12][i + 3] = dArray2[n10 + 1];
                                dArray[n12][i + 4] = dArray2[n9];
                                dArray[n12][i + 5] = dArray2[n9 + 1];
                                dArray[n12][i + 6] = dArray2[n8];
                                dArray[n12][i + 7] = dArray2[n8 + 1];
                            }
                        }
                        break block24;
                    }
                    if (this.columns != 4) break block25;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        dArray2[n5] = dArray[n6][0];
                        dArray2[n5 + 1] = dArray[n6][1];
                        dArray2[n4] = dArray[n6][2];
                        dArray2[n4 + 1] = dArray[n6][3];
                    }
                    this.fftRows.complexForward(dArray2, 0);
                    this.fftRows.complexForward(dArray2, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        dArray[n6][0] = dArray2[n5];
                        dArray[n6][1] = dArray2[n5 + 1];
                        dArray[n6][2] = dArray2[n4];
                        dArray[n6][3] = dArray2[n4 + 1];
                    }
                    break block24;
                }
                if (this.columns != 2) break block24;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = 2 * n3;
                    dArray2[n2] = dArray[n3][0];
                    dArray2[n2 + 1] = dArray[n3][1];
                }
                this.fftRows.complexForward(dArray2, 0);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = 2 * n3;
                    dArray[n3][0] = dArray2[n2];
                    dArray[n3][1] = dArray2[n2 + 1];
                }
                break block24;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.columns; i += 8) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    for (n17 = 0; n17 < this.rows; ++n17) {
                        n16 = 2 * n17;
                        n15 = 2 * this.rows + 2 * n17;
                        n14 = n15 + 2 * this.rows;
                        n13 = n14 + 2 * this.rows;
                        dArray2[n16] = dArray[n17][i];
                        dArray2[n16 + 1] = dArray[n17][i + 1];
                        dArray2[n15] = dArray[n17][i + 2];
                        dArray2[n15 + 1] = dArray[n17][i + 3];
                        dArray2[n14] = dArray[n17][i + 4];
                        dArray2[n14 + 1] = dArray[n17][i + 5];
                        dArray2[n13] = dArray[n17][i + 6];
                        dArray2[n13 + 1] = dArray[n17][i + 7];
                    }
                    this.fftRows.complexInverse(dArray2, 0, bl);
                    this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                    this.fftRows.complexInverse(dArray2, 4 * this.rows, bl);
                    this.fftRows.complexInverse(dArray2, 6 * this.rows, bl);
                    for (n17 = 0; n17 < this.rows; ++n17) {
                        n16 = 2 * n17;
                        n15 = 2 * this.rows + 2 * n17;
                        n14 = n15 + 2 * this.rows;
                        n13 = n14 + 2 * this.rows;
                        dArray[n17][i] = dArray2[n16];
                        dArray[n17][i + 1] = dArray2[n16 + 1];
                        dArray[n17][i + 2] = dArray2[n15];
                        dArray[n17][i + 3] = dArray2[n15 + 1];
                        dArray[n17][i + 4] = dArray2[n14];
                        dArray[n17][i + 5] = dArray2[n14 + 1];
                        dArray[n17][i + 6] = dArray2[n13];
                        dArray[n17][i + 7] = dArray2[n13 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int n18;
                int n19;
                int n20;
                for (n20 = 0; n20 < this.rows; ++n20) {
                    n19 = 2 * n20;
                    n18 = 2 * this.rows + 2 * n20;
                    dArray2[n19] = dArray[n20][0];
                    dArray2[n19 + 1] = dArray[n20][1];
                    dArray2[n18] = dArray[n20][2];
                    dArray2[n18 + 1] = dArray[n20][3];
                }
                this.fftRows.complexInverse(dArray2, 0, bl);
                this.fftRows.complexInverse(dArray2, 2 * this.rows, bl);
                for (n20 = 0; n20 < this.rows; ++n20) {
                    n19 = 2 * n20;
                    n18 = 2 * this.rows + 2 * n20;
                    dArray[n20][0] = dArray2[n19];
                    dArray[n20][1] = dArray2[n19 + 1];
                    dArray[n20][2] = dArray2[n18];
                    dArray[n20][3] = dArray2[n18 + 1];
                }
            } else if (this.columns == 2) {
                int n21;
                int n22;
                for (n22 = 0; n22 < this.rows; ++n22) {
                    n21 = 2 * n22;
                    dArray2[n21] = dArray[n22][0];
                    dArray2[n21 + 1] = dArray[n22][1];
                }
                this.fftRows.complexInverse(dArray2, 0, bl);
                for (n22 = 0; n22 < this.rows; ++n22) {
                    n21 = 2 * n22;
                    dArray[n22][0] = dArray2[n21];
                    dArray[n22][1] = dArray2[n21 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final double[] dArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexForward(dArray, i * DoubleFFT_2D.this.columns);
                            }
                        } else {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(dArray, i * DoubleFFT_2D.this.columns, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realForward(dArray, i * DoubleFFT_2D.this.columns);
                        }
                    } else {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realInverse(dArray, i * DoubleFFT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth1(final long l, final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (l == 0L) {
                        if (n == -1) {
                            for (long i = (long)n3; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                                DoubleFFT_2D.this.fftColumns.complexForward(doubleLargeArray, i * DoubleFFT_2D.this.columnsl);
                            }
                        } else {
                            for (long i = (long)n3; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(doubleLargeArray, i * DoubleFFT_2D.this.columnsl, bl);
                            }
                        }
                    } else if (n == 1) {
                        for (long i = (long)n3; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                            DoubleFFT_2D.this.fftColumns.realForward(doubleLargeArray, i * DoubleFFT_2D.this.columnsl);
                        }
                    } else {
                        for (long i = (long)n3; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                            DoubleFFT_2D.this.fftColumns.realInverse(doubleLargeArray, i * DoubleFFT_2D.this.columnsl, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final int n, final int n2, final double[] dArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexForward(dArray, i * DoubleFFT_2D.this.columns);
                            }
                        } else {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(dArray, i * DoubleFFT_2D.this.columns, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realForward(dArray, i * DoubleFFT_2D.this.columns);
                        }
                    } else {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realInverse2(dArray, i * DoubleFFT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final long l, final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l2 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (l == 0L) {
                        if (n == -1) {
                            for (long i = l2; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                                DoubleFFT_2D.this.fftColumns.complexForward(doubleLargeArray, i * DoubleFFT_2D.this.columnsl);
                            }
                        } else {
                            for (long i = l2; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(doubleLargeArray, i * DoubleFFT_2D.this.columnsl, bl);
                            }
                        }
                    } else if (n == 1) {
                        for (long i = l2; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                            DoubleFFT_2D.this.fftColumns.realForward(doubleLargeArray, i * DoubleFFT_2D.this.columnsl);
                        }
                    } else {
                        for (long i = l2; i < DoubleFFT_2D.this.rowsl; i += (long)n2) {
                            DoubleFFT_2D.this.fftColumns.realInverse2(doubleLargeArray, i * DoubleFFT_2D.this.columnsl, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth1(final int n, final int n2, final double[][] dArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexForward(dArray[i]);
                            }
                        } else {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(dArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realForward(dArray[i]);
                        }
                    } else {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realInverse(dArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final int n, final int n2, final double[][] dArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexForward(dArray[i]);
                            }
                        } else {
                            for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                                DoubleFFT_2D.this.fftColumns.complexInverse(dArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realForward(dArray[i]);
                        }
                    } else {
                        for (int i = n4; i < DoubleFFT_2D.this.rows; i += n3) {
                            DoubleFFT_2D.this.fftColumns.realInverse2(dArray[i], 0, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final double[] dArray, final boolean bl) {
        int n2 = Math.min(this.columns / 2, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 8 * this.rows;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        final int n5 = n2;
        for (int i = 0; i < n2; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        double[] dArray2;
                        block19: {
                            int n24;
                            int n2;
                            int n3;
                            block22: {
                                int n42;
                                int n52;
                                int n62;
                                int n7;
                                block20: {
                                    dArray2 = new double[n4];
                                    if (n != -1) break block19;
                                    if (DoubleFFT_2D.this.columns <= 4 * n5) break block20;
                                    for (int i = 8 * n6; i < DoubleFFT_2D.this.columns; i += 8 * n5) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        int n11;
                                        int n12;
                                        int n13;
                                        for (n13 = 0; n13 < DoubleFFT_2D.this.rows; ++n13) {
                                            n12 = n13 * DoubleFFT_2D.this.columns + i;
                                            n11 = 2 * n13;
                                            n10 = 2 * DoubleFFT_2D.this.rows + 2 * n13;
                                            n9 = n10 + 2 * DoubleFFT_2D.this.rows;
                                            n8 = n9 + 2 * DoubleFFT_2D.this.rows;
                                            dArray2[n11] = dArray[n12];
                                            dArray2[n11 + 1] = dArray[n12 + 1];
                                            dArray2[n10] = dArray[n12 + 2];
                                            dArray2[n10 + 1] = dArray[n12 + 3];
                                            dArray2[n9] = dArray[n12 + 4];
                                            dArray2[n9 + 1] = dArray[n12 + 5];
                                            dArray2[n8] = dArray[n12 + 6];
                                            dArray2[n8 + 1] = dArray[n12 + 7];
                                        }
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 0);
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_2D.this.rows);
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 4 * DoubleFFT_2D.this.rows);
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 6 * DoubleFFT_2D.this.rows);
                                        for (n13 = 0; n13 < DoubleFFT_2D.this.rows; ++n13) {
                                            n12 = n13 * DoubleFFT_2D.this.columns + i;
                                            n11 = 2 * n13;
                                            n10 = 2 * DoubleFFT_2D.this.rows + 2 * n13;
                                            n9 = n10 + 2 * DoubleFFT_2D.this.rows;
                                            n8 = n9 + 2 * DoubleFFT_2D.this.rows;
                                            dArray[n12] = dArray2[n11];
                                            dArray[n12 + 1] = dArray2[n11 + 1];
                                            dArray[n12 + 2] = dArray2[n10];
                                            dArray[n12 + 3] = dArray2[n10 + 1];
                                            dArray[n12 + 4] = dArray2[n9];
                                            dArray[n12 + 5] = dArray2[n9 + 1];
                                            dArray[n12 + 6] = dArray2[n8];
                                            dArray[n12 + 7] = dArray2[n8 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (DoubleFFT_2D.this.columns != 4 * n5) break block22;
                                for (n7 = 0; n7 < DoubleFFT_2D.this.rows; ++n7) {
                                    n62 = n7 * DoubleFFT_2D.this.columns + 4 * n6;
                                    n52 = 2 * n7;
                                    n42 = 2 * DoubleFFT_2D.this.rows + 2 * n7;
                                    dArray2[n52] = dArray[n62];
                                    dArray2[n52 + 1] = dArray[n62 + 1];
                                    dArray2[n42] = dArray[n62 + 2];
                                    dArray2[n42 + 1] = dArray[n62 + 3];
                                }
                                DoubleFFT_2D.this.fftRows.complexForward(dArray2, 0);
                                DoubleFFT_2D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_2D.this.rows);
                                for (n7 = 0; n7 < DoubleFFT_2D.this.rows; ++n7) {
                                    n62 = n7 * DoubleFFT_2D.this.columns + 4 * n6;
                                    n52 = 2 * n7;
                                    n42 = 2 * DoubleFFT_2D.this.rows + 2 * n7;
                                    dArray[n62] = dArray2[n52];
                                    dArray[n62 + 1] = dArray2[n52 + 1];
                                    dArray[n62 + 2] = dArray2[n42];
                                    dArray[n62 + 3] = dArray2[n42 + 1];
                                }
                                break block21;
                            }
                            if (DoubleFFT_2D.this.columns != 2 * n5) break block21;
                            for (n3 = 0; n3 < DoubleFFT_2D.this.rows; ++n3) {
                                n2 = n3 * DoubleFFT_2D.this.columns + 2 * n6;
                                n24 = 2 * n3;
                                dArray2[n24] = dArray[n2];
                                dArray2[n24 + 1] = dArray[n2 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(dArray2, 0);
                            for (n3 = 0; n3 < DoubleFFT_2D.this.rows; ++n3) {
                                n2 = n3 * DoubleFFT_2D.this.columns + 2 * n6;
                                n24 = 2 * n3;
                                dArray[n2] = dArray2[n24];
                                dArray[n2 + 1] = dArray2[n24 + 1];
                            }
                            break block21;
                        }
                        if (DoubleFFT_2D.this.columns > 4 * n5) {
                            for (int i = 8 * n6; i < DoubleFFT_2D.this.columns; i += 8 * n5) {
                                int n25;
                                int n14;
                                int n15;
                                int n16;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < DoubleFFT_2D.this.rows; ++n18) {
                                    n17 = n18 * DoubleFFT_2D.this.columns + i;
                                    n16 = 2 * n18;
                                    n15 = 2 * DoubleFFT_2D.this.rows + 2 * n18;
                                    n14 = n15 + 2 * DoubleFFT_2D.this.rows;
                                    n25 = n14 + 2 * DoubleFFT_2D.this.rows;
                                    dArray2[n16] = dArray[n17];
                                    dArray2[n16 + 1] = dArray[n17 + 1];
                                    dArray2[n15] = dArray[n17 + 2];
                                    dArray2[n15 + 1] = dArray[n17 + 3];
                                    dArray2[n14] = dArray[n17 + 4];
                                    dArray2[n14 + 1] = dArray[n17 + 5];
                                    dArray2[n25] = dArray[n17 + 6];
                                    dArray2[n25 + 1] = dArray[n17 + 7];
                                }
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 0, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_2D.this.rows, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 4 * DoubleFFT_2D.this.rows, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 6 * DoubleFFT_2D.this.rows, bl);
                                for (n18 = 0; n18 < DoubleFFT_2D.this.rows; ++n18) {
                                    n17 = n18 * DoubleFFT_2D.this.columns + i;
                                    n16 = 2 * n18;
                                    n15 = 2 * DoubleFFT_2D.this.rows + 2 * n18;
                                    n14 = n15 + 2 * DoubleFFT_2D.this.rows;
                                    n25 = n14 + 2 * DoubleFFT_2D.this.rows;
                                    dArray[n17] = dArray2[n16];
                                    dArray[n17 + 1] = dArray2[n16 + 1];
                                    dArray[n17 + 2] = dArray2[n15];
                                    dArray[n17 + 3] = dArray2[n15 + 1];
                                    dArray[n17 + 4] = dArray2[n14];
                                    dArray[n17 + 5] = dArray2[n14 + 1];
                                    dArray[n17 + 6] = dArray2[n25];
                                    dArray[n17 + 7] = dArray2[n25 + 1];
                                }
                            }
                        } else if (DoubleFFT_2D.this.columns == 4 * n5) {
                            int n26;
                            int n19;
                            int n20;
                            int n21;
                            for (n21 = 0; n21 < DoubleFFT_2D.this.rows; ++n21) {
                                n20 = n21 * DoubleFFT_2D.this.columns + 4 * n6;
                                n19 = 2 * n21;
                                n26 = 2 * DoubleFFT_2D.this.rows + 2 * n21;
                                dArray2[n19] = dArray[n20];
                                dArray2[n19 + 1] = dArray[n20 + 1];
                                dArray2[n26] = dArray[n20 + 2];
                                dArray2[n26 + 1] = dArray[n20 + 3];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 0, bl);
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_2D.this.rows, bl);
                            for (n21 = 0; n21 < DoubleFFT_2D.this.rows; ++n21) {
                                n20 = n21 * DoubleFFT_2D.this.columns + 4 * n6;
                                n19 = 2 * n21;
                                n26 = 2 * DoubleFFT_2D.this.rows + 2 * n21;
                                dArray[n20] = dArray2[n19];
                                dArray[n20 + 1] = dArray2[n19 + 1];
                                dArray[n20 + 2] = dArray2[n26];
                                dArray[n20 + 3] = dArray2[n26 + 1];
                            }
                        } else if (DoubleFFT_2D.this.columns == 2 * n5) {
                            int n27;
                            int n22;
                            int n23;
                            for (n23 = 0; n23 < DoubleFFT_2D.this.rows; ++n23) {
                                n22 = n23 * DoubleFFT_2D.this.columns + 2 * n6;
                                n27 = 2 * n23;
                                dArray2[n27] = dArray[n22];
                                dArray2[n27 + 1] = dArray[n22 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 0, bl);
                            for (n23 = 0; n23 < DoubleFFT_2D.this.rows; ++n23) {
                                n22 = n23 * DoubleFFT_2D.this.columns + 2 * n6;
                                n27 = 2 * n23;
                                dArray[n22] = dArray2[n27];
                                dArray[n22 + 1] = dArray2[n27 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final DoubleLargeArray doubleLargeArray, final boolean bl) {
        int n2 = (int)Math.min(this.columnsl / 2L, (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 8L * this.rowsl;
        if (this.columnsl == 4L) {
            l >>= 1;
        } else if (this.columnsl < 4L) {
            l >>= 2;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        final int n3 = n2;
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        DoubleLargeArray doubleLargeArray2;
                        block19: {
                            long l;
                            long l24;
                            long l32;
                            block22: {
                                long l4;
                                long l5;
                                long l6;
                                long l7;
                                block20: {
                                    doubleLargeArray2 = new DoubleLargeArray(l2, false);
                                    if (n != -1) break block19;
                                    if (DoubleFFT_2D.this.columnsl <= (long)(4 * n3)) break block20;
                                    for (long i = 8L * l3; i < DoubleFFT_2D.this.columnsl; i += (long)(8 * n3)) {
                                        long l8;
                                        long l9;
                                        long l10;
                                        long l11;
                                        long l12;
                                        long l13;
                                        for (l13 = 0L; l13 < DoubleFFT_2D.this.rowsl; ++l13) {
                                            l12 = l13 * DoubleFFT_2D.this.columnsl + i;
                                            l11 = 2L * l13;
                                            l10 = 2L * DoubleFFT_2D.this.rowsl + 2L * l13;
                                            l9 = l10 + 2L * DoubleFFT_2D.this.rowsl;
                                            l8 = l9 + 2L * DoubleFFT_2D.this.rowsl;
                                            doubleLargeArray2.setDouble(l11, doubleLargeArray.getDouble(l12));
                                            doubleLargeArray2.setDouble(l11 + 1L, doubleLargeArray.getDouble(l12 + 1L));
                                            doubleLargeArray2.setDouble(l10, doubleLargeArray.getDouble(l12 + 2L));
                                            doubleLargeArray2.setDouble(l10 + 1L, doubleLargeArray.getDouble(l12 + 3L));
                                            doubleLargeArray2.setDouble(l9, doubleLargeArray.getDouble(l12 + 4L));
                                            doubleLargeArray2.setDouble(l9 + 1L, doubleLargeArray.getDouble(l12 + 5L));
                                            doubleLargeArray2.setDouble(l8, doubleLargeArray.getDouble(l12 + 6L));
                                            doubleLargeArray2.setDouble(l8 + 1L, doubleLargeArray.getDouble(l12 + 7L));
                                        }
                                        DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                                        DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 2L * DoubleFFT_2D.this.rowsl);
                                        DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 4L * DoubleFFT_2D.this.rowsl);
                                        DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 6L * DoubleFFT_2D.this.rowsl);
                                        for (l13 = 0L; l13 < DoubleFFT_2D.this.rowsl; ++l13) {
                                            l12 = l13 * DoubleFFT_2D.this.columnsl + i;
                                            l11 = 2L * l13;
                                            l10 = 2L * DoubleFFT_2D.this.rowsl + 2L * l13;
                                            l9 = l10 + 2L * DoubleFFT_2D.this.rowsl;
                                            l8 = l9 + 2L * DoubleFFT_2D.this.rowsl;
                                            doubleLargeArray.setDouble(l12, doubleLargeArray2.getDouble(l11));
                                            doubleLargeArray.setDouble(l12 + 1L, doubleLargeArray2.getDouble(l11 + 1L));
                                            doubleLargeArray.setDouble(l12 + 2L, doubleLargeArray2.getDouble(l10));
                                            doubleLargeArray.setDouble(l12 + 3L, doubleLargeArray2.getDouble(l10 + 1L));
                                            doubleLargeArray.setDouble(l12 + 4L, doubleLargeArray2.getDouble(l9));
                                            doubleLargeArray.setDouble(l12 + 5L, doubleLargeArray2.getDouble(l9 + 1L));
                                            doubleLargeArray.setDouble(l12 + 6L, doubleLargeArray2.getDouble(l8));
                                            doubleLargeArray.setDouble(l12 + 7L, doubleLargeArray2.getDouble(l8 + 1L));
                                        }
                                    }
                                    break block21;
                                }
                                if (DoubleFFT_2D.this.columnsl != (long)(4 * n3)) break block22;
                                for (l7 = 0L; l7 < DoubleFFT_2D.this.rowsl; ++l7) {
                                    l6 = l7 * DoubleFFT_2D.this.columnsl + 4L * l3;
                                    l5 = 2L * l7;
                                    l4 = 2L * DoubleFFT_2D.this.rowsl + 2L * l7;
                                    doubleLargeArray2.setDouble(l5, doubleLargeArray.getDouble(l6));
                                    doubleLargeArray2.setDouble(l5 + 1L, doubleLargeArray.getDouble(l6 + 1L));
                                    doubleLargeArray2.setDouble(l4, doubleLargeArray.getDouble(l6 + 2L));
                                    doubleLargeArray2.setDouble(l4 + 1L, doubleLargeArray.getDouble(l6 + 3L));
                                }
                                DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                                DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 2L * DoubleFFT_2D.this.rowsl);
                                for (l7 = 0L; l7 < DoubleFFT_2D.this.rowsl; ++l7) {
                                    l6 = l7 * DoubleFFT_2D.this.columnsl + 4L * l3;
                                    l5 = 2L * l7;
                                    l4 = 2L * DoubleFFT_2D.this.rowsl + 2L * l7;
                                    doubleLargeArray.setDouble(l6, doubleLargeArray2.getDouble(l5));
                                    doubleLargeArray.setDouble(l6 + 1L, doubleLargeArray2.getDouble(l5 + 1L));
                                    doubleLargeArray.setDouble(l6 + 2L, doubleLargeArray2.getDouble(l4));
                                    doubleLargeArray.setDouble(l6 + 3L, doubleLargeArray2.getDouble(l4 + 1L));
                                }
                                break block21;
                            }
                            if (DoubleFFT_2D.this.columnsl != (long)(2 * n3)) break block21;
                            for (l32 = 0L; l32 < DoubleFFT_2D.this.rowsl; ++l32) {
                                l24 = l32 * DoubleFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l32;
                                doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l24));
                                doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l24 + 1L));
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(doubleLargeArray2, 0L);
                            for (l32 = 0L; l32 < DoubleFFT_2D.this.rowsl; ++l32) {
                                l24 = l32 * DoubleFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l32;
                                doubleLargeArray.setDouble(l24, doubleLargeArray2.getDouble(l));
                                doubleLargeArray.setDouble(l24 + 1L, doubleLargeArray2.getDouble(l + 1L));
                            }
                            break block21;
                        }
                        if (DoubleFFT_2D.this.columnsl > (long)(4 * n3)) {
                            for (long i = 8L * l3; i < DoubleFFT_2D.this.columnsl; i += (long)(8 * n3)) {
                                long l;
                                long l14;
                                long l15;
                                long l16;
                                long l17;
                                long l18;
                                for (l18 = 0L; l18 < DoubleFFT_2D.this.rowsl; ++l18) {
                                    l17 = l18 * DoubleFFT_2D.this.columnsl + i;
                                    l16 = 2L * l18;
                                    l15 = 2L * DoubleFFT_2D.this.rowsl + 2L * l18;
                                    l14 = l15 + 2L * DoubleFFT_2D.this.rowsl;
                                    l = l14 + 2L * DoubleFFT_2D.this.rowsl;
                                    doubleLargeArray2.setDouble(l16, doubleLargeArray.getDouble(l17));
                                    doubleLargeArray2.setDouble(l16 + 1L, doubleLargeArray.getDouble(l17 + 1L));
                                    doubleLargeArray2.setDouble(l15, doubleLargeArray.getDouble(l17 + 2L));
                                    doubleLargeArray2.setDouble(l15 + 1L, doubleLargeArray.getDouble(l17 + 3L));
                                    doubleLargeArray2.setDouble(l14, doubleLargeArray.getDouble(l17 + 4L));
                                    doubleLargeArray2.setDouble(l14 + 1L, doubleLargeArray.getDouble(l17 + 5L));
                                    doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l17 + 6L));
                                    doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l17 + 7L));
                                }
                                DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 2L * DoubleFFT_2D.this.rowsl, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 4L * DoubleFFT_2D.this.rowsl, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 6L * DoubleFFT_2D.this.rowsl, bl);
                                for (l18 = 0L; l18 < DoubleFFT_2D.this.rowsl; ++l18) {
                                    l17 = l18 * DoubleFFT_2D.this.columnsl + i;
                                    l16 = 2L * l18;
                                    l15 = 2L * DoubleFFT_2D.this.rowsl + 2L * l18;
                                    l14 = l15 + 2L * DoubleFFT_2D.this.rowsl;
                                    l = l14 + 2L * DoubleFFT_2D.this.rowsl;
                                    doubleLargeArray.setDouble(l17, doubleLargeArray2.getDouble(l16));
                                    doubleLargeArray.setDouble(l17 + 1L, doubleLargeArray2.getDouble(l16 + 1L));
                                    doubleLargeArray.setDouble(l17 + 2L, doubleLargeArray2.getDouble(l15));
                                    doubleLargeArray.setDouble(l17 + 3L, doubleLargeArray2.getDouble(l15 + 1L));
                                    doubleLargeArray.setDouble(l17 + 4L, doubleLargeArray2.getDouble(l14));
                                    doubleLargeArray.setDouble(l17 + 5L, doubleLargeArray2.getDouble(l14 + 1L));
                                    doubleLargeArray.setDouble(l17 + 6L, doubleLargeArray2.getDouble(l));
                                    doubleLargeArray.setDouble(l17 + 7L, doubleLargeArray2.getDouble(l + 1L));
                                }
                            }
                        } else if (DoubleFFT_2D.this.columnsl == (long)(4 * n3)) {
                            long l;
                            long l19;
                            long l20;
                            long l21;
                            for (l21 = 0L; l21 < DoubleFFT_2D.this.rowsl; ++l21) {
                                l20 = l21 * DoubleFFT_2D.this.columnsl + 4L * l3;
                                l19 = 2L * l21;
                                l = 2L * DoubleFFT_2D.this.rowsl + 2L * l21;
                                doubleLargeArray2.setDouble(l19, doubleLargeArray.getDouble(l20));
                                doubleLargeArray2.setDouble(l19 + 1L, doubleLargeArray.getDouble(l20 + 1L));
                                doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l20 + 2L));
                                doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l20 + 3L));
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                            DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 2L * DoubleFFT_2D.this.rowsl, bl);
                            for (l21 = 0L; l21 < DoubleFFT_2D.this.rowsl; ++l21) {
                                l20 = l21 * DoubleFFT_2D.this.columnsl + 4L * l3;
                                l19 = 2L * l21;
                                l = 2L * DoubleFFT_2D.this.rowsl + 2L * l21;
                                doubleLargeArray.setDouble(l20, doubleLargeArray2.getDouble(l19));
                                doubleLargeArray.setDouble(l20 + 1L, doubleLargeArray2.getDouble(l19 + 1L));
                                doubleLargeArray.setDouble(l20 + 2L, doubleLargeArray2.getDouble(l));
                                doubleLargeArray.setDouble(l20 + 3L, doubleLargeArray2.getDouble(l + 1L));
                            }
                        } else if (DoubleFFT_2D.this.columnsl == (long)(2 * n3)) {
                            long l;
                            long l22;
                            long l23;
                            for (l23 = 0L; l23 < DoubleFFT_2D.this.rowsl; ++l23) {
                                l22 = l23 * DoubleFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l23;
                                doubleLargeArray2.setDouble(l, doubleLargeArray.getDouble(l22));
                                doubleLargeArray2.setDouble(l + 1L, doubleLargeArray.getDouble(l22 + 1L));
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(doubleLargeArray2, 0L, bl);
                            for (l23 = 0L; l23 < DoubleFFT_2D.this.rowsl; ++l23) {
                                l22 = l23 * DoubleFFT_2D.this.columnsl + 2L * l3;
                                l = 2L * l23;
                                doubleLargeArray.setDouble(l22, doubleLargeArray2.getDouble(l));
                                doubleLargeArray.setDouble(l22 + 1L, doubleLargeArray2.getDouble(l + 1L));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final double[][] dArray, final boolean bl) {
        int n2 = Math.min(this.columns / 2, ConcurrencyUtils.getNumberOfThreads());
        int n3 = 8 * this.rows;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        final int n5 = n2;
        for (int i = 0; i < n5; ++i) {
            final int n6 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        double[] dArray2;
                        block19: {
                            int n18;
                            int n2;
                            block22: {
                                int n3;
                                int n42;
                                int n52;
                                block20: {
                                    dArray2 = new double[n4];
                                    if (n != -1) break block19;
                                    if (DoubleFFT_2D.this.columns <= 4 * n5) break block20;
                                    for (int i = 8 * n6; i < DoubleFFT_2D.this.columns; i += 8 * n5) {
                                        int n62;
                                        int n7;
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < DoubleFFT_2D.this.rows; ++n10) {
                                            n9 = 2 * n10;
                                            n8 = 2 * DoubleFFT_2D.this.rows + 2 * n10;
                                            n7 = n8 + 2 * DoubleFFT_2D.this.rows;
                                            n62 = n7 + 2 * DoubleFFT_2D.this.rows;
                                            dArray2[n9] = dArray[n10][i];
                                            dArray2[n9 + 1] = dArray[n10][i + 1];
                                            dArray2[n8] = dArray[n10][i + 2];
                                            dArray2[n8 + 1] = dArray[n10][i + 3];
                                            dArray2[n7] = dArray[n10][i + 4];
                                            dArray2[n7 + 1] = dArray[n10][i + 5];
                                            dArray2[n62] = dArray[n10][i + 6];
                                            dArray2[n62 + 1] = dArray[n10][i + 7];
                                        }
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 0);
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_2D.this.rows);
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 4 * DoubleFFT_2D.this.rows);
                                        DoubleFFT_2D.this.fftRows.complexForward(dArray2, 6 * DoubleFFT_2D.this.rows);
                                        for (n10 = 0; n10 < DoubleFFT_2D.this.rows; ++n10) {
                                            n9 = 2 * n10;
                                            n8 = 2 * DoubleFFT_2D.this.rows + 2 * n10;
                                            n7 = n8 + 2 * DoubleFFT_2D.this.rows;
                                            n62 = n7 + 2 * DoubleFFT_2D.this.rows;
                                            dArray[n10][i] = dArray2[n9];
                                            dArray[n10][i + 1] = dArray2[n9 + 1];
                                            dArray[n10][i + 2] = dArray2[n8];
                                            dArray[n10][i + 3] = dArray2[n8 + 1];
                                            dArray[n10][i + 4] = dArray2[n7];
                                            dArray[n10][i + 5] = dArray2[n7 + 1];
                                            dArray[n10][i + 6] = dArray2[n62];
                                            dArray[n10][i + 7] = dArray2[n62 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (DoubleFFT_2D.this.columns != 4 * n5) break block22;
                                for (n52 = 0; n52 < DoubleFFT_2D.this.rows; ++n52) {
                                    n42 = 2 * n52;
                                    n3 = 2 * DoubleFFT_2D.this.rows + 2 * n52;
                                    dArray2[n42] = dArray[n52][4 * n6];
                                    dArray2[n42 + 1] = dArray[n52][4 * n6 + 1];
                                    dArray2[n3] = dArray[n52][4 * n6 + 2];
                                    dArray2[n3 + 1] = dArray[n52][4 * n6 + 3];
                                }
                                DoubleFFT_2D.this.fftRows.complexForward(dArray2, 0);
                                DoubleFFT_2D.this.fftRows.complexForward(dArray2, 2 * DoubleFFT_2D.this.rows);
                                for (n52 = 0; n52 < DoubleFFT_2D.this.rows; ++n52) {
                                    n42 = 2 * n52;
                                    n3 = 2 * DoubleFFT_2D.this.rows + 2 * n52;
                                    dArray[n52][4 * n6] = dArray2[n42];
                                    dArray[n52][4 * n6 + 1] = dArray2[n42 + 1];
                                    dArray[n52][4 * n6 + 2] = dArray2[n3];
                                    dArray[n52][4 * n6 + 3] = dArray2[n3 + 1];
                                }
                                break block21;
                            }
                            if (DoubleFFT_2D.this.columns != 2 * n5) break block21;
                            for (n2 = 0; n2 < DoubleFFT_2D.this.rows; ++n2) {
                                n18 = 2 * n2;
                                dArray2[n18] = dArray[n2][2 * n6];
                                dArray2[n18 + 1] = dArray[n2][2 * n6 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexForward(dArray2, 0);
                            for (n2 = 0; n2 < DoubleFFT_2D.this.rows; ++n2) {
                                n18 = 2 * n2;
                                dArray[n2][2 * n6] = dArray2[n18];
                                dArray[n2][2 * n6 + 1] = dArray2[n18 + 1];
                            }
                            break block21;
                        }
                        if (DoubleFFT_2D.this.columns > 4 * n5) {
                            for (int i = 8 * n6; i < DoubleFFT_2D.this.columns; i += 8 * n5) {
                                int n19;
                                int n11;
                                int n12;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < DoubleFFT_2D.this.rows; ++n14) {
                                    n13 = 2 * n14;
                                    n12 = 2 * DoubleFFT_2D.this.rows + 2 * n14;
                                    n11 = n12 + 2 * DoubleFFT_2D.this.rows;
                                    n19 = n11 + 2 * DoubleFFT_2D.this.rows;
                                    dArray2[n13] = dArray[n14][i];
                                    dArray2[n13 + 1] = dArray[n14][i + 1];
                                    dArray2[n12] = dArray[n14][i + 2];
                                    dArray2[n12 + 1] = dArray[n14][i + 3];
                                    dArray2[n11] = dArray[n14][i + 4];
                                    dArray2[n11 + 1] = dArray[n14][i + 5];
                                    dArray2[n19] = dArray[n14][i + 6];
                                    dArray2[n19 + 1] = dArray[n14][i + 7];
                                }
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 0, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_2D.this.rows, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 4 * DoubleFFT_2D.this.rows, bl);
                                DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 6 * DoubleFFT_2D.this.rows, bl);
                                for (n14 = 0; n14 < DoubleFFT_2D.this.rows; ++n14) {
                                    n13 = 2 * n14;
                                    n12 = 2 * DoubleFFT_2D.this.rows + 2 * n14;
                                    n11 = n12 + 2 * DoubleFFT_2D.this.rows;
                                    n19 = n11 + 2 * DoubleFFT_2D.this.rows;
                                    dArray[n14][i] = dArray2[n13];
                                    dArray[n14][i + 1] = dArray2[n13 + 1];
                                    dArray[n14][i + 2] = dArray2[n12];
                                    dArray[n14][i + 3] = dArray2[n12 + 1];
                                    dArray[n14][i + 4] = dArray2[n11];
                                    dArray[n14][i + 5] = dArray2[n11 + 1];
                                    dArray[n14][i + 6] = dArray2[n19];
                                    dArray[n14][i + 7] = dArray2[n19 + 1];
                                }
                            }
                        } else if (DoubleFFT_2D.this.columns == 4 * n5) {
                            int n20;
                            int n15;
                            int n16;
                            for (n16 = 0; n16 < DoubleFFT_2D.this.rows; ++n16) {
                                n15 = 2 * n16;
                                n20 = 2 * DoubleFFT_2D.this.rows + 2 * n16;
                                dArray2[n15] = dArray[n16][4 * n6];
                                dArray2[n15 + 1] = dArray[n16][4 * n6 + 1];
                                dArray2[n20] = dArray[n16][4 * n6 + 2];
                                dArray2[n20 + 1] = dArray[n16][4 * n6 + 3];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 0, bl);
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 2 * DoubleFFT_2D.this.rows, bl);
                            for (n16 = 0; n16 < DoubleFFT_2D.this.rows; ++n16) {
                                n15 = 2 * n16;
                                n20 = 2 * DoubleFFT_2D.this.rows + 2 * n16;
                                dArray[n16][4 * n6] = dArray2[n15];
                                dArray[n16][4 * n6 + 1] = dArray2[n15 + 1];
                                dArray[n16][4 * n6 + 2] = dArray2[n20];
                                dArray[n16][4 * n6 + 3] = dArray2[n20 + 1];
                            }
                        } else if (DoubleFFT_2D.this.columns == 2 * n5) {
                            int n21;
                            int n17;
                            for (n17 = 0; n17 < DoubleFFT_2D.this.rows; ++n17) {
                                n21 = 2 * n17;
                                dArray2[n21] = dArray[n17][2 * n6];
                                dArray2[n21 + 1] = dArray[n17][2 * n6 + 1];
                            }
                            DoubleFFT_2D.this.fftRows.complexInverse(dArray2, 0, bl);
                            for (n17 = 0; n17 < DoubleFFT_2D.this.rows; ++n17) {
                                n21 = 2 * n17;
                                dArray[n17][2 * n6] = dArray2[n21];
                                dArray[n17][2 * n6 + 1] = dArray2[n21 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void fillSymmetric(final double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 2 * this.columns;
        int n6 = this.rows / 2;
        for (n4 = this.rows - 1; n4 >= 1; --n4) {
            n3 = n4 * this.columns;
            n2 = 2 * n3;
            for (n = 0; n < this.columns; n += 2) {
                dArray[n2 + n] = dArray[n3 + n];
                dArray[n3 + n] = 0.0;
                dArray[n2 + n + 1] = dArray[n3 + n + 1];
                dArray[n3 + n + 1] = 0.0;
            }
        }
        n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && n6 >= n4) {
            Future[] futureArray = new Future[n4];
            int n7 = n6 / n4;
            final int n8 = 2 * this.columns;
            for (int i = 0; i < n4; ++i) {
                final int n9 = i == 0 ? i * n7 + 1 : i * n7;
                final int n10 = i * n7 + n7;
                final int n11 = i * n7;
                final int n12 = i == n4 - 1 ? i * n7 + n7 + 1 : i * n7 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = n9; n6 < n10; ++n6) {
                            n5 = n6 * n8;
                            n4 = (DoubleFFT_2D.this.rows - n6) * n8;
                            n3 = n5 + DoubleFFT_2D.this.columns;
                            dArray[n3] = dArray[n4 + 1];
                            dArray[n3 + 1] = -dArray[n4];
                        }
                        for (n6 = n9; n6 < n10; ++n6) {
                            n5 = n6 * n8;
                            n3 = (DoubleFFT_2D.this.rows - n6 + 1) * n8;
                            for (n2 = DoubleFFT_2D.this.columns + 2; n2 < n8; n2 += 2) {
                                n4 = n3 - n2;
                                n = n5 + n2;
                                dArray[n] = dArray[n4];
                                dArray[n + 1] = -dArray[n4 + 1];
                            }
                        }
                        for (n6 = n11; n6 < n12; ++n6) {
                            n3 = (DoubleFFT_2D.this.rows - n6) % DoubleFFT_2D.this.rows * n8;
                            n = n6 * n8;
                            for (n2 = 0; n2 < n8; n2 += 2) {
                                n5 = n3 + (n8 - n2) % n8;
                                n4 = n + n2;
                                dArray[n5] = dArray[n4];
                                dArray[n5 + 1] = -dArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n13;
            int n14;
            for (n = 1; n < n6; ++n) {
                n2 = n * n5;
                n14 = (this.rows - n) * n5;
                dArray[n2 + this.columns] = dArray[n14 + 1];
                dArray[n2 + this.columns + 1] = -dArray[n14];
            }
            for (n = 1; n < n6; ++n) {
                n2 = n * n5;
                n14 = (this.rows - n + 1) * n5;
                for (n13 = this.columns + 2; n13 < n5; n13 += 2) {
                    dArray[n2 + n13] = dArray[n14 - n13];
                    dArray[n2 + n13 + 1] = -dArray[n14 - n13 + 1];
                }
            }
            for (n = 0; n <= this.rows / 2; ++n) {
                n3 = n * n5;
                int n15 = (this.rows - n) % this.rows * n5;
                for (n13 = 0; n13 < n5; n13 += 2) {
                    n2 = n3 + n13;
                    n14 = n15 + (n5 - n13) % n5;
                    dArray[n14] = dArray[n2];
                    dArray[n14 + 1] = -dArray[n2 + 1];
                }
            }
        }
        dArray[this.columns] = -dArray[1];
        dArray[1] = 0.0;
        n3 = n6 * n5;
        dArray[n3 + this.columns] = -dArray[n3 + 1];
        dArray[n3 + 1] = 0.0;
        dArray[n3 + this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final DoubleLargeArray doubleLargeArray) {
        long l;
        long l2;
        long l3;
        long l4 = 2L * this.columnsl;
        long l5 = this.rowsl / 2L;
        for (long i = this.rowsl - 1L; i >= 1L; --i) {
            l3 = i * this.columnsl;
            l2 = 2L * l3;
            for (l = 0L; l < this.columnsl; l += 2L) {
                doubleLargeArray.setDouble(l2 + l, doubleLargeArray.getDouble(l3 + l));
                doubleLargeArray.setDouble(l3 + l, 0.0);
                doubleLargeArray.setDouble(l2 + l + 1L, doubleLargeArray.getDouble(l3 + l + 1L));
                doubleLargeArray.setDouble(l3 + l + 1L, 0.0);
            }
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.useThreads && l5 >= (long)n) {
            Future[] futureArray = new Future[n];
            l = l5 / (long)n;
            final long l6 = 2L * this.columnsl;
            for (int i = 0; i < n; ++i) {
                final long l7 = i == 0 ? (long)i * l + 1L : (long)i * l;
                final long l8 = (long)i * l + l;
                final long l9 = (long)i * l;
                final long l10 = i == n - 1 ? (long)i * l + l + 1L : (long)i * l + l;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        long l;
                        long l2;
                        long l3;
                        long l4;
                        long l5;
                        long l62;
                        for (l62 = l7; l62 < l8; ++l62) {
                            l5 = l62 * l6;
                            l4 = (DoubleFFT_2D.this.rowsl - l62) * l6;
                            l3 = l5 + DoubleFFT_2D.this.columnsl;
                            doubleLargeArray.setDouble(l3, doubleLargeArray.getDouble(l4 + 1L));
                            doubleLargeArray.setDouble(l3 + 1L, -doubleLargeArray.getDouble(l4));
                        }
                        for (l62 = l7; l62 < l8; ++l62) {
                            l5 = l62 * l6;
                            l3 = (DoubleFFT_2D.this.rowsl - l62 + 1L) * l6;
                            for (l2 = DoubleFFT_2D.this.columnsl + 2L; l2 < l6; l2 += 2L) {
                                l4 = l3 - l2;
                                l = l5 + l2;
                                doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l4));
                                doubleLargeArray.setDouble(l + 1L, -doubleLargeArray.getDouble(l4 + 1L));
                            }
                        }
                        for (l62 = l9; l62 < l10; ++l62) {
                            l3 = (DoubleFFT_2D.this.rowsl - l62) % DoubleFFT_2D.this.rowsl * l6;
                            l = l62 * l6;
                            for (l2 = 0L; l2 < l6; l2 += 2L) {
                                l5 = l3 + (l6 - l2) % l6;
                                l4 = l + l2;
                                doubleLargeArray.setDouble(l5, doubleLargeArray.getDouble(l4));
                                doubleLargeArray.setDouble(l5 + 1L, -doubleLargeArray.getDouble(l4 + 1L));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l11;
            long l12;
            long l13;
            for (l13 = 1L; l13 < l5; ++l13) {
                l2 = l13 * l4;
                l12 = (this.rowsl - l13) * l4;
                doubleLargeArray.setDouble(l2 + this.columnsl, doubleLargeArray.getDouble(l12 + 1L));
                doubleLargeArray.setDouble(l2 + this.columnsl + 1L, -doubleLargeArray.getDouble(l12));
            }
            for (l13 = 1L; l13 < l5; ++l13) {
                l2 = l13 * l4;
                l12 = (this.rowsl - l13 + 1L) * l4;
                for (l11 = this.columnsl + 2L; l11 < l4; l11 += 2L) {
                    doubleLargeArray.setDouble(l2 + l11, doubleLargeArray.getDouble(l12 - l11));
                    doubleLargeArray.setDouble(l2 + l11 + 1L, -doubleLargeArray.getDouble(l12 - l11 + 1L));
                }
            }
            for (l13 = 0L; l13 <= this.rowsl / 2L; ++l13) {
                l3 = l13 * l4;
                long l14 = (this.rowsl - l13) % this.rowsl * l4;
                for (l11 = 0L; l11 < l4; l11 += 2L) {
                    l2 = l3 + l11;
                    l12 = l14 + (l4 - l11) % l4;
                    doubleLargeArray.setDouble(l12, doubleLargeArray.getDouble(l2));
                    doubleLargeArray.setDouble(l12 + 1L, -doubleLargeArray.getDouble(l2 + 1L));
                }
            }
        }
        doubleLargeArray.setDouble(this.columnsl, -doubleLargeArray.getDouble(1L));
        doubleLargeArray.setDouble(1L, 0.0);
        l3 = l5 * l4;
        doubleLargeArray.setDouble(l3 + this.columnsl, -doubleLargeArray.getDouble(l3 + 1L));
        doubleLargeArray.setDouble(l3 + 1L, 0.0);
        doubleLargeArray.setDouble(l3 + this.columnsl + 1L, 0.0);
    }

    private void fillSymmetric(final double[][] dArray) {
        final int n = 2 * this.columns;
        int n2 = this.rows / 2;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && n2 >= n3) {
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i == 0 ? i * n4 + 1 : i * n4;
                final int n6 = i * n4 + n4;
                final int n7 = i * n4;
                final int n8 = i == n3 - 1 ? i * n4 + n4 + 1 : i * n4 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n9;
                        int n2;
                        int n3;
                        int n4;
                        for (n4 = n5; n4 < n6; ++n4) {
                            n3 = DoubleFFT_2D.this.rows - n4;
                            dArray[n4][((DoubleFFT_2D)DoubleFFT_2D.this).columns] = dArray[n3][1];
                            dArray[n4][((DoubleFFT_2D)DoubleFFT_2D.this).columns + 1] = -dArray[n3][0];
                        }
                        for (n4 = n5; n4 < n6; ++n4) {
                            n3 = DoubleFFT_2D.this.rows - n4;
                            for (n2 = DoubleFFT_2D.this.columns + 2; n2 < n; n2 += 2) {
                                n9 = n - n2;
                                dArray[n4][n2] = dArray[n3][n9];
                                dArray[n4][n2 + 1] = -dArray[n3][n9 + 1];
                            }
                        }
                        for (n4 = n7; n4 < n8; ++n4) {
                            n3 = (DoubleFFT_2D.this.rows - n4) % DoubleFFT_2D.this.rows;
                            for (n2 = 0; n2 < n; n2 += 2) {
                                n9 = (n - n2) % n;
                                dArray[n3][n9] = dArray[n4][n2];
                                dArray[n3][n9 + 1] = -dArray[n4][n2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            for (n12 = 1; n12 < n2; ++n12) {
                n11 = this.rows - n12;
                dArray[n12][this.columns] = dArray[n11][1];
                dArray[n12][this.columns + 1] = -dArray[n11][0];
            }
            for (n12 = 1; n12 < n2; ++n12) {
                n11 = this.rows - n12;
                for (n10 = this.columns + 2; n10 < n; n10 += 2) {
                    n9 = n - n10;
                    dArray[n12][n10] = dArray[n11][n9];
                    dArray[n12][n10 + 1] = -dArray[n11][n9 + 1];
                }
            }
            for (n12 = 0; n12 <= this.rows / 2; ++n12) {
                n11 = (this.rows - n12) % this.rows;
                for (n10 = 0; n10 < n; n10 += 2) {
                    n9 = (n - n10) % n;
                    dArray[n11][n9] = dArray[n12][n10];
                    dArray[n11][n9 + 1] = -dArray[n12][n10 + 1];
                }
            }
        }
        dArray[0][this.columns] = -dArray[0][1];
        dArray[0][1] = 0.0;
        dArray[n2][this.columns] = -dArray[n2][1];
        dArray[n2][1] = 0.0;
        dArray[n2][this.columns + 1] = 0.0;
    }
}

