/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.log4j.Logger;

public class ChecksumUtils {
    private static final Logger log = Logger.getLogger(ChecksumUtils.class);

    public static long adler32(Path p) throws IOException {
        return ChecksumUtils.file(p, new Adler32());
    }

    public static long crc32(Path p) throws IOException {
        return ChecksumUtils.file(p, new CRC32());
    }

    public static long file(Path p, Checksum c) throws IOException {
        log.debug((Object)("Calculating checksum for " + p));
        byte[] buf = new byte[131136];
        try (CheckedInputStream cis = new CheckedInputStream(Files.newInputStream(p, new OpenOption[0]), c);){
            while (cis.read(buf, 0, buf.length) != -1) {
            }
            log.debug((Object)("Checksum = " + cis.getChecksum().getValue()));
            long l = cis.getChecksum().getValue();
            return l;
        }
    }
}

