/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.WigAnalysisTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public abstract class WigMathTool
extends WigAnalysisTool {
    private static final Logger log = Logger.getLogger(WigMathTool.class);
    @Parameter(names={"-f", "--fixedstep"}, description="Force fixedStep output")
    public boolean fixedStep = false;
    @Parameter(names={"-v", "--variablestep"}, description="Force variableStep output")
    public boolean variableStep = false;
    @Parameter(names={"--step"}, description="Step size for output Wig files")
    public int step = 1;
    @Parameter(names={"-o", "--output"}, required=true, description="Output Wig file")
    public Path outputFile;
    private WigFileWriter writer;

    protected abstract void setup();

    protected abstract float[] compute(Interval var1) throws IOException, WigFileException;

    @Override
    protected final void prepare() {
        this.setup();
        try {
            this.writer = new WigFileWriter(this.outputFile, TrackHeader.newWiggle());
        }
        catch (IOException e) {
            throw new CommandLineToolException("Error initializing output file " + this.outputFile, e);
        }
    }

    @Override
    protected final void shutdown() throws IOException {
        this.writer.close();
        super.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void process(Interval chunk) throws IOException, WigFileException {
        float[] result = this.compute(chunk);
        Contig outputContig = null;
        if (result.length != chunk.length()) {
            int nValues = (int)Math.ceil((float)chunk.length() / (float)this.step);
            if (result.length != nValues) {
                log.error((Object)("Expected result length=" + chunk.length() + ", got=" + result.length));
                throw new CommandLineToolException("Result of Wig computation is not the expected length!");
            }
            outputContig = new Contig(chunk, result, this.step);
        } else {
            outputContig = new Contig(chunk, result);
            if (this.step != 1) {
                outputContig.setSpan(this.step);
            }
        }
        if (this.fixedStep) {
            this.writer.writeFixedStepContig(outputContig);
            return;
        }
        if (this.variableStep) {
            this.writer.writeVariableStepContig(outputContig);
            return;
        }
        this.writer.write(outputContig);
    }
}

