/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.IntervalFileWriter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SplitReads
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(SplitReads.class);
    @Parameter(names={"-i", "--input"}, required=true, description="Input file", validateWith=ReadablePathValidator.class)
    public Path input;
    @Parameter(names={"-b", "--bins"}, description="Number of bins to split reads into")
    public int bins = 5;
    @Parameter(names={"-o", "--output"}, description="Output file")
    public Path output;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        String[] splitName = this.output.toString().split("\\.(?=[^\\.]+$)");
        String basename = splitName[0];
        String ext = splitName[1];
        ArrayList<IntervalFileWriter> writers = new ArrayList<IntervalFileWriter>();
        try {
            for (int i = 0; i < this.bins; ++i) {
                Path outFile = this.output.resolve(basename + '.' + i + '.' + ext);
                IntervalFileWriter writer = new IntervalFileWriter(outFile, new OpenOption[0]);
                writers.add(writer);
            }
            try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.input);){
                int current = 0;
                int count = 0;
                for (Interval interval : reader) {
                    ((IntervalFileWriter)writers.get(current)).write(interval);
                    ++current;
                    current %= this.bins;
                    if (++count % 1000000 != 0) continue;
                    log.debug((Object)("Processed " + count + " reads."));
                }
            }
        }
        finally {
            for (IntervalFileWriter writer : writers) {
                writer.close();
            }
        }
    }

    public static void main(String[] args) {
        new SplitReads().instanceMain(args);
    }
}

