/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.visualization;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.KMeansRow;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileSnifferException;
import edu.unc.genomics.io.WigFileException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.clustering.Cluster;
import org.apache.commons.math3.stat.clustering.KMeansPlusPlusClusterer;
import org.apache.log4j.Logger;

public class KMeans
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(KMeans.class);
    @Parameter(names={"-i", "--input"}, description="Input file (matrix2png format)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-k", "--clusters"}, description="Number of clusters")
    public int k = 10;
    @Parameter(names={"-1", "--min"}, description="Minimum column to use for clustering")
    public int minCol = 1;
    @Parameter(names={"-2", "--max"}, description="Maximum column to use for clustering")
    public Integer maxCol;
    @Parameter(names={"-o", "--output"}, description="Output file (clustered matrix2png format)", required=true)
    public Path outputFile;
    private Map<String, String> rows = new HashMap<String, String>();
    private List<KMeansRow> data = new ArrayList<KMeansRow>();

    @Override
    public void run() throws IOException {
        log.debug((Object)"Loading data from the input matrix");
        String headerLine = "";
        try (BufferedReader reader = Files.newBufferedReader(this.inputFile, Charset.defaultCharset());){
            String line;
            int lineNum = 1;
            headerLine = reader.readLine();
            int numColsInMatrix = StringUtils.countMatches((CharSequence)headerLine, (CharSequence)"\t");
            if (this.maxCol != null && this.maxCol != -1) {
                if (this.maxCol > numColsInMatrix) {
                    throw new RuntimeException("Invalid range of data specified for clustering (" + this.maxCol + " > " + numColsInMatrix + ")");
                }
            } else {
                this.maxCol = numColsInMatrix;
            }
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                if (StringUtils.countMatches((CharSequence)line, (CharSequence)"\t") != numColsInMatrix) {
                    throw new RuntimeException("Irregular input matrix does not have same number of columns on line " + lineNum);
                }
                int delim = line.indexOf(9);
                String id = line.substring(0, delim);
                String[] row = line.substring(delim + 1).split("\t");
                String[] subset = Arrays.copyOfRange(row, this.minCol, (int)this.maxCol);
                float[] rowData = new float[subset.length];
                for (int i = 0; i < subset.length; ++i) {
                    try {
                        rowData[i] = Float.parseFloat(subset[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        rowData[i] = Float.NaN;
                    }
                }
                this.data.add(new KMeansRow(id, rowData));
                this.rows.put(id, line);
            }
        }
        log.debug((Object)"Clustering the data");
        Random rng = new Random();
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(rng);
        List clusters = clusterer.cluster(this.data, this.k, 50);
        log.debug((Object)"Writing clustered data to output file");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(headerLine);
            writer.newLine();
            int n = 1;
            int count = 1;
            for (Cluster cluster : clusters) {
                int numRowsInCluster = cluster.getPoints().size();
                int stop = count + numRowsInCluster - 1;
                log.info((Object)("Cluster " + n++ + ": rows " + count + "-" + stop));
                count = stop + 1;
                for (KMeansRow row : cluster.getPoints()) {
                    writer.write(this.rows.get(row.getId()));
                    writer.newLine();
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException, IntervalFileSnifferException {
        new KMeans().instanceMain(args);
    }
}

