/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.samtools.Bin;

public class BinList
implements Iterable<Bin> {
    private final int referenceSequence;
    private final BitSet bins;

    protected BinList(int referenceSequence, BitSet bins) {
        this.referenceSequence = referenceSequence;
        this.bins = bins;
    }

    @Override
    public Iterator<Bin> iterator() {
        return new BinIterator();
    }

    protected int getReferenceSequence() {
        return this.referenceSequence;
    }

    protected BitSet getBins() {
        return this.bins;
    }

    private class BinIterator
    implements Iterator<Bin> {
        private int nextBin;

        public BinIterator() {
            this.nextBin = BinList.this.bins.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextBin >= 0;
        }

        @Override
        public Bin next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("This BinIterator is currently empty");
            }
            int currentBin = this.nextBin;
            this.nextBin = BinList.this.bins.nextSetBit(this.nextBin + 1);
            return new Bin(BinList.this.referenceSequence, currentBin);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from a bin iterator");
        }
    }
}

