/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.SAMEntry;
import java.util.Iterator;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

class SAMEntryIterator
implements Iterator<SAMEntry> {
    private final SAMRecordIterator it;
    private final boolean allowUnmapped;
    private SAMRecord nextRecord;

    public SAMEntryIterator(SAMRecordIterator it, boolean allowUnmapped) {
        this.it = it;
        this.allowUnmapped = allowUnmapped;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public SAMEntry next() {
        SAMEntry entry = new SAMEntry(this.nextRecord);
        this.advance();
        return entry;
    }

    @Override
    public void remove() {
        this.it.remove();
    }

    private void advance() {
        this.nextRecord = null;
        if (this.it.hasNext()) {
            this.nextRecord = (SAMRecord)this.it.next();
            if (!this.allowUnmapped) {
                while (this.it.hasNext() && this.nextRecord.getReadUnmappedFlag()) {
                    this.nextRecord = (SAMRecord)this.it.next();
                }
            }
        }
    }
}

