/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.SAMEntry;
import edu.unc.genomics.io.IntervalFileFormatException;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.SAMEntryIterator;
import edu.unc.genomics.util.Samtools;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;

public class SAMFileReader
extends IntervalFileReader<SAMEntry> {
    private static final Logger log = Logger.getLogger(SAMFileReader.class);
    private net.sf.samtools.SAMFileReader reader;
    private SAMRecordIterator it;
    private Set<String> chromosomes;
    private int count = 0;
    private Path bam;
    private Path index;
    private boolean allowUnmappedReads = true;

    public SAMFileReader(Path p) {
        super(p);
        log.debug((Object)("Opening SAM file reader " + p));
        this.reader = new net.sf.samtools.SAMFileReader(p.toFile());
    }

    public SAMFileReader(Path p, boolean allowUnmappedReads) {
        this(p);
        this.allowUnmappedReads = allowUnmappedReads;
    }

    @Override
    public void close() throws IOException {
        log.debug((Object)("Closing SAM file reader " + this.p));
        this.reader.close();
    }

    @Override
    public int count() {
        if (this.count == 0) {
            if (this.bam == null) {
                this.convertToBAM();
            }
            BAMIndex index = this.reader.getIndex();
            int nRefs = this.reader.getFileHeader().getSequenceDictionary().size();
            for (int i = 0; i < nRefs; ++i) {
                BAMIndexMetaData data = index.getMetaData(i);
                this.count += data.getAlignedRecordCount();
                this.count += data.getUnalignedRecordCount();
            }
        }
        return this.count;
    }

    @Override
    public Set<String> chromosomes() {
        if (this.chromosomes == null) {
            this.chromosomes = new LinkedHashSet<String>();
            SAMSequenceDictionary dict = this.reader.getFileHeader().getSequenceDictionary();
            for (SAMSequenceRecord seqRec : dict.getSequences()) {
                this.chromosomes.add(seqRec.getSequenceName());
            }
        }
        return this.chromosomes;
    }

    @Override
    public Iterator<SAMEntry> iterator() {
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.iterator();
        return new SAMEntryIterator(this.it, this.allowUnmappedReads);
    }

    @Override
    public Iterator<SAMEntry> query(String chr, int start, int stop) {
        if (this.bam == null) {
            this.convertToBAM();
        }
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.query(chr, start, stop, false);
        return new SAMEntryIterator(this.it, this.allowUnmappedReads);
    }

    private void convertToBAM() {
        log.debug((Object)("Autoconverting SAM file (" + this.p + ") to BAM"));
        try {
            this.bam = Files.createTempFile(this.p.getFileName().toString(), ".bam", new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error((Object)("Error creating temporary BAM file from SAM: " + this.p.getFileName()));
            e.printStackTrace();
            throw new RuntimeException("Error creating temporary BAM file from SAM: " + this.p.getFileName());
        }
        this.bam.toFile().deleteOnExit();
        Samtools.samToBam(this.p, this.bam);
        this.index = this.bam.resolveSibling(this.bam.getFileName() + ".bai");
        this.index.toFile().deleteOnExit();
        Samtools.indexBAMFile(this.bam, this.index);
        this.reader = new net.sf.samtools.SAMFileReader(this.bam.toFile(), this.index.toFile());
        if (!this.reader.hasIndex()) {
            throw new IntervalFileFormatException("Error indexing BAM file: " + this.bam);
        }
        this.reader.enableIndexMemoryMapping(false);
        this.reader.enableIndexCaching(true);
    }

    public boolean doesAllowUnmappedReads() {
        return this.allowUnmappedReads;
    }

    public void setAllowUnmappedReads(boolean allowUnmappedReads) {
        this.allowUnmappedReads = allowUnmappedReads;
    }
}

