/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.SequenceGenerator;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class ReferenceByIdMarshaller
extends TreeMarshaller {
    private ObjectIdDictionary references = new ObjectIdDictionary();
    private IDGenerator idGenerator;

    public ReferenceByIdMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, ClassMapper classMapper, IDGenerator idGenerator) {
        super(writer, converterLookup, classMapper);
        this.idGenerator = idGenerator;
    }

    public ReferenceByIdMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, ClassMapper classMapper) {
        this(writer, converterLookup, classMapper, new SequenceGenerator(1));
    }

    public void convertAnother(Object item) {
        Converter converter = this.converterLookup.lookupConverterForType(item.getClass());
        if (this.classMapper.isImmutableValueType(item.getClass())) {
            converter.marshal(item, this.writer, this);
        } else {
            Object idOfExistingReference = this.references.lookupId(item);
            if (idOfExistingReference != null) {
                this.writer.addAttribute("reference", idOfExistingReference.toString());
            } else {
                String newId = this.idGenerator.next();
                this.writer.addAttribute("id", newId);
                this.references.associateId(item, newId);
                converter.marshal(item, this.writer, this);
            }
        }
    }

    public static interface IDGenerator {
        public String next();
    }
}

