/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class FloatFFT_3DTest {
    public static final String DEFAULT_MESSAGE = "%d-threaded FFT of size %dx%dx%d: ";
    public static final int SEED = 20110625;
    private final FloatFFT_3D fft;
    private final int numCols;
    private final int numRows;
    private final int numSlices;
    private final Random random;
    private final FloatFFT_2D sfft;
    private final FloatFFT_1D xfft;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    arrayList.add(new Object[]{nArray[i], nArray[j], nArray[k], 1, 20110625});
                    arrayList.add(new Object[]{nArray[i], nArray[j], nArray[k], 4, 20110625});
                }
            }
        }
        return arrayList;
    }

    public FloatFFT_3DTest(int n, int n2, int n3, int n4, long l) {
        this.numSlices = n;
        this.numRows = n2;
        this.numCols = n3;
        this.fft = new FloatFFT_3D(n, n2, n3);
        this.xfft = new FloatFFT_1D(n);
        this.sfft = new FloatFFT_2D(n2, n3);
        this.random = new Random(l);
        ConcurrencyUtils.setNumberOfThreads(n4);
        ConcurrencyUtils.setThreadsBeginN_3D(4);
    }

    public void complexForward(float[][][] fArray) {
        for (int i = 0; i < this.numSlices; ++i) {
            this.sfft.complexForward(fArray[i]);
        }
        float[] fArray2 = new float[2 * this.numSlices];
        for (int i = 0; i < this.numCols; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                int n;
                for (n = 0; n < this.numSlices; ++n) {
                    fArray2[2 * n] = fArray[n][j][2 * i];
                    fArray2[2 * n + 1] = fArray[n][j][2 * i + 1];
                }
                this.xfft.complexForward(fArray2);
                for (n = 0; n < this.numSlices; ++n) {
                    fArray[n][j][2 * i] = fArray2[2 * n];
                    fArray[n][j][2 * i + 1] = fArray2[2 * n + 1];
                }
            }
        }
    }

    public FloatingPointEqualityChecker createEqualityChecker(float f, float f2) {
        String string = String.format(DEFAULT_MESSAGE, ConcurrencyUtils.getNumberOfThreads(), this.numSlices, this.numRows, this.numCols);
        return new FloatingPointEqualityChecker(string, 0.0, 0.0, f, f2);
    }

    @Test
    public void testRealForward1fInput() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        float f = 0.002f;
        float f2 = 0.005f;
        if (this.numSlices == 64 || this.numRows == 64 || this.numCols == 64) {
            f = 0.01f;
        }
        if (this.numSlices == 64 && this.numRows == 64 && this.numCols == 64) {
            f = 0.02f;
        }
        if (this.numSlices == 128 || this.numRows == 128 || this.numCols == 128) {
            f = 0.02f;
        }
        if (this.numSlices == 128 && this.numRows == 128 && this.numCols == 128) {
            f = 0.02f;
            f2 = 0.01f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[this.numSlices * this.numRows * this.numCols];
        float[][][] fArray2 = new float[this.numSlices][this.numRows][2 * this.numCols];
        boolean[] blArray = new boolean[this.numSlices * this.numRows * this.numCols];
        for (int i = 0; i < this.numSlices; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    float f4;
                    n4 = k + this.numCols * (j + this.numRows * i);
                    fArray[n4] = f4 = this.random.nextFloat();
                    fArray2[i][j][2 * k] = f4;
                    fArray2[i][j][2 * k + 1] = 0.0f;
                    blArray[n4] = false;
                }
            }
        }
        this.fft.realForward(fArray);
        this.complexForward(fArray2);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            float f5;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 2; n < this.numCols; ++n) {
                    n4 = n + this.numCols * (n2 + this.numRows * n3);
                    f5 = fArray[n4];
                    float f6 = fArray2[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n4 + "]", f6, f5);
                    blArray[n4] = true;
                }
            }
            for (n2 = 1; n2 < this.numRows / 2; ++n2) {
                arrayList.clear();
                arrayList.add(new int[]{n3, n2, 0, n3, n2, 0});
                arrayList.add(new int[]{n3, n2, 1, n3, n2, 1});
                n = this.numRows - n2;
                arrayList.add(new int[]{n3, n, 1, n3, n, this.numCols});
                arrayList.add(new int[]{n3, n, 0, n3, n, this.numCols + 1});
                for (int i = 0; i < arrayList.size(); ++i) {
                    int[] nArray = (int[])arrayList.get(i);
                    n4 = nArray[2] + this.numCols * (nArray[1] + this.numRows * nArray[0]);
                    f5 = fArray[n4];
                    float f7 = fArray2[nArray[3]][nArray[4]][nArray[5]];
                    floatingPointEqualityChecker.assertEquals("[" + n4 + "]", f7, f5);
                    blArray[n4] = true;
                }
            }
        }
        for (n3 = 1; n3 < this.numSlices / 2; ++n3) {
            arrayList.clear();
            arrayList.add(new int[]{n3, 0, 0, n3, 0, 0});
            arrayList.add(new int[]{n3, 0, 1, n3, 0, 1});
            arrayList.add(new int[]{n3, this.numRows / 2, 0, n3, this.numRows / 2, 0});
            arrayList.add(new int[]{n3, this.numRows / 2, 1, n3, this.numRows / 2, 1});
            n2 = this.numSlices - n3;
            arrayList.add(new int[]{n2, 0, 1, n2, 0, this.numCols});
            arrayList.add(new int[]{n2, 0, 0, n2, 0, this.numCols + 1});
            arrayList.add(new int[]{n2, this.numRows / 2, 1, n2, this.numRows / 2, this.numCols});
            arrayList.add(new int[]{n2, this.numRows / 2, 0, n2, this.numRows / 2, this.numCols + 1});
            for (n = 0; n < arrayList.size(); ++n) {
                int[] nArray = (int[])arrayList.get(n);
                n4 = nArray[2] + this.numCols * (nArray[1] + this.numRows * nArray[0]);
                float f8 = fArray[n4];
                float f9 = fArray2[nArray[3]][nArray[4]][nArray[5]];
                floatingPointEqualityChecker.assertEquals("[" + n4 + "]", f9, f8);
                blArray[n4] = true;
            }
        }
        arrayList.clear();
        arrayList.add(new int[]{0, 0, 0, 0, 0, 0});
        arrayList.add(new int[]{0, 0, 1, 0, 0, this.numCols});
        arrayList.add(new int[]{0, this.numRows / 2, 0, 0, this.numRows / 2, 0});
        arrayList.add(new int[]{0, this.numRows / 2, 1, 0, this.numRows / 2, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, 0, 0, this.numSlices / 2, 0, 0});
        arrayList.add(new int[]{this.numSlices / 2, 0, 1, this.numSlices / 2, 0, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 0, this.numSlices / 2, this.numRows / 2, 0});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 1, this.numSlices / 2, this.numRows / 2, this.numCols});
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            int[] nArray = (int[])arrayList.get(n3);
            n4 = nArray[2] + this.numCols * (nArray[1] + this.numRows * nArray[0]);
            float f10 = fArray[n4];
            float f11 = fArray2[nArray[3]][nArray[4]][nArray[5]];
            floatingPointEqualityChecker.assertEquals("[" + n4 + "]", f11, f10);
            blArray[n4] = true;
        }
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    n4 = n + this.numCols * (n2 + this.numRows * n3);
                    Assert.assertTrue((String)String.format("[%d][%d][%d]", n3, n2, n), (boolean)blArray[n4]);
                }
            }
        }
    }

    @Test
    public void testRealForward3fInput() {
        int n;
        int n2;
        int n3;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        float f = 0.002f;
        float f2 = 0.005f;
        if (this.numSlices == 64 || this.numRows == 64 || this.numCols == 64) {
            f = 0.01f;
        }
        if (this.numSlices == 64 && this.numRows == 64 && this.numCols == 64) {
            f = 0.02f;
        }
        if (this.numSlices == 128 || this.numRows == 128 || this.numCols == 128) {
            f = 0.02f;
        }
        if (this.numSlices == 128 && this.numRows == 128 && this.numCols == 128) {
            f = 0.02f;
            f2 = 0.01f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[][][] fArray = new float[this.numSlices][this.numRows][this.numCols];
        float[][][] fArray2 = new float[this.numSlices][this.numRows][2 * this.numCols];
        boolean[][][] blArray = new boolean[this.numSlices][this.numRows][this.numCols];
        for (int i = 0; i < this.numSlices; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                for (n3 = 0; n3 < this.numCols; ++n3) {
                    float f4;
                    fArray[i][j][n3] = f4 = this.random.nextFloat();
                    fArray2[i][j][2 * n3] = f4;
                    fArray2[i][j][2 * n3 + 1] = 0.0f;
                    blArray[i][j][n3] = false;
                }
            }
        }
        this.fft.realForward(fArray);
        this.complexForward(fArray2);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            int n4;
            for (n4 = 0; n4 < this.numRows; ++n4) {
                for (int i = 2; i < this.numCols; ++i) {
                    float f5 = fArray[n3][n4][i];
                    float f6 = fArray2[n3][n4][i];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n4 + "][" + i + "]", f6, f5);
                    blArray[n3][n4][i] = true;
                }
            }
            for (n4 = 1; n4 < this.numRows / 2; ++n4) {
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                arrayList.add(new int[]{n3, n4, 0, n3, n4, 0});
                arrayList.add(new int[]{n3, n4, 1, n3, n4, 1});
                n2 = this.numRows - n4;
                arrayList.add(new int[]{n3, n2, 1, n3, n2, this.numCols});
                arrayList.add(new int[]{n3, n2, 0, n3, n2, this.numCols + 1});
                for (int i = 0; i < arrayList.size(); ++i) {
                    int[] nArray = (int[])arrayList.get(i);
                    float f7 = fArray[nArray[0]][nArray[1]][nArray[2]];
                    float f8 = fArray2[nArray[3]][nArray[4]][nArray[5]];
                    floatingPointEqualityChecker.assertEquals("[" + nArray[0] + "][" + nArray[1] + "][" + nArray[2] + "]", f8, f7);
                    blArray[nArray[0]][nArray[1]][nArray[2]] = true;
                }
            }
        }
        for (n3 = 1; n3 < this.numSlices / 2; ++n3) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            arrayList.add(new int[]{n3, 0, 0, n3, 0, 0});
            arrayList.add(new int[]{n3, 0, 1, n3, 0, 1});
            arrayList.add(new int[]{n3, this.numRows / 2, 0, n3, this.numRows / 2, 0});
            arrayList.add(new int[]{n3, this.numRows / 2, 1, n3, this.numRows / 2, 1});
            int n5 = this.numSlices - n3;
            arrayList.add(new int[]{n5, 0, 1, n5, 0, this.numCols});
            arrayList.add(new int[]{n5, 0, 0, n5, 0, this.numCols + 1});
            arrayList.add(new int[]{n5, this.numRows / 2, 1, n5, this.numRows / 2, this.numCols});
            arrayList.add(new int[]{n5, this.numRows / 2, 0, n5, this.numRows / 2, this.numCols + 1});
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int[] nArray = (int[])arrayList.get(n2);
                float f9 = fArray[nArray[0]][nArray[1]][nArray[2]];
                float f10 = fArray2[nArray[3]][nArray[4]][nArray[5]];
                floatingPointEqualityChecker.assertEquals("[" + nArray[0] + "][" + nArray[1] + "][" + nArray[2] + "]", f10, f9);
                blArray[nArray[0]][nArray[1]][nArray[2]] = true;
            }
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        arrayList.add(new int[]{0, 0, 0, 0, 0, 0});
        arrayList.add(new int[]{0, 0, 1, 0, 0, this.numCols});
        arrayList.add(new int[]{0, this.numRows / 2, 0, 0, this.numRows / 2, 0});
        arrayList.add(new int[]{0, this.numRows / 2, 1, 0, this.numRows / 2, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, 0, 0, this.numSlices / 2, 0, 0});
        arrayList.add(new int[]{this.numSlices / 2, 0, 1, this.numSlices / 2, 0, this.numCols});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 0, this.numSlices / 2, this.numRows / 2, 0});
        arrayList.add(new int[]{this.numSlices / 2, this.numRows / 2, 1, this.numSlices / 2, this.numRows / 2, this.numCols});
        for (n = 0; n < arrayList.size(); ++n) {
            int[] nArray = (int[])arrayList.get(n);
            float f11 = fArray[nArray[0]][nArray[1]][nArray[2]];
            float f12 = fArray2[nArray[3]][nArray[4]][nArray[5]];
            floatingPointEqualityChecker.assertEquals("[" + nArray[0] + "][" + nArray[1] + "][" + nArray[2] + "]", f12, f11);
            blArray[nArray[0]][nArray[1]][nArray[2]] = true;
        }
        for (n = 0; n < this.numSlices; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                for (n2 = 0; n2 < this.numCols; ++n2) {
                    Assert.assertTrue((String)String.format("[%d][%d][%d]", n, i, n2), (boolean)blArray[n][i][n2]);
                }
            }
        }
    }

    @Test
    public void testRealInverseScaled1fInput() {
        float f;
        int n;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        float f2 = 2.0E-4f;
        float f3 = 0.005f;
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[] fArray = new float[this.numRows * this.numCols * this.numSlices];
        float[] fArray2 = new float[fArray.length];
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = f = this.random.nextFloat();
            fArray2[n] = f;
        }
        this.fft.realForward(fArray);
        this.fft.realInverse(fArray, true);
        for (n = 0; n < fArray.length; ++n) {
            f = fArray2[n];
            float f5 = fArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", f, f5);
        }
    }

    @Test
    public void testRealInverseScaled3fInput() {
        float f;
        int n;
        int n2;
        int n3;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numSlices)) {
            return;
        }
        float f2 = 2.0E-4f;
        float f3 = 0.005f;
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[][][] fArray = new float[this.numSlices][this.numRows][this.numCols];
        float[][][] fArray2 = new float[this.numSlices][this.numRows][this.numCols];
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    fArray[n3][n2][n] = f = this.random.nextFloat();
                    fArray2[n3][n2][n] = f;
                }
            }
        }
        this.fft.realForward(fArray);
        this.fft.realInverse(fArray, true);
        for (n3 = 0; n3 < this.numSlices; ++n3) {
            for (n2 = 0; n2 < this.numRows; ++n2) {
                for (n = 0; n < this.numCols; ++n) {
                    f = fArray2[n3][n2][n];
                    float f5 = fArray[n3][n2][n];
                    floatingPointEqualityChecker.assertEquals("[" + n3 + "][" + n2 + "][" + n + "]", f, f5);
                }
            }
        }
    }
}

