/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class IntervalToWig
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalToWig.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Bed/BedGraph/GFF)", required=true)
    public IntervalFile<? extends Interval> intervalFile;
    @Parameter(names={"-z", "--zero"}, description="Assume zero where there is no data (default = NaN)")
    public boolean defaultZero = false;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing output file");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader header = new TrackHeader("wiggle_0");
            header.setName("Converted " + this.intervalFile.getPath().getFileName());
            header.setDescription("Converted " + this.intervalFile.getPath().getFileName());
            writer.write(header.toString());
            writer.newLine();
            for (String chr : this.intervalFile.chromosomes()) {
                if (!this.assembly.includes(chr)) {
                    log.info((Object)("Skipping chromosome " + chr + " because it is not in assembly " + this.assembly));
                    continue;
                }
                log.debug((Object)("Processing chromosome " + chr));
                writer.write("fixedStep chrom=" + chr + " start=1 step=1 span=1");
                writer.newLine();
                int start = 1;
                while (start < this.assembly.getChrLength(chr)) {
                    int stop = Math.min(start + 300000 - 1, this.assembly.getChrLength(chr));
                    int length = stop - start + 1;
                    int[] count = new int[length];
                    float[] sum = new float[length];
                    Iterator it = this.intervalFile.query(chr, start, stop);
                    while (it.hasNext()) {
                        ValuedInterval entry = (ValuedInterval)it.next();
                        if (entry.getValue() == null) continue;
                        int entryStart = Math.max(start, entry.getStart());
                        int entryStop = Math.min(stop, entry.getStop());
                        for (int i = entryStart; i <= entryStop; ++i) {
                            int n = i - start;
                            sum[n] = sum[n] + entry.getValue().floatValue();
                            int n2 = i - start;
                            count[n2] = count[n2] + 1;
                        }
                    }
                    for (int i = 0; i < sum.length; ++i) {
                        if (count[i] == 0) {
                            if (this.defaultZero) {
                                writer.write("0");
                            } else {
                                writer.write(String.valueOf(Float.NaN));
                            }
                        } else {
                            writer.write(String.valueOf(sum[i] / (float)count[i]));
                        }
                        writer.newLine();
                    }
                    start = stop + 1;
                }
            }
        }
        finally {
            this.intervalFile.close();
        }
    }

    public static void main(String[] args) {
        new IntervalToWig().instanceMain(args);
    }
}

