/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class InterpolateDiscontinuousData
extends WigMathTool {
    private static final Logger log = Logger.getLogger(InterpolateDiscontinuousData.class);
    @Parameter(names={"-i", "--input"}, description="Input file (Wig)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-t", "--type"}, description="Interpolant (nearest/linear/cubic)")
    public String type = "linear";
    @Parameter(names={"-m", "--max"}, description="Maximum span of missing values to interpolate (bp)")
    public int max = 1000;
    private Interpolant interp;

    @Override
    public void setup() {
        this.interp = Interpolant.fromName(this.type);
        if (this.interp == null) {
            log.error((Object)("Unknown interpolation method: " + this.type));
            throw new CommandLineToolException("Unknown interpolation method: " + this.type + ". Options are nearest, linear, pchip");
        }
        log.debug((Object)("Using interpolant: " + this.type));
        if (this.max > 300000) {
            log.warn((Object)"Allowable span of missing values exceeds processing chunk size");
        }
        this.inputs.add(this.inputFile);
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        float y1;
        float y0;
        int x1;
        int x0;
        int j;
        int queryStop;
        int queryStart;
        Iterator data = this.inputFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)data, (int)start, (int)stop);
        int first = 0;
        while (Float.isNaN(result[first]) && ++first < result.length) {
        }
        int last = result.length - 1;
        while (Float.isNaN(result[last]) && --last > first) {
        }
        if (first == result.length) {
            log.warn((Object)("Skipping entire chunk " + chr + ":" + start + "-" + stop + " that is missing values"));
            return result;
        }
        if (first > 0 && first < this.max) {
            int upstream = this.max - first;
            queryStart = Math.max(start - upstream, this.inputFile.getChrStart(chr));
            if (queryStart >= (queryStop = start - 1)) {
                log.debug((Object)("Cannot interpolate missing values at the start of chromosome " + chr));
            } else {
                Iterator upstreamData = this.inputFile.query(chr, queryStart, queryStop);
                float[] upstreamResult = WigFile.flattenData((Iterator)upstreamData, (int)queryStart, (int)queryStop);
                j = upstreamResult.length - 1;
                while (Float.isNaN(upstreamResult[j]) && --j >= 0) {
                }
                if (j >= 0 && !Float.isNaN(upstreamResult[j])) {
                    x0 = -j;
                    x1 = first;
                    y0 = upstreamResult[j];
                    y1 = result[first];
                    this.doInterpolation(result, x0, x1, y0, y1);
                }
            }
        }
        if (last < result.length - 1 && last >= result.length - this.max) {
            queryStart = stop + 1;
            int downstream = this.max - (result.length - last);
            queryStop = Math.min(stop + downstream, this.inputFile.getChrStop(chr));
            if (queryStart >= queryStop) {
                log.debug((Object)("Cannot interpolate missing values at the end of chromosome " + chr));
            } else {
                Iterator downstreamData = this.inputFile.query(chr, queryStart, queryStop);
                float[] downstreamResult = WigFile.flattenData((Iterator)downstreamData, (int)queryStart, (int)queryStop);
                j = 0;
                while (Float.isNaN(downstreamResult[j]) && ++j < downstreamResult.length) {
                }
                if (j < downstreamResult.length && !Float.isNaN(downstreamResult[j])) {
                    x0 = last;
                    x1 = result.length + j;
                    y0 = result[last];
                    y1 = downstreamResult[j];
                    this.doInterpolation(result, x0, x1, y0, y1);
                }
            }
        }
        for (int i = first; i < last; ++i) {
            if (!Float.isNaN(result[i])) continue;
            int x02 = i - 1;
            while (Float.isNaN(result[++i])) {
            }
            int x12 = i - 1;
            if (x12 - x02 <= this.max) {
                this.doInterpolation(result, x02, x12, result[x02], result[x12]);
                continue;
            }
            log.debug((Object)("Skipping interval " + chr + ":" + (start + x02) + "-" + (start + x12) + " (exceeds maximum span)"));
        }
        return result;
    }

    protected void doInterpolation(float[] x, int x0, int x1, float y0, float y1) {
        switch (this.interp) {
            case NEAREST: {
                int i;
                int center = (x0 + x1) / 2;
                for (i = x0 + 1; i <= center; ++i) {
                    if (i <= 0 || i >= x.length) continue;
                    x[i] = y0;
                }
                i = center + 1;
                while ((float)i < y0) {
                    if (i > 0 && i < x.length) {
                        x[i] = y1;
                    }
                    ++i;
                }
                break;
            }
            case LINEAR: {
                float m = (y1 - y0) / (float)(x1 - x0);
                for (int i = x0 + 1; i < x1; ++i) {
                    if (i <= 0 || i >= x.length) continue;
                    x[i] = y0 + m * (float)(i - x0);
                }
                break;
            }
            case CUBIC: {
                int l = x1 - x0;
                float a = (y1 - y0) / (float)(l * l);
                float b = 2.0f * (y0 - y1) / (float)(l * l * l);
                for (int i = x0 + 1; i < x1; ++i) {
                    if (i <= 0 || i >= x.length) continue;
                    x[i] = y0 + a * (float)(i - x0) * (float)(i - x0) + b * (float)(i - x0) * (float)(i - x0) * (float)(i - x1);
                }
                break;
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new InterpolateDiscontinuousData().instanceMain(args);
    }

    public static enum Interpolant {
        NEAREST("nearest"),
        LINEAR("linear"),
        CUBIC("cubic");

        private String name;

        private Interpolant(String name) {
            this.name = name;
        }

        public static Interpolant fromName(String name) {
            for (Interpolant i : Interpolant.values()) {
                if (!i.getName().equalsIgnoreCase(name)) continue;
                return i;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

