/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BaseAlignCounts
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(BaseAlignCounts.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true)
    public IntervalFile<? extends Interval> intervalFile;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-x", "--extend"}, description="Extend reads from 5' end (default = read length)")
    public Integer extend = -1;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing output file");
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader header = new TrackHeader("wiggle_0");
            header.setName("Converted " + this.intervalFile.getPath().getFileName());
            header.setDescription("Converted " + this.intervalFile.getPath().getFileName());
            writer.write(header.toString());
            writer.newLine();
            for (String chr : this.intervalFile.chromosomes()) {
                if (!this.assembly.includes(chr)) {
                    log.info((Object)("Skipping chromosome " + chr + " because it is not in assembly " + this.assembly));
                    continue;
                }
                log.debug((Object)("Processing chromosome " + chr));
                writer.write("fixedStep chrom=" + chr + " start=1 step=1 span=1");
                writer.newLine();
                int start = 1;
                while (start < this.assembly.getChrLength(chr)) {
                    int stop = Math.min(start + 300000 - 1, this.assembly.getChrLength(chr));
                    int length = stop - start + 1;
                    int[] count = new int[length];
                    Iterator it = this.intervalFile.query(chr, start, stop);
                    while (it.hasNext()) {
                        Interval entry = (Interval)it.next();
                        int entryStop = entry.getStop();
                        if (this.extend != null && this.extend != -1) {
                            entryStop = entry.isWatson() ? entry.getStart() + this.extend - 1 : entry.getStart() - this.extend + 1;
                        }
                        int low = Math.max(Math.min(entry.getStart(), entryStop), start);
                        int high = Math.min(Math.max(entry.getStart(), entryStop), stop);
                        for (int i = low; i <= high; ++i) {
                            int n = i - start;
                            count[n] = count[n] + 1;
                        }
                    }
                    for (int i = 0; i < count.length; ++i) {
                        writer.write(Integer.toString(count[i]));
                        writer.newLine();
                    }
                    start = stop + 1;
                }
            }
        }
        this.intervalFile.close();
    }

    public static void main(String[] args) {
        new BaseAlignCounts().instanceMain(args);
    }
}

