/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.converters;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.GeneTrackEntry;
import edu.unc.genomics.io.GeneTrackFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GeneTrackToWig
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(GeneTrackToWig.class);
    @Parameter(names={"-i", "--input"}, description="Input file (GeneTrack)", required=true)
    public Path gtFile;
    @Parameter(names={"-z", "--zero"}, description="Assume zero where there is no data (default = NaN)")
    public boolean defaultZero = false;
    @Parameter(names={"-s", "--shift"}, description="Shift from 5' end (bp)")
    public Integer shift;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing input GeneTrack file");
        log.debug((Object)"Initializing output file");
        try (GeneTrackFile gt = new GeneTrackFile(this.gtFile);
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader header = new TrackHeader("wiggle_0");
            header.setName("Converted " + this.gtFile.getFileName());
            header.setDescription("Converted " + this.gtFile.getFileName());
            writer.write(header.toString());
            writer.newLine();
            for (String chr : gt.chromosomes()) {
                if (!this.assembly.includes(chr)) {
                    log.info((Object)("Skipping chromosome " + chr + " because it is not in assembly " + this.assembly));
                    continue;
                }
                log.debug((Object)("Processing chromosome " + chr));
                writer.write("fixedStep chrom=" + chr + " start=1 step=1 span=1");
                writer.newLine();
                int start = 1;
                while (start < this.assembly.getChrLength(chr)) {
                    int stop = Math.min(start + 300000 - 1, this.assembly.getChrLength(chr));
                    int length = stop - start + 1;
                    int[] count = new int[length];
                    float[] sum = new float[length];
                    int paddedStart = start;
                    int paddedStop = stop;
                    if (this.shift != null) {
                        paddedStart = Math.max(start - this.shift - 1, 1);
                        paddedStop = Math.min(stop + this.shift + 1, this.assembly.getChrLength(chr));
                    }
                    Iterator it = gt.query(chr, paddedStart, paddedStop);
                    while (it.hasNext()) {
                        int reverseShift;
                        int forwardShift;
                        GeneTrackEntry entry = (GeneTrackEntry)it.next();
                        int entryPos = entry.getStart();
                        if (this.shift == null || this.shift == 0) {
                            int n = entryPos - start;
                            sum[n] = sum[n] + entry.getValue().floatValue();
                            int n2 = entryPos - start;
                            count[n2] = count[n2] + 1;
                            continue;
                        }
                        if (entry.getForward() > 0.0 && (forwardShift = entryPos + this.shift) >= start && forwardShift - start < sum.length) {
                            int n = forwardShift - start;
                            sum[n] = (float)((double)sum[n] + entry.getForward());
                            int n3 = forwardShift - start;
                            count[n3] = count[n3] + 1;
                        }
                        if (!(entry.getReverse() > 0.0) || (reverseShift = entryPos - this.shift) < start || reverseShift - start >= sum.length) continue;
                        int n = reverseShift - start;
                        sum[n] = (float)((double)sum[n] + entry.getReverse());
                        int n4 = reverseShift - start;
                        count[n4] = count[n4] + 1;
                    }
                    for (int i = 0; i < sum.length; ++i) {
                        if (count[i] == 0) {
                            if (this.defaultZero) {
                                writer.write("0");
                            } else {
                                writer.write(String.valueOf(Float.NaN));
                            }
                        } else {
                            writer.write(String.valueOf(sum[i]));
                        }
                        writer.newLine();
                    }
                    start = stop + 1;
                }
            }
        }
    }

    public static void main(String[] args) {
        new GeneTrackToWig().instanceMain(args);
    }
}

