/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ZScore
extends WigMathTool {
    private static final Logger log = Logger.getLogger(ZScore.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true)
    public WigFile inputFile;
    double mean;
    double stdev;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        this.mean = this.inputFile.mean();
        this.stdev = this.inputFile.stdev();
        if (this.stdev == 0.0) {
            log.error((Object)"Cannot Z-score a file with stdev = 0!");
            throw new CommandLineToolException("Cannot Z-score a file with stdev = 0!");
        }
        log.info((Object)("Mean = " + Float.toString((float)this.mean)));
        log.info((Object)("StDev = " + Float.toString((float)this.stdev)));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        Iterator data = this.inputFile.query(chr, start, stop);
        float[] result = WigFile.flattenData((Iterator)data, (int)start, (int)stop);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)(((double)result[i] - this.mean) / this.stdev);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new ZScore().instanceMain(args);
    }
}

