/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.WigItem;

public class Multiply
extends WigMathTool {
    private static final Logger log = Logger.getLogger(Multiply.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();

    @Override
    public void setup() {
        log.debug((Object)"Initializing input files");
        for (String inputFile : this.inputFiles) {
            try {
                this.addInputFile(WigFile.autodetect((Path)Paths.get(inputFile, new String[0])));
            }
            catch (WigFileException | IOException e) {
                log.error((Object)("Error initializing input Wig file: " + inputFile));
                e.printStackTrace();
                System.exit(-1);
            }
        }
        log.debug((Object)("Initialized " + this.inputs.size() + " input files"));
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        int length = stop - start + 1;
        float[] product = new float[length];
        Arrays.fill(product, 1.0f);
        for (WigFile wig : this.inputs) {
            Iterator data = wig.query(chr, start, stop);
            while (data.hasNext()) {
                WigItem item = (WigItem)data.next();
                for (int i = item.getStartBase(); i <= item.getEndBase(); ++i) {
                    if (i - start < 0 || i - start >= product.length) continue;
                    int n = i - start;
                    product[n] = product[n] * item.getWigValue();
                }
            }
        }
        return product;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new Multiply().instanceMain(args);
    }
}

