/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.picard.util.ReferenceSequenceMask;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceRecord;

public class WholeGenomeReferenceSequenceMask
implements ReferenceSequenceMask {
    SAMFileHeader header;

    public WholeGenomeReferenceSequenceMask(SAMFileHeader header) {
        this.header = header;
    }

    @Override
    public boolean get(int sequenceIndex, int position) {
        if (sequenceIndex < 0) {
            throw new IllegalArgumentException("Negative sequence index " + sequenceIndex);
        }
        if (sequenceIndex >= this.header.getSequenceDictionary().size()) {
            return false;
        }
        SAMSequenceRecord sequenceRecord = this.header.getSequence(sequenceIndex);
        return position <= sequenceRecord.getSequenceLength();
    }

    @Override
    public int nextPosition(int sequenceIndex, int position) {
        if (this.get(sequenceIndex, position + 1)) {
            return position + 1;
        }
        return -1;
    }

    @Override
    public int getMaxSequenceIndex() {
        return this.header.getSequenceDictionary().size() - 1;
    }

    @Override
    public int getMaxPosition() {
        SAMSequenceRecord lastSequenceRecord = this.header.getSequence(this.getMaxSequenceIndex());
        return lastSequenceRecord.getSequenceLength();
    }
}

