/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.utils.WigStatistic;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class IntervalStats
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(IntervalStats.class);
    @Parameter(description="Input files", required=true)
    public List<String> inputFiles = new ArrayList<String>();
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true)
    public IntervalFile<? extends Interval> lociFile;
    @Parameter(names={"-s", "--stat"}, description="Statistic to compute (mean/min/max)")
    public String stat = "mean";
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    private List<WigFile> wigs = new ArrayList<WigFile>();

    @Override
    public void run() throws IOException {
        WigStatistic s = WigStatistic.fromName(this.stat);
        if (s == null) {
            log.error((Object)("Unknown statistic: " + this.stat));
            throw new CommandLineToolException("Unknown statistic: " + this.stat + ". Options are mean, min, max");
        }
        log.debug((Object)("Using statistic: " + this.stat));
        log.debug((Object)"Initializing input Wig file(s)");
        for (String inputFile : this.inputFiles) {
            try {
                WigFile wig = WigFile.autodetect((Path)Paths.get(inputFile, new String[0]));
                this.wigs.add(wig);
            }
            catch (WigFileException e) {
                log.error((Object)("Error initializing Wig input file: " + inputFile));
                e.printStackTrace();
                throw new RuntimeException("Error initializing Wig input file: " + inputFile);
            }
        }
        log.debug((Object)"Initializing output file");
        int count = 0;
        int skipped = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("#Chr\tStart\tStop\tID\tAlignment\tStrand");
            for (String inputFile : this.inputFiles) {
                Path p = Paths.get(inputFile, new String[0]);
                writer.write("\t" + p.getFileName().toString());
            }
            writer.newLine();
            log.debug((Object)("Iterating over all intervals and computing " + this.stat));
            for (Interval interval : this.lociFile) {
                writer.write(interval.toBed());
                for (WigFile wig : this.wigs) {
                    try {
                        Iterator result = wig.query(interval);
                        float value = Float.NaN;
                        switch (s) {
                            case MEAN: {
                                value = WigFile.mean((Iterator)result, (int)interval.getStart(), (int)interval.getStop());
                                break;
                            }
                            case MIN: {
                                value = WigFile.min((Iterator)result, (int)interval.getStart(), (int)interval.getStop());
                                break;
                            }
                            case MAX: {
                                value = WigFile.max((Iterator)result, (int)interval.getStart(), (int)interval.getStop());
                            }
                        }
                        writer.write("\t" + value);
                    }
                    catch (WigFileException e) {
                        writer.write("\tNaN");
                        ++skipped;
                    }
                }
                writer.newLine();
                ++count;
            }
        }
        this.lociFile.close();
        for (WigFile wig : this.wigs) {
            wig.close();
        }
        log.info((Object)(count + " intervals processed"));
        log.info((Object)(skipped + " interval skipped"));
    }

    public static void main(String[] args) {
        new IntervalStats().instanceMain(args);
    }
}

