/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFile;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.wigmath.WigMathTool;
import edu.unc.utils.InclusionExclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PredictFAIRESignal
extends WigMathTool {
    private static final Logger log = Logger.getLogger(PredictFAIRESignal.class);
    @Parameter(names={"-i", "--input"}, description="Input (nucleosome occupancy)", required=true)
    public WigFile inputFile;
    @Parameter(names={"-s", "--sonication"}, description="Sonication distribution", required=true, validateWith=ReadablePathValidator.class)
    public Path sonicationFile;
    @Parameter(names={"-c", "--crosslinking"}, description="FAIRE efficiency / crosslinking coefficient")
    public float crosslink = 1.0f;
    @Parameter(names={"-x", "--extend"}, description="In silico read extension (bp)")
    public int extend = 250;
    double[] sonication = new double[100];
    int minL = Integer.MAX_VALUE;
    int maxL = 0;
    double maxOcc;

    @Override
    public void setup() {
        this.inputs.add(this.inputFile);
        log.debug((Object)"Loading sonication fragment length distribution");
        double total = 0.0;
        try (BufferedReader reader = Files.newBufferedReader(this.sonicationFile, Charset.defaultCharset());){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] entry = line.split("\t");
                if (entry.length != 2) {
                    throw new CommandLineToolException("Invalid format for sonication distribution file");
                }
                int length = Integer.parseInt(entry[0]);
                double percent = Double.parseDouble(entry[1]);
                if (length >= this.sonication.length) {
                    this.sonication = Arrays.copyOf(this.sonication, Math.max(this.sonication.length + 100, length + 1));
                }
                if (length < this.minL) {
                    this.minL = length;
                }
                if (length > this.maxL) {
                    this.maxL = length;
                }
                this.sonication[length] = percent;
                total += percent;
            }
        }
        catch (IOException e) {
            log.fatal((Object)"Error loading sonication fragment length distribution");
            e.printStackTrace();
            throw new CommandLineToolException("Error loading sonication fragment length distribution");
        }
        this.sonication = Arrays.copyOfRange(this.sonication, 0, this.maxL);
        log.debug((Object)("Loaded sonication distribution for lengths: 0-" + this.maxL + "bp"));
        int i = 0;
        while (i < this.sonication.length) {
            int n = i++;
            this.sonication[n] = this.sonication[n] / total;
        }
        this.maxOcc = this.inputFile.max();
    }

    @Override
    public float[] compute(String chr, int start, int stop) throws IOException, WigFileException {
        int paddedStart = Math.max(start - this.maxL, this.inputFile.getChrStart(chr));
        int paddedStop = Math.min(stop + this.maxL, this.inputFile.getChrStop(chr));
        Iterator data = this.inputFile.query(chr, paddedStart, paddedStop);
        float[] result = WigFile.flattenData((Iterator)data, (int)(start - this.maxL), (int)(stop + this.maxL), (float)0.0f);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = (float)((double)result[n] / this.maxOcc);
        }
        log.debug((Object)"Computing FAIRE prediction");
        float[] watson = new float[result.length];
        float[] crick = new float[result.length];
        for (int i2 = this.minL; i2 < this.sonication.length; ++i2) {
            if (this.sonication[i2] == 0.0) continue;
            for (int j = 0; j < result.length - i2; ++j) {
                float pOccupied = InclusionExclusion.independent(result, j, j + i2);
                float pFAIRE = 1.0f - this.crosslink * pOccupied;
                int n = j;
                watson[n] = (float)((double)watson[n] + this.sonication[i2] * (double)pFAIRE);
                int n2 = j + i2 - 1;
                crick[n2] = (float)((double)crick[n2] + this.sonication[i2] * (double)pFAIRE);
            }
        }
        log.debug((Object)"Extending reads from the +/- strands");
        float[] prediction = new float[stop - start + 1];
        for (int i3 = 0; i3 < result.length; ++i3) {
            for (int j = 0; j < this.extend; ++j) {
                if (i3 + j - this.maxL > 0 && i3 + j - this.maxL < prediction.length) {
                    int n = i3 + j - this.maxL;
                    prediction[n] = prediction[n] + watson[i3];
                }
                if (i3 - j - this.maxL <= 0 || i3 - j - this.maxL >= prediction.length) continue;
                int n = i3 - j - this.maxL;
                prediction[n] = prediction[n] + crick[i3];
            }
        }
        return prediction;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new PredictFAIRESignal().instanceMain(args);
    }
}

