/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Arrays;

public class BenchmarkDoubleFFT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static int[] sizes1D = new int[]{65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 10368, 27000, 75600, 165375, 362880, 1562500, 0x310000, 6250000};
    private static int[] sizes2D = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 260, 520, 1050, 1458, 1960, 2916, 4116, 5832};
    private static int[] sizes3D = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 5, 17, 30, 95, 180, 270, 324, 420};
    private static boolean doScaling = false;

    private BenchmarkDoubleFFT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new int[nsize];
            sizes2D = new int[nsize];
            sizes3D = new int[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleFFT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleFFT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkDoubleFFT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkComplexForward_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Complex forward FFT 1D of size " + sizes1D[i]);
            DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D(sizes1D[i]);
            double[] dArray2 = new double[2 * sizes1D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(2 * sizes1D[i], dArray2);
                doubleFFT_1D.complexForward(dArray2);
                IOUtils.fillMatrix_1D(2 * sizes1D[i], dArray2);
                doubleFFT_1D.complexForward(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(2 * sizes1D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_1D.complexForward(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray);
    }

    public static void benchmarkRealForward_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Real forward FFT 1D of size " + sizes1D[i]);
            DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D(sizes1D[i]);
            double[] dArray2 = new double[2 * sizes1D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(sizes1D[i], dArray2);
                doubleFFT_1D.realForwardFull(dArray2);
                IOUtils.fillMatrix_1D(sizes1D[i], dArray2);
                doubleFFT_1D.realForwardFull(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_1D.realForwardFull(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray);
    }

    public static void benchmarkComplexForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Complex forward FFT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(sizes2D[i], sizes2D[i]);
            double[] dArray2 = new double[sizes2D[i] * 2 * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], dArray2);
                doubleFFT_2D.complexForward(dArray2);
                IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], dArray2);
                doubleFFT_2D.complexForward(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_2D.complexForward(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray);
    }

    public static void benchmarkComplexForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Complex forward FFT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(sizes2D[i], sizes2D[i]);
            double[][] dArray2 = new double[sizes2D[i]][2 * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], dArray2);
                doubleFFT_2D.complexForward(dArray2);
                IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], dArray2);
                doubleFFT_2D.complexForward(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_2D.complexForward(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray);
    }

    public static void benchmarkRealForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Real forward FFT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(sizes2D[i], sizes2D[i]);
            double[] dArray2 = new double[sizes2D[i] * 2 * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray2);
                doubleFFT_2D.realForwardFull(dArray2);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray2);
                doubleFFT_2D.realForwardFull(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_2D.realForwardFull(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray);
    }

    public static void benchmarkRealForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Real forward FFT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(sizes2D[i], sizes2D[i]);
            double[][] dArray2 = new double[sizes2D[i]][2 * sizes2D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray2);
                doubleFFT_2D.realForwardFull(dArray2);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray2);
                doubleFFT_2D.realForwardFull(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_2D.realForwardFull(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray);
    }

    public static void benchmarkComplexForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            if (sizes3D[i] >= 1024) continue;
            System.out.println("Complex forward FFT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleFFT_3D doubleFFT_3D = new DoubleFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[] dArray2 = new double[sizes3D[i] * sizes3D[i] * 2 * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], dArray2);
                doubleFFT_3D.complexForward(dArray2);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], dArray2);
                doubleFFT_3D.complexForward(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_3D.complexForward(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray);
    }

    public static void benchmarkComplexForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Complex forward FFT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleFFT_3D doubleFFT_3D = new DoubleFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[][][] dArray2 = new double[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], dArray2);
                doubleFFT_3D.complexForward(dArray2);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], dArray2);
                doubleFFT_3D.complexForward(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_3D.complexForward(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray);
    }

    public static void benchmarkRealForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            if (sizes3D[i] >= 1024) continue;
            System.out.println("Real forward FFT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleFFT_3D doubleFFT_3D = new DoubleFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[] dArray2 = new double[sizes3D[i] * sizes3D[i] * 2 * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray2);
                doubleFFT_3D.realForwardFull(dArray2);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray2);
                doubleFFT_3D.realForwardFull(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_3D.realForwardFull(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray);
    }

    public static void benchmarkRealForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            System.out.println("Real forward FFT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            DoubleFFT_3D doubleFFT_3D = new DoubleFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            double[][][] dArray2 = new double[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray2);
                doubleFFT_3D.realForwardFull(dArray2);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray2);
                doubleFFT_3D.realForwardFull(dArray2);
            }
            double d = 0.0;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], dArray2);
                l = System.nanoTime();
                doubleFFT_3D.realForwardFull(dArray2);
                l = System.nanoTime() - l;
                d += (double)l;
            }
            dArray[i] = d / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", d / 1000000.0 / (double)niter) + " msec");
            dArray2 = null;
            doubleFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleFFT.parseArguments(stringArray);
        BenchmarkDoubleFFT.benchmarkComplexForward_1D();
        BenchmarkDoubleFFT.benchmarkRealForward_1D();
        BenchmarkDoubleFFT.benchmarkComplexForward_2D_input_1D();
        BenchmarkDoubleFFT.benchmarkComplexForward_2D_input_2D();
        BenchmarkDoubleFFT.benchmarkRealForward_2D_input_1D();
        BenchmarkDoubleFFT.benchmarkRealForward_2D_input_2D();
        BenchmarkDoubleFFT.benchmarkComplexForward_3D_input_1D();
        BenchmarkDoubleFFT.benchmarkComplexForward_3D_input_3D();
        BenchmarkDoubleFFT.benchmarkRealForward_3D_input_1D();
        BenchmarkDoubleFFT.benchmarkRealForward_3D_input_3D();
        System.exit(0);
    }
}

