/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Interval;

public class ValuedInterval
extends Interval {
    private static final long serialVersionUID = 2976113135643438146L;
    protected String id;
    protected Number value;

    public ValuedInterval(String chr, int start, int stop, String id, Number value) {
        super(chr, start, stop);
        this.id = id;
        this.value = value;
    }

    public ValuedInterval(String chr, int start, int stop, String id) {
        this(chr, start, stop, id, null);
    }

    public ValuedInterval(String chr, int start, int stop) {
        this(chr, start, stop, null);
    }

    @Override
    public String toBed() {
        String idStr = this.id == null ? "." : this.id;
        String valueStr = this.getValue() == null ? "." : this.getValue().toString();
        return this.getChr() + "\t" + (this.low() - 1) + "\t" + this.high() + "\t" + idStr + "\t" + valueStr + "\t" + this.strand();
    }

    @Override
    public String toBedGraph() {
        if (this.getValue() == null) {
            return super.toBedGraph();
        }
        return super.toBedGraph() + "\t" + this.getValue().toString();
    }

    @Override
    public String toGFF() {
        String idStr = this.id == null ? "no_id" : this.id;
        String valueStr = this.getValue() == null ? "." : this.getValue().toString();
        return this.getChr() + "\tSpotArray\tfeature\t" + this.low() + "\t" + this.high() + "\t" + valueStr + "\t" + this.strand() + "\t.\tprobe_id=" + idStr + ";count=1";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }
}

